/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhInvOccupy;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInvService;
import com.thebeastshop.pegasus.service.warehouse.service.WhProxyService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author Eric.Lou
 * @version $Id: WhProxyServiceImpl.java, v 0.1 2015-12-03 10:51
 */
@Service("whProxyService")
public class WhProxyServiceImpl implements WhProxyService {

    @Autowired
    private WhCommandService whCommandService;

    @Autowired
    private WhInvService whInvService;

    /**
     * 动作序列
     * 1.创建指令并自动完成
     * 2.创建占用
     *
     * @param commandList
     * @param occupyList
     * @return
     * @throws Exception 
     */
    @Transactional
    public boolean firstMethodCreateCommandThenFinishAnotherMethodOccupy(List<WhCommand> commandList,List<WhInvOccupy> occupyList) throws Exception{
        if(CollectionUtils.isNotEmpty(commandList)){
            for (WhCommand whCommand : commandList) {
                whCommandService.createCommandThenFinish(whCommand);
            }
        }
        if(CollectionUtils.isNotEmpty(occupyList)){
            whInvService.occupy(occupyList);
        }
        return true;
    }

}
