package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.common.utils.BeanUtil;
import com.thebeastshop.common.utils.EmptyUtil;
import com.thebeastshop.common.utils.NullUtil;
import com.thebeastshop.pegasus.service.warehouse.dao.WhJitPackageSkuReferenceMapper;
import com.thebeastshop.pegasus.service.warehouse.model.WhJitPackageSkuReference;
import com.thebeastshop.pegasus.service.warehouse.model.WhJitPackageSkuReferenceExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhJitPackageSkuReferenceService;
import com.thebeastshop.pegasus.service.warehouse.vo.AssociatedInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhJitPackageSkuReferenceVO;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * Created by Administrator on 2017/7/13.
 */

@Service("whJitPackageSkuReferenceService")
public class WhJitPackageSkuReferenceServiceImpl implements WhJitPackageSkuReferenceService {

    @Autowired
    private WhJitPackageSkuReferenceMapper whJitPackageSkuReferenceMapper;

    @Override
    @Transactional
    public boolean createWhJitPackageSkuReference(WhJitPackageSkuReferenceVO vo) {
        vo.setStatus(WhJitPackageSkuReferenceVO.STATUS_PROCESSING);
        vo.setCreateTime(DateUtil.getNow());
        WhJitPackageSkuReference record = buildModelFromVo(vo);
        whJitPackageSkuReferenceMapper.insert(record);
        return true;
    }
    
    @Override
    @Transactional
    public boolean updateByPrimaryKeySelective(WhJitPackageSkuReference record) {
    	return whJitPackageSkuReferenceMapper.updateByPrimaryKeySelective(record) != 0;
    }

    @Override
    @Transactional
    public boolean createWhJitPackageSkuReference(List<WhJitPackageSkuReferenceVO> voList) {
        if(EmptyUtil.isEmpty(voList)){
            return false;
        }
        for(WhJitPackageSkuReferenceVO vo : voList){
            createWhJitPackageSkuReference(vo);
        }
        return true;
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findByReferenceCode(String referenceCode) {
        return findByReferenceCode(Collections.singletonList(referenceCode));
    }
    
    @Override
    public List<WhJitPackageSkuReferenceVO> findBySkuCode(String skuCode) {
        return findBySkuCode(Collections.singletonList(skuCode));
    }
    
    @Override
    public List<WhJitPackageSkuReferenceVO> findByPackageCode(String packageCode) {
        return findByPackageCode(Collections.singletonList(packageCode));
    }
    
    /**
     * 根据相关单据号查找关联包裹的未分配数量
     *
     * @param referenceCode 单据号
     * @return 未分配数量
     */
    @Override
    public int findUndistributedNumberByreferenceCode(String referenceCode) {
    	final Map<String, String> params = new HashMap<>();
        params.put("referenceCode", referenceCode);
        return whJitPackageSkuReferenceMapper.findUndistributedNumberByreferenceCode(params);
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findByReferenceCode(List<String> referenceCodeList) {
        List<Integer> statusList = new ArrayList<>();
        statusList.add(WhJitPackageSkuReferenceVO.STATUS_PROCESSING);
        statusList.add(WhJitPackageSkuReferenceVO.STATUS_FINISHED);
        WhJitPackageSkuReferenceExample example = new WhJitPackageSkuReferenceExample();
        example.createCriteria().andReferenceCodeIn(referenceCodeList).andStatusIn(statusList);
        return BeanUtil.buildListFrom(whJitPackageSkuReferenceMapper.selectByExample(example),WhJitPackageSkuReferenceVO.class);
    }
    
    @Override
    public List<WhJitPackageSkuReferenceVO> findBySkuCode(List<String> skuCodeList) {
        List<Integer> statusList = new ArrayList<>();
        statusList.add(WhJitPackageSkuReferenceVO.STATUS_PROCESSING);
        statusList.add(WhJitPackageSkuReferenceVO.STATUS_FINISHED);
        WhJitPackageSkuReferenceExample example = new WhJitPackageSkuReferenceExample();
        example.createCriteria().andSkuCodeIn(skuCodeList).andStatusIn(statusList);
        return BeanUtil.buildListFrom(whJitPackageSkuReferenceMapper.selectByExample(example),WhJitPackageSkuReferenceVO.class);
    }
    
    @Override
    public List<WhJitPackageSkuReferenceVO> findByPackageCode(List<String> packageCodeList) {
        List<Integer> statusList = new ArrayList<>();
        statusList.add(WhJitPackageSkuReferenceVO.STATUS_PROCESSING);
        statusList.add(WhJitPackageSkuReferenceVO.STATUS_FINISHED);
        List<Integer> typeList = new ArrayList<>();
        typeList.add(2);
        typeList.add(4);
        WhJitPackageSkuReferenceExample example = new WhJitPackageSkuReferenceExample();
        example.createCriteria().andPackageCodeIn(packageCodeList).andStatusIn(statusList).andTypeIn(typeList);
        return BeanUtil.buildListFrom(whJitPackageSkuReferenceMapper.selectByExample(example),WhJitPackageSkuReferenceVO.class);
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findJitPackageRefByPackageCode(String packageCode,Integer type){
        List<Integer> statusList = new ArrayList<>();
        statusList.add(WhJitPackageSkuReferenceVO.STATUS_PROCESSING);
        statusList.add(WhJitPackageSkuReferenceVO.STATUS_FINISHED);
        WhJitPackageSkuReferenceExample example = new WhJitPackageSkuReferenceExample();
        example.createCriteria().andPackageCodeEqualTo(packageCode).andStatusIn(statusList).andTypeEqualTo(type);
        return BeanUtil.buildListFrom(whJitPackageSkuReferenceMapper.selectByExample(example),WhJitPackageSkuReferenceVO.class);
    }
    
    @Override
    public List<WhJitPackageSkuReferenceVO> findNeedAllotPackageByReferenceCode(String referenceCode,Integer type) {
        return BeanUtil.buildListFrom(whJitPackageSkuReferenceMapper.findNeedAllotPackageByReferenceCode(referenceCode,type),WhJitPackageSkuReferenceVO.class);
    }
    
    @Override
    public List<WhJitPackageSkuReferenceVO> findOpJitPackageReferenceListByTypeAndReferenceCode(String referenceCode,Integer type) {
    	WhJitPackageSkuReferenceExample example = new WhJitPackageSkuReferenceExample();
    	WhJitPackageSkuReferenceExample.Criteria criteria = example.createCriteria();
		criteria.andTypeEqualTo(type);
		criteria.andReferenceCodeEqualTo(referenceCode);
        return BeanUtil.buildListFrom(whJitPackageSkuReferenceMapper.selectByExample(example),WhJitPackageSkuReferenceVO.class);
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findOpJitPackageReferenceByTypeAndReferenceCode(List<String> referenceCodes, Integer type) {
        if(EmptyUtil.isEmpty(referenceCodes)){
            return new ArrayList<>();
        }
        WhJitPackageSkuReferenceExample example = new WhJitPackageSkuReferenceExample();
        WhJitPackageSkuReferenceExample.Criteria criteria = example.createCriteria();
        criteria.andTypeEqualTo(type);
        criteria.andReferenceCodeIn(referenceCodes);
        return BeanUtil.buildListFrom(whJitPackageSkuReferenceMapper.selectByExample(example),WhJitPackageSkuReferenceVO.class);
    }

    @Override
    public WhJitPackageSkuReferenceVO findLastUsableJitPackageReferenceByTypeAndReferenceCode(String referenceCode, Integer type) {
        List<Integer> statusList = new ArrayList<>();
        statusList.add(WhJitPackageSkuReferenceVO.STATUS_PROCESSING);
        statusList.add(WhJitPackageSkuReferenceVO.STATUS_FINISHED);
        WhJitPackageSkuReferenceExample example = new WhJitPackageSkuReferenceExample();
        WhJitPackageSkuReferenceExample.Criteria criteria = example.createCriteria();
        criteria.andTypeEqualTo(type);
        criteria.andReferenceCodeEqualTo(referenceCode);
        criteria.andStatusIn(statusList);
        example.setOrderByClause( "id desc");
        List<WhJitPackageSkuReference> list = whJitPackageSkuReferenceMapper.selectByExample(example);
        if(EmptyUtil.isNotEmpty(list)){
            return BeanUtil.buildFrom(list.get(0),WhJitPackageSkuReferenceVO.class);
        }
        return null;
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findNeedAllotByReferenceCode(String packageCode,String skuCode) {
        return whJitPackageSkuReferenceMapper.findNeedAllotByReferenceCode(packageCode,skuCode);
    }
    
    @Override
    public List<WhJitPackageSkuReferenceVO> findNeedAllotByPackageCodeAndSkuCode(String packageCode,String skuCode,Integer referenceType) {
        return whJitPackageSkuReferenceMapper.findNeedAllotByPackageCodeAndSkuCode(packageCode,skuCode,referenceType);
    }
    
    @Override
    public int countAssigndNumber(String packageCode,String skuCode) {
    	WhJitPackageSkuReferenceExample example = new WhJitPackageSkuReferenceExample();
    	example.createCriteria().andPackageCodeEqualTo(packageCode).andSkuCodeEqualTo(skuCode);
        return whJitPackageSkuReferenceMapper.countAssigndNumber(example);
    }
    
    @Override
    public WhJitPackageSkuReferenceVO findPopWarehouseByReferenceCode(String referenceCode) {
        return whJitPackageSkuReferenceMapper.findPopWarehouseByReferenceCode(referenceCode);
    }
    
    @Override
    public WhJitPackageSkuReferenceVO findPjWarehouseByReferenceCode(String referenceCode) {
        return whJitPackageSkuReferenceMapper.findPjWarehouseByReferenceCode(referenceCode);
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findByPackageCode(List<String> packageCodeList, Integer referenceType) {
        List<Integer> statusList = new ArrayList<>();
        statusList.add(WhJitPackageSkuReferenceVO.STATUS_PROCESSING);
        statusList.add(WhJitPackageSkuReferenceVO.STATUS_FINISHED);
        WhJitPackageSkuReferenceExample example = new WhJitPackageSkuReferenceExample();
        example.createCriteria().andPackageCodeIn(packageCodeList).andStatusIn(statusList).andTypeEqualTo(referenceType);
        return BeanUtil.buildListFrom(whJitPackageSkuReferenceMapper.selectByExample(example),WhJitPackageSkuReferenceVO.class);
    }

    @Override
    public Map<String, List<WhJitPackageSkuReferenceVO>> findByReferenceCodeGroup(List<String> referenceCodeList) {
        return groupByReferenceCode(findByReferenceCode(referenceCodeList));
    }

    private Map<String, List<WhJitPackageSkuReferenceVO>> groupByReferenceCode(List<WhJitPackageSkuReferenceVO> list){
        Map<String,List<WhJitPackageSkuReferenceVO>> map = new HashMap<>();
        if(EmptyUtil.isNotEmpty(list)){
            for(WhJitPackageSkuReferenceVO vo : list){
                List<WhJitPackageSkuReferenceVO> tmpList = map.get(vo.getReferenceCode());
                if(NullUtil.isNull(tmpList)){
                    tmpList = new ArrayList<>();
                    map.put(vo.getReferenceCode(),tmpList);
                }
                tmpList.add(vo);
            }
        }
        return map;
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findJitPackageSkuNotSendMailAfterJobCancel() {
        return whJitPackageSkuReferenceMapper.findJitPackageSkuNotSendMailAfterJobCancel();
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findJitPackageSkuNotSendMailAfterJobFinishException() {
        return whJitPackageSkuReferenceMapper.findJitPackageSkuNotSendMailAfterJobFinishException();
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findJitPackageSkuNotCreatePrdcJobAfterAltFinished() {
        return whJitPackageSkuReferenceMapper.findJitPackageSkuNotCreatePrdcJobAfterAltFinished();
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findJitPackageSkuNotSendMailAfterAltFinished(WhJitPackageSkuReferenceVO vo) {
        return whJitPackageSkuReferenceMapper.findJitPackageSkuNotSendMailAfterAltFinished(vo);
    }

    @Override
    public Map<String, List<WhJitPackageSkuReferenceVO>> findJitPackageSkuNotCreatePrdcJobAfterAltFinishedGroup() {
        return groupByReferenceCode(findJitPackageSkuNotCreatePrdcJobAfterAltFinished());
    }

    @Override
    public Map<String, List<WhJitPackageSkuReferenceVO>> findJitPackageSkuNotSendMailAfterAltFinishedGroup(WhJitPackageSkuReferenceVO vo) {
        return groupByReferenceCode(findJitPackageSkuNotSendMailAfterAltFinished(vo));
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findJitPackageSkuNotAltAfterPrdcJobFinished() {
        return whJitPackageSkuReferenceMapper.findJitPackageSkuNotAltAfterPrdcJobFinished();
    }

    @Override
    public Map<String, List<WhJitPackageSkuReferenceVO>> findJitPackageSkuNotAltAfterPrdcJobFinishedGroup() {
        return groupByReferenceCode(findJitPackageSkuNotAltAfterPrdcJobFinished());
    }

    @Override
    public Map<String, List<WhJitPackageSkuReferenceVO>> findJitPackageSkuOrderCancelGroup() {
        List<WhJitPackageSkuReferenceVO> list = whJitPackageSkuReferenceMapper.findJitPackageSkuOrderCancel();
        return groupByReferenceCode(list);
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findJitPackageSkuNotSendMailAfterOrderCancel() {
        return whJitPackageSkuReferenceMapper.findJitPackageSkuNotSendMailAfterOrderCancel();
    }

    @Override
    public Map<String, List<WhJitPackageSkuReferenceVO>> findJitPackageSkuNotProcessAfterOrderPaidGroup() {
        List<WhJitPackageSkuReferenceVO> list = whJitPackageSkuReferenceMapper.findJitPackageSkuNotProcessAfterOrderPaid();
        return groupByReferenceCode(list);
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findJitPackageSkuByPackageCode(List<String> packageCodes) {
        return whJitPackageSkuReferenceMapper.findJitPackageSkuByPackageCode(packageCodes);
    }
    
    @Override
    public List<WhJitPackageSkuReferenceVO> findReferenceCodeByPackageCode(List<String> packageCodes) {
        return whJitPackageSkuReferenceMapper.findReferenceCodeByPackageCode(packageCodes);
    }
    
    @Override
    public List<AssociatedInfoVO> findAssociatedInfoByreferenceCode(String referenceCode) {
        return whJitPackageSkuReferenceMapper.findAssociatedInfoByreferenceCode(referenceCode);
    }
    
    @Override
    public List<AssociatedInfoVO> findJobAssociatedInfoByreferenceCode(String referenceCode) {
        return whJitPackageSkuReferenceMapper.findJobAssociatedInfoByreferenceCode(referenceCode);
    }
    
    @Override
    public List<WhJitPackageSkuReferenceVO> findNonCustomByPackageCode(Long orderId) {
        return whJitPackageSkuReferenceMapper.findNonCustomByPackageCode(orderId);
    }

    @Override
    @Transactional
    public boolean deleteByReferenceCode(String referenceCode) {
        whJitPackageSkuReferenceMapper.deleteByReferenceCode(referenceCode);
        return true;
    }

    @Override
    @Transactional
    public boolean finishByReferenceCode(String referenceCode) {
        whJitPackageSkuReferenceMapper.finishByReferenceCode(referenceCode);
        return true;
    }

    private WhJitPackageSkuReference buildModelFromVo(WhJitPackageSkuReferenceVO vo){
        return BeanUtil.buildFrom(vo,WhJitPackageSkuReference.class);
    }

}
