package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.dao.WhJitPackageSendMailMapper;
import com.thebeastshop.pegasus.service.warehouse.model.WhJitPackageSendMail;
import com.thebeastshop.pegasus.service.warehouse.service.WhJitPackageSendMailService;
import com.thebeastshop.pegasus.service.warehouse.service.WhJitPackageSkuReferenceService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhJitPackageSendMailVO;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * Created by Administrator on 2017/7/14.
 */
@Service("whJitPackageSendMailService")
public class WhJitPackageSendMailServiceImpl implements WhJitPackageSendMailService {

    @Autowired
    private WhJitPackageSendMailMapper whJitPackageSendMailMapper;

    @Autowired
    private WhJitPackageSkuReferenceService whJitPackageSkuReferenceService;

    @Override
    @Transactional
    public boolean saveJitPackageSendMail(WhJitPackageSendMailVO vo) {
        vo.setCreateTime(DateUtil.getNow());
        whJitPackageSendMailMapper.insert(vo);
        whJitPackageSkuReferenceService.finishByReferenceCode(vo.getReferenceCode());
        return true;
    }
}
