/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.thebeastshop.pegasus.service.warehouse.dao.*;
import com.thebeastshop.pegasus.service.warehouse.model.*;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thebeastshop.common.validation.Validation;
import com.thebeastshop.pegasus.service.warehouse.WMSConstants;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWarehouseCond;
import com.thebeastshop.pegasus.service.warehouse.dao.custom.WhDistrictPhysicalWarehouseCustomMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.custom.WhPhysicalWarehouseRelateWarehouseCustomMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.service.WhInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsHouseShelvesService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsWarehouseAreaService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhDistrictPhysicalWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhPhysicalWarehouseRelateWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhPhysicalWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsHouseShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsWarehouseAreaVO;
import com.thebeastshop.pegasus.util.PegasusConstants;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.SQLUtils;

/**
 * @author Royan
 * @version $Id: WhInfoServiceImpl.java, v 0.1 2015-07-06 下午5:10
 */
@Service("whInfoService")
public class WhInfoServiceImpl implements WhInfoService {

    private final Logger              log = LoggerFactory.getLogger(WhInfoServiceImpl.class);

    @Autowired
    private WhPhysicalWarehouseMapper whPhysicalWarehouseMapper;

    @Autowired
    private WhWarehouseMapper         whWarehouseMapper;

    @Autowired
    private WhWmsExpressInfoMapper whWmsExpressInfoMapper;

    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;

    @Autowired
    private WhWmsWarehouseAreaService whWmsWarehouseAreaService;

    @Autowired
    private WhDistrictPhysicalWarehouseMapper whDistrictPhysicalWarehouseMapper;

    @Autowired
    private WhDistrictPhysicalWarehouseCustomMapper whDistrictPhysicalWarehouseCustomMapper;

    @Autowired
    private WhPhysicalWarehouseRelateWarehouseMapper whPhysicalWarehouseRelateWarehouseMapper;

    @Autowired
    private WhPhysicalWarehouseRelateWarehouseCustomMapper whPhysicalWarehouseRelateWarehouseCustomMapper;

    @Autowired
    private WhAllotRcdMapper whAllotRcdMapper;
    @Autowired
    private WhApplicatParaMapper whApplicatParaMapper;
    @Autowired
    private WhApplicatParaSkuMapper whApplicatParaSkuMapper;
    /**
     * 创建物理仓
     *
     * @param whPhysicalWarehouse 物理仓
     * @return 物理仓编码
     */
    @Override
    @Transactional
    public String createPhysicalWarehouse(WhPhysicalWarehouse whPhysicalWarehouse) {
        whPhysicalWarehouse.setCreateTime(new Date());
        whPhysicalWarehouse.setWarehouseStatus(PegasusConstants.STATUS_UNAVAILABLE);
        whPhysicalWarehouseMapper.insert(whPhysicalWarehouse);
        Map<String, Object> params = new HashMap<>();
        params.put("cityId", whPhysicalWarehouse.getCityId());
        params.put("id", whPhysicalWarehouse.getId());
        String code = CodeGenerator.getInstance().generate("WH_PHYSICAL_WAREHOUSE", params);
        whPhysicalWarehouse.setCode(code);
        whPhysicalWarehouse.setHouseNo(buildHouseNo(whPhysicalWarehouse.getId()));
        whPhysicalWarehouseMapper.updateByPrimaryKeySelective(whPhysicalWarehouse);
        if(!WhPhysicalWarehouseVO.WAREHOUSE_TYPE_WH_WMS.equals(whPhysicalWarehouse.getWarehouseType())){
            createDefaultShelves(whPhysicalWarehouse);
        }
        return code;
    }

    private String buildHouseNo(Long phyWarehouseId){
        Long tmepId = phyWarehouseId+20;
        return tmepId.toString();
    }

    //良品，样品，残次各一个
    private void createDefaultShelves(WhPhysicalWarehouse phyWarehouse){
        WhWmsHouseShelves houseShelves = buildEmptyShelves();
        WhWmsWarehouseArea area =  whWmsWarehouseAreaService.getAreaByHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_PUSH_KEEP);
        houseShelves.setHouseType(area.getHouseType());
        houseShelves.setPhysicalWarehouseCode(phyWarehouse.getCode());
        //良品
        houseShelves.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
        houseShelves.setShelves(getDefaultShelves(houseShelves.getSkuStatus()));
        houseShelves.setCode(phyWarehouse.getHouseNo()+"-"+area.getCode()+"-"+houseShelves.getShelves());
        whWmsHouseShelvesService.newHouseShelves(houseShelves);

        //样品
        houseShelves.setId(null);
        houseShelves.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE);
        houseShelves.setShelves(getDefaultShelves(houseShelves.getSkuStatus()));
        houseShelves.setCode(phyWarehouse.getHouseNo()+"-"+area.getCode()+"-"+houseShelves.getShelves());
        whWmsHouseShelvesService.newHouseShelves(houseShelves);

        // 陈列品
        houseShelves.setId(null);
        houseShelves.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_DISPLAY);
        houseShelves.setShelves(getDefaultShelves(houseShelves.getSkuStatus()));
        houseShelves.setCode(phyWarehouse.getHouseNo()+"-"+area.getCode()+"-"+houseShelves.getShelves());
        whWmsHouseShelvesService.newHouseShelves(houseShelves);

        // 道具
        houseShelves.setId(null);
        houseShelves.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_PROP);
        houseShelves.setShelves(getDefaultShelves(houseShelves.getSkuStatus()));
        houseShelves.setCode(phyWarehouse.getHouseNo()+"-"+area.getCode()+"-"+houseShelves.getShelves());
        whWmsHouseShelvesService.newHouseShelves(houseShelves);

        //轻残品
        houseShelves.setId(null);
        houseShelves.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED);
        houseShelves.setShelves(getDefaultShelves(houseShelves.getSkuStatus()));
        houseShelves.setCode(phyWarehouse.getHouseNo()+"-"+area.getCode()+"-"+houseShelves.getShelves());
        whWmsHouseShelvesService.newHouseShelves(houseShelves);

        //中残品
        houseShelves.setId(null);
        houseShelves.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_MODERATE_DAMAGED);
        houseShelves.setShelves(getDefaultShelves(houseShelves.getSkuStatus()));
        houseShelves.setCode(phyWarehouse.getHouseNo()+"-"+area.getCode()+"-"+houseShelves.getShelves());
        whWmsHouseShelvesService.newHouseShelves(houseShelves);

        //重残品
        houseShelves.setId(null);
        houseShelves.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_SEVERE_DAMAGED);
        houseShelves.setShelves(getDefaultShelves(houseShelves.getSkuStatus()));
        houseShelves.setCode(phyWarehouse.getHouseNo()+"-"+area.getCode()+"-"+houseShelves.getShelves());
        whWmsHouseShelvesService.newHouseShelves(houseShelves);

        //废品
        houseShelves.setId(null);
        houseShelves.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_WASTED);
        houseShelves.setShelves(getDefaultShelves(houseShelves.getSkuStatus()));
        houseShelves.setCode(phyWarehouse.getHouseNo()+"-"+area.getCode()+"-"+houseShelves.getShelves());
        whWmsHouseShelvesService.newHouseShelves(houseShelves);
    }

    private WhWmsHouseShelves buildEmptyShelves(){
        WhWmsHouseShelves houseShelves = new WhWmsHouseShelves();
        houseShelves.setMixedType(WhWmsHouseShelvesVO.MIXED_TYPE_UNLIMIT);
        houseShelves.setShelvesStatus(WhWmsHouseShelvesVO.SHELVES_STATUS_UNOCCUPY);
        houseShelves.setShelvesUsableStatus(WhWmsHouseShelvesVO.SHELVES_USABLE_SUATUS_AVAILABLE);
        houseShelves.setCreateTime(DateUtil.getNow());
        houseShelves.setShelvesType(WhWmsHouseShelvesVO.SHELVES_TYPE_NORMAL);
        houseShelves.setStorageType(WhWmsHouseShelvesVO.STORAGE_TYPE_NORMAL_TEMPERATURE);
        houseShelves.setShelvesStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
        houseShelves.setSortOrder(null);
        houseShelves.setCreateUserId(null);
        return houseShelves;
    }

    private String getDefaultShelves(Integer skuStatus){
        return WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE.equals(skuStatus)?"01-01-01-01":
                 WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE.equals(skuStatus)?"01-01-01-02":
                   WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED.equals(skuStatus)?"01-01-01-03":
                     WhWarehouseVO.COMMODITY_STATUS_FOR_WASTED.equals(skuStatus)?"01-01-01-04":
                       WhWarehouseVO.COMMODITY_STATUS_FOR_MODERATE_DAMAGED.equals(skuStatus)?"01-01-01-05":
                         WhWarehouseVO.COMMODITY_STATUS_FOR_SEVERE_DAMAGED.equals(skuStatus)?"01-01-01-06":
                            WhWarehouseVO.COMMODITY_STATUS_FOR_DISPLAY.equals(skuStatus)?"01-01-01-07":
                                WhWarehouseVO.COMMODITY_STATUS_FOR_PROP.equals(skuStatus)?"01-01-01-08":"";
    }

    /**
     * 更新物理仓
     *
     * @param whPhysicalWarehouse 物理仓
     * @return 是否成功
     */
    @Override
    public boolean updatePhysicalWarehouse(WhPhysicalWarehouse whPhysicalWarehouse) {
        return whPhysicalWarehouseMapper.updateByPrimaryKeySelective(whPhysicalWarehouse) != 0;
    }
    @Override
    public void saveOrUpdateApplicationPara(String bu, boolean autoAudit) {
        WhApplicatParaExample example = new WhApplicatParaExample();
        example.createCriteria().andBuEqualTo(bu);
        List<WhApplicatPara> whApplicatParaList = whApplicatParaMapper.selectByExample(example);
        if(whApplicatParaList != null && whApplicatParaList.size() > 0){
            WhApplicatPara whApplicatPara = whApplicatParaList.get(0);
            whApplicatPara.setBu(bu);
            whApplicatPara.setAutoAudit(autoAudit?1:0);
            whApplicatParaMapper.updateByPrimaryKeySelective(whApplicatPara);
        }else{
            WhApplicatPara whApplicatPara = new WhApplicatPara();
            whApplicatPara.setBu(bu);
            whApplicatPara.setAutoAudit(autoAudit?1:0);
            whApplicatParaMapper.insertSelective(whApplicatPara);
        }
    }

    @Override
    public WhApplicatPara findWhApplicationParaByBu(String bu) {
        WhApplicatParaExample example = new WhApplicatParaExample();
        example.createCriteria().andBuEqualTo(bu);
        List<WhApplicatPara> list = whApplicatParaMapper.selectByExample(example);
        if(list != null && list.size() > 0){
            return list.get(0);
        }
        return null;
    }

    @Override
    public List<WhApplicatPara> findAllWhApplicationPara() {
        return whApplicatParaMapper.selectByExample(new WhApplicatParaExample());
    }

    @Override
    public List<WhApplicatParaSku> findWhApplicationParaSkuBySkuCode(String skuCode) {
        WhApplicatParaSkuExample example = new WhApplicatParaSkuExample();
        example.createCriteria().andSkuCodeEqualTo(skuCode);
        return whApplicatParaSkuMapper.selectByExample(example);
    }

    @Override
    public List<WhWmsExpressInfo> findAllExpressInfo() {
        WhWmsExpressInfoExample expressInfoExample = new WhWmsExpressInfoExample();
        expressInfoExample.createCriteria().andCancelFlagEqualTo(0);
        expressInfoExample.setOrderByClause("id");
        return whWmsExpressInfoMapper.selectByExample(expressInfoExample);
    }

    /**
     * 根据编码更新物理仓
     *
     * @param code                编码
     * @param whPhysicalWarehouse 物理仓
     * @return 是否成功
     */
    @Override
    public boolean updatePhysicalWarehouseByCode(String code,
                                                 WhPhysicalWarehouse whPhysicalWarehouse) {
        WhPhysicalWarehouseExample example = new WhPhysicalWarehouseExample();
        example.createCriteria().andCodeEqualTo(code);
        return whPhysicalWarehouseMapper.updateByExampleSelective(whPhysicalWarehouse, example) != 0;
    }

    @Override
    public WhWmsExpressInfo findExpressInfoById(Long id) {
        return whWmsExpressInfoMapper.selectByPrimaryKey(id);
    }

    /**
     * 删除物理仓
     *
     * @param whPhysicalWarehouse 物理仓
     * @return 是否成功
     */
    @Override
    public boolean deletePhysicalWarehouse(WhPhysicalWarehouse whPhysicalWarehouse) {
        return whPhysicalWarehouseMapper.deleteByPrimaryKey(whPhysicalWarehouse.getId()) != 0;
    }

    /**
     * 根据编码查找物理仓
     *
     * @param code 物理仓编码
     * @return 物理仓
     */
    @Override
    public WhPhysicalWarehouse findPhysicalWarehouseByCode(String code) {
        WhPhysicalWarehouseExample example = new WhPhysicalWarehouseExample();
        example.createCriteria().andCodeEqualTo(code);
        example.setOrderByClause("id");
        List<WhPhysicalWarehouse> whPhysicalWarehouseList = whPhysicalWarehouseMapper
            .selectByExample(example);
        return (whPhysicalWarehouseList != null && !whPhysicalWarehouseList.isEmpty()) ? whPhysicalWarehouseList
            .get(0) : null;
    }

    @Override
    public WhPhysicalWarehouseVO findPhysicalWarehouseVOAndWarehouseGroupByPhyCode(String code) {
        List<WhPhysicalWarehouseVO> whPhysicalWarehouseList = whPhysicalWarehouseMapper.findPhysicalWarehouseVOAndWarehouseGroupByPhyCode(code);
        return (whPhysicalWarehouseList != null && !whPhysicalWarehouseList.isEmpty()) ? whPhysicalWarehouseList
            .get(0) : null;
    }

    @Override
    public WhPhysicalWarehouse findPhysicalWarehouseById(Long id) {
        return whPhysicalWarehouseMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<WhPhysicalWarehouseVO> findPhysicalWarehouseByGroupId(List<Long> warehouseGroupIds) {
        if(EmptyUtil.isEmpty(warehouseGroupIds)){
            return Collections.emptyList();
        }
        WhPhysicalWarehouseExample example = new WhPhysicalWarehouseExample();
        example.createCriteria().andWarehouseGroupIdIn(warehouseGroupIds);
        List<WhPhysicalWarehouse> whPhysicalWarehouseList = whPhysicalWarehouseMapper.selectByExample(example);
        return BeanUtil.buildListFrom(whPhysicalWarehouseList,WhPhysicalWarehouseVO.class);
    }

    @Override
    public Map<Long, List<WhPhysicalWarehouseVO>> findPhysicalWarehouseMapByGroupId(List<Long> warehouseGroupIds) {
        List<WhPhysicalWarehouseVO> physicalWarehouseList = findPhysicalWarehouseByGroupId(warehouseGroupIds);
        Map<Long, List<WhPhysicalWarehouseVO>> map = new HashMap<>();
        if(EmptyUtil.isNotEmpty(physicalWarehouseList)){
            for(WhPhysicalWarehouseVO phyWh : physicalWarehouseList){
                List<WhPhysicalWarehouseVO> groupList = map.get(phyWh.getWarehouseGroupId());
                if(NullUtil.isNull(groupList)){
                    groupList = new ArrayList<>();
                    map.put(phyWh.getWarehouseGroupId(),groupList);
                }
                groupList.add(phyWh);
            }
        }
        return map;
    }

    @Override
    public List<WhPhysicalWarehouse> findPhysicalWarehouseByNameCode(String nameOrCode) {
        return whPhysicalWarehouseMapper.findPhysicalWarehouseByNameCode(SQLUtils.allLike(nameOrCode));
    }
    
    @Override
    public List<WhPhysicalWarehouse> findNewPhysicalWarehouseByNameOrCode(String nameOrCode) {
        return whPhysicalWarehouseMapper.findNewPhysicalWarehouseByNameOrCode(SQLUtils.allLike(nameOrCode));
    }

    @Override
    public List<WhPhysicalWarehouse> listPhysicalWarehouseByIds(List<Long> ids) {
        WhPhysicalWarehouseExample example = new WhPhysicalWarehouseExample();
        example.createCriteria().andIdIn(ids);
        return whPhysicalWarehouseMapper.selectByExample(example);
    }


    @Override
    public List<WhPhysicalWarehouse> findPhysicalWarehouseByDistrict(List<Long> districtIds) {
        WhPhysicalWarehouseExample example = new WhPhysicalWarehouseExample();
        example.createCriteria().andCityIdIn(districtIds);
        return whPhysicalWarehouseMapper.selectByExample(example);
    }

    /**
     * 查找所有物理仓（含禁用）
     *
     * @return 物理仓列表
     */
    @Override
    public List<WhPhysicalWarehouse> findAllPhysicalWarehouse() {
        WhPhysicalWarehouseExample example = new WhPhysicalWarehouseExample();
        example.setOrderByClause("id");
        return whPhysicalWarehouseMapper.selectByExample(example);
    }

    @Override
    public Map<String, WhPhysicalWarehouseVO> findAllPhysicalWarehouseMap() {
        Map<String,WhPhysicalWarehouseVO> map = new HashMap<>();
        List<WhPhysicalWarehouse> list = findAllPhysicalWarehouse();
        if(EmptyUtil.isNotEmpty(list)){
            for(WhPhysicalWarehouse phyWh : list){
                map.put(phyWh.getCode(),BeanUtil.buildFrom(phyWh,WhPhysicalWarehouseVO.class));
            }
        }
        return map;
    }

    @Override
    public List<WhPhysicalWarehouse> findPhysicalWarehouseByCond(WhPhysicalWarehouseVO whPhysicalWarehouseVO) {
        WhPhysicalWarehouseExample example = new WhPhysicalWarehouseExample();
        WhPhysicalWarehouseExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty(whPhysicalWarehouseVO.getCode())){
            criteria.andCodeEqualTo(whPhysicalWarehouseVO.getCode());
        }
        if (EmptyUtil.isNotEmpty(whPhysicalWarehouseVO.getName())){
            criteria.andNameLike(SQLUtils.allLike(whPhysicalWarehouseVO.getName()));
        }
        if (EmptyUtil.isNotEmpty(whPhysicalWarehouseVO.getWarehouseType())){
            criteria.andWarehouseTypeEqualTo(whPhysicalWarehouseVO.getWarehouseType());
        }
        if (CollectionUtils.isNotEmpty(whPhysicalWarehouseVO.getWarehouseCodes())){
            criteria.andCodeIn(whPhysicalWarehouseVO.getWarehouseCodes());
        }
        if (CollectionUtils.isNotEmpty(whPhysicalWarehouseVO.getWarehouseTypeList())){
            criteria.andWarehouseTypeIn(whPhysicalWarehouseVO.getWarehouseTypeList());
        }
        example.setOrderByClause("id");
        return whPhysicalWarehouseMapper.selectByExample(example);
    }

    @Override
    public List<WhPhysicalWarehouseVO> listOffLinePhysicalWarehouse(WhPhysicalWarehouseVO whPhysicalWarehouseVO) {
        return whPhysicalWarehouseMapper.listOffLinePhysicalWarehouse(whPhysicalWarehouseVO);
    }

    @Override
    public List<WhDistrictPhysicalWarehouseVO> findDistrictPyWarehouseByExample(WhDistrictPhysicalWarehouseVO whDistrictPhysicalWarehouseVO){
        WhDistrictPhysicalWarehouseExample example = new WhDistrictPhysicalWarehouseExample();
        WhDistrictPhysicalWarehouseExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty(whDistrictPhysicalWarehouseVO.getDistrictId())){
            criteria.andDistrictIdEqualTo(whDistrictPhysicalWarehouseVO.getDistrictId());
        }
        if (EmptyUtil.isNotEmpty(whDistrictPhysicalWarehouseVO.getPhysicalWarehouseCode())){
            criteria.andPhysicalWarehouseCodeEqualTo(whDistrictPhysicalWarehouseVO.getPhysicalWarehouseCode());
        }
        if (EmptyUtil.isNotEmpty(whDistrictPhysicalWarehouseVO.getOperatorId())){
            criteria.andOperatorIdEqualTo(whDistrictPhysicalWarehouseVO.getOperatorId());
        }
        example.setOrderByClause("id");
        List<WhDistrictPhysicalWarehouse> whDistrictPhysicalWarehouses = whDistrictPhysicalWarehouseMapper.selectByExample(example);
        return BeanUtil.buildListFrom(whDistrictPhysicalWarehouses,WhDistrictPhysicalWarehouseVO.class);
    }

    @Override
    public List<WhDistrictPhysicalWarehouseVO> findDistrictPyWarehouseByCodeAndDistrictId(List<String> codes,Long districtId){
        WhDistrictPhysicalWarehouseExample example = new WhDistrictPhysicalWarehouseExample();
        WhDistrictPhysicalWarehouseExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty(districtId)){
            criteria.andDistrictIdEqualTo(districtId);
        }
        if (EmptyUtil.isNotEmpty(codes)){
            criteria.andPhysicalWarehouseCodeIn(codes);
        }
        example.setOrderByClause("sort");
        List<WhDistrictPhysicalWarehouse> whDistrictPhysicalWarehouses = whDistrictPhysicalWarehouseMapper.selectByExample(example);
        return BeanUtil.buildListFrom(whDistrictPhysicalWarehouses,WhDistrictPhysicalWarehouseVO.class);
    }

    @Override
    public List<WhDistrictPhysicalWarehouseVO> listDistrictPyWarehouseByCond(WhDistrictPhysicalWarehouseVO whDistrictPhysicalWarehouseVO){
        return whDistrictPhysicalWarehouseCustomMapper.listWhDistrictPhysicalWarehouseByCond(whDistrictPhysicalWarehouseVO);
    }

    @Override
    @Transactional
    public int batchInsertDistrictPyWarehouse(List<WhDistrictPhysicalWarehouseVO> whDistrictPhysicalWarehouseVOs){
        return whDistrictPhysicalWarehouseCustomMapper.batchInsert(whDistrictPhysicalWarehouseVOs);
    }

    @Override
    @Transactional
    public int deleteDistrictPyWarehouseByExample(WhDistrictPhysicalWarehouseVO whDistrictPhysicalWarehouseVO){
        WhDistrictPhysicalWarehouseExample example = new WhDistrictPhysicalWarehouseExample();
        WhDistrictPhysicalWarehouseExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty(whDistrictPhysicalWarehouseVO.getDistrictId())){
            criteria.andDistrictIdEqualTo(whDistrictPhysicalWarehouseVO.getDistrictId());
        }
        if (EmptyUtil.isNotEmpty(whDistrictPhysicalWarehouseVO.getPhysicalWarehouseCode())){
            criteria.andPhysicalWarehouseCodeEqualTo(whDistrictPhysicalWarehouseVO.getPhysicalWarehouseCode());
        }
        return whDistrictPhysicalWarehouseMapper.deleteByExample(example);
    }

    @Override
    public void insertApplicationParaSku(WhApplicatParaSku whApplicatParaSku) {
        whApplicatParaSkuMapper.insertSelective(whApplicatParaSku);
    }

    @Override
    public void deleteApplicationParaSku(String skuCode) {
        WhApplicatParaSkuExample example = new WhApplicatParaSkuExample();
        example.createCriteria().andSkuCodeEqualTo(skuCode);
        whApplicatParaSkuMapper.deleteByExample(example);
    }

    @Override
    public List<WhApplicatParaSku> findAllWhApplicationParaSku() {
        WhApplicatParaSkuExample example = new WhApplicatParaSkuExample();
        return whApplicatParaSkuMapper.selectByExample(example);
    }

    /**
     * 查找所有可用物理仓
     *
     * @return 物理仓列表
     */
    @Override
    public List<WhPhysicalWarehouse> findPhysicalWarehouse() {
        WhPhysicalWarehouseExample example = new WhPhysicalWarehouseExample();
        example.createCriteria().andWarehouseStatusEqualTo(PegasusConstants.STATUS_AVAILABLE);
        example.setOrderByClause("id");
        return whPhysicalWarehouseMapper.selectByExample(example);
    }

    /**
     * 根据逻辑仓查找物理仓
     *
     * @param warehouseCode 逻辑仓编码
     * @return 物理仓列表
     */
    @Override
    @Deprecated
    public WhPhysicalWarehouse findPhysicalWarehouseByWarehouse(String warehouseCode) {
        return whPhysicalWarehouseMapper.findPhysicalWarehouseByWarehouse(warehouseCode);
    }

    @Override
    public List<WhPhysicalWarehouse> findPhysicalWarehouseByWarehouseCodes(Set<String> warehouseCodeSet) {
        return whPhysicalWarehouseMapper.findPhysicalWarehouseByWarehouseCodes(warehouseCodeSet);
    }

    @Override
    public List<WhPhysicalWarehouse> findPhysicalWarehouseByWarehouseCodesNew(Set<String> warehouseCodeSet) {
        return whPhysicalWarehouseMapper.findPhysicalWarehouseByWarehouseCodesNew(warehouseCodeSet);
    }

    /**
     * 创建逻辑仓
     *
     * @param whPhysicalWarehouse 物理仓 不再使用
     * @param whWarehouse         逻辑仓
     * @return 逻辑仓编码
     */
    @Override
    @Transactional
    public String createWarehouse(WhPhysicalWarehouse whPhysicalWarehouse, WhWarehouse whWarehouse) {
        // 去除
        /*if (whPhysicalWarehouse.getId() == null && whPhysicalWarehouse.getCode() != null) {
            whPhysicalWarehouse = findPhysicalWarehouseByCode(whPhysicalWarehouse.getCode());
        }*/

        //checkWarehouseArchiveToPhysicalWarehouse(whPhysicalWarehouse, whWarehouse);

        //whWarehouse.setPhysicalWarehouseId(whPhysicalWarehouse.getId());
        // 不再需要,但表结构不为空，要给个默认值
        whWarehouse.setPhysicalWarehouseId(0L);
        // 默认值
        whWarehouse.setWarehouseStatus(PegasusConstants.STATUS_UNAVAILABLE);
        whWarehouseMapper.insert(whWarehouse);
        Map<String, Object> params = new HashMap<>();
        //params.put("physicalWarehouseCode", whPhysicalWarehouse.getCode());
        params.put("physicalWarehouseCode", generateParamCode(whWarehouse));
        params.put("id", whWarehouse.getId());
        String code = CodeGenerator.getInstance().generate("WAREHOUSE", params);
        whWarehouse.setCode(code);
        whWarehouseMapper.updateByPrimaryKeySelective(whWarehouse);
        return code;
    }

    /**
     * code生成规则[WH000+ID+逻辑仓类型+逻辑仓状态+]
     * @param whWarehouse
     * @return
     */
    private String generateParamCode(WhWarehouse whWarehouse){
        Long id = whWarehouse.getId();
        StringBuffer idStr = new StringBuffer(id.toString());
        int idLength = idStr.length();
        if (idLength<3){
            while((3-idLength)>0){
                idStr.insert(0,"0");
                idLength++;
            }
        }
        return "WH000"+idStr.toString()+whWarehouse.getWarehouseType().toString()+whWarehouse.getCommodityStatus();
    }

    /**
     * 更新逻辑仓
     *
     * @param whWarehouse 逻辑仓
     * @return 是否成功
     */
    @Override
    public boolean updateWarehouse(WhWarehouse whWarehouse) {
        WhWarehouse old = findWarehouseByCode(whWarehouse.getCode());
        whWarehouse.setId(old.getId());
        // WhPhysicalWarehouse whPhysicalWarehouse = whPhysicalWarehouseMapper.selectByPrimaryKey(old.getPhysicalWarehouseId());
        // checkWarehouseArchiveToPhysicalWarehouse(whPhysicalWarehouse, whWarehouse);

        return whWarehouseMapper.updateByPrimaryKeySelective(whWarehouse) != 0;
    }

    /**
     * 根据编码更新逻辑仓
     *
     * @param code        逻辑仓编码
     * @param whWarehouse 逻辑仓
     * @return 是否成功
     */
    @Override
    public boolean updateWarehouseByCode(String code, WhWarehouse whWarehouse) {
        WhWarehouse old = findWarehouseByCode(whWarehouse.getCode());
        whWarehouse.setId(old.getId());
        // WhPhysicalWarehouse whPhysicalWarehouse = whPhysicalWarehouseMapper.selectByPrimaryKey(old.getPhysicalWarehouseId());
        // checkWarehouseArchiveToPhysicalWarehouse(whPhysicalWarehouse, whWarehouse);

        WhWarehouseExample example = new WhWarehouseExample();
        example.createCriteria().andCodeEqualTo(code);
        return whWarehouseMapper.updateByExampleSelective(whWarehouse, example) != 0;
    }

    /**
     * 删除逻辑仓
     *
     * @param whWarehouse 逻辑仓
     * @return 是否成功
     */
    @Override
    public boolean deleteWarehouse(WhWarehouse whWarehouse) {
        return whWarehouseMapper.deleteByPrimaryKey(whWarehouse.getId()) != 0;
    }

    /**
     * 根据编码查找逻辑仓
     *
     * @param code 逻辑仓编码
     * @return 逻辑仓
     */
    @Override
    public WhWarehouse findWarehouseByCode(String code) {
        WhWarehouseExample example = new WhWarehouseExample();
        example.createCriteria().andCodeEqualTo(code);
        example.setOrderByClause("id");
        List<WhWarehouse> whWarehouseList = whWarehouseMapper.selectByExample(example);
        return (whWarehouseList != null && !whWarehouseList.isEmpty()) ? whWarehouseList.get(0)
            : null;
    }

    @Override
    public WhWarehouseVO findWarehouseAndGroupByWarehouseCode(String code) {
        List<WhWarehouseVO> whWarehouseList = whWarehouseMapper.findWarehouseAndGroupByWarehouseCode(code);
        return (whWarehouseList != null && !whWarehouseList.isEmpty()) ? whWarehouseList.get(0): null;
    }

    @Override
    public List<WhWarehouseVO> findWarehouseAndGroupByWarehouseCodes(List<String> warehouseCode) {
        List<WhWarehouseVO> whWarehouseList = whWarehouseMapper.findWarehouseAndGroupByWarehouseCodes(warehouseCode);
        return (whWarehouseList != null && !whWarehouseList.isEmpty()) ? whWarehouseList: null;
    }

    /**
     * 根据编码列表查找逻辑仓
     *
     * @param codes 逻辑仓编码列表
     * @return 逻辑仓列表
     */
    @Override
    public List<WhWarehouse> findWarehouseByCodes(List<String> codes) {
        if (EmptyUtil.isEmpty(codes)) {
            return new ArrayList<>();
        }
        WhWarehouseExample example = new WhWarehouseExample();
        example.createCriteria().andCodeIn(codes);
        // example.setOrderByClause("PHYSICAL_WAREHOUSE_ID,ID");
        example.setOrderByClause("CODE,ID");
        List<WhWarehouse> whWarehouseList = whWarehouseMapper.selectByExample(example);
        return whWarehouseList;
    }

    @Override
    public Map<String, WhWarehouseVO> findWarehouseMapByCodes(List<String> codes) {
        Map<String,WhWarehouseVO> map = new HashMap<>();
        List<WhWarehouse> list = findWarehouseByCodes(codes);
        if(EmptyUtil.isNotEmpty(list)){
            for(WhWarehouse warehouse : list){
                map.put(warehouse.getCode(),BeanUtil.buildFrom(warehouse,WhWarehouseVO.class));
            }
        }
        return map;
    }

    @Override
    public List<WhWarehouseVO> findWarehouseByGroupId(List<Long> warehouseGroupIds) {
        if (EmptyUtil.isEmpty(warehouseGroupIds)) {
            return Collections.emptyList();
        }
        WhWarehouseExample example = new WhWarehouseExample();
        example.createCriteria().andWarehouseGroupIdIn(warehouseGroupIds);
        List<WhWarehouse> whWarehouseList = whWarehouseMapper.selectByExample(example);
        return BeanUtil.buildListFrom(whWarehouseList,WhWarehouseVO.class);
    }

    @Override
    public Map<Long, List<WhWarehouseVO>> findWarehouseMapByGroupId(List<Long> warehouseGroupIds) {
        List<WhWarehouseVO> warehouseList = findWarehouseByGroupId(warehouseGroupIds);
        Map<Long,List<WhWarehouseVO>> map = new HashMap<>();
        if(EmptyUtil.isNotEmpty(warehouseList)){
            for(WhWarehouseVO whWarehouse : warehouseList){
                List<WhWarehouseVO> groupList = map.get(whWarehouse.getWarehouseGroupId());
                if(NullUtil.isNull(groupList)){
                    groupList = new ArrayList<>();
                    map.put(whWarehouse.getWarehouseGroupId(),groupList);
                }
                groupList.add(whWarehouse);
            }
        }
        return map;
    }

    @Override
    public List<WhWarehouse> findGroupWarehouseSorted(String phyWhCode, Integer skuStatus) {
        return whWarehouseMapper.findGroupWarehouseSorted(phyWhCode,skuStatus);
    }

    @Override
    public Map<Integer, List<WhWarehouse>> findGroupWarehouseSortedMap(String phyWhCode, Integer skuStatus) {
        Map<Integer, List<WhWarehouse>> map = new HashMap<>();
        List<WhWarehouse> whList = findGroupWarehouseSorted(phyWhCode,skuStatus);
        if(EmptyUtil.isNotEmpty(whList)){
            for(WhWarehouse wh : whList){
                List<WhWarehouse> statusList = map.get(wh.getCommodityStatus());
                if(NullUtil.isNull(statusList)){
                    statusList = new ArrayList<>();
                    map.put(wh.getCommodityStatus(),statusList);
                }
                statusList.add(wh);
            }
        }
        return map;
    }

    /**
     * 根据条件查找逻辑仓
     *
     * @param cond 条件
     * @return 逻辑仓列表
     */
    @Override
    public List<WhWarehouse> findWarehouseByCond(WhWarehouseCond cond) {
        return whWarehouseMapper.findWarehouseByCond(cond);
    }

    /**
     * 根据名字/编码查找逻辑仓
     *
     * @param nameOrCode 名字/编码
     * @return 逻辑仓列表
     */
    @Override
    public List<WhWarehouse> findWarehouseByNameCode(String nameOrCode) {
        nameOrCode = SQLUtils.allLike(nameOrCode);
        return whWarehouseMapper.findWarehouseByNameCode(nameOrCode);
    }

    @Override
    public List<WhWarehouse> findGroupWarehouseByNameCode(String nameOrCode, String physicalWarehouseCode,Boolean noPage) {
        if(EmptyUtil.isEmpty(physicalWarehouseCode)){
            return Collections.emptyList();
        }
        if (EmptyUtil.isNotEmpty(nameOrCode)){
            nameOrCode = SQLUtils.allLike(nameOrCode);
        }
        return whWarehouseMapper.findGroupWarehouseByNameCode(nameOrCode,physicalWarehouseCode,noPage);
    }

    /**
     * 根据名字/编码和类型查找逻辑仓
     *
     * @param nameOrCode    名字/编码
     * @param warehouseType 类型
     * @return 逻辑仓列表
     */
    @Override
    public List<WhWarehouse> findWarehouseByNameCodeAndType(String nameOrCode, Integer warehouseType) {
        nameOrCode = SQLUtils.allLike(nameOrCode);
        return whWarehouseMapper.findWarehouseByNameCodeAndType(nameOrCode, warehouseType);
    }

    @Override
    @Deprecated
    public List<WhWarehouse> findWarehouseByNameAndWaitForDispatchingFilter(String nameOrCode, Integer filterRuleType) {
        nameOrCode = SQLUtils.allLike(nameOrCode);
        return whWarehouseMapper.findWarehouseByNameCodeAndTypeFilter(nameOrCode, filterRuleType);
    }

    /**
     * 根据仓库编码查找同物理仓下唯一的良品待分配仓
     *
     * @param warehouseCode
     * @return
     */
    @Override
    @Deprecated
    public WhWarehouse findUniqWaitForDispatchingWarehouse(String warehouseCode) {
        return findUniqWarehouseByType(warehouseCode, WhWarehouseVO.TYPE_WAIT_FOR_DISPATCHING);
    }

    /**
     * 根据仓库编码查找同物理仓下唯一的残次仓
     *
     * @param warehouseCode
     * @return
     */
    @Override
    @Deprecated
    public WhWarehouse findUniqDamagedWarehouse(String warehouseCode) {
        return findUniqWarehouseByType(warehouseCode, WhWarehouseVO.TYPE_DAMAGED);
    }

    /**
     * 根据仓库编码查找同物理仓下唯一的报废仓
     *
     * @param warehouseCode
     * @return
     */
    @Override
    @Deprecated
    public WhWarehouse findUniqWastedWarehouse(String warehouseCode) {
        return findUniqWarehouseByType(warehouseCode, WhWarehouseVO.TYPE_WASTED);
    }

    /**
     * 根据仓库编码查找同物理仓下唯一的生产加工仓
     *
     * @param warehouseCode
     * @return
     */
    @Override
    @Deprecated
    public WhWarehouse findUniqProducingWarehouse(String warehouseCode) {
        return findUniqWarehouseByType(warehouseCode, WhWarehouseVO.TYPE_PRODUCING);
    }

    /**
     * 判断两个是否在同一物理仓
     *
     * @param warehouseCode1 逻辑仓1
     * @param warehouseCode2 逻辑仓2
     * @return
     */
    @Override
    public boolean isInSamePhysicalWarehouse(String warehouseCode1, String warehouseCode2) {
        WhWarehouse warehouse1 = findWarehouseByCode(warehouseCode1);
        if (warehouse1 == null) {
            return false;
        }
        WhWarehouse warehouse2 = findWarehouseByCode(warehouseCode2);
        if (warehouse2 == null) {
            return false;
        }

        return warehouse1.getWarehouseGroupId().equals(warehouse2.getWarehouseGroupId());
    }

    /**
     * 判断两个是否库间移动（瞬间完成）
     * 逻辑变动 通过逻辑仓无法判断 2017-12-12
     * @param warehouseCode1 逻辑仓1
     * @param warehouseCode2 逻辑仓2
     * @return
     */
    @Override
    @Deprecated
    public boolean isWarehouseMove(String warehouseCode1, String warehouseCode2) {
        WhWarehouse warehouse1 = findWarehouseByCode(warehouseCode1);
        if (warehouse1 == null) {
            return false;
        }
        WhWarehouse warehouse2 = findWarehouseByCode(warehouseCode2);
        if (warehouse2 == null) {
            return false;
        }

        if (!warehouse1.getPhysicalWarehouseId().equals(warehouse2.getPhysicalWarehouseId())) {
            return false;
        }

        Integer warehouseType1 = warehouse1.getWarehouseType();
        Integer warehouseType2 = warehouse2.getWarehouseType();

        // 1良品待分配仓2残次品仓3废品仓4礼品仓5样品仓6生产加工仓9渠道销售仓
        // 物理上需要区分的: 2,3,6
        if (WhWarehouseVO.TYPE_DAMAGED.equals(warehouseType1)
            || WhWarehouseVO.TYPE_DAMAGED.equals(warehouseType2)
            || WhWarehouseVO.TYPE_WASTED.equals(warehouseType1)
            || WhWarehouseVO.TYPE_WASTED.equals(warehouseType2)
            || WhWarehouseVO.TYPE_PRODUCING.equals(warehouseType1)
            || WhWarehouseVO.TYPE_PRODUCING.equals(warehouseType2)) {
            return false;
        }

        return true;
    }

    @Override
    public boolean isWarehouseInSameWarehouseGroup(String warehouseCode1, String warehouseCode2) {
        WhWarehouse warehouse1 = findWarehouseByCode(warehouseCode1);
        WhWarehouse warehouse2 = findWarehouseByCode(warehouseCode2);
        return NullUtil.isNotNull(warehouse1)
                && NullUtil.isNotNull(warehouse2)
                && NullUtil.isNotNull(warehouse1.getWarehouseGroupId())
                && warehouse1.getWarehouseGroupId().equals(warehouse2.getWarehouseGroupId());
    }

    @Override
    public WhPhysicalWarehouse findPhysicalWarehouseByNo(String no) {
        WhPhysicalWarehouseExample example = new WhPhysicalWarehouseExample();
        example.createCriteria().andHouseNoEqualTo(no);
        List<WhPhysicalWarehouse> physicalHouse = whPhysicalWarehouseMapper.selectByExample(example);
        if(CollectionUtils.isEmpty(physicalHouse)) return null;
        return physicalHouse.get(0);
    }

    @Override
    public List<WhPhysicalWarehouseVO> findNotRelatePhysicalWarehouses() {
        WhPhysicalWarehouseExample example = new WhPhysicalWarehouseExample();
        example.createCriteria().andWarehouseGroupIdIsNull();
        List<WhPhysicalWarehouse> physicalHouseList = whPhysicalWarehouseMapper.selectByExample(example);
        return BeanUtil.buildListFrom(physicalHouseList,WhPhysicalWarehouseVO.class);
    }

    @Override
    public List<WhWarehouseVO> findNotRelateWarehouses() {
        WhWarehouseExample example = new WhWarehouseExample();

        WhWarehouseExample.Criteria criteria = example.createCriteria();
        criteria.andWarehouseGroupIdIsNull();
        criteria.andWarehouseStatusEqualTo(1);
        List<WhWarehouse> list =  whWarehouseMapper.selectByExample(example);
        return BeanUtil.buildListFrom(list,WhWarehouseVO.class);
    }

    @Override
    @Transactional
    public boolean physicalWarehouseRelateWarehouseGroup(List<String> physicalWarehouseCodes, Long warehouseGroupId) {
        Set<String> codes = new HashSet<>();
        codes.addAll(physicalWarehouseCodes);
        int count = whPhysicalWarehouseMapper.physicalWarehouseRelateWarehouseGroup(codes,warehouseGroupId);
        return count == codes.size();
    }

    @Override
    @Transactional
    public boolean physicalWarehouseRelieveWarehouseGroup(Long warehouseGroupId) {
        whPhysicalWarehouseMapper.physicalWarehouseRelieveWarehouseGroup(warehouseGroupId);
        return true;
    }

    @Override
    @Transactional
    public boolean warehouseRelateWarehouseGroup(List<String> warehouseCodes, Long warehouseGroupId) {
        Set<String> codes = new HashSet<>();
        codes.addAll(warehouseCodes);
        int count = whWarehouseMapper.warehouseRelateWarehouseGroup(codes,warehouseGroupId);
        return count == codes.size();
    }

    @Override
    @Transactional
    public boolean warehouseRelieveWarehouseGroup(Long warehouseGroupId) {
        whWarehouseMapper.warehouseRelieveWarehouseGroup(warehouseGroupId);
        return true;
    }

    @Override
    public boolean updateWhPhysicalWarehouseDeliveryNotice(Long whPhysicalWarehouseId, Integer needDeliveryNotice) {
        if(NullUtil.isNull(whPhysicalWarehouseId)){
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"物理仓为空");
        }
        WhPhysicalWarehouse update = new WhPhysicalWarehouse();
        update.setId(whPhysicalWarehouseId);
        update.setDeliveryNotice(needDeliveryNotice);
        return whPhysicalWarehouseMapper.updateByPrimaryKeySelective(update)!=0;
    }

    @Override
    public List<WhWarehouse> findWarehouseByPhysicalCodeAndStatus(String physicWarehouseCode, Integer commodityStatus) {
        log.info("查询逻辑仓的参数  pyhialCode={},commodityStatus={}",physicWarehouseCode,commodityStatus);
        List<WhWarehouse> whWarehouses = whWarehouseMapper.findWarehouseByPhysicalCodeAndStatus(physicWarehouseCode,commodityStatus,null);
        if (CollectionUtils.isEmpty(whWarehouses)){
            throw new WarehouseException(WarehouseExceptionErrorCode.WAREHOUSE_NOT_FIND,"物理仓["+physicWarehouseCode+"],商品状态["+WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(commodityStatus)+"],通过分组找不到逻辑仓，无法创建");
        }else if(whWarehouses.size()>2){ // 最多两个(出、入)，根据 前台逻辑 来取出或入的逻辑仓
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"物理仓["+physicWarehouseCode+"],商品状态["+WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(commodityStatus)+"],通过分组找到多个逻辑仓，无法创建");
        }
        return whWarehouses;
    }

    @Override
    public List<WhWarehouse> findAllWarehousesByPhyCodeAndStatus(String physicWarehouseCode, Integer commodityStatus,Integer relateType) {
        log.info("查询逻辑仓的参数  pyhialCode={},commodityStatus={}",physicWarehouseCode,commodityStatus);
        List<WhWarehouse> whWarehouses = whWarehouseMapper.findWarehouseByPhysicalCodeAndStatus(physicWarehouseCode,commodityStatus,relateType);
        if (CollectionUtils.isEmpty(whWarehouses)){
            throw new WarehouseException(WarehouseExceptionErrorCode.WAREHOUSE_NOT_FIND,"物理仓["+physicWarehouseCode+"],商品状态["+WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(commodityStatus)+"],通过分组找不到逻辑仓，无法创建");
        }
        return whWarehouses;
    }

    @Override
    public List<WhWarehouse> listWarehousesByPhyCodeAndStatusFromGroup(String physicWarehouseCode, Integer commodityStatus) {
        log.info("查询逻辑仓的参数  pyhialCode={},commodityStatus={}",physicWarehouseCode,commodityStatus);
        List<WhWarehouse> whWarehouses = whWarehouseMapper.listWarehousesByPhyCodeAndStatusFromGroup(physicWarehouseCode,commodityStatus);
        if (CollectionUtils.isEmpty(whWarehouses)){
            throw new WarehouseException(WarehouseExceptionErrorCode.WAREHOUSE_NOT_FIND,"物理仓["+physicWarehouseCode+"],商品状态["+WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(commodityStatus)+"],通过分组找不到逻辑仓，无法创建");
        }
        return whWarehouses;
    }

    @Deprecated
    @Override
    public List<String> findGoodWarehouseCode() {
        return whWarehouseMapper.findGoodWarehouseCode();
    }

    private WhWarehouse findUniqWarehouseByType(String warehouseCode, Integer warehouseType) {
        WhPhysicalWarehouse whPhysicalWarehouse = findPhysicalWarehouseByWarehouse(warehouseCode);
        if (whPhysicalWarehouse == null) {
            return null;
        }

        WhWarehouseCond cond = new WhWarehouseCond();
        cond.setPhysicalWarehouseCode(whPhysicalWarehouse.getCode());
        cond.setWarehouseType(warehouseType);
        List<WhWarehouse> whWarehouseList = findWarehouseByCond(cond);
        if (EmptyUtil.isEmpty(whWarehouseList)) {
            return null;
        } else if (whWarehouseList.size() > 1) {
            throw new WarehouseException(
                WarehouseExceptionErrorCode.PHYSICAL_WAREHOUSE_HAS_SAME_TYPE_WAREHOUSE,
                "同物理仓只能有一个当前类型的逻辑仓");
        } else {
            return whWarehouseList.get(0);
        }
    }

    /**
     * 构建 物理仓默认出入库逻辑仓 查询条件
     * @param physicalWarehouseCode 物理仓
     * @param type  类型1入库,2出库
     * @param skuStatus SKU状态,0残次1良品2样品3废品
     * @return
     */
    private WhPhysicalWarehouseRelateWarehouseVO buildWarehouseRelateCond(String physicalWarehouseCode,Integer type,Integer skuStatus){
        Validation.paramNotNull(physicalWarehouseCode, "物理仓编码为空");
        Validation.paramNotNull(type, "出入库类型为空");
        Validation.paramNotNull(skuStatus, "SKU状态为空");
        WhPhysicalWarehouseRelateWarehouseVO cond = new WhPhysicalWarehouseRelateWarehouseVO();
        cond.setPhysicalWarehouseCode(physicalWarehouseCode);
        cond.setType(type);
        cond.setSkuStatus(skuStatus);
        return cond;
    }

    @Override
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultOutNondefectiveWarehouseByPyCode(String physicalWarehouseCode){
        WhPhysicalWarehouseRelateWarehouseVO cond = buildWarehouseRelateCond(physicalWarehouseCode,WhWarehouseVO.RELATE_OUT,WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
        List<WhPhysicalWarehouseRelateWarehouseVO> vos = findPhysicalWarehouseRelateWarehouseByCond(cond);
        if (CollectionUtils.isEmpty(vos)){
            return null;
        }
        return vos.get(0);
    }

    @Override
    public WhWarehouse findDefaultInNondefectiveWarehouseByPhyWhCode(String physicalWarehouseCode){
        return findDefaultInOrOutWarehouseByPhyWhCode(physicalWarehouseCode,WhWarehouseVO.RELATE_IN,WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
    }

    @Override
    public WhWarehouse findDefaultInDefectiveWarehouseByPhyWhCode(String physicalWarehouseCode) {
        return findDefaultInOrOutWarehouseByPhyWhCode(physicalWarehouseCode,WhWarehouseVO.RELATE_IN,WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED);
    }

    /**
     * 默认入库逻辑仓
     * @param physicalWarehouseCode
     * @param commodityStatus
     * @return
     */
    @Override
    public WhWarehouse findDefaultInWarehouseByPhyWhCodeAndCommodityStatus(String physicalWarehouseCode,Integer commodityStatus){
        return findDefaultInOrOutWarehouseByPhyWhCode(physicalWarehouseCode,WhWarehouseVO.RELATE_IN,commodityStatus);
    }

    @Override
    public WhWarehouse findDefaultOutWarehouseByPhyWhCodeAndCommodityStatus(String physicalWarehouseCode, Integer commodityStatus) {
        return findDefaultInOrOutWarehouseByPhyWhCode(physicalWarehouseCode,WhWarehouseVO.RELATE_OUT,commodityStatus);
    }

    @Override
    public WhWarehouse findDefaultOutNondefectiveWarehouseByPhyWhCode(String physicalWarehouseCode){
        return findDefaultInOrOutWarehouseByPhyWhCode(physicalWarehouseCode,WhWarehouseVO.RELATE_OUT,WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
    }

    @Override
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultOutDefectiveWarehouseByPyCode(String physicalWarehouseCode){
        WhPhysicalWarehouseRelateWarehouseVO cond = buildWarehouseRelateCond(physicalWarehouseCode,WhWarehouseVO.RELATE_OUT,WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED);
        List<WhPhysicalWarehouseRelateWarehouseVO> vos = findPhysicalWarehouseRelateWarehouseByCond(cond);
        if (CollectionUtils.isEmpty(vos)){
            return null;
        }
        return vos.get(0);
    }

    @Override
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultOutSampleWarehouseByPyCode(String physicalWarehouseCode){
        WhPhysicalWarehouseRelateWarehouseVO cond = buildWarehouseRelateCond(physicalWarehouseCode,WhWarehouseVO.RELATE_OUT,WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE);
        List<WhPhysicalWarehouseRelateWarehouseVO> vos = findPhysicalWarehouseRelateWarehouseByCond(cond);
        if (CollectionUtils.isEmpty(vos)){
            return null;
        }
        return vos.get(0);
    }

    @Override
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultOutWasteWarehouseByPyCode(String physicalWarehouseCode){
        WhPhysicalWarehouseRelateWarehouseVO cond = buildWarehouseRelateCond(physicalWarehouseCode,WhWarehouseVO.RELATE_OUT,WhWarehouseVO.COMMODITY_STATUS_FOR_WASTED);
        List<WhPhysicalWarehouseRelateWarehouseVO> vos = findPhysicalWarehouseRelateWarehouseByCond(cond);
        if (CollectionUtils.isEmpty(vos)){
            return null;
        }
        return vos.get(0);
    }

    @Override
    public WhWarehouse findDefaultInOrOutWarehouseByPhyWhCode(String physicalWarehouseCode,Integer inOrOut,Integer skuStatus){
        return whWarehouseMapper.findDefaultInOrOutWarehouseByPhyWhCode(physicalWarehouseCode,inOrOut,skuStatus);
    }

    @Override
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultInNondefectiveWarehouseByPyCode(String physicalWarehouseCode){
        WhPhysicalWarehouseRelateWarehouseVO cond = buildWarehouseRelateCond(physicalWarehouseCode,WhWarehouseVO.RELATE_IN,WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
        List<WhPhysicalWarehouseRelateWarehouseVO> vos = findPhysicalWarehouseRelateWarehouseByCond(cond);
        if (CollectionUtils.isEmpty(vos)){
            return null;
        }
        return vos.get(0);
    }

    @Override
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultInDefectiveWarehouseByPyCode(String physicalWarehouseCode){
        WhPhysicalWarehouseRelateWarehouseVO cond = buildWarehouseRelateCond(physicalWarehouseCode,WhWarehouseVO.RELATE_IN,WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED);
        List<WhPhysicalWarehouseRelateWarehouseVO> vos = findPhysicalWarehouseRelateWarehouseByCond(cond);
        if (CollectionUtils.isEmpty(vos)){
            return null;
        }
        return vos.get(0);
    }

    @Override
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultInSampleWarehouseByPyCode(String physicalWarehouseCode){
        WhPhysicalWarehouseRelateWarehouseVO cond = buildWarehouseRelateCond(physicalWarehouseCode,WhWarehouseVO.RELATE_IN,WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE);
        List<WhPhysicalWarehouseRelateWarehouseVO> vos = findPhysicalWarehouseRelateWarehouseByCond(cond);
        if (CollectionUtils.isEmpty(vos)){
            return null;
        }
        return vos.get(0);
    }

    @Override
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultInWasteWarehouseByPyCode(String physicalWarehouseCode){
        WhPhysicalWarehouseRelateWarehouseVO cond = buildWarehouseRelateCond(physicalWarehouseCode,WhWarehouseVO.RELATE_IN,WhWarehouseVO.COMMODITY_STATUS_FOR_WASTED);
        List<WhPhysicalWarehouseRelateWarehouseVO> vos = findPhysicalWarehouseRelateWarehouseByCond(cond);
        if (CollectionUtils.isEmpty(vos)){
            return null;
        }
        return vos.get(0);
    }

    @Override
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultInDisplayWarehouseByPyCode(String physicalWarehouseCode) {
        WhPhysicalWarehouseRelateWarehouseVO cond = buildWarehouseRelateCond(physicalWarehouseCode,WhWarehouseVO.RELATE_IN,WhWarehouseVO.COMMODITY_STATUS_FOR_DISPLAY);
        List<WhPhysicalWarehouseRelateWarehouseVO> vos = findPhysicalWarehouseRelateWarehouseByCond(cond);
        if (CollectionUtils.isEmpty(vos)){
            return null;
        }
        return vos.get(0);
    }

    @Override
    public List<WhPhysicalWarehouseRelateWarehouseVO> findPhysicalWarehouseRelateWarehouseByCond(WhPhysicalWarehouseRelateWarehouseVO cond){
        return whPhysicalWarehouseRelateWarehouseCustomMapper.findPhysicalWarehouseRelateByCond(cond);
    }

    @Override
    public WhPhysicalWarehouse findPhysicalWarehouseByWarehouseGroupCond(String warehouseCode,Integer relateInOrOut){
        WhWarehouse targetWhWarehouse = findWarehouseByCode(warehouseCode);
        Validation.paramNotNull(targetWhWarehouse, "逻辑仓为空");
        WhPhysicalWarehouseRelateWarehouseVO cond = new WhPhysicalWarehouseRelateWarehouseVO();
        cond.setWarehouseCode(warehouseCode);
        cond.setSkuStatus(WhWarehouseVO.convertSkuStatusByCommodityStatus(targetWhWarehouse.getCommodityStatus()));
        cond.setType(relateInOrOut);
        List<WhPhysicalWarehouseRelateWarehouseVO> warehouseRelateWarehouseVos = findPhysicalWarehouseRelateWarehouseByCond(cond);
        if (CollectionUtils.isEmpty(warehouseRelateWarehouseVos)){
            throw new WarehouseException(WarehouseExceptionErrorCode.WAREHOUSE_NOT_FIND,"逻辑仓["+cond.getWarehouseCode()+"],SKU状态["+WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(cond.getSkuStatus())+"],类型["+WhWarehouseVO.RELATE_MAP.get(cond.getType())+"] 找不到物理仓，无法创建");
        }else if(warehouseRelateWarehouseVos.size()>1){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"逻辑仓["+cond.getWarehouseCode()+"],SKU状态["+WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(cond.getSkuStatus())+"],类型["+WhWarehouseVO.RELATE_MAP.get(cond.getType())+"] 存在多个物理仓，无法创建");
        }
        WhPhysicalWarehouse physicalWarehouse = findPhysicalWarehouseByCode(warehouseRelateWarehouseVos.get(0).getPhysicalWarehouseCode());
        Validation.paramNotNull(physicalWarehouse, "物理仓不存在");
        return physicalWarehouse;
    }

    @Override
    public List<WhPhysicalWarehouse> findPhysicalWarehouseByType(List<Integer> warehouseTypeList) {
        return whPhysicalWarehouseMapper.findPhysicalWarehouseByType(warehouseTypeList);
    }

    @Override
    public Map<String, WhPhysicalWarehouse> findPhyWhMapByWarehouseCodes(List<String> warehouseCodeList) {
        Map<String, WhPhysicalWarehouse> whPhysicalWarehouseMap = new HashMap<>();
        List<WhPhysicalWarehouse> physicalWarehouseList = whPhysicalWarehouseMapper.findPhysicalWhByWarehouseCodes(warehouseCodeList);
        if (EmptyUtil.isNotEmpty(warehouseCodeList)) {
            checkRepeatPhysicalWh(physicalWarehouseList, findWarehouseByCodes(warehouseCodeList));
            int listSize = warehouseCodeList.size();
            for (int i = 0 ; i < listSize; i ++) {
                whPhysicalWarehouseMap.put(warehouseCodeList.get(i).toString(), physicalWarehouseList.get(i));
            }
        }
        return whPhysicalWarehouseMap;
    }

    /**
     * 检查物理仓是否存在多个
     * @param physicalWarehouseList
     * @param whWarehouseList
     */
    private void checkRepeatPhysicalWh(List<WhPhysicalWarehouse> physicalWarehouseList, List<WhWarehouse> whWarehouseList) {
        int listSize = whWarehouseList.size();
        int physicalWhSize = physicalWarehouseList.size();
        int i = 0, j = 0;
        for (; i < listSize; i ++) {
            WhWarehouse whWarehouse = whWarehouseList.get(i);
            Long groupId = whWarehouse.getWarehouseGroupId();
            int physicalWhCnt = 0;


            for (; j < physicalWhSize; j ++) {
              if (groupId.equals(physicalWarehouseList.get(j).getWarehouseGroupId())) {
                  physicalWhCnt ++;
              }
             if (physicalWhCnt > 1) {
                throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM ,new StringBuilder().append("[")
                               .append(whWarehouse.getCode())
                               .append("]").append(whWarehouse.getName()).append(", 存在多个物理仓").toString());
             }
          }
        }
    }

    @Override
    public List<WhWarehouseVO> findWarehouseByGroupId(Long warehouseGroupId) {
        if (EmptyUtil.isEmpty(warehouseGroupId)) {
            return Collections.emptyList();
        }
        WhWarehouseExample example = new WhWarehouseExample();
        example.createCriteria().andWarehouseGroupIdEqualTo(warehouseGroupId);
        List<WhWarehouse> whWarehouseList = whWarehouseMapper.selectByExample(example);
        return BeanUtil.buildListFrom(whWarehouseList,WhWarehouseVO.class);
    }

    @Override
    public List<WhPhysicalWarehouseVO> findPhysicalWarehouseByWarehouseCode(String warehouseCode) {
        return whPhysicalWarehouseMapper.findPhysicalWarehouseByWarehouseCode(warehouseCode);
    }

    @Override
    public List<WhPhysicalWarehouseVO> findRelatePhysicalWarehouseByWarehouseCode(String warehouseCode, Integer inOrOut, Integer skuStatus) {
        return whPhysicalWarehouseMapper.findRelatePhysicalWarehouseByWarehousCode(warehouseCode, inOrOut, skuStatus);
    }

    /**
     * 检查是否可以将当前逻辑仓归档于物理仓（排除当前逻辑仓本身）
     * 
     * @param whPhysicalWarehouse 物理仓
     * @param whWarehouse 逻辑仓
     * @return
     */
    private void checkWarehouseArchiveToPhysicalWarehouse(WhPhysicalWarehouse whPhysicalWarehouse,
                                                          WhWarehouse whWarehouse) {
        // 此方法暂时不用
        boolean check = false;
        if(check){
            // 如果类型是[1良品待分配仓2残次品仓3废品仓6生产加工仓]，则检查物理仓是否已经有同类型逻辑仓
            Integer warehouseType = whWarehouse.getWarehouseType();
            if (WhWarehouseVO.TYPE_WAIT_FOR_DISPATCHING.equals(warehouseType)
                || WhWarehouseVO.TYPE_DAMAGED.equals(warehouseType)
                || WhWarehouseVO.TYPE_WASTED.equals(warehouseType)
                || WhWarehouseVO.TYPE_PRODUCING.equals(warehouseType)) {
                WhWarehouseExample example = new WhWarehouseExample();
                WhWarehouseExample.Criteria criteria = example.createCriteria()
                    .andPhysicalWarehouseIdEqualTo(whPhysicalWarehouse.getId())
                    .andWarehouseTypeEqualTo(warehouseType);
                // 排除当前逻辑仓
                if (whWarehouse.getId() != null) {
                    criteria.andIdNotEqualTo(whWarehouse.getId());
                }
                if (EmptyUtil.isNotEmpty(whWarehouseMapper.selectByExample(example))) {
                    throw new WarehouseException(
                        WarehouseExceptionErrorCode.PHYSICAL_WAREHOUSE_HAS_SAME_TYPE_WAREHOUSE,
                        "同物理仓只能有一个当前类型的逻辑仓");
                }
            }
        }
    }
}