package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.cond.WhExpressWaybillCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhExpressWaybillMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsPrdcJobTaskMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.custom.WhExpressWaybillCustomMapper;
import com.thebeastshop.pegasus.service.warehouse.model.WhExpressWaybill;
import com.thebeastshop.pegasus.service.warehouse.model.WhExpressWaybillExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhExpressWaybillService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhExpressWaybillVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsPrdcJobTaskVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.pegasus.util.comm.SQLUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import page.Pagination;

import java.util.List;

/**
 * com.thebeastshop.pegasus.service.warehouse.service
 *
 * @author xwei
 * @create 2018-01-15 15:19
 */
@Service("whExpressWaybillService")
public class WhExpressWaybillServiceImpl implements WhExpressWaybillService {

    @Autowired
    private WhExpressWaybillMapper whExpressWaybillMapper;

    @Autowired
    private WhExpressWaybillCustomMapper whExpressWaybillCustomMapper;

    @Override
    public boolean insert(WhExpressWaybill whExpressWaybill) {
        return whExpressWaybillMapper.insert(whExpressWaybill)>0;
    }

    @Override
    public boolean deleteById(Long id) {
        return whExpressWaybillMapper.deleteByPrimaryKey(id)>0;
    }

    @Override
    public boolean deleteByCond(WhExpressWaybillCond cond) {
        if (EmptyUtil.isNotEmpty(cond.getId())){
            return deleteById(cond.getId());
        }
        WhExpressWaybillExample example = buildConditionExampleByCond(cond);
        return whExpressWaybillMapper.deleteByExample(example)>0;
    }

    @Override
    public boolean updateByCond(WhExpressWaybill whExpressWaybill, WhExpressWaybillCond cond) {
        WhExpressWaybillExample example = buildConditionExampleByCond(cond);
        return whExpressWaybillMapper.updateByExampleSelective(whExpressWaybill,example)>0;
    }

    @Override
    public boolean updateById(WhExpressWaybill whExpressWaybill) {
        return whExpressWaybillMapper.updateByPrimaryKeySelective(whExpressWaybill)>0;
    }

    @Override
    public WhExpressWaybill findById(Long id) {
        return whExpressWaybillMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<WhExpressWaybill> findWhExpressWaybillByCond(WhExpressWaybillCond cond) {
        WhExpressWaybillExample example = buildConditionExampleByCond(cond);
        return whExpressWaybillMapper.selectByExample(example);
    }

    @Override
    public List<WhExpressWaybillVO> listWhExpressWaybillByCond(WhExpressWaybillCond cond) {
        return whExpressWaybillCustomMapper.listWhExpressWaybillByCond(cond);
    }

    @Override
    public Pagination<WhExpressWaybillVO> listWhExpressWaybillByCondPage(WhExpressWaybillCond cond) {
        Pagination<WhExpressWaybillVO> page = new Pagination<>(cond.getCurrpage(),cond.getPagenum());
        int count = whExpressWaybillCustomMapper.getCountByCond(cond);
        page.setRecord(count);
        if (NumberUtil.isNullOrZero(count)) return null;
        page.setResultList(whExpressWaybillCustomMapper.listWhExpressWaybillByCond(cond));
        if (NumberUtil.isNullOrZero(count)) {
            return null;
        }
        return page;
    }

    @Override
    public boolean batchCreate(List<WhExpressWaybillVO> whExpressWaybillVOs) {
        if (CollectionUtils.isEmpty(whExpressWaybillVOs)){
            return false;
        }
        return whExpressWaybillCustomMapper.batchInsert(whExpressWaybillVOs)>0;
    }

    // private 构建查询条件
    private WhExpressWaybillExample buildConditionExampleByCond(WhExpressWaybillCond cond){
        WhExpressWaybillExample example = new WhExpressWaybillExample();
        WhExpressWaybillExample.Criteria criteria = example.createCriteria();
        // 出库单号
        if (EmptyUtil.isNotEmpty(cond.getCommandCodes())){
            criteria.andCommandCodeIn(cond.getCommandCodes());
        }else if(EmptyUtil.isNotEmpty(cond.getCommandCode())){
            criteria.andCommandCodeEqualTo(cond.getCommandCode());
        }else if(EmptyUtil.isNotEmpty(cond.getCommandCodeLike())){
            criteria.andCommandCodeLike(SQLUtils.allLike(cond.getCommandCodeLike()));
        }

        // 相关单据号 [例：包裹号]
        if (EmptyUtil.isNotEmpty(cond.getReferenceCode())){
            criteria.andReferenceCodeEqualTo(cond.getReferenceCode());
        }else if(EmptyUtil.isNotEmpty(cond.getReferenceCodeLike())){
            criteria.andReferenceCodeLike(SQLUtils.allLike(cond.getReferenceCodeLike()));
        }

        // 快递单号
        if (EmptyUtil.isNotEmpty(cond.getExpressNo())){
            criteria.andExpressNoEqualTo(cond.getExpressNo());
        }else if(EmptyUtil.isNotEmpty(cond.getExpressNoLike())){
            criteria.andExpressNoLike(SQLUtils.allLike(cond.getExpressNoLike()));
        }else if(CollectionUtils.isNotEmpty(cond.getExpressNos())){
            criteria.andExpressNoIn(cond.getExpressNos());
        }

        if (EmptyUtil.isNotEmpty(cond.getExpressType())){
            criteria.andExpressTypeEqualTo(cond.getExpressType());
        }

        // 处理状态
        if (EmptyUtil.isNotEmpty(cond.getProcessStatus())){
            criteria.andProcessStatusEqualTo(cond.getProcessStatus());
        }

        // 创建时间
        if (EmptyUtil.isNotEmpty(cond.getCreateTimeBegin())){
            criteria.andCreateTimeGreaterThanOrEqualTo(cond.getCreateTimeBegin());
        }
        if (EmptyUtil.isNotEmpty(cond.getCreateTimeEnd())){
            criteria.andCreateTimeLessThanOrEqualTo(cond.getCreateTimeEnd());
        }

        // 路由信息
        if (EmptyUtil.isNotEmpty(cond.getRoutingInfo())){
            criteria.andRoutingInfoEqualTo(cond.getRoutingInfo());
        }
        return example;
    }
}
