package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.dao.WhCustomizatonParamMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.WhCustomizatonParam;
import com.thebeastshop.pegasus.service.warehouse.model.WhCustomizatonParamExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhCustomizatonParamService;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * Created by Administrator on 2017/7/18.
 */
@Service("whCustomizatonParamService")
public class WhCustomizatonParamServiceImpl implements WhCustomizatonParamService {

    @Autowired
    private WhCustomizatonParamMapper whCustomizatonParamMapper;

    @Override
    public WhCustomizatonParam findCustomizatonParamByType(Integer type) {
        WhCustomizatonParamExample example = new WhCustomizatonParamExample();
        example.createCriteria().andTypeEqualTo(type);
        List<WhCustomizatonParam> paramList = whCustomizatonParamMapper.selectByExample(example);
        if(EmptyUtil.isEmpty(paramList)){
            return null;
        }
        return paramList.get(0);
    }

    @Override
    @Transactional
    public boolean saveOrUpdateCustomizationParam(WhCustomizatonParam param) {
        try{
            if(NullUtil.isNull(param.getId())){
                insertParam(param);
            }else {
                updateParam(param);
            }
        }catch (Exception e){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"参数保存失败");
        }
        return true;
    }

    private void insertParam(WhCustomizatonParam param){
        whCustomizatonParamMapper.insert(param);
    }

    private void updateParam(WhCustomizatonParam param){
        whCustomizatonParamMapper.updateByPrimaryKey(param);
    }
}
