package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.common.utils.NumberUtil;
import com.thebeastshop.common.validation.Validation;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsHouseShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhCrossGoodsMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.*;
import com.thebeastshop.pegasus.service.warehouse.service.*;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.exception.CommExceptionErrorCode;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

import java.util.*;

import static com.thebeastshop.pegasus.service.warehouse.vo.WhPhysicalWarehouseVO.WAREHOUSE_TYPE_WH_WMS;

/**
 * @version V1.0
 * @Description:${todo}(用一句话描述该文件做什么)
 * @author: ljj
 * @date: 2018/8/2 14:49
 */
@Service
public class WhCrossGoodsServiceImpl implements WhCrossGoodsService {

    @Autowired
    private WhCrossGoodsMapper whCrossGoodsMapper;

    @Autowired
    private WhInfoService whInfoService;

    @Autowired
    private WhInvService whInvService;

    @Autowired
    private WhCommandService whCommandService;

    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;

    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;

    @Autowired
    private WhTakeStockService whTakeStockService;



    public Boolean addOrEditCrossGoodsApply (WhCrossGoods whCrossGoods) {
        if (null == whCrossGoods.getId()) {
            //创建
            return whCrossGoodsMapper.insert(whCrossGoods)>0;
        } else {
            //更新
            return whCrossGoodsMapper.updateByPrimaryKeySelective(whCrossGoods)>0;
        }
    }

    @Override
    @Transactional
    public Boolean approveCrossGoodsApply(WhCrossGoods whCrossGoods) throws Exception{
        Boolean addOrEditFlag = addOrEditCrossGoodsApply(whCrossGoods);
        if (addOrEditFlag && !whCrossGoods.getStatus().equals(3)) {
            WhCrossGoodsVO whCrossGoodsVO = detailCrossGoods(whCrossGoods.getId().longValue());
            Integer approveOpId = whCrossGoods.getApproveOperatorId();

            BeanUtils.copyProperties(whCrossGoodsVO, whCrossGoods);
            whCrossGoods.setApproveOperatorId(approveOpId);

            WhInvVO whInvVO = whInvService
                    .findCanUseQttBySkuCodeAndWarehouseCode(whCrossGoodsVO.getSourceSkuCode(),whCrossGoodsVO.getWarehouseCode());
            if (whInvVO.getCanUseInv() < whCrossGoodsVO.getAmount()) {
                throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM,"逻辑仓["+whCrossGoodsVO.getWarehouseName()+"]中 SKU["+whCrossGoodsVO.getSourceSkuCode()+"]数量不足,"+
                        whInvVO.getCanUseInv()+"<"+whCrossGoodsVO.getAmount());
            }

            //1:生成两条 SCM 出入库记录，字段如下
            WhInvRcd outWhInvRcd = new WhInvRcd();
            outWhInvRcd.setWarehouseCode(whCrossGoods.getWarehouseCode());
            outWhInvRcd.setQuantity((0-whCrossGoods.getAmount()));
            outWhInvRcd.setInOutType(WhCommand.TYPE_CROSSGOODS_OUT);
            outWhInvRcd.setCommandCode("CROSSGOODS_ID_"+whCrossGoods.getId().toString());
            outWhInvRcd.setSkuCode(whCrossGoods.getSourceSkuCode());
            outWhInvRcd.setSubmitTime(DateUtil.getNow());
            outWhInvRcd.setMemo(whCrossGoodsVO.getApplyRemark());
            outWhInvRcd.setSubmitUserId(whCrossGoods.getApproveOperatorId().longValue());
            WhInvRcd inWhInvRcd = new WhInvRcd();
            inWhInvRcd.setWarehouseCode(whCrossGoods.getWarehouseCode());
            inWhInvRcd.setQuantity(whCrossGoods.getAmount());
            inWhInvRcd.setInOutType(WhCommand.TYPE_CROSSGOODS_IN);
            inWhInvRcd.setCommandCode("CROSSGOODS_ID_"+whCrossGoods.getId().toString());
            inWhInvRcd.setSkuCode(whCrossGoods.getTargetSkuCode());
            inWhInvRcd.setSubmitTime(DateUtil.getNow());
            inWhInvRcd.setMemo(whCrossGoodsVO.getApplyRemark());
            inWhInvRcd.setSubmitUserId(whCrossGoods.getApproveOperatorId().longValue());
            List<WhInvRcd> lists = Lists.newArrayList();
            lists.add(outWhInvRcd);
            lists.add(inWhInvRcd);
            whInvService.batchRecord(lists);
            //物理仓出入库记录
            Map<String,WhWarehouse> whMap = new HashMap<>();
            WhWarehouse whWarehouse = whInfoService.findWarehouseByCode(whCrossGoods.getWarehouseCode());
            whMap.put(whCrossGoods.getWarehouseCode(),whWarehouse);

            WhPhysicalWarehouse physicalWarehouse = findPhysicalByWarehouseCode(whCrossGoods.getWarehouseCode());
            //2:同步生成 WMS 出入库记录（同样需要两个出入库类型：串货调整出 库、串货调整入库）
            for (WhInvRcd invRcd : lists) {
                WhWarehouse wh = whMap.get(invRcd.getWarehouseCode());
                Integer skuStatus = whCommandService.getSkuStatusByWarehouseType(wh.getCommodityStatus());
                whWmsSkuStockService.updatePhyWhSkuStock(physicalWarehouse.getCode()
                        ,invRcd.getSkuCode(),skuStatus,invRcd.getQuantity(),invRcd.getInOutType(),
                        whCrossGoodsVO.getId().toString(),invRcd.getSubmitUserId(),invRcd.getMemo());
            }
        }
        return addOrEditFlag;
    }

    @Override
    public Pagination<WhCrossGoodsVO> listCrossGoods(WhCrossGoodsCondVO cond) {
        Pagination<WhCrossGoodsVO> page = new Pagination<>(cond.getCurrpage(), cond.getPagenum());

        int count = whCrossGoodsMapper.countByCond(cond);
        page.setRecord(count);
        if (NumberUtil.isNullOrZero(count)) {
            return null;
        }
        List<WhCrossGoodsVO> applyVOList = whCrossGoodsMapper.selectByCond(cond);
        if (CollectionUtils.isEmpty(applyVOList)) {
            return null;
        }

        page.setResultList(applyVOList);

        return page;
    }

    @Override
    public WhCrossGoodsVO detailCrossGoods(Long id) {
        WhCrossGoodsCondVO crossGoodsCondVO = new WhCrossGoodsCondVO();
        crossGoodsCondVO.setId(id);
        return whCrossGoodsMapper.selectByCond(crossGoodsCondVO).get(0);
    }

    @Override
    @Transactional
    public Integer batchUpdate(List<Long> ids,Integer status,Long operatorId,String approveRemark) throws Exception {
        Integer res = 0;
        for (Long id : ids) {
            WhCrossGoods whCrossGoods = new WhCrossGoods();
            whCrossGoods.setId(id.intValue());
            whCrossGoods.setStatus(status);
            whCrossGoods.setApproveRemark(approveRemark);
            whCrossGoods.setApproveOperatorId(operatorId.intValue());
            if (approveCrossGoodsApply(whCrossGoods)) {
                res ++;
            }
        }
        return res;
    }


    private WhWmsHouseShelvesVO getWhWmsHouseShelves(String physicalWarehouseCode,Integer skuStatus){
        WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
        cond.setPhysicalWarehouseCode(physicalWarehouseCode);
        cond.setSkuStatus(skuStatus);
        List<WhWmsHouseShelvesVO> whWmsHouseShelvesList = whWmsHouseShelvesService.getHouseShelvesByCond(cond);
        if (CollectionUtils.isEmpty(whWmsHouseShelvesList)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                    "物理仓["+cond.getPhysicalWarehouseCode()+"],SKU["+cond.getSkuCode()+"],SKU状态["+ WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(cond.getSkuStatus())+"]"+",库位不存在!");
        }
        if (whWmsHouseShelvesList.size()>1){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                    "物理仓["+cond.getPhysicalWarehouseCode()+"],SKU["+cond.getSkuCode()+"],SKU状态["+WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(cond.getSkuStatus())+"]"+",查询有多个库位!");
        }
        return whWmsHouseShelvesList.get(0);
    }

    private WhPhysicalWarehouseVO findPhysicalByWarehouseCode(String warehouseCode){
        Validation.paramNotNull(warehouseCode,"逻辑仓编码为空");
        List<WhPhysicalWarehouseVO> physicalWarehouseVOs = whInfoService.findPhysicalWarehouseByWarehouseCode(warehouseCode);
        Iterator iter = physicalWarehouseVOs.iterator();
        //2、通过循环迭代
        //hasNext():判断是否存在下一个元素
        while(iter.hasNext()){
            //如果存在，则调用next实现迭代
            WhPhysicalWarehouseVO whPhysicalWarehouseVO=(WhPhysicalWarehouseVO)iter.next();
            if (whPhysicalWarehouseVO.getWarehouseType().equals(whPhysicalWarehouseVO.WAREHOUSE_TYPE_WH_WMS)) {
                iter.remove();
            }
        }

        if (CollectionUtils.isEmpty(physicalWarehouseVOs)){
            throw new WarehouseException(WarehouseExceptionErrorCode.WAREHOUSE_NOT_FIND,
                    "逻辑仓["+warehouseCode+"]在逻辑仓分组中找不到对应的物理仓，操作失败");
        }
        if (physicalWarehouseVOs.size()>1){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                    "逻辑仓["+warehouseCode+"]对应的物理仓有多个，操作失败");
        }

        return physicalWarehouseVOs.get(0);
    }

//    private Boolean checkStockByWarehouseCodeAndSkuCode (String warehouseCode , String skuCode) {
//
//    }



}
