/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.taobao.api.response.ItemQuantityUpdateResponse;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.pegasus.integration.express.PackageInfo;
import com.thebeastshop.pegasus.integration.express.zt.ZTOrderSubmitKeys;
import com.thebeastshop.pegasus.integration.express.zt.ZTOrderSubmitResponse;
import com.thebeastshop.pegasus.service.warehouse.WMSConstants;
import com.thebeastshop.pegasus.service.warehouse.cond.*;
import com.thebeastshop.pegasus.service.warehouse.dao.*;
import com.thebeastshop.pegasus.service.warehouse.dao.custom.WhSalesReturnExceptionCustomMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.custom.WhSalesReturnExceptionSkuCustomMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.*;
import com.thebeastshop.pegasus.service.warehouse.service.*;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import com.thebeastshop.pegasus.util.PegasusConstants;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.*;
import com.thebeastshop.pegasus.util.exception.CommExceptionErrorCode;
import com.thebeastshop.pegasus.util.model.CommFileRef;
import com.thebeastshop.pegasus.util.model.CommFileRefExample;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
import com.thebeastshop.pegasus.util.vo.JdStockSyncResult;
import com.thebeastshop.stock.dto.SStockOccupyDTO;
import com.thebeastshop.stock.dto.SStockReleaseDTO;
import com.thebeastshop.stock.enums.SStockOccupyTypeEnum;
import com.thebeastshop.stock.enums.SStockOperationTypeEnum;
import com.thebeastshop.stock.service.SStockService;
import com.thebeastshop.stock.service.SWhCommandService;
import com.thebeastshop.stock.vo.*;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author Royan
 * @version $Id: WhCommandServiceImpl.java, v 0.1 2015-07-08 下午12:03
 */
@Service("whCommandService")
public class WhCommandServiceImpl implements WhCommandService {

    private final Logger         log = LoggerFactory.getLogger(WhCommandServiceImpl.class);

    @Autowired
    private WhCommandMapper      whCommandMapper;

    @Autowired
    private WhCommandSkuMapper   whCommandSkuMapper;
    @Autowired
    private WhPhysicalWarehouseMapper whPhysicalWarehouseMapper;

    @Autowired
    private WhInvService         whInvService;

    @Autowired
    private WhInfoService        whInfoService;

    @Autowired
    private WhAllotService       whAllotService;

    @Autowired
    private WhWmsConnectAllotPackageService whWmsConnectAllotPackageService;

    @Autowired
    private WhDamageWasteService whDamageWasteService;

    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;

    @Autowired
    private WhWmsSkuStockRecordService whWmsSkuStockRecordService;

    @Autowired
    private WhWmsWaitPutawayService whWmsWaitPutawayService;

    @Autowired
    private WhWmsSkuBarcodeService whWmsSkuBarcodeService;
    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;
    @Autowired
    private WhWmsCommandShortRecordMapper whWmsCommandShortRecordMapper;
    @Autowired
    private WhCommandOutFinishMapper whCommandOutFinishMapper;
    @Autowired
    private TmallStockLogMapper tmallStockLogMapper;
    @Autowired
    private WhWarehouseMapper whWarehouseMapper;
    
    private PegasusUtilFacade pegasusUtilFacade = PegasusUtilFacade.getInstance();
    
    @Autowired
    private TaskExecutor myScheduler;
    @Autowired
    private WhWmsSubmitHandRecordMapper whWmsSubmitHandRecordMapper;
    @Autowired
    private WhWmsSkuStockRecordMapper whWmsSkuStockRecordMapper;

    @Autowired
    private WhWmsSkuStockMapper whWmsSkuStockMapper;

    @Autowired
    private WhWmsHouseShelvesMapper whWmsHouseShelvesMapper;
    @Autowired
    private SStockService sStockService;
    @Autowired
    private SWhCommandService sWhCommandService;

    @Autowired
    private WhWmsCommandPreOccupyService whWmsCommandPreOccupyService;

    @Autowired
    private WhSalesReturnExceptionMapper whSalesReturnExceptionMapper;

    @Autowired
    private WhSalesReturnExceptionCustomMapper whSalesReturnExceptionCustomMapper;

    @Autowired
    private WhSalesReturnExceptionSkuMapper whSalesReturnExceptionSkuMapper;

    @Autowired
    private WhSalesReturnExceptionSkuCustomMapper whSalesReturnExceptionSkuCustomMapper;

    @Autowired
    private WhWarehouseGroupService whWarehouseGroupService;


    @Autowired
    private WhWmsReceiveShelvesDetailService whWmsReceiveShelvesDetailService;
    @Autowired
    private WhWmsPrdcJobTaskDetailService whWmsPrdcJobTaskDetailService;
    @Autowired
    private WhWmsPrdcJobTaskService whWmsPrdcJobTaskService;

    @Autowired
    private WhWmsShelvesSkuInfoMapper whWmsShelvesSkuInfoMapper;

    @Autowired
    private WhWmsShelvesSkuInfoService whWmsShelvesSkuInfoService;
    /**
     * 创建指令
     *
     * @param whCommand 指令
     * @return 指令编码
     */
    @Override
    @Transactional
    public String createCommand(WhCommand whCommand) {
        buildAndCreateCommandWithOccupy(whCommand);
        return whCommand.getCode();
    }

    @Override
    @Transactional
    public boolean recordCommand(List<WhCommand> cmdList) {
        List<SWhCommandVO> sCmdList = cmdList.stream().map(whCommand->{
            Integer commandStatus = whCommand.getCommandStatus();
            SWhCommandVO sWhCommand = buildCommandForCreate(whCommand);
            sWhCommand.setCommandStatus(commandStatus);
            return sWhCommand;
        }).collect(Collectors.toList());
        sWhCommandService.recordWhCommand(sCmdList);
        return true;
    }

    private boolean buildAndCreateCommandWithOccupy(WhCommand whCommand){
        SWhCommandVO sWhCommand = buildCommandForCreate(whCommand);
        SWhCommandVO createdCmdDto = sWhCommandService.createWhCommandWithOccupy(sWhCommand);
        copyWhCommandProps(createdCmdDto,whCommand);
        return true;
    }

    private boolean buildAndCreateCommand(WhCommand whCommand){
        SWhCommandVO sWhCommand = buildCommandForCreate(whCommand);
        SWhCommandVO createdCmdDto = sWhCommandService.createWhCommand(sWhCommand);
        copyWhCommandProps(createdCmdDto,whCommand);
        return true;
    }

    private SWhCommandVO buildCommandForCreate(WhCommand whCommand){
        if(NullUtil.isNull(whCommand.getCommodityStatus())){
            if(EmptyUtil.isEmpty(whCommand.getWarehouseCode())){
                throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM,
                        "指令行商品状态异常");
            }
            WhWarehouse warehouse = whInfoService.findWarehouseByCode(whCommand.getWarehouseCode());
            whCommand.setCommodityStatus(warehouse.getCommodityStatus());
        }
        List<WhCommandSku> whCommandSkuList = whCommand.getWhCommandSkuList();
        if (EmptyUtil.isEmpty(whCommandSkuList.isEmpty())) {
            throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM,
                    "指令行不可为空");
        }
        for (WhCommandSku whCommandSku : whCommandSkuList) {
            if(EmptyUtil.isEmpty(whCommandSku.getSkuCode())){
                throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM,
                        "SKU不能为空！");
            }
            if (NumberUtil.isNullOrZero(whCommandSku.getPlanedQuantity())) {
                throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM,
                        "SKU的计划数量不能为空！");
            }
        }
        Date now = DateUtil.getNow();
        whCommand.setCommandStatus(WhCommand.STATUS_IN_PROCESSING);
        whCommand.setCreateTime(now);
        if(whCommand.getExpressType()==null){
            whCommand.setExpressType(WMSConstants.ExpressType.DEFAULT);
        }
        whCommand.setCancelFlag(PegasusConstants.NO);
        whCommand.setFailureStartConnect(0);
        SWhCommandVO sWhCommandVO = BeanUtil.buildFrom(whCommand,SWhCommandVO.class);
        List<SWhCommandSkuVO> sWhCommandSkuList = BeanUtil
                .buildListFrom(whCommand.getWhCommandSkuList(),SWhCommandSkuVO.class);
        sWhCommandVO.setCommandSkuList(sWhCommandSkuList);
        return sWhCommandVO;
    }


    private void copyWhCommandProps(SWhCommandVO createdCmdDto,WhCommand whCommand){
        if(NullUtil.isNull(createdCmdDto)){
            return;
        }
        BeanUtils.copyProperties(createdCmdDto,whCommand);
        whCommand.setRollbackOccupyList(null);//回归对象，清除，防止数据误操作
        if(EmptyUtil.isNotEmpty(createdCmdDto.getCommandSkuList())){
            List<WhCommandSku> whCommandSkuList = new ArrayList<>();
            for(SWhCommandSkuVO sWhCommandSkuVO : createdCmdDto.getCommandSkuList()){
                WhCommandSku commandSku = new WhCommandSku();
                BeanUtils.copyProperties(sWhCommandSkuVO,commandSku);
                whCommandSkuList.add(commandSku);
            }
            whCommand.setWhCommandSkuList(whCommandSkuList);
        }
    }

    @Override
    @Transactional
    public String createCommandWithoutOccupy(WhCommand whCommand){
        buildAndCreateCommand(whCommand);
        return whCommand.getCode();
    }


    @Deprecated
    @Transactional
    public void buildAndCreateCommand_old(WhCommand whCommand) {
        List<WhCommandSku> whCommandSkuList = whCommand.getWhCommandSkuList();
        if (whCommandSkuList == null && whCommandSkuList.isEmpty()) {
            throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM,
                                         "whCommandSkuList can not be empty.");
        }

        for (WhCommandSku whCommandSku : whCommandSkuList) {
            if (whCommandSku.getPlanedQuantity() == null || whCommandSku.getPlanedQuantity() == 0) {
                throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM,
                                             "SKU的计划数量不能为空！");
            }
        }

        Date current = new Date();
        whCommand.setCommandStatus(WhCommand.STATUS_IN_PROCESSING);
        whCommand.setCreateTime(current);
        if(whCommand.getExpressType()==null){
            whCommand.setExpressType(WMSConstants.ExpressType.DEFAULT);
        }
        whCommand.setCancelFlag(PegasusConstants.NO);
        whCommand.setFailureStartConnect(0);

        SWhCommandVO sWhCommandVO = sWhCommandService.insertCommand(BeanUtil.buildFrom(whCommand,SWhCommandVO.class));
        whCommand.setId(sWhCommandVO.getId());
        Map<String, Object> params = new HashMap<>();
        params.put("createTime", current);
        params.put("inOutType", whCommand.getInOutType());
        params.put("id", whCommand.getId());
        String code = CodeGenerator.getInstance().generate("WH_COMMAND", params);
        whCommand.setCode(code);
        sWhCommandService.updateWhCommandByKey(BeanUtil.buildFrom(whCommand,SWhCommandVO.class));

        for (WhCommandSku whCommandSku : whCommandSkuList) {
            if (EmptyUtil.isEmpty(whCommandSku.getSkuCode())) {
                throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM,
                                             "skuCode can not be empty.");
            }
            whCommandSku.setCommandId(whCommand.getId());
            whCommandSku.setCode(null);
            SWhCommandSkuVO sWhCommandSkuVO = sWhCommandService.insertCommandSku(BeanUtil.buildFrom(whCommandSku,SWhCommandSkuVO.class));
            whCommandSku.setId(sWhCommandSkuVO.getId());
            Map<String, Object> skuParams = new HashMap<>();
            skuParams.put("whCommandCode", whCommand.getCode());
            skuParams.put("id", whCommandSku.getId());
            whCommandSku.setCode(CodeGenerator.getInstance().generate("WH_COMMAND_SKU", skuParams));
            sWhCommandService.updateWhCommandSkuByKey(BeanUtil.buildFrom(whCommandSku,SWhCommandSkuVO.class));
        }

    }

    /**
     * 看了下没有使用，不改
     * */
    @Override
    @Transactional
    @Deprecated
    public String createCommand(WhCommand whCommand, List<WhReleaseOccupationVO> whReleaseOccupationVOList) throws Exception {
        buildAndCreateCommand(whCommand);
        List<SStockOccupyDTO> occupyDTOList = new ArrayList<>();
        // 如果是出库指令,占用
        if (!whCommand.isIn()) {
            for (WhCommandSku whCommandSku : whCommand.getWhCommandSkuList()) {
                SStockOccupyDTO occupyDTO = new SStockOccupyDTO();
                occupyDTO.setWarehouseCode(whCommand.getWarehouseCode());
                occupyDTO.setOccupyType(SStockOccupyTypeEnum.getEnumByCode(whCommand.getInOutType()));
                occupyDTO.setOperationType(SStockOperationTypeEnum.DEFAULT);
                occupyDTO.setReferenceCode(whCommandSku.getCode());
                occupyDTO.setSkuCode(whCommandSku.getSkuCode());
                occupyDTO.setQuantity(whCommandSku.getPlanedQuantity());
                occupyDTOList.add(occupyDTO);
            }
        }

        //占用列表为空，释放列表不为空
        if (EmptyUtil.isEmpty(occupyDTOList) && EmptyUtil.isNotEmpty(whReleaseOccupationVOList)) {
            ServiceResp<List<SReleaseResultVO>>  serviceResp=   sStockService.release(whInvService.convertWhRelease2DTO(whReleaseOccupationVOList));
            if (serviceResp.isFailure()) {
                throw  new WarehouseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
            }
        }

        //占用列表不为空，释放列表为空
        if (EmptyUtil.isNotEmpty(occupyDTOList) && EmptyUtil.isEmpty(whReleaseOccupationVOList)) {
            ServiceResp<List<SOccupyResultVO>>  serviceResp=   sStockService.occupy(occupyDTOList);
            if (serviceResp.isFailure()) {
                throw  new WarehouseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
            }
        }

        //占用列表不为空，释放列表也不为空
        if (EmptyUtil.isNotEmpty(occupyDTOList) && EmptyUtil.isNotEmpty(whReleaseOccupationVOList)) {
            ServiceResp<SOccupyAfterReleaseResultVO> serviceResp = sStockService.occupyAfterRelease(occupyDTOList,
                                                                                                    whInvService.convertWhRelease2DTO(
                                                                                                      whReleaseOccupationVOList));
            if (serviceResp.isFailure()) {
                throw new WarehouseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
            }
        }
        return whCommand.getCode();
    }

    @Override
    @Transactional
    public String createCommandAfterReleasePreOccupy(WhCommand whCommand, List<SStockReleaseDTO> releaseList) throws Exception {
        SWhCommandVO sWhCommandVO = buildCommandForCreate(whCommand);
        sWhCommandVO = sWhCommandService.createWhCommand(sWhCommandVO);
        // 如果是出库指令,占用
        List<SStockOccupyDTO> occupyList = new ArrayList<>();
        for(SWhCommandSkuVO whCommandSku : sWhCommandVO.getCommandSkuList()){
            SStockOccupyDTO occupyDTO = new SStockOccupyDTO();
            occupyDTO.setWarehouseCode(whCommand.getWarehouseCode());
            occupyDTO.setOccupyType(SStockOccupyTypeEnum.getEnumByCode(whCommand.getInOutType()));
            occupyDTO.setOperationType(SStockOperationTypeEnum.DEFAULT);
            occupyDTO.setReferenceCode(whCommandSku.getCode());
            occupyDTO.setSkuCode(whCommandSku.getSkuCode());
            occupyDTO.setQuantity(whCommandSku.getPlanedQuantity());
            occupyList.add(occupyDTO);
        }
        ServiceResp<SOccupyAfterReleaseResultVO>  resp = sStockService.occupyAfterRelease(occupyList, releaseList);
        if (resp.isFailure()) {
           throw  new WarehouseException(resp.getRespMsg());
        }
        return sWhCommandVO.getCode();
    }

    /**
     * 创建指令，并自动完成
     *
     * @param whCommand 指令
     * @return 指令编码
     * @throws Exception 
     */
    @Override
    @Transactional
    public String createCommandThenFinish(WhCommand whCommand) throws Exception {
        String commandCode = createCommand(whCommand);
        whCommand.setCode(commandCode);
        finishCommandByCode(whCommand);
        return commandCode;
    }
    /**
     * 创建指令，并自动完成
     *
     * @param whCommands 指令
     * @return 指令编码
     * @throws Exception 
     */
    @Override
    @Transactional
    public List<String> createCommandsThenFinish(List<WhCommand> whCommands) throws Exception {
        List<String> cmdCodes = new ArrayList<String>();
        for (WhCommand whCommand : whCommands) {
            String commandCode = createCommandThenFinish(whCommand);
            cmdCodes.add(commandCode);
        }
        return cmdCodes;
    }

    /**
     * 释放SKU库存后创建指令
     *
     * @param whCommand                 指令
     * @param whReleaseOccupationVOList
     * @return 指令编码
     */
    @Override
    @Transactional
    public String createCommandAfterRelease(WhCommand whCommand,
                                            List<WhReleaseOccupationVO> whReleaseOccupationVOList) throws Exception {
        //whInvService.releaseOccupation(whReleaseOccupationVOList);
        String commandCode = createCommand(whCommand, whReleaseOccupationVOList);
        return commandCode;
    }

    /**
     * 占用SKU库存后创建指令
     *
     * @param whCommand       指令
     * @param whInvOccupyList SKU库存占用列表
     * @return 指令编码
     */
    @Override
    @Transactional
    public String createCommandAfterOccupy(WhCommand whCommand, List<WhInvOccupy> whInvOccupyList) {
        whInvService.occupy(whInvOccupyList);
        String commandCode = createCommand(whCommand);
        return commandCode;
    }

    /**
     * 释放SKU库存后创建指令，并自动完成
     *
     * @param whCommand                 指令
     * @param whReleaseOccupationVOList          释放占用
     * @return 指令编码
     * @throws Exception 
     */
    @Override
    @Transactional
    public String createCommandAfterReleaseThenFinish(WhCommand whCommand,
                                                      List<WhReleaseOccupationVO> whReleaseOccupationVOList) throws Exception {
        String commandCode = createCommandAfterRelease(whCommand, whReleaseOccupationVOList);
        whCommand.setCode(commandCode);
        finishCommandByCode(whCommand);
        return commandCode;
    }

    @Override
    @Transactional
    public String createCommandThenFinishWithoutOccupy(WhCommand whCommand,List<WhReleaseOccupationVO> releaseList) {
        String comandCode = createCommandWithoutOccupy(whCommand);
        WhCommand tmpCmd = findCommandByCode(comandCode,true);
        finishCommandWithoutOccupy(tmpCmd,releaseList);
        return comandCode;
    }

    @Override
    @Transactional
    public String createCommandThenFinishForSales(WhCommand rcd
            , List<WhReleaseOccupationVO> releaseList
            , List<WhInvRcd> invRcdList,String uniqueCode) {
        //创建指令
        String comandCode = createCommandWithoutOccupy(rcd);
        //完成指令
        if(EmptyUtil.isNotEmpty(invRcdList)){
            for(WhInvRcd invRcd : invRcdList){
                invRcd.setCommandCode(rcd.getCode());
            }
        }
        //防止重复出库
        recordCommandOutFinishDone(comandCode);
        rcd.setCommandStatus(WhCommand.STATUS_FINISHED);
        if (EmptyUtil.isEmpty(rcd.getWhCommandSkuList())) {
            rcd.setWhCommandSkuList(this.findCommandSkuByCommandCode(rcd.getCode()));
        }
        boolean phyWhStockUpdateResult = updatePhyWhSkuStockOut(invRcdList,rcd);
        if(!phyWhStockUpdateResult){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED, "更新物理仓库存失败!");
        }
        //完成指令
        SWhCommandVO sWhCommand = convertCommandToDto(rcd);
        sWhCommand.setStockRecordList(convertInvRcdToDto(invRcdList));
        if(EmptyUtil.isNotEmpty(releaseList)){
            List<SStockReleaseDTO> stockReleaseList = whInvService.convertWhRelease2DTO(releaseList);
            sWhCommand.setStockReleaseList(stockReleaseList);
        }
        SWhCommandVO currentCommand = sWhCommandService.finishWhCommand(sWhCommand);
        if(!WhCommand.STATUS_IN_PROCESSING.equals(currentCommand.getCommandStatus())){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                    ,String.format("[%s]指令状态[%s]!"
                    ,rcd.getCode(),WhCommand.getCommandStatusStr(currentCommand.getCommandStatus())));
        }
        return comandCode;
    }

    private void recordCommandOutFinishDone(String unionCode){
        if(EmptyUtil.isEmpty(unionCode)){
            //唯一键，防止并发
            WhCommandOutFinish outFinish = new WhCommandOutFinish();
            outFinish.setCommandCode(unionCode);//
            outFinish.setStatus(PegasusConstants.YES);
            outFinish.setWhStatus(PegasusConstants.YES);
            outFinish.setFinishDate(DateUtil.getNow());
            whCommandOutFinishMapper.insert(outFinish);
        }
    }

    @Override
    @Transactional
    public boolean finishOutCommandForSales(WhCommand rcd
            ,List<WhReleaseOccupationVO> releaseList
            ,List<WhInvRcd> invRcdList){
        if(EmptyUtil.isNotEmpty(invRcdList)){
            for(WhInvRcd invRcd : invRcdList){
                invRcd.setCommandCode(rcd.getCode());
            }
        }
        //防止重复出库
        recordCommandOutFinishDone(rcd.getCode());
        rcd.setCommandStatus(WhCommand.STATUS_FINISHED);
        if (EmptyUtil.isEmpty(rcd.getWhCommandSkuList())) {
            rcd.setWhCommandSkuList(this.findCommandSkuByCommandCode(rcd.getCode()));
        }
        boolean phyWhStockUpdateResult = updatePhyWhSkuStockOut(invRcdList,rcd);
        if(!phyWhStockUpdateResult){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED, "更新物理仓库存失败!");
        }
        //完成指令
        SWhCommandVO sWhCommand = convertCommandToDto(rcd);
        sWhCommand.setStockRecordList(convertInvRcdToDto(invRcdList));
        if(EmptyUtil.isNotEmpty(releaseList)){
            List<SStockReleaseDTO> stockReleaseList = whInvService.convertWhRelease2DTO(releaseList);
            sWhCommand.setStockReleaseList(stockReleaseList);
        }
        SWhCommandVO currentCommand = sWhCommandService.finishWhCommand(sWhCommand);
        if(!WhCommand.STATUS_IN_PROCESSING.equals(currentCommand.getCommandStatus())){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                    ,String.format("[%s]指令状态[%s]!"
                    ,rcd.getCode(),WhCommand.getCommandStatusStr(currentCommand.getCommandStatus())));
        }
        return true;
    }

    /**
     * 释放SKU库存后创建指令，并自动完成
     *
     * @param whCommands                 指令
     * @param whReleaseOccupationVOList
     * @return 指令编码
     * @throws Exception 
     */
    @Override
    @Transactional
    public List<String> createCommandsAfterReleaseThenFinish(List<WhCommand> whCommands, List<WhReleaseOccupationVO> whReleaseOccupationVOList) throws Exception {
        List<String> commandCodes = new ArrayList<>();
        whInvService.releaseOccupation(whReleaseOccupationVOList);
        for (WhCommand whCommand : whCommands) {
            String commandCode = createCommand(whCommand);
            commandCodes.add(commandCode);
            //finishCommandByCode(commandCode);
            finishCommand(whCommand);
        }
        return commandCodes;
    }
    
    /**
     * 释放SKU库存后创建指令，并自动完成
     *
     * @param whCommands                 指令
     * @param whReleaseOccupationVOList
     * @return 指令编码
     * @throws Exception 
     */
    @Override
    @Transactional
    public List<String> createCommandsAfterReleaseThenFinishForPrdc(List<WhCommand> whCommands, List<WhReleaseOccupationVO> whReleaseOccupationVOList) throws Exception {
        List<String> commandCodes = new ArrayList<>();
        whInvService.releaseOccupation(whReleaseOccupationVOList);
        for (WhCommand whCommand : whCommands) {
            String commandCode = createCommand(whCommand);
            commandCodes.add(commandCode);
            //finishCommandByCode(commandCode);
            finishCommandForPrdc(whCommand);
        }
        return commandCodes;
    }
    
    /**
     * 释放SKU库存后创建指令，并自动完成,并创建占用
     *
     * @param whCommands                 指令
     * @param whReleaseOccupationVOList
     * @return 指令编码
     * @throws Exception 
     */
    @Override
    @Transactional
	public List<String> createCommandsAfterReleaseThenFinishThenOccupy(
			List<WhCommand> whCommands,
			List<WhReleaseOccupationVO> whReleaseOccupationVOList,
			List<WhInvOccupy> whInvOccupyList) throws Exception {
    	List<String> commandCodes = new ArrayList<>();
    	if(whInvOccupyList!=null && whInvOccupyList.isEmpty()){
    		whInvService.releaseOccupation(whReleaseOccupationVOList);
    	}else{
    		whInvService.occupyAfterRelease(whInvOccupyList,whReleaseOccupationVOList);
    	}
    	for (WhCommand whCommand : whCommands) {
            String commandCode = createCommand(whCommand);
            commandCodes.add(commandCode);
            //finishCommandByCode(commandCode);
            finishCommand(whCommand);
        }
    	return commandCodes;
	}

    /**
     * 占用SKU库存后创建指令，并自动完成
     *
     * @param whCommand 指令
     * @param whInvOccupyList SKU库存占用列表
     * @return 指令编码
     * @throws Exception 
     */
    @Override
    @Transactional
    public String createCommandAfterOccupyThenFinish(WhCommand whCommand, List<WhInvOccupy> whInvOccupyList) throws Exception {
        String commandCode = createCommandAfterOccupy(whCommand, whInvOccupyList);
        whCommand.setCode(commandCode);
        finishCommandByCode(whCommand);
        return commandCode;
    }

    /**
     * 根据CODE列表查找指令列表
     *
     * @param codeList 指令编码列表
     * @param fetch    是否抓取行
     * @return 指令列表
     */
    @Override
    public List<WhCommand> findCommandByCodes(List<String> codeList, boolean fetch) {
        if (EmptyUtil.isEmpty(codeList)) {
            return new ArrayList<>();
        }
        WhCommandCond cond = new WhCommandCond();
        cond.setCodeList(codeList);
        cond.setFetch(fetch);
        return findCommandByCond(cond);
    }

    @Override
    public List<WhCommandSku> findCommandSkuByCommandCodes(List<String> commandCodeList) {
        return whCommandSkuMapper.findCommandSkuByCommandCodes(commandCodeList);
    }

    @Override
    public List<WhCommandSku> findCommandSkuByCommandSkuCodes(List<String> commandSkuCodeList) {
        return whCommandSkuMapper.findCommandSkuByCommandSkuCodes(commandSkuCodeList);
    }

    /**
     * 根据仓库和指令编码查找处理中的指令
     *
     * @param warehouseCodeList
     * @param codeList
     * @return
     */
    @Override
    public List<WhCommand> findInProcessCommandByWarehouseAndAndCodes(List<String> warehouseCodeList,
                                                                      List<String> codeList) {
        if (EmptyUtil.isEmpty(warehouseCodeList) || EmptyUtil.isEmpty(codeList)) {
            return new ArrayList<>();
        }

        WhCommandExample example = new WhCommandExample();
        example.createCriteria().andCommandStatusEqualTo(WhCommand.STATUS_IN_PROCESSING)
            .andWarehouseCodeIn(warehouseCodeList).andCodeIn(codeList);
        List<WhCommand> result = whCommandMapper.selectByExample(example);

        fillCommandSku(result);
        return result;
    }

    /**
     * 根据CODE查找指令
     *
     * @param code 指令编码
     * @param fetch 是否抓取行
     * @return 指令
     */
    @Override
    public WhCommand findCommandByCode(String code, boolean fetch) {
        WhCommandCond cond = new WhCommandCond();
        cond.setCode(code);
        cond.setFetch(fetch);
        List<WhCommand> whCommandList = findCommandByCond(cond);
        return (whCommandList != null && !whCommandList.isEmpty()) ? whCommandList.get(0) : null;
    }
    
    /**
     * 根据CODE查找指令
     *
     * @param code 指令编码
     * @param fetch 是否抓取行
     * @return 指令
     */
    @Override
    public WhCommand findNewCommandByCode(String code, boolean fetch) {
        WhCommandCond cond = new WhCommandCond();
        cond.setCode(code);
        cond.setFetch(fetch);
        List<WhCommand> whCommandList = findNewCommandByCond(cond);
        return (whCommandList != null && !whCommandList.isEmpty()) ? whCommandList.get(0) : null;
    }

    @Override
    public WhCommand findCommandById(Integer id, boolean fetch) {
        WhCommandCond cond = new WhCommandCond();
        cond.setId(id);
        cond.setFetch(fetch);
        List<WhCommand> whCommandList = findCommandByCond(cond);
        return (whCommandList != null && !whCommandList.isEmpty()) ? whCommandList.get(0) : null;
    }

    /**
     * 根据逻辑仓和增量时间条件查找处理中的指令
     *
     * @param warehouseCodeList 逻辑仓列表
     * @param incrementTime     增量时间
     * @return 指令列表
     */
    @Override
    public List<WhCommand> findInProcessCommandByIncrement(List<String> warehouseCodeList,
                                                           Date incrementTime) {
        if (EmptyUtil.isEmpty(warehouseCodeList) || EmptyUtil.isEmpty(incrementTime)) {
            return new ArrayList<>();
        }

        WhCommandExample example = new WhCommandExample();
        example.createCriteria().andCommandStatusEqualTo(WhCommand.STATUS_IN_PROCESSING)
            .andWarehouseCodeIn(warehouseCodeList).andCreateTimeGreaterThanOrEqualTo(incrementTime);
        List<WhCommand> result = whCommandMapper.selectByExample(example);

        fillCommandSku(result);

        return result;
    }

    /**
     * 根据出入库类型和相关单据号查找指令
     *
     * @param type          出入库类型
     * @param referenceCode 相关单据号
     * @param fetch 是否抓取行
     * @return 是否成功
     */
    @Override
    public WhCommand findCommandByTypeAndReferenceCode(Integer type, String referenceCode,
                                                       boolean fetch) {
        WhCommandCond cond = new WhCommandCond();
        List<Integer> inOutTypeList = new ArrayList<>();
        inOutTypeList.add(type);
        cond.setInOutTypeList(inOutTypeList);
        cond.setReferenceCode(referenceCode);
        cond.setFetch(fetch);

        List<WhCommand> whCommandList = findCommandByCond(cond);
        if (whCommandList.size() == 0) {
            return null;
        } else if (whCommandList.size() != 1) {
            throw new WarehouseException(CommExceptionErrorCode.ONLY_ONE_RECORD_EXPECTED,
                "相同类型+相关单据号只能有一条记录");
        }

        return whCommandList.get(0);
    }

    /**
     * 根据条件查找指令
     *
     * @param cond 条件
     * @return
     */
    @Override
    public List<WhCommand> findCommandByCond(WhCommandCond cond) {
        if (EmptyUtil.isEmpty(cond.getWarehouseCodeList())) {
            cond.setWarehouseCodeList(null);
        }

        if (EmptyUtil.isEmpty(cond.getInOutTypeList())) {
            cond.setInOutTypeList(null);
        }

        List<WhCommand> result = whCommandMapper.findCommandByCond(cond);
        if (cond.isFetch() && EmptyUtil.isNotEmpty(result)) {
            List<Long> whCommandIdList = new ArrayList<>();
            for (WhCommand whCommand : result) {
                whCommandIdList.add(whCommand.getId());
            }

            List<WhCommandSku> whCommandSkuList = findCommandSkuByCommandIds(whCommandIdList);
            // 组装成map
            Map<Long, List<WhCommandSku>> map = new HashMap<>();
            for (WhCommandSku whCommandSku : whCommandSkuList) {
                Long commandId = whCommandSku.getCommandId();
                List<WhCommandSku> listInMap = map.get(commandId);
                if (listInMap == null) {
                    listInMap = new ArrayList<>();
                    map.put(commandId, listInMap);
                }
                listInMap.add(whCommandSku);
            }

            // 填充
            for (WhCommand whCommand : result) {
                List<WhCommandSku> listInMap = map.get(whCommand.getId());
                whCommand.setWhCommandSkuList(listInMap);
            }
        }

        return result;
    }
    
    /**
     * 根据条件查找指令
     *
     * @param cond 条件
     * @return
     */
    @Override
    public List<WhCommand> findNewCommandByCond(WhCommandCond cond) {
        if (EmptyUtil.isEmpty(cond.getWarehouseCodeList())) {
            cond.setWarehouseCodeList(null);
        }

        if (EmptyUtil.isEmpty(cond.getInOutTypeList())) {
            cond.setInOutTypeList(null);
        }

        List<WhCommand> result = whCommandMapper.findNewCommandByCond(cond);
        if (cond.isFetch() && EmptyUtil.isNotEmpty(result)) {
            List<Long> whCommandIdList = new ArrayList<>();
            for (WhCommand whCommand : result) {
                whCommandIdList.add(whCommand.getId());
            }

            List<WhCommandSku> whCommandSkuList = findCommandSkuByCommandIds(whCommandIdList);
            // 组装成map
            Map<Long, List<WhCommandSku>> map = new HashMap<>();
            for (WhCommandSku whCommandSku : whCommandSkuList) {
                Long commandId = whCommandSku.getCommandId();
                List<WhCommandSku> listInMap = map.get(commandId);
                if (listInMap == null) {
                    listInMap = new ArrayList<>();
                    map.put(commandId, listInMap);
                }
                listInMap.add(whCommandSku);
            }

            // 填充
            for (WhCommand whCommand : result) {
                List<WhCommandSku> listInMap = map.get(whCommand.getId());
                whCommand.setWhCommandSkuList(listInMap);
            }
        }

        return result;
    }

    @Override
    public List<WhCommand> findUnDeliveryGoodsAndNoSendMailByCond(WhCommandCond cond) {
        return whCommandMapper.findUnDeliveryGoodsAndNoSendMailByCond(cond);
    }

    /**
     * 根据逻辑仓创建时间范围查找处理中的指令
     *
     * @param warehouseCodeList
     * @param startTime
     * @param endTime
     * @return 指令列表
     */
    @Override
    public List<WhCommand> findInProcessCommandByWarehouseAndTimeRange(List<String> warehouseCodeList,
                                                                       Date startTime, Date endTime) {
        WhCommandExample example = new WhCommandExample();
        example.createCriteria().andCommandStatusEqualTo(WhCommand.STATUS_IN_PROCESSING)
            .andWarehouseCodeIn(warehouseCodeList).andCreateTimeBetween(startTime, endTime);
        return whCommandMapper.selectByExample(example);
    }

    /**
     * 根据CODE查找指令行
     *
     * @param code 指令行编码
     * @return 指令行
     */
    @Override
    public WhCommandSku findCommandSkuByCode(String code) {
        WhCommandSkuExample example = new WhCommandSkuExample();
        example.createCriteria().andCodeEqualTo(code);
        List<WhCommandSku> whCommandSkuList = whCommandSkuMapper.selectByExample(example);
        return (whCommandSkuList != null && !whCommandSkuList.isEmpty()) ? whCommandSkuList.get(0)
            : null;
    }

    /**
     * 根据CODE查找指令行
     *
     * @param commandCode 指令编码
     * @return 指令行列表
     */
    @Override
    public List<WhCommandSku> findCommandSkuByCommandCode(String commandCode) {
        WhCommand whCommand = findCommandByCode(commandCode, false);
        if (whCommand == null) {
            return new ArrayList<>();
        }

        WhCommandSkuExample example = new WhCommandSkuExample();
        example.createCriteria().andCommandIdEqualTo(whCommand.getId());
        example.setOrderByClause("id");
        return whCommandSkuMapper.selectByExample(example);
    }

    /**
     * 根据CODE查找指令行
     *
     * @param commandId 指令Id
     * @return 指令行列表
     */
    @Override
    public List<WhCommandSku> findCommandSkuByCommandId(Long commandId) {
        WhCommandSkuExample example = new WhCommandSkuExample();
        example.createCriteria().andCommandIdEqualTo(commandId);
        example.setOrderByClause("id");
        return whCommandSkuMapper.selectByExample(example);
    }

    /**
     * 根据ID取消指令
     *
     * @param id 指令Id
     * @return 是否成功
     */
    @Override
    public boolean cancelCommandById(Long id) {
        WhCommand rcd = whCommandMapper.selectByPrimaryKey(id);
        return rcd != null ? cancelCommand(rcd) : false;
    }

    /**
     * 根据编码取消指令
     *
     * @param code 指令编码
     * @return 是否成功
     */
    @Override
    @Transactional
    public boolean cancelCommandByCode(String code) {
        WhCommand rcd = findCommandByCode(code, false);
        return rcd != null ? cancelCommand(rcd) : false;
    }

    @Override
    @Transactional
    public boolean cancelCommandByCodeWithoutOccupy(String code) {
        WhCommand rcd = findCommandByCode(code, false);
        return cancelCommandWithoutOccupy(rcd);
    }

    /**
     * 根据出入库类型和相关单据号取消指令
     *
     * @param type          出入库类型
     * @param referenceCode 相关单据号
     * @return 是否成功
     */
    @Override
    @Transactional
    public boolean cancelCommandByTypeAndReferenceCode(Integer type, String referenceCode) {
        WhCommand rcd = findCommandByTypeAndReferenceCode(type, referenceCode, false);
        return rcd != null ? cancelCommand(rcd) : false;
    }

    /**
     * 根据出入库类型和相关单据号取消指令,再占用
     *
     * @param type          出入库类型
     * @param referenceCode 相关单据号
     * @param whInvOccupyList 占用列表
     * @return 是否成功cancelMake.json
     */
    @Override
    @Transactional
    public boolean cancelCommandByTypeAndReferenceCodeBeforeOccupy(Integer type, String referenceCode, List<WhInvOccupy> whInvOccupyList) {
        //cancelCommandByTypeAndReferenceCode(type,referenceCode);
        WhCommand rcd = findCommandByTypeAndReferenceCode(type, referenceCode, false);
        if (NullUtil.isNotNull(rcd)
                && ( WhCommand.STATUS_IN_PROCESSING.equals(rcd.getCommandStatus()) || WhCommand.STATUS_SHORTAGES.equals(rcd.getCommandStatus()) )//处理中或缺货中
                ) {
            rcd.setReferenceCode(rcd.getReferenceCode() + "_"
                    + DateUtil.format(new Date(), "yyyyMMddHHmmss"));
            rcd.setCommandStatus(WhCommand.STATUS_CANCELED);
            rcd.setProcessTime(new Date());
            whCommandMapper.updateByPrimaryKey(rcd);
            WhCommandExample commandExample = new WhCommandExample();
            commandExample.createCriteria().andIdEqualTo(rcd.getId()).andCommandStatusEqualTo(rcd.getCommandStatus());
            boolean success = whCommandMapper.updateByExampleSelective(rcd,commandExample)==1;
            if(!success){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"指令取消失败,请重试");
            }
            // 如果是出库指令,释放占用
            releaseWhCommandOccupy(rcd);
            //释放预占用
            whWmsCommandPreOccupyService.releasePreOccupy(Collections.singletonList(rcd.getCode()));
        } else {
            throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                    "指令当前不可取消");
        }
        // 此处占用时，无需校验库存
        whInvService.occupyAndNoNeedCheckStock(whInvOccupyList,true);
        return true;
    }

    @Override
    @Transactional
    public boolean cancelCommandByTypeAndReferenceCodeWithoutOccupy(Integer type, String referenceCode) {
        WhCommand rcd = findCommandByTypeAndReferenceCode(type, referenceCode, false);
        if (NullUtil.isNotNull(rcd)
                && ( WhCommand.STATUS_IN_PROCESSING.equals(rcd.getCommandStatus())
                    || WhCommand.STATUS_SHORTAGES.equals(rcd.getCommandStatus()) )//处理中或缺货中
        ) {
            Integer oldCommandStatus = rcd.getCommandStatus();
            rcd.setReferenceCode(rcd.getReferenceCode() + "_"
                    + DateUtil.format(new Date(), "yyyyMMddHHmmss"));
            rcd.setCommandStatus(WhCommand.STATUS_CANCELED);
            rcd.setProcessTime(new Date());
            WhCommandExample commandExample = new WhCommandExample();
            commandExample.createCriteria().andIdEqualTo(rcd.getId()).andCommandStatusEqualTo(oldCommandStatus);
            boolean success = whCommandMapper.updateByExampleSelective(rcd,commandExample)==1;
            if(!success){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"指令取消失败,请重试");
            }
            //释放预占用
            whWmsCommandPreOccupyService.releasePreOccupy(Collections.singletonList(rcd.getCode()));
        } else {
            throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                    "指令当前不可取消");
        }
        return true;
    }

    @Override
    @Transactional
    public boolean cancelCommandByTypeAndReferenceCodeAfterRelease(Integer type,
                                                                   String referenceCode,
                                                                   List<WhReleaseOccupationVO> whReleaseOccupationVOList) {
        whInvService.releaseOccupation(whReleaseOccupationVOList);
        WhCommand rcd = findCommandByTypeAndReferenceCode(type, referenceCode, false);
        return rcd != null ? cancelCommand(rcd) : false;
    }

    /**
     * 根据出入库类型和相关单据号重置指令相关单据号
     *
     * @param type          出入库类型
     * @param referenceCode 相关单据号
     */
    @Override
    public void resetCommandReferenceCodeByTypeAndReferenceCode(Integer type, String referenceCode) {
        WhCommand rcd = findCommandByTypeAndReferenceCode(type, referenceCode, false);
        rcd.setReferenceCode(rcd.getReferenceCode() + "_"
                + DateUtil.format(new Date(), "yyyyMMddHHmmss"));
        whCommandMapper.updateByPrimaryKeySelective(rcd);
    }

    /**
     * 占用前根据出入库类型和相关单据号重置指令相关单据号
     *
     * @param type
     * @param referenceCode
     * @param whInvOccupyList
     */
    @Override
    @Transactional
    public void resetCommandReferenceCodeByTypeAndReferenceCodeBeforeOccupy(Integer type,
                                                                            String referenceCode,
                                                                            List<WhInvOccupy> whInvOccupyList) {
        whInvService.occupy(whInvOccupyList);
        resetCommandReferenceCodeByTypeAndReferenceCode(type, referenceCode);
    }

    /**
     * 根据ID完成指令
     *
     * @param id 指令Id
     * @return 是否成功
     * @throws Exception 
     */
    @Override
    public boolean finishCommandById(Long id) throws Exception {
        WhCommand rcd = whCommandMapper.selectByPrimaryKey(id);
        return finishCommand(rcd);
    }

    /**
     * 根据编码完成指令
     *
     * @param code 指令编码
     * @return 是否成功
     * @throws Exception 
     */
    @Override
    @Transactional
    public boolean finishCommandByCode(String code) throws Exception {
        WhCommand rcd = findCommandByCode(code, false);
        return finishCommand(rcd);
    }

    @Override
    @Transactional
    @Deprecated
    public boolean finishCommandWithoutOccupy(String code) {
        WhCommand rcd = findCommandByCode(code, false);
        return finishCommandWithoutOccupy(rcd);
    }

    //获取包裹占用
    private List<WhReleaseOccupationVO> findPackageOccupyRelease(WhCommand cmd){
        return whCommandMapper.findPackageOccupyReleaseByPackageCode(cmd.getReferenceCode());
    }

    public boolean finishCommandByCode(WhCommand whCommand) throws Exception {
        WhCommand rcd = findCommandByCode(whCommand.getCode(), false);
        if (EmptyUtil.isNotEmpty(whCommand.getOperatorId())){
            rcd.setOperatorId(whCommand.getOperatorId());
        }
        return finishCommand(rcd);
    }

    /**
     * 根据出入库类型和相关单据号完成指令
     *
     * @param type          出入库类型
     * @param referenceCode 相关单据号
     * @return 是否成功
     * @throws Exception 
     */
    @Override
    public boolean finishCommandByTypeAndReferenceCode(Integer type, String referenceCode) throws Exception {
        WhCommand rcd = findCommandByTypeAndReferenceCode(type, referenceCode, false);
        return finishCommand(rcd);
    }

    private List<WhCommandSku> findCommandSkuByCommandIds(List<Long> whCommandIdList) {
        WhCommandSkuExample example = new WhCommandSkuExample();
        example.createCriteria().andCommandIdIn(whCommandIdList);
        return whCommandSkuMapper.selectByExample(example);
    }

    /**
     * 取消指令
     *
     * @param rcd 指令
     * @return 是否成功
     */
    @Transactional
    @Override
    public boolean cancelCommand(WhCommand rcd) {
        if (rcd != null
                && ( WhCommand.STATUS_IN_PROCESSING.equals(rcd.getCommandStatus()) || WhCommand.STATUS_SHORTAGES.equals(rcd.getCommandStatus()) )//处理中或缺货中
                ) {
            rcd.setReferenceCode(rcd.getReferenceCode() + "_"
                    + DateUtil.format(new Date(), "yyyyMMddHHmmss"));

            rcd.setProcessTime(new Date());
            // #3604 取消订单显示快递单号 此处无需清空快递单
            //rcd.setExpressNo(null);
//            whCommandMapper.updateByPrimaryKey(rcd);
            WhCommandExample example = new WhCommandExample();
            example.createCriteria().andIdEqualTo(rcd.getId()).andCommandStatusEqualTo(rcd.getCommandStatus());
            rcd.setCommandStatus(WhCommand.STATUS_CANCELED);
            boolean success = whCommandMapper.updateByExampleSelective(rcd,example) == 1;
            if(!success){
                throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,"指令取消失败，请稍后重试");
            }
            // 如果是出库指令,释放占用
            releaseWhCommandOccupy(rcd);
            return true;
        } else {
            throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                "cancelCommand failed,current status is not STATUS_IN_PROCESSING or STATUS_SHORTAGES.");
        }
    }

    @Override
    @Transactional
    public boolean cancelCommandWithoutOccupy(WhCommand rcd) {
        if (rcd != null
                && ( WhCommand.STATUS_IN_PROCESSING.equals(rcd.getCommandStatus()) || WhCommand.STATUS_SHORTAGES.equals(rcd.getCommandStatus()) )//处理中或缺货中
        ) {
            rcd.setReferenceCode(rcd.getReferenceCode() + "_"
                    + DateUtil.format(new Date(), "yyyyMMddHHmmss"));

            rcd.setProcessTime(new Date());
            // #3604 取消订单显示快递单号 此处无需清空快递单
            //rcd.setExpressNo(null);
//            whCommandMapper.updateByPrimaryKey(rcd);
            WhCommandExample example = new WhCommandExample();
            example.createCriteria().andIdEqualTo(rcd.getId()).andCommandStatusEqualTo(rcd.getCommandStatus());
            if(EmptyUtil.isNotEmpty(rcd.getReferenceCode())
                    && !rcd.getReferenceCode().contains("_") ){
                rcd.setReferenceCode(rcd.getReferenceCode()+"_"+DateUtil.getNowFormat(DateUtil.DEFAULT_STR_FORMAT));
            }
            rcd.setCommandStatus(WhCommand.STATUS_CANCELED);
            boolean success = whCommandMapper.updateByExampleSelective(rcd,example) == 1;
            if(!success){
                throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,"指令取消失败，请稍后重试");
            }
            //释放预占用
            whWmsCommandPreOccupyService.releasePreOccupy(Collections.singletonList(rcd.getCode()));
            return true;
        } else {
            throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                    "cancelCommand failed,current status is not STATUS_IN_PROCESSING or STATUS_SHORTAGES.");
        }
    }

    @Override
    @Transactional
    public boolean cancelCommandforShortage(String commandCode) {
        WhCommand rcd = findCommandByCode(commandCode,false);
        return cancelCommandforShortage(rcd);
    }

    @Override
    @Transactional
    public boolean cancelCommandforShortage(List<String> whCommandCodes,Integer oldStatus) {
        if(EmptyUtil.isEmpty(whCommandCodes)){
            return true;
        }
        List<WhCommand> cmdList = findCommandByCodes(whCommandCodes,false);
        for(WhCommand rcd : cmdList){
            WhCommandExample example = new WhCommandExample();
            example.createCriteria().andIdEqualTo(rcd.getId()).andCommandStatusEqualTo(oldStatus);
            WhCommand update = new WhCommand();
            update.setCommandStatus(WhCommand.STATUS_CANCELED);
            if(EmptyUtil.isNotEmpty(rcd.getReferenceCode())
                    && !rcd.getReferenceCode().contains("_") ){
                rcd.setReferenceCode(rcd.getReferenceCode()+"_"+DateUtil.getNowFormat(DateUtil.DEFAULT_STR_FORMAT));
            }
            update.setCancelFlag(PegasusConstants.YES);
            update.setProcessTime(DateUtil.getNow());
            boolean success = whCommandMapper.updateByExampleSelective(update,example) == 1;
            if(!success){
                throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                        String.format("[%s]取消指令取消失败",rcd.getCode()));
            }
        }
        return true;
    }

    @Override
    @Transactional
    public boolean cancelCommandforShortage(WhCommand rcd) {
        if(NullUtil.isNull(rcd)){
            throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                    "指令不存在");
        }
        rcd = findCommandByCode(rcd.getCode(),false);
        if(WhCommand.STATUS_CANCELED.equals(rcd.getCommandStatus())){
            throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                    "指令已取消");
        }
        WhCommandExample example = new WhCommandExample();
        example.createCriteria().andIdEqualTo(rcd.getId()).andCommandStatusEqualTo(rcd.getCommandStatus());
        WhCommand update = new WhCommand();
        update.setCommandStatus(WhCommand.STATUS_CANCELED);
        if(EmptyUtil.isNotEmpty(rcd.getReferenceCode())
                && !rcd.getReferenceCode().contains("_") ){
            update.setReferenceCode(rcd.getReferenceCode()+"_"+DateUtil.getNowFormat(DateUtil.DEFAULT_STR_FORMAT));
        }
        update.setCancelFlag(PegasusConstants.YES);
        update.setProcessTime(DateUtil.getNow());
        boolean success = whCommandMapper.updateByExampleSelective(update,example) == 1;
        if(!success){
            throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                    String.format("[%s]取消指令取消失败",rcd.getCode()));
        }
        return true;
    }


    @Transactional
    @Deprecated
    public boolean cancelCommandForSalesOrder_old(List<WhCommand> whCommands, List<SStockReleaseDTO> releaseList) {
        if(EmptyUtil.isNotEmpty(whCommands)){
            List<String> commandCodes = new ArrayList<>();
            for(WhCommand command : whCommands){
                if(WhWmsCommandInfoVO.STATUS_DELIVERYCOMPLETION.equals(command.getCommandStatus())){
                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"出库命令已完成");
                }
                commandCodes.add(command.getCode());
                if(NullUtil.isNotNull(command.getCancelFlag()) && PegasusConstants.YES == command.getCancelFlag() ){
                    //更新取消标志
                    WhCommandExample commandExample = new WhCommandExample();
                    commandExample.createCriteria().andIdEqualTo(command.getId()).andCancelFlagEqualTo(PegasusConstants.NO);
                    boolean success = whCommandMapper.updateByExampleSelective(command,commandExample)==1;
                    if(!success){
                        throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"订单取消失败,请重试");
                    }
                }else{
                    command.setReferenceCode(command.getReferenceCode() + "_"+ DateUtil.format(new Date(), "yyyyMMddHHmmss"));
                    command.setCommandStatus(WhCommand.STATUS_CANCELED);
                    command.setProcessTime(new Date());
                    WhCommandExample commandExample = new WhCommandExample();
                    commandExample.createCriteria().andIdEqualTo(command.getId()).andCommandStatusEqualTo(WhCommand.STATUS_IN_PROCESSING);
                    boolean success = whCommandMapper.updateByExampleSelective(command,commandExample)==1;
                    if(!success){
                        throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"订单取消失败,请重试");
                    }
                    //释放占用
                    releaseWhCommandOccupy(command);
                }
                //释放预占用
                whWmsCommandPreOccupyService.releasePreOccupy(commandCodes);
            }
        }
        // 非来单不占用库存，不需要释放
        if(EmptyUtil.isNotEmpty(releaseList)){// 释放占用
            ServiceResp<List<SReleaseResultVO>> serviceResp = sStockService.release(releaseList);
            if (serviceResp.isFailure()) {
                throw new WarehouseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
            }
        }
        return true;
    }

    @Override
    @Transactional
    public boolean cancelCommandForSalesOrder(List<WhCommand> whCommands,List<SStockReleaseDTO> releaseList){
        if(EmptyUtil.isNotEmpty(whCommands)){
            List<String> commandCodes = new ArrayList<>();
            for(WhCommand command : whCommands){
                commandCodes.add(command.getCode());
            }
            List<WhCommand> list = findCommandByCodes(commandCodes,false);
            for(WhCommand command : list){
                if(WhWmsCommandInfoVO.STATUS_DELIVERYCOMPLETION.equals(command.getCommandStatus())){
                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"出库命令已完成");
                }
                if(WhCommand.STATUS_IN_PROCESSING.equals(command.getCommandStatus())){
                    //直接取消
                    command.setReferenceCode(command.getReferenceCode() + "_" + DateUtil.getNowFormat(DateUtil.DEFAULT_STR_FORMAT));
                    command.setCommandStatus(WhCommand.STATUS_CANCELED);
                    command.setProcessTime(new Date());
                    WhCommandExample commandExample = new WhCommandExample();
                    commandExample.createCriteria().andIdEqualTo(command.getId()).andCommandStatusEqualTo(WhCommand.STATUS_IN_PROCESSING);
                    boolean success = whCommandMapper.updateByExampleSelective(command,commandExample)==1;
                    if(!success){
                        throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"指令取消失败,请重试");
                    }
                }else{
                    //更新取消标志
                    WhCommandExample commandExample = new WhCommandExample();
                    commandExample.createCriteria().andIdEqualTo(command.getId()).andCancelFlagEqualTo(PegasusConstants.NO);
                    command.setCancelFlag(PegasusConstants.YES);
                    command.setReferenceCode(command.getReferenceCode() + "_" + DateUtil.getNowFormat(DateUtil.DEFAULT_STR_FORMAT));
                    boolean success = whCommandMapper.updateByExampleSelective(command,commandExample)==1;
                    if(!success){
                        throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"订单取消失败,请重试");
                    }
                }
            }
            //释放预占用
            whWmsCommandPreOccupyService.releasePreOccupy(commandCodes);
        }
        // 非来单不占用库存，不需要释放
        if(EmptyUtil.isNotEmpty(releaseList)){// 释放占用
            ServiceResp<List<SReleaseResultVO>> serviceResp = sStockService.release(releaseList);
            if (serviceResp.isFailure()) {
                throw new WarehouseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
            }
        }
        return true;
    }

    @Transactional
    @Override
    public void releaseWhCommandOccupy(WhCommand rcd){
        if (rcd.isOut()) {
            rcd = this.findCommandByCode(rcd.getCode(), true);
            if (EmptyUtil.isEmpty(rcd.getWhCommandSkuList())) {
                rcd.setWhCommandSkuList(this.findCommandSkuByCommandCode(rcd.getCode()));
            }

            List<WhReleaseOccupationVO> whReleaseOccupationVOList = new ArrayList<>();
            for (WhCommandSku whCommandSku : rcd.getWhCommandSkuList()) {
                WhReleaseOccupationVO whReleaseOccupationVO = new WhReleaseOccupationVO();
                whReleaseOccupationVO.setOccupyType(rcd.getInOutType());
                whReleaseOccupationVO.setReferenceCode(whCommandSku.getCode());
                whReleaseOccupationVOList.add(whReleaseOccupationVO);
            }
            if(whReleaseOccupationVOList != null && whReleaseOccupationVOList.size() > 0){
                whInvService.releaseOccupation(whReleaseOccupationVOList);
            }
        }
    }

    private SWhCommandVO convertCommandToDto(WhCommand cmd){
        if(NullUtil.isNull(cmd)){
            return null;
        }
        SWhCommandVO dto = BeanUtil.buildFrom(cmd,SWhCommandVO.class);
        if(EmptyUtil.isNotEmpty(cmd.getWhCommandSkuList())){
            List<SWhCommandSkuVO> commandSkuList = BeanUtil
                    .buildListFrom(cmd.getWhCommandSkuList(), SWhCommandSkuVO.class);
            dto.setCommandSkuList(commandSkuList);
        }
        return dto;
    }

    private WhCommand convertDtoToCommand(SWhCommandVO sWhCommandVO){
        if(NullUtil.isNull(sWhCommandVO)){
            return null;
        }
        WhCommand cmd = BeanUtil.buildFrom(sWhCommandVO,WhCommand.class);
        if(EmptyUtil.isNotEmpty(sWhCommandVO.getCommandSkuList())){
            List<WhCommandSku> commandSkuList = BeanUtil
                    .buildListFrom(sWhCommandVO.getCommandSkuList(), WhCommandSku.class);
            cmd.setWhCommandSkuList(commandSkuList);
        }
        return cmd;
    }
    /**
     * 完成指令
     *
     * @param rcd 指令
     * @return 是否成功
     * @throws Exception 
     */
    @Deprecated
    @Transactional
    public boolean finishCommand_old(WhCommand rcd) throws Exception {
        if (rcd != null && WhCommand.STATUS_IN_PROCESSING.equals(rcd.getCommandStatus())) {
            rcd.setCommandStatus(WhCommand.STATUS_FINISHED);
            rcd.setProcessTime(rcd.getProcessTime() == null ? new Date() : rcd.getProcessTime());
            sWhCommandService.updateWhCommandByKey(BeanUtil.buildFrom(rcd, SWhCommandVO.class));
            if (EmptyUtil.isEmpty(rcd.getWhCommandSkuList())) {
                rcd.setWhCommandSkuList(this.findCommandSkuByCommandCode(rcd.getCode()));
            }
            //批量释放库存
            List<SStockReleaseDTO> releaseDTOS = new ArrayList<>();
            for (WhCommandSku whCommandSku : rcd.getWhCommandSkuList()) {
                // 如果数量为空，加载并设置 [实际数量=计划数量,残次数量=0]
                if (whCommandSku.getQuantity() == null) {
                    whCommandSku.setQuantity(whCommandSku.getPlanedQuantity());
                }
                if (whCommandSku.getDamagedQuantity() == null) {
                    whCommandSku.setDamagedQuantity(0);
                }

                // 更新行
                sWhCommandService.updateWhCommandSkuByKey(BeanUtil.buildFrom(whCommandSku,SWhCommandSkuVO.class));

                List<SStockRecordVO> rollbackRecordList = new ArrayList<SStockRecordVO>();
                // 如果是入库指令
                if (rcd.isIn()) {
                    //库存记录回滚List
                    // (非残次数量 + 残次数量) > 0，记录SKU库存记录)
                    List<SStockRecordVO> stockRcdList = new ArrayList<>();
                    if(whCommandSku.getQuantity() > 0){
                        SStockRecordVO stockRecordVO = new SStockRecordVO();
                        stockRecordVO.setCommandCode(rcd.getCode());
                        stockRecordVO.setWarehouseCode(rcd.getWarehouseCode());
                        stockRecordVO.setInOutType(rcd.getInOutType());
                        stockRecordVO.setSkuCode(whCommandSku.getSkuCode());
                        stockRecordVO.setQuantity(whCommandSku.getQuantity());
                        stockRecordVO.setSubmitTime(DateUtil.getNow());
                        stockRecordVO.setSubmitUserId(EmptyUtil.isNotEmpty(rcd.getOperatorId())?Integer.parseInt(rcd.getOperatorId()+""):1);
                        stockRcdList.add(stockRecordVO);
                    }
                    if(whCommandSku.getDamagedQuantity() > 0){
                        if(EmptyUtil.isEmpty(rcd.getPhysicalWarehouseCode())){
                            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"存在残次品入库物理仓必填");
                        }
                        WhWarehouse damagedWh = whInfoService.findDefaultInDefectiveWarehouseByPhyWhCode(rcd.getPhysicalWarehouseCode());
                        if(NullUtil.isNull(damagedWh)){
                            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,String.format("[%s]默认残次品入库仓未设置",rcd.getPhysicalWarehouseCode()));
                        }
                        SStockRecordVO stockRecordVO = new SStockRecordVO();
                        stockRecordVO.setCommandCode(rcd.getCode());
                        stockRecordVO.setWarehouseCode(damagedWh.getCode());
                        stockRecordVO.setInOutType(rcd.getInOutType());
                        stockRecordVO.setSkuCode(whCommandSku.getSkuCode());
                        stockRecordVO.setQuantity(whCommandSku.getDamagedQuantity());
                        stockRecordVO.setSubmitTime(DateUtil.getNow());
                        stockRecordVO.setSubmitUserId(EmptyUtil.isNotEmpty(rcd.getOperatorId())?Integer.parseInt(rcd.getOperatorId()+""):1);
                        stockRcdList.add(stockRecordVO);
                    }
                    // 扣减物理仓库存
                    boolean phyWhStockUpdateResult = updatePhysicalStockByCond(stockRcdList,rcd);
                    if (phyWhStockUpdateResult){
                        if(EmptyUtil.isNotEmpty(stockRcdList)){
                            ServiceResp<List<SStockRecordVO>> serviceResp = sStockService.batchRecord(stockRcdList);
                            if (serviceResp.isSuccess()) {
                                rollbackRecordList.addAll(serviceResp.getBean());
                            } else {
                                throw new  WarehouseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
                            }
                        }
                    }else{
                        throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED, "更新物理仓库存失败!");
                    }

                }

                // 如果是出库指令
                else if (rcd.isOut()) {
                    // 记录SKU库存记录
                   /* WhInvRcd whInvRcd = new WhInvRcd();
                    whInvRcd.setCommandCode(rcd.getCode());
                    whInvRcd.setWarehouseCode(rcd.getWarehouseCode());
                    whInvRcd.setInOutType(rcd.getInOutType());
                    whInvRcd.setSkuCode(whCommandSku.getSkuCode());
                    // 记负数
                    whInvRcd.setQuantity((0 - whCommandSku.getQuantity()));
                    whInvService.record(whInvRcd);*/
                    SStockRecordVO stockRecordVO = new SStockRecordVO();
                    stockRecordVO.setCommandCode(rcd.getCode());
                    stockRecordVO.setWarehouseCode(rcd.getWarehouseCode());
                    stockRecordVO.setInOutType(rcd.getInOutType());
                    stockRecordVO.setSkuCode(whCommandSku.getSkuCode());
                    stockRecordVO.setQuantity(0 - whCommandSku.getQuantity());
                    stockRecordVO.setSubmitTime(DateUtil.getNow());
                    stockRecordVO.setSubmitUserId(EmptyUtil.isNotEmpty(rcd.getOperatorId())?Integer.parseInt(rcd.getOperatorId()+""):1);
                    // 扣减物理仓库存
                    boolean result = false;
                    if(stockRecordVO.getQuantity() == 0){
                        result = true;
                    }else{
                        result = updatePhysicalStockByCond(Collections.singletonList(stockRecordVO),rcd);
                    }
                    if (result){
                        ServiceResp<SStockRecordVO> serviceResp = sStockService.record(stockRecordVO);
                        if (serviceResp.isSuccess()) {
                            rollbackRecordList.add(serviceResp.getBean());
                        } else {
                            throw new  WarehouseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
                        }
                    }else{
                        throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED, "更新物理仓库存失败!");
                    }

                    SStockReleaseDTO stockReleaseDTO = new SStockReleaseDTO();
                    stockReleaseDTO.setReferenceCode(whCommandSku.getCode());
                    stockReleaseDTO.setOccupyType(SStockOccupyTypeEnum.getEnumByCode(rcd.getInOutType()));
                    stockReleaseDTO.setOperationType(SStockOperationTypeEnum.DEFAULT);
                    releaseDTOS.add(stockReleaseDTO);
                }
                rcd.setRollbackRecordList(rollbackRecordList);
            }
            //开始释放占用库存
            if (EmptyUtil.isNotEmpty(releaseDTOS)) {
                ServiceResp<List<SReleaseResultVO>> releaseServiceResp = sStockService.release(releaseDTOS);
                if (releaseServiceResp.isFailure()) {
                    throw new WarehouseException(releaseServiceResp.getRespCode(), releaseServiceResp.getRespMsg());
                }
            }
            // 处理需要回调的类型
            processAfterFinishCommand(rcd);

            return true;
        } else {
            throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                    "finishCommand failed,current status is not STATUS_IN_PROCESSING.");
        }
    }
    /**
     * 指令占用-完成
     * */
    @Transactional
    @Override
    public boolean finishCommand(WhCommand rcd){
        if (NullUtil.isNull(rcd ) || !WhCommand.STATUS_IN_PROCESSING.equals(rcd.getCommandStatus())) {
            throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED
                    ,String.format("指令当前状态[%s]",rcd.getCommandStatusStr()));
        }
        prepareWhCommandBeforeFinish(rcd);
        rcd.setCommandStatus(WhCommand.STATUS_FINISHED);
        if (rcd.isIn()){
            finishCommandInWithOccupy(rcd);
        }else if(rcd.isOut()){
            finishCommandOutWithOccupy(rcd);
        }else{
            throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                    "指令出入库类型异常");
        }
        // 处理需要回调的类型
        processAfterFinishCommand(rcd);
        return true;
    }

    private void prepareWhCommandBeforeFinish(WhCommand rcd){
        if(NullUtil.isNull(rcd.getProcessTime())){
            rcd.setProcessTime(DateUtil.getNow());
        }
        if(EmptyUtil.isEmpty(rcd.getWhCommandSkuList())) {
            rcd.setWhCommandSkuList(this.findCommandSkuByCommandCode(rcd.getCode()));
        }
        for(WhCommandSku cmdSku : rcd.getWhCommandSkuList()){
            // 如果数量为空，加载并设置 [实际数量=计划数量,残次数量=0]
            if (NullUtil.isNull(cmdSku.getQuantity())) {
                cmdSku.setQuantity(cmdSku.getPlanedQuantity());
            }
            if (NullUtil.isNull(cmdSku.getDamagedQuantity())) {
                cmdSku.setDamagedQuantity(0);
            }
        }
    }

    //指令占用-入库
    private boolean finishCommandInWithOccupy(WhCommand rcd){
        List<WhInvRcd> invRcdList = buildWhCommandInInvRcd(rcd);
        List<SStockRecordVO> stockRcdList = convertInvRcdToDto(invRcdList);
        // 扣减物理仓库存
        boolean phyWhStockUpdateResult = updatePhysicalStockByCond(stockRcdList,rcd);
        if (!phyWhStockUpdateResult){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED, "更新物理仓库存失败!");
        }
        //完成指令
        SWhCommandVO sWhCommand = convertCommandToDto(rcd);
        sWhCommand.setStockRecordList(convertInvRcdToDto(invRcdList));
        sWhCommandService.finishWhCommand(sWhCommand);
        return true;
    }

    //指令占用-出库
    private boolean finishCommandOutWithOccupy(WhCommand rcd){
        List<WhInvRcd> invRcdList = buildWhCommandOutInvRcd(rcd);
        // 扣减物理仓库存
        boolean result = false;
        for(WhInvRcd invRcd : invRcdList){
            if(invRcd.getQuantity() == 0){
                result = true;
                continue;
            }
            List<SStockRecordVO> singleList = convertInvRcdToDto(Collections.singletonList(invRcd));
            result = updatePhysicalStockByCond(singleList,rcd);
            if(!result){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED, "更新物理仓库存失败!");
            }
        }
        //完成指令
        SWhCommandVO sWhCommand = convertCommandToDto(rcd);
        sWhCommand.setStockRecordList(convertInvRcdToDto(invRcdList));
        //占用释放
        List<SStockReleaseDTO> stockReleaseList = new ArrayList<>();
        for (WhCommandSku whCommandSku : rcd.getWhCommandSkuList()) {
            SStockReleaseDTO stockReleaseDTO = new SStockReleaseDTO();
            stockReleaseDTO.setReferenceCode(whCommandSku.getCode());
            stockReleaseDTO.setOccupyType(SStockOccupyTypeEnum.getEnumByCode(rcd.getInOutType()));
            stockReleaseDTO.setOperationType(SStockOperationTypeEnum.DEFAULT);
            stockReleaseList.add(stockReleaseDTO);
        }
        sWhCommand.setStockReleaseList(stockReleaseList);
        sWhCommandService.finishWhCommand(sWhCommand);
        return true;
    }

    /**
     * 指令无占用-完成
     * */
    @Override
    @Transactional
    public boolean finishCommandWithoutOccupy(WhCommand rcd) {
        if(NullUtil.isNull(rcd)){
            throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED, "指令不存在");
        }
        if(!WhCommand.STATUS_IN_PROCESSING.equals(rcd.getCommandStatus())){
            throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                    String.format("指令状态异常[%s]",rcd.getCommandStatusStr()));
        }
        if (rcd.isIn()) {
            finishCommandInWithoutOccupy(rcd);
        }else if(rcd.isOut()){
            //当前仅支持包裹出库
            List<WhReleaseOccupationVO> releaseList = findPackageOccupyRelease(rcd);
            if(EmptyUtil.isEmpty(releaseList)){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"包裹未占用或占用已释放");
            }
            finishCommandOutWithoutOccupy(rcd,releaseList);
        }else{
            throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                    "指令出入库类型异常");
        }
        // 处理需要回调的类型
        processAfterFinishCommand(rcd);
        return true;
    }

    @Override
    @Transactional
    public boolean processCommandOutFinish(
            WhCommand command
            ,List<WhInvRcd> invRcdList
            ,List<WhReleaseOccupationVO> releaseList){
        prepareWhCommandBeforeFinish(command);
        if(!command.isOut()){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                    "指令出库类型异常");
        }
        //更新完成状态
        boolean success = updateCommandOutFinishWhDone(command.getCode());
        if(!success){
            throw new WarehouseException(WarehouseExceptionErrorCode.REPEATED_CONSUMPTION
                    ,String.format("%s指令已处理",command.getCode()));
        }
        //完成指令
        SWhCommandVO sWhCommand = convertCommandToDto(command);
        sWhCommand.setStockRecordList(convertInvRcdToDto(invRcdList));
        if(EmptyUtil.isNotEmpty(releaseList)){
            List<SStockReleaseDTO> stockReleaseList = whInvService.convertWhRelease2DTO(releaseList);
            sWhCommand.setStockReleaseList(stockReleaseList);
        }
        sWhCommandService.processCommandFinish(sWhCommand);
        return true;
    }

    private boolean updateCommandOutFinishWhDone(String commandCode){
        WhCommandOutFinish updateInfo= new WhCommandOutFinish();
        updateInfo.setWhStatus(PegasusConstants.YES);
        updateInfo.setFinishDate(DateUtil.getNow());
        WhCommandOutFinishExample example = new WhCommandOutFinishExample();
        example.createCriteria().andCommandCodeEqualTo(commandCode).andWhStatusEqualTo(PegasusConstants.NO);
        return whCommandOutFinishMapper.updateByExampleSelective(updateInfo,example) == 1;
    }

    @Override
    @Transactional
    public boolean finishCommandWithoutOccupy(WhCommand rcd, List<WhReleaseOccupationVO> releaseList) {
        if(NullUtil.isNull(rcd)){
            throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED, "指令不存在");
        }
        if(!WhCommand.STATUS_IN_PROCESSING.equals(rcd.getCommandStatus())){
            throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                    String.format("指令状态异常[%s]",rcd.getCommandStatusStr()));
        }
        rcd.setCommandStatus(WhCommand.STATUS_FINISHED);
        prepareWhCommandBeforeFinish(rcd);
        if (rcd.isIn()) {
            finishCommandInWithoutOccupy(rcd);
        }else if(rcd.isOut()){
            finishCommandOutWithoutOccupy(rcd,releaseList);
        }else{
            throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                    "指令出入库类型异常");
        }
        // 处理需要回调的类型
        processAfterFinishCommand(rcd);
        return true;
    }

    private boolean finishCommandInWithoutOccupy(WhCommand rcd){
        List<WhInvRcd> invRcdList = buildWhCommandInInvRcd(rcd);
        //增加物理仓库存
        boolean phyWhStockUpdateResult = updatePhyWhSkuStockIn(invRcdList,rcd);
        if(!phyWhStockUpdateResult){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED, "更新物理仓库存失败!");
        }
        //完成指令
        SWhCommandVO sWhCommand = convertCommandToDto(rcd);
        sWhCommand.setStockRecordList(convertInvRcdToDto(invRcdList));
        sWhCommandService.finishWhCommand(sWhCommand);
        return true;
    }


    private List<SStockRecordVO> convertInvRcdToDto(List<WhInvRcd> whInvRcdList){
        return whInvService.convertWhInv2DTO(whInvRcdList);
    }

    //入库指令出库记录
    private List<WhInvRcd> buildWhCommandInInvRcd(WhCommand rcd){
        List<WhInvRcd> invRcdList = new ArrayList<>();
        for (WhCommandSku whCommandSku : rcd.getWhCommandSkuList()) {
            // 如果数量为空，加载并设置 [实际数量=计划数量,残次数量=0]
            if (whCommandSku.getQuantity() == null) {
                whCommandSku.setQuantity(whCommandSku.getPlanedQuantity());
            }
            if (whCommandSku.getDamagedQuantity() == null) {
                whCommandSku.setDamagedQuantity(0);
            }
            // (非残次数量 + 残次数量) > 0，记录SKU库存记录)
            if(whCommandSku.getQuantity() > 0){
                WhInvRcd whInvRcd = new WhInvRcd();
                whInvRcd.setCommandCode(rcd.getCode());
                whInvRcd.setWarehouseCode(rcd.getWarehouseCode());
                whInvRcd.setInOutType(rcd.getInOutType());
                whInvRcd.setSkuCode(whCommandSku.getSkuCode());
                whInvRcd.setQuantity(whCommandSku.getQuantity());
                whInvRcd.setSubmitTime(DateUtil.getNow());
                whInvRcd.setSubmitUserId(1L);
                if(EmptyUtil.isNotEmpty(rcd.getOperatorId())){
                    whInvRcd.setSubmitUserId(rcd.getOperatorId());
                }
                invRcdList.add(whInvRcd);
            }
            if(whCommandSku.getDamagedQuantity() > 0){
                if(EmptyUtil.isEmpty(rcd.getPhysicalWarehouseCode())){
                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"存在残次品入库物理仓必填");
                }
                WhWarehouse damagedWh = whInfoService.findDefaultInDefectiveWarehouseByPhyWhCode(rcd.getPhysicalWarehouseCode());
                if(NullUtil.isNull(damagedWh)){
                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,String.format("[%s]默认残次品入库仓未设置",rcd.getPhysicalWarehouseCode()));
                }
                WhInvRcd whInvRcd = new WhInvRcd();
                whInvRcd.setCommandCode(rcd.getCode());
                whInvRcd.setWarehouseCode(damagedWh.getCode());
                whInvRcd.setInOutType(rcd.getInOutType());
                whInvRcd.setSkuCode(whCommandSku.getSkuCode());
                whInvRcd.setQuantity(whCommandSku.getDamagedQuantity());
                whInvRcd.setSubmitTime(DateUtil.getNow());
                whInvRcd.setSubmitUserId(1L);
                if(EmptyUtil.isNotEmpty(rcd.getOperatorId())){
                    whInvRcd.setSubmitUserId(rcd.getOperatorId());
                }
                invRcdList.add(whInvRcd);
            }
        }
        return invRcdList;
    }

    @Override
    @Transactional
    public boolean processAllotPackageInBound(WhAllotPackageInBoundVO altPackageInBound){
        WhCommand inCommand = findCommandByCode(altPackageInBound.getInCommandCode(),true);
        if(WhCommand.STATUS_IN_PROCESSING.equals(inCommand.getCommandStatus())
                && WhCommand.STATUS_QUALITY_PROCESSING.equals(inCommand.getCommandStatus())){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                    ,String.format("指令状态[%s]",inCommand.getCommandStatusStr()));
        }
        inCommand.setProcessTime(DateUtil.getNow());
        inCommand.setOperatorId(altPackageInBound.getOperatorId());
        if(altPackageInBound.isLastPackage()){
            //更新指令状态
            inCommand.setCommandStatus(WhCommand.STATUS_FINISHED);
            //updateCommandV2(inCommand);
        }else if(WhCommand.STATUS_IN_PROCESSING.equals(inCommand.getCommandStatus())){
            //更新指令状态
            inCommand.setCommandStatus(WhCommand.STATUS_QUALITY_PROCESSING);
            //updateCommandV2(inCommand);
        }
        List<WhCommandSku> commandSkuList = inCommand.getWhCommandSkuList();
        Map<String,Map<Integer,Integer>> inSkuQtMap = buildInBoundSkuQuantityMap(altPackageInBound.getInBoundSkuDetailList());
        List<WhInvRcd> invRcdList = new ArrayList<>();
        List<WhCommandSku> updateCmdSkuList = new ArrayList<>();
        for(WhCommandSku cmdSku : commandSkuList){
            if(NullUtil.isNull(cmdSku.getQuantity())){
                cmdSku.setQuantity(0);
            }
            if(NullUtil.isNull(cmdSku.getDamagedQuantity())){
                cmdSku.setDamagedQuantity(0);
            }
            Map<Integer,Integer> inSkuStatusQtMap = inSkuQtMap.get(cmdSku.getSkuCode());
            if(NullUtil.isNull(inSkuStatusQtMap)){
                updateCmdSkuList.add(cmdSku);//更新未收货sku数量,防止null
                continue;
            }
            Integer inQuantity = 0,inDamagedQuantity = 0;//良品及样品可能收残次
            if(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE.equals(altPackageInBound.getWhCommodityStatus())
                    || WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE.equals(altPackageInBound.getWhCommodityStatus())){
                inQuantity = inSkuStatusQtMap.get(altPackageInBound.getWhCommodityStatus());
                inDamagedQuantity = inSkuStatusQtMap.get(WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED);
            }else{
                inQuantity = inSkuStatusQtMap.get(altPackageInBound.getWhCommodityStatus());
            }
            if(NumberUtil.isNullOrZero(inQuantity) && NumberUtil.isNullOrZero(inDamagedQuantity)){
                //未收货
                continue;
            }
            if(NullUtil.isNotNull(inQuantity) && inQuantity > 0){
                cmdSku.setQuantity(cmdSku.getQuantity()+inQuantity);//增量更新
                WhInvRcd whInvRcd = new WhInvRcd();
                whInvRcd.setCommandCode(inCommand.getCode());
                whInvRcd.setWarehouseCode(inCommand.getWarehouseCode());
                whInvRcd.setInOutType(inCommand.getInOutType());
                whInvRcd.setSkuCode(cmdSku.getSkuCode());
                whInvRcd.setQuantity(inQuantity);//实际入库数
                whInvRcd.setSubmitTime(DateUtil.getNow());
                whInvRcd.setSubmitUserId(1L);
                if(EmptyUtil.isNotEmpty(inCommand.getOperatorId())){
                    whInvRcd.setSubmitUserId(inCommand.getOperatorId());
                }
                invRcdList.add(whInvRcd);
            }
            if(NullUtil.isNotNull(inDamagedQuantity) && inDamagedQuantity > 0){
                if(EmptyUtil.isEmpty(inCommand.getPhysicalWarehouseCode())){
                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                            ,"存在残次品入库物理仓必填");
                }
                WhWarehouse damagedWh = whInfoService
                        .findDefaultInDefectiveWarehouseByPhyWhCode(inCommand.getPhysicalWarehouseCode());
                if(NullUtil.isNull(damagedWh)){
                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                            ,String.format("[%s]默认残次品入库仓未设置",inCommand.getPhysicalWarehouseCode()));
                }
                cmdSku.setDamagedQuantity(cmdSku.getDamagedQuantity()+inDamagedQuantity);//增量更新
                WhInvRcd whInvRcd = new WhInvRcd();
                whInvRcd.setCommandCode(inCommand.getCode());
                whInvRcd.setWarehouseCode(damagedWh.getCode());
                whInvRcd.setInOutType(inCommand.getInOutType());
                whInvRcd.setSkuCode(cmdSku.getSkuCode());
                whInvRcd.setQuantity(inDamagedQuantity);
                whInvRcd.setSubmitTime(DateUtil.getNow());
                whInvRcd.setSubmitUserId(1L);
                if(EmptyUtil.isNotEmpty(inCommand.getOperatorId())){
                    whInvRcd.setSubmitUserId(inCommand.getOperatorId());
                }
                invRcdList.add(whInvRcd);
            }
            updateCmdSkuList.add(cmdSku);
            // 更新行
            //sWhCommandService.updateWhCommandSkuByKey(BeanUtil.buildFrom(cmdSku,SWhCommandSkuVO.class));
        }
        //增加物理仓库存
        boolean phyWhStockUpdateResult = updatePhyWhSkuStockAltInBound(altPackageInBound);
        if (!phyWhStockUpdateResult){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED, "更新物理仓库存失败!");

        }
        //更新指令
        inCommand.setWhCommandSkuList(updateCmdSkuList);
        SWhCommandVO sWhCommand = convertCommandToDto(inCommand);
        sWhCommand.setStockRecordList(convertInvRcdToDto(invRcdList));
        sWhCommandService.processAllotPackageInBound(sWhCommand);

        if(altPackageInBound.isLastPackage()){
            // 调拨入，需要设置调拨状态为完成
            try{
                whAllotService.updateAllotRcdStatusByCode(inCommand.getReferenceCode(), WhAllotRcd.STATUS_FINISHED);
            }catch (Exception e){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                        e.getMessage());
            }
        }
        return true;
    }

    private boolean updatePhyWhSkuStockAltInBound(WhAllotPackageInBoundVO altPackageInBound){
        if(EmptyUtil.isEmpty(altPackageInBound.getInBoundSkuDetailList())){
            return true;
        }
        List<WhWmsSkuStockRecord> skuStockRecordList = new ArrayList<>();
        for(WhAllotPackageInBoundSkuDetailVO inBoundSkuDetail : altPackageInBound.getInBoundSkuDetailList()){
            if(inBoundSkuDetail.getQuantity() == 0){
                continue;
            }
            WhWmsHouseShelvesVO houseShelves =findPhyWhShelves(altPackageInBound.getPhysicalWarehouseCode()
                    ,inBoundSkuDetail.getSkuStatus());
            WhWmsSkuStockRecord stockRecord = BeanUtil.buildFrom(inBoundSkuDetail,WhWmsSkuStockRecord.class);
            stockRecord.setPhysicalWarehouseCode(houseShelves.getPhysicalWarehouseCode());
            stockRecord.setHouseType(houseShelves.getHouseType());
            stockRecord.setShelvesCode(houseShelves.getCode());
            stockRecord.setInOutType(WhCommand.TYPE_ALLOT_IN);
            stockRecord.setQuantity(inBoundSkuDetail.getQuantity());
            stockRecord.setReceiptNo(altPackageInBound.getAllotCode());
            stockRecord.setMemo(null);
            stockRecord.setIsUpdateScm(2);
            stockRecord.setCreateUserId(altPackageInBound.getOperatorId());
            skuStockRecordList.add(stockRecord);
        }
        whWmsSkuStockService.batchUpdateWhSkuStock(skuStockRecordList);
        return true;
    }

    private Map<String,Map<Integer,Integer>> buildInBoundSkuQuantityMap(List<WhAllotPackageInBoundSkuDetailVO> inBoundSkuDetailList){
        Map<String,Map<Integer,Integer>> inSkuQtMap = new HashMap<>();//入库sku汇总

        if(EmptyUtil.isNotEmpty(inBoundSkuDetailList)){
            for(WhAllotPackageInBoundSkuDetailVO inBoundSkuDetail : inBoundSkuDetailList){
                //按入库商品状态汇总
                if(inBoundSkuDetail.getQuantity() == 0){
                    continue;
                }
                Map<Integer,Integer> skuStatusQtMap = inSkuQtMap.get(inBoundSkuDetail.getSkuCode());
                if(NullUtil.isNull(skuStatusQtMap)){
                    skuStatusQtMap = new HashMap<>();
                    inSkuQtMap.put(inBoundSkuDetail.getSkuCode(),skuStatusQtMap);
                }
                Integer total = skuStatusQtMap.get(inBoundSkuDetail.getSkuStatus());
                if(NullUtil.isNull(total)){
                    total = 0;
                }
                skuStatusQtMap.put(inBoundSkuDetail.getSkuStatus(),total + inBoundSkuDetail.getQuantity());
            }
        }
        return inSkuQtMap;
    }


    private boolean finishCommandOutWithoutOccupy(WhCommand rcd,List<WhReleaseOccupationVO> releaseList){
        if (EmptyUtil.isEmpty(rcd.getWhCommandSkuList())) {
            rcd.setWhCommandSkuList(this.findCommandSkuByCommandCode(rcd.getCode()));
        }
        List<WhInvRcd> invRcdList = buildWhCommandOutInvRcd(rcd);
        boolean phyWhStockUpdateResult = updatePhyWhSkuStockOut(invRcdList,rcd);
        if(!phyWhStockUpdateResult){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED, "更新物理仓库存失败!");
        }
        //完成指令
        SWhCommandVO sWhCommand = convertCommandToDto(rcd);
        sWhCommand.setStockRecordList(convertInvRcdToDto(invRcdList));
        if(EmptyUtil.isNotEmpty(releaseList)){
            List<SStockReleaseDTO> stockReleaseList = whInvService.convertWhRelease2DTO(releaseList);
            sWhCommand.setStockReleaseList(stockReleaseList);
        }
        sWhCommandService.finishWhCommand(sWhCommand);
        return true;
    }

    private List<WhInvRcd> buildWhCommandOutInvRcd(WhCommand rcd){
        List<WhInvRcd> invRcdList = new ArrayList<>();
        for (WhCommandSku whCommandSku : rcd.getWhCommandSkuList()) {
            // 如果数量为空，加载并设置 [实际数量=计划数量,残次数量=0]
            if (whCommandSku.getQuantity() == null) {
                whCommandSku.setQuantity(whCommandSku.getPlanedQuantity());
            }
            if (whCommandSku.getDamagedQuantity() == null) {
                whCommandSku.setDamagedQuantity(0);
            }
            WhInvRcd whInvRcd = new WhInvRcd();
            whInvRcd.setCommandCode(rcd.getCode());
            whInvRcd.setWarehouseCode(rcd.getWarehouseCode());
            whInvRcd.setInOutType(rcd.getInOutType());
            whInvRcd.setSkuCode(whCommandSku.getSkuCode());
            whInvRcd.setSkuCode(whCommandSku.getSkuCode());
            whInvRcd.setQuantity(0 - whCommandSku.getQuantity());
            whInvRcd.setSubmitTime(DateUtil.getNow());
            whInvRcd.setSubmitUserId(1L);
            if(EmptyUtil.isNotEmpty(rcd.getOperatorId())){
                whInvRcd.setSubmitUserId(rcd.getOperatorId());
            }
            invRcdList.add(whInvRcd);
        }
        return invRcdList;
    }


    private boolean updatePhysicalStockByCond(List<SStockRecordVO> stockRecordList, WhCommand rcd){
        if(EmptyUtil.isEmpty(rcd.getPhysicalWarehouseCode()) || EmptyUtil.isEmpty(stockRecordList)){
            return true;
        }
        if(rcd.isIn()){
            return updatePhyWhSkuStockInBySStock(stockRecordList,rcd);
        }else if(rcd.isOut()){
            return updatePhyWhSkuStockOutBySStock(stockRecordList,rcd);
        }else{
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"指令出入库类型异常");
        }
    }

    private boolean updatePhyWhSkuStockInBySStock(List<SStockRecordVO> skuStockRcdList,WhCommand cmd){
        if(EmptyUtil.isEmpty(cmd.getPhysicalWarehouseCode()) || EmptyUtil.isEmpty(skuStockRcdList)){
            return true;
        }
        List<WhWmsConnectAllotPackageDetailVO> skuAllotDetailList = new ArrayList<>();
        if(WhCommand.TYPE_ALLOT_IN.equals(cmd.getInOutType())){
            //仓库出特别处理
            WhConnectAltPackageCond cond = new WhConnectAltPackageCond();
            cond.setAllotRcdCode(cmd.getReferenceCode());
            cond.setFetch(true);
            List<WhWmsConnectAllotPackageVO> allotPackageList = whWmsConnectAllotPackageService.findConnectAltPackageList(cond);
            if(EmptyUtil.isNotEmpty(allotPackageList)){
                for(WhWmsConnectAllotPackageVO allotPackage : allotPackageList){
                    if(EmptyUtil.isNotEmpty(allotPackage.getDetails())){
                        skuAllotDetailList.addAll(allotPackage.getDetails());
                    }
                }
            }
        }
        List<WhWmsSkuStockRecord> phyWhRcdList = buildPhyWhRcdInBySStock(skuStockRcdList,cmd,skuAllotDetailList);
        updatePhyWhSkuStock(phyWhRcdList);
        return true;
    }

    private boolean updatePhyWhSkuStockIn(List<WhInvRcd> invRcdList,WhCommand cmd){
        if(EmptyUtil.isEmpty(cmd.getPhysicalWarehouseCode()) || EmptyUtil.isEmpty(invRcdList)){
            return true;
        }
        List<WhWmsConnectAllotPackageDetailVO> skuAllotDetailList = new ArrayList<>();
        if(WhCommand.TYPE_ALLOT_IN.equals(cmd.getInOutType())){
            //仓库出特别处理
            WhConnectAltPackageCond cond = new WhConnectAltPackageCond();
            cond.setAllotRcdCode(cmd.getReferenceCode());
            cond.setFetch(true);
            List<WhWmsConnectAllotPackageVO> allotPackageList = whWmsConnectAllotPackageService.findConnectAltPackageList(cond);
            if(EmptyUtil.isNotEmpty(allotPackageList)){
                for(WhWmsConnectAllotPackageVO allotPackage : allotPackageList){
                    if(EmptyUtil.isNotEmpty(allotPackage.getDetails())){
                        skuAllotDetailList.addAll(allotPackage.getDetails());
                    }
                }
            }
        }
        List<WhWmsSkuStockRecord> phyWhRcdList = buildPhyWhRcdIn(invRcdList,cmd,skuAllotDetailList);
        updatePhyWhSkuStock(phyWhRcdList);
        return true;
    }

    private boolean updatePhyWhSkuStockOut(List<WhInvRcd> invRcdList,WhCommand cmd){
        if(EmptyUtil.isEmpty(cmd.getPhysicalWarehouseCode()) || EmptyUtil.isEmpty(invRcdList)){
            return true;
        }
        WhPhysicalWarehouse physicalWarehouse = whInfoService.findPhysicalWarehouseByCode(cmd.getPhysicalWarehouseCode());
        if (EmptyUtil.isEmpty(physicalWarehouse)){
            throw new WarehouseException(WarehouseExceptionErrorCode.WAREHOUSE_NOT_FIND, "["+cmd.getPhysicalWarehouseCode()+"]物理仓不存在!");
        }
        if (WhPhysicalWarehouseVO.WAREHOUSE_TYPE_WH_WMS.equals(physicalWarehouse.getWarehouseType())){
            return true;
        }
        for(WhInvRcd skuStockRcd : invRcdList){
            if(skuStockRcd.getQuantity() == 0){
                continue;
            }
            WhWarehouse whWarehouse = whWarehouseMapper.findWarehouseByCode(skuStockRcd.getWarehouseCode());
            if (EmptyUtil.isEmpty(whWarehouse)){
                throw new WarehouseException(WarehouseExceptionErrorCode.WAREHOUSE_NOT_FIND, "["+cmd.getWarehouseCode()+"]逻辑仓不存在!");
            }
            if(NullUtil.isNull(skuStockRcd.getSubmitUserId())){
                skuStockRcd.setSubmitUserId(1L);
            }
            int skuStatus = getSkuStatusByWarehouseType(whWarehouse.getCommodityStatus());
            whWmsSkuStockService.updatePhyWhSkuStock(physicalWarehouse.getCode()
                    ,skuStockRcd.getSkuCode(),skuStatus
                    ,skuStockRcd.getQuantity()
                    ,cmd.getInOutType()
                    ,cmd.getReferenceCode(),skuStockRcd.getSubmitUserId()
                    ,null);
        }
        return true;
    }


    //仓库调拨入库
    private List<WhWmsSkuStockRecord> buildPhyWhRcdIn(List<WhInvRcd> skuStockRcdList,WhCommand cmd,List<WhWmsConnectAllotPackageDetailVO> skuAllotDetailList){
        WhPhysicalWarehouse physicalWarehouse = whInfoService.findPhysicalWarehouseByCode(cmd.getPhysicalWarehouseCode());
        if (EmptyUtil.isEmpty(physicalWarehouse)){
            throw new WarehouseException(WarehouseExceptionErrorCode.WAREHOUSE_NOT_FIND, "["+cmd.getPhysicalWarehouseCode()+"]物理仓不存在!");
        }
        if (WhPhysicalWarehouseVO.WAREHOUSE_TYPE_WH_WMS.equals(physicalWarehouse.getWarehouseType())){
            return Collections.emptyList();
        }
        sortSkuAllotDetail(skuAllotDetailList);//排序
        Map<String,List<WhWmsConnectAllotPackageDetailVO>> skuAllotMap = groupBySku(skuAllotDetailList);
        List<WhWmsSkuStockRecord> phyWhSkuStockRcdList = new ArrayList<>();
        for(WhInvRcd skuStockRcd : skuStockRcdList){
            WhWarehouse whWarehouse = whWarehouseMapper.findWarehouseByCode(skuStockRcd.getWarehouseCode());
            if (EmptyUtil.isEmpty(whWarehouse)){
                throw new WarehouseException(WarehouseExceptionErrorCode.WAREHOUSE_NOT_FIND, "["+cmd.getWarehouseCode()+"]逻辑仓不存在!");
            }
            int skuStatus = getSkuStatusByWarehouseType(whWarehouse.getCommodityStatus());
            WhWmsHouseShelvesVO houseShelves =findPhyWhShelves(cmd.getPhysicalWarehouseCode(),skuStatus);
            int needQuantity = skuStockRcd.getQuantity();
            List<WhWmsConnectAllotPackageDetailVO> tmpSkuAllotDetailList = skuAllotMap.get(skuStockRcd.getSkuCode());
            if(EmptyUtil.isNotEmpty(tmpSkuAllotDetailList)){
                for(WhWmsConnectAllotPackageDetailVO packageDetail : tmpSkuAllotDetailList){
                    if(packageDetail.getQuantity() == 0){
                        continue;
                    }
                    int canuseQuantity = Math.min(needQuantity,packageDetail.getQuantity());
                    needQuantity -= canuseQuantity;
                    packageDetail.setQuantity(packageDetail.getQuantity()-canuseQuantity);
                    WhWmsSkuStockRecordVO record = buildWmsSkuStockRecord(houseShelves,skuStockRcd
                            ,packageDetail.getBarCode(),skuStatus,canuseQuantity);
                    phyWhSkuStockRcdList.add(record);
                    if(needQuantity == 0){
                        break;
                    }
                }
            }else{
                WhWmsSkuStockRecordVO record = buildWmsSkuStockRecord(houseShelves,skuStockRcd
                        ,skuStockRcd.getSkuCode()+"_0000",skuStatus,needQuantity);
                phyWhSkuStockRcdList.add(record);
            }
        }
        return phyWhSkuStockRcdList;
    }

    private Map<String,List<WhWmsConnectAllotPackageDetailVO>> groupBySku(List<WhWmsConnectAllotPackageDetailVO> skuAllotDetailList){
        Map<String,List<WhWmsConnectAllotPackageDetailVO>> map = new HashMap<>();
        if(EmptyUtil.isNotEmpty(skuAllotDetailList)){
            for(WhWmsConnectAllotPackageDetailVO skuPackageDetail : skuAllotDetailList){
                List<WhWmsConnectAllotPackageDetailVO> tmpList = map.get(skuPackageDetail.getSkuCode());
                if(NullUtil.isNull(tmpList)){
                    tmpList = new ArrayList<>();
                    map.put(skuPackageDetail.getSkuCode(),tmpList);
                }
                tmpList.add(skuPackageDetail);
            }
        }
        return map;
    }

    //仓库调拨入库
    private List<WhWmsSkuStockRecord> buildPhyWhRcdInBySStock(List<SStockRecordVO> skuStockRcdList,WhCommand cmd,List<WhWmsConnectAllotPackageDetailVO> skuAllotDetailList){
        WhPhysicalWarehouse physicalWarehouse = whInfoService.findPhysicalWarehouseByCode(cmd.getPhysicalWarehouseCode());
        if (EmptyUtil.isEmpty(physicalWarehouse)){
            throw new WarehouseException(WarehouseExceptionErrorCode.WAREHOUSE_NOT_FIND, "["+cmd.getPhysicalWarehouseCode()+"]物理仓不存在!");
        }
        if (WhPhysicalWarehouseVO.WAREHOUSE_TYPE_WH_WMS.equals(physicalWarehouse.getWarehouseType())){
            return Collections.emptyList();
        }
        sortSkuAllotDetail(skuAllotDetailList);//排序
        Map<String,List<WhWmsConnectAllotPackageDetailVO>> skuAllotMap = groupBySku(skuAllotDetailList);
        List<WhWmsSkuStockRecord> phyWhSkuStockRcdList = new ArrayList<>();
        for(SStockRecordVO skuStockRcd : skuStockRcdList){
            WhWarehouse whWarehouse = whWarehouseMapper.findWarehouseByCode(skuStockRcd.getWarehouseCode());
            if (EmptyUtil.isEmpty(whWarehouse)){
                throw new WarehouseException(WarehouseExceptionErrorCode.WAREHOUSE_NOT_FIND, "["+cmd.getWarehouseCode()+"]逻辑仓不存在!");
            }
            int skuStatus = getSkuStatusByWarehouseType(whWarehouse.getCommodityStatus());
            WhWmsHouseShelvesVO houseShelves =findPhyWhShelves(cmd.getPhysicalWarehouseCode(),skuStatus);
            int needQuantity = skuStockRcd.getQuantity();
            List<WhWmsConnectAllotPackageDetailVO> skuDetailList = skuAllotMap.get(skuStockRcd.getSkuCode());
            if(EmptyUtil.isNotEmpty(skuDetailList)){
                for(WhWmsConnectAllotPackageDetailVO packageDetail : skuDetailList){
                    if(packageDetail.getQuantity() == 0){
                        continue;
                    }
                    int canuseQuantity = Math.min(needQuantity,packageDetail.getQuantity());
                    needQuantity -= canuseQuantity;
                    packageDetail.setQuantity(packageDetail.getQuantity()-canuseQuantity);
                    WhWmsSkuStockRecordVO record = buildWmsSkuStockRecord(houseShelves,skuStockRcd
                            ,packageDetail.getBarCode(),skuStatus,canuseQuantity);
                    phyWhSkuStockRcdList.add(record);
                    if(needQuantity == 0){
                        break;
                    }
                }
                if(needQuantity != 0){
                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"入库数量异常");
                }
            }else{
                WhWmsSkuStockRecordVO record = buildWmsSkuStockRecord(houseShelves,skuStockRcd
                        ,skuStockRcd.getSkuCode()+"_0000",skuStatus,needQuantity);
                phyWhSkuStockRcdList.add(record);
            }
        }
        return phyWhSkuStockRcdList;
    }

    private WhWmsSkuStockRecordVO buildWmsSkuStockRecord(WhWmsHouseShelvesVO houseShelves,SStockRecordVO skuStockRcd
            ,String barcode,Integer skuStatus,Integer canUseQuantity){
        WhWmsSkuStockRecordVO record = new WhWmsSkuStockRecordVO();
        record.setQuantity(canUseQuantity);
        record.setPhysicalWarehouseCode(houseShelves.getPhysicalWarehouseCode());
        record.setHouseType(houseShelves.getHouseType());
        record.setBarCode(barcode);
        record.setShelvesCode(houseShelves.getCode());
        record.setSkuCode(skuStockRcd.getSkuCode());
        record.setSkuStatus(skuStatus);
        record.setReceiptNo(skuStockRcd.getCommandCode());
        record.setInOutType(skuStockRcd.getInOutType());
        record.setMemo("");
        if(NullUtil.isNotNull(skuStockRcd.getSubmitUserId())){
            record.setCreateUserId(skuStockRcd.getSubmitUserId().longValue());
        }else{
            record.setCreateUserId(1L);
        }
        record.setIsUpdateScm(2);
        return record;
    }

    private WhWmsSkuStockRecordVO buildWmsSkuStockRecord(WhWmsHouseShelvesVO houseShelves,WhInvRcd skuStockRcd
            ,String barcode,Integer skuStatus,Integer canUseQuantity){
        WhWmsSkuStockRecordVO record = new WhWmsSkuStockRecordVO();
        record.setQuantity(canUseQuantity);
        record.setPhysicalWarehouseCode(houseShelves.getPhysicalWarehouseCode());
        record.setHouseType(houseShelves.getHouseType());
        record.setBarCode(barcode);
        record.setShelvesCode(houseShelves.getCode());
        record.setSkuCode(skuStockRcd.getSkuCode());
        record.setSkuStatus(skuStatus);
        record.setReceiptNo(skuStockRcd.getCommandCode());
        record.setInOutType(skuStockRcd.getInOutType());
        record.setMemo("");
        if(NullUtil.isNotNull(skuStockRcd.getSubmitUserId())){
            record.setCreateUserId(skuStockRcd.getSubmitUserId().longValue());
        }else{
            record.setCreateUserId(1L);
        }
        record.setIsUpdateScm(2);
        return record;
    }

    private void sortSkuAllotDetail(List<WhWmsConnectAllotPackageDetailVO> skuAllotDetailList){
        if(EmptyUtil.isEmpty(skuAllotDetailList)){
            return;
        }
        List<String> barcodes = new ArrayList<>();
        for(WhWmsConnectAllotPackageDetailVO allotPackageDetail : skuAllotDetailList){
            barcodes.add(allotPackageDetail.getBarCode());
        }
        final Map<String,WhWmsSkuBarcodeVO> barcodeMap = getBarcodeMap(barcodes);
        Collections.sort(skuAllotDetailList, new Comparator<WhWmsConnectAllotPackageDetailVO>() {
            @Override
            public int compare(WhWmsConnectAllotPackageDetailVO o1, WhWmsConnectAllotPackageDetailVO o2) {
                WhWmsSkuBarcodeVO bc1 = barcodeMap.get(o1.getBarCode());
                WhWmsSkuBarcodeVO bc2 = barcodeMap.get(o2.getBarCode());
                return whWmsSkuBarcodeService.compareBarCode(bc1,bc2);
            }
        });
    }


    private boolean updatePhyWhSkuStockOutBySStock(List<SStockRecordVO> skuStockRcdList,WhCommand cmd){
        WhPhysicalWarehouse physicalWarehouse = whInfoService.findPhysicalWarehouseByCode(cmd.getPhysicalWarehouseCode());
        if (EmptyUtil.isEmpty(physicalWarehouse)){
            throw new WarehouseException(WarehouseExceptionErrorCode.WAREHOUSE_NOT_FIND, "["+cmd.getPhysicalWarehouseCode()+"]物理仓不存在!");
        }
        if (WhPhysicalWarehouseVO.WAREHOUSE_TYPE_WH_WMS.equals(physicalWarehouse.getWarehouseType())){
            return true;
        }
        for(SStockRecordVO skuStockRcd : skuStockRcdList){
            WhWarehouse whWarehouse = whWarehouseMapper.findWarehouseByCode(skuStockRcd.getWarehouseCode());
            if (EmptyUtil.isEmpty(whWarehouse)){
                throw new WarehouseException(WarehouseExceptionErrorCode.WAREHOUSE_NOT_FIND, "["+cmd.getWarehouseCode()+"]逻辑仓不存在!");
            }
            if(NullUtil.isNull(skuStockRcd.getSubmitUserId())){
                skuStockRcd.setSubmitUserId(1);
            }
            int skuStatus = getSkuStatusByWarehouseType(whWarehouse.getCommodityStatus());
            int needQuantity = -skuStockRcd.getQuantity();//出库是负值
            int errorCount =0;
            while(errorCount<3 && needQuantity!=0){//尝试3次
                List<WhWmsSkuStock> skuStockList = findPhyWhSkuStock(physicalWarehouse.getCode(),skuStockRcd.getSkuCode(),skuStatus);
                if(EmptyUtil.isEmpty(skuStockList)){
                    break;
                }
                sortPhyWhSkuStock(skuStockList);//排序
                for(WhWmsSkuStock skuStock : skuStockList){
                    int canUse = Math.min(needQuantity,skuStock.getAmount());
                    try{
                        whWmsSkuStockService.updateStockByCond(-canUse//出库
                                ,skuStock.getPhysicalWarehouseCode()
                                ,skuStock.getHouseType()
                                ,skuStock.getBarCode(),skuStock.getShelvesCode(),skuStock.getSkuCode(),skuStock.getSkuStatus()
                                ,skuStockRcd.getInOutType(),skuStockRcd.getCommandCode(),skuStockRcd.getSubmitUserId().longValue(),skuStockRcd.getMemo(),2);
                        needQuantity -= canUse;
                        skuStock.setAmount(skuStock.getAmount()-needQuantity);
                        if(needQuantity == 0){
                            break;
                        }
                    }catch (WarehouseException whEx){
                        errorCount++;
                        break;
                    }
                }
            }
            if(needQuantity!=0){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                        ,String.format("物理仓[%s][%s][%s]库存不足[%s]"
                        ,physicalWarehouse.getCode(),skuStockRcd.getSkuCode(),WhCommand.getSkuStatusName(skuStatus),-skuStockRcd.getQuantity()));
            }
        }
        return true;
    }

    @Transactional
    @Override
    public boolean updatePhyWhSkuStockOut(String physicalWarehouseCode,String skuCode,Integer skuStatus,Integer outAmount){
        WhPhysicalWarehouse physicalWarehouse = whInfoService.findPhysicalWarehouseByCode(physicalWarehouseCode);
        if (EmptyUtil.isEmpty(physicalWarehouse)){
            throw new WarehouseException(WarehouseExceptionErrorCode.WAREHOUSE_NOT_FIND, "["+physicalWarehouseCode+"]物理仓不存在!");
        }
        if (WhPhysicalWarehouseVO.WAREHOUSE_TYPE_WH_WMS.equals(physicalWarehouse.getWarehouseType())){
            return false;
        }
        int needQuantity = -outAmount;//出库是负值
        int errorCount =0;
        while(errorCount<3 && needQuantity!=0){//尝试3次
            List<WhWmsSkuStock> skuStockList = findPhyWhSkuStock(physicalWarehouse.getCode(),skuCode,skuStatus);
            if(EmptyUtil.isEmpty(skuStockList)){
                break;
            }
            sortPhyWhSkuStock(skuStockList);//排序
            for(WhWmsSkuStock skuStock : skuStockList){
                int canUse = Math.min(needQuantity,skuStock.getAmount());
                try{
                    whWmsSkuStockService.outSkuStockByCond(-canUse//出库
                            ,skuStock.getPhysicalWarehouseCode()
                            ,skuStock.getHouseType()
                            ,skuStock.getBarCode(),skuStock.getShelvesCode(),skuStock.getSkuCode(),skuStock.getSkuStatus());
                    needQuantity -= canUse;
                    skuStock.setAmount(skuStock.getAmount()-needQuantity);
                    if(needQuantity == 0){
                        break;
                    }
                }catch (WarehouseException whEx){
                    errorCount++;
                    break;
                }
            }
        }
        if(needQuantity!=0){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                    ,String.format("物理仓[%s][%s][%s]库存不足[%s]"
                    ,physicalWarehouse.getCode(),skuCode,WhCommand.getSkuStatusName(skuStatus),-outAmount));
        }
        return true;
    }

    @Override
    public boolean updatePhyWhSkuStockOut(String physicalWarehouseCode
            ,String skuCode,Integer skuStatus,Integer quantity
            ,Integer inOutType,String referenceCode,Long operatorId,String memo){
        if(NullUtil.isNull(operatorId)){
            operatorId = 1L;
        }
        int needQuantity = -quantity;//出库是负值
        int errorCount =0;
        while(errorCount<3 && needQuantity!=0){//尝试3次
            List<WhWmsSkuStock> skuStockList = findPhyWhSkuStock(physicalWarehouseCode,skuCode,skuStatus);
            if(EmptyUtil.isEmpty(skuStockList)){
                break;
            }
            sortPhyWhSkuStock(skuStockList);//排序
            for(WhWmsSkuStock skuStock : skuStockList){
                int canUse = Math.min(needQuantity,skuStock.getAmount());
                try{
                    whWmsSkuStockService.updateStockByCond(-canUse//出库
                            ,skuStock.getPhysicalWarehouseCode()
                            ,skuStock.getHouseType()
                            ,skuStock.getBarCode(),skuStock.getShelvesCode(),skuStock.getSkuCode(),skuStock.getSkuStatus()
                            ,inOutType,referenceCode,operatorId,memo,2);
                    needQuantity -= canUse;
                    skuStock.setAmount(skuStock.getAmount()-needQuantity);
                    if(needQuantity == 0){
                        break;
                    }
                }catch (WarehouseException whEx){
                    errorCount++;
                    break;
                }
            }
        }
        if(needQuantity!=0){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                    ,String.format("物理仓[%s][%s][%s]库存不足[%s]"
                    ,physicalWarehouseCode,skuCode,WhCommand.getSkuStatusName(skuStatus),-quantity));
        }
        return true;
    }

    private void sortPhyWhSkuStock(List<WhWmsSkuStock> skuStockList){
        if(EmptyUtil.isEmpty(skuStockList)){
            return;
        }
        List<String> barcodes = new ArrayList<>();
        for(WhWmsSkuStock skuStock : skuStockList){
            barcodes.add(skuStock.getBarCode());
        }
        final Map<String,WhWmsSkuBarcodeVO> barcodeMap = getBarcodeMap(barcodes);
        Collections.sort(skuStockList, new Comparator<WhWmsSkuStock>() {
            @Override
            public int compare(WhWmsSkuStock o1, WhWmsSkuStock o2) {
                if(o1.getBarCode().endsWith("_0000") && o2.getBarCode().endsWith("_0000")){
                    return 0;
                }else if(o1.getBarCode().endsWith("_0000")){
                    return -1;
                }else if(o2.getBarCode().endsWith("_0000")){
                    return 1;
                }else{
                    if(o1.getBarCode().endsWith("_0001") && o2.getBarCode().endsWith("_0001")){
                        return 0;
                    }else if(o1.getBarCode().endsWith("_0001")){
                        return -1;
                    }else if(o2.getBarCode().endsWith("_0001")){
                        return 1;
                    }else{
                        WhWmsSkuBarcodeVO bc1 = barcodeMap.get(o1.getBarCode());
                        WhWmsSkuBarcodeVO bc2 = barcodeMap.get(o2.getBarCode());
                        return whWmsSkuBarcodeService.compareBarCode(bc1,bc2);
                    }
                }
            }
        });

    }

    private Map<String,WhWmsSkuBarcodeVO> getBarcodeMap(List<String> barcodes){
        return whWmsSkuBarcodeService.getBarcodeMap(barcodes);
    }

    private List<WhWmsSkuStock> findPhyWhSkuStock(String physicalWarehouseCode,String skuCode,Integer skuStatus){
        WhWmsSkuStockVO stockCond = new WhWmsSkuStockVO();
        stockCond.setPhysicalWarehouseCode(physicalWarehouseCode);
        stockCond.setSkuCode(skuCode);
        stockCond.setSkuStatus(skuStatus);
        List<WhWmsSkuStock> skuStockList = whWmsSkuStockService.getStockByCond(stockCond);
        if(EmptyUtil.isNotEmpty(skuStockList)){//过滤数量不足0
           Iterator<WhWmsSkuStock> iterator = skuStockList.iterator();
            while (iterator.hasNext()){
                WhWmsSkuStock skuStock = iterator.next();
                if(skuStock.getAmount() <= 0){
                    iterator.remove();
                }
            }
        }
        return skuStockList;
    }

    private WhWmsHouseShelvesVO findPhyWhShelves(String physicalWarehouseCode,Integer skuStatus){
        WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
        cond.setPhysicalWarehouseCode(physicalWarehouseCode);
        cond.setSkuStatus(skuStatus);
        List<WhWmsHouseShelvesVO> whWmsHouseShelvesVOs = whWmsHouseShelvesService.getHouseShelvesByCond(cond);
        if (CollectionUtils.isEmpty(whWmsHouseShelvesVOs)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                    "物理仓["+cond.getPhysicalWarehouseCode()+"],SKU状态["+WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(cond.getSkuStatus())+"]"+",库位不存在!");
        }
        if (whWmsHouseShelvesVOs.size()>1){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                    "物理仓["+cond.getPhysicalWarehouseCode()+"],SKU状态["+WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(cond.getSkuStatus())+"]"+",查询有多个库位!");
        }
        return whWmsHouseShelvesVOs.get(0);
    }

    private boolean _updatePhysicalStockByCond(SStockRecordVO stockRecordVO,WhCommand rcd) {
        if(EmptyUtil.isEmpty(rcd.getPhysicalWarehouseCode())){
            return true;
        }
        WhWmsSkuStockVO record = new WhWmsSkuStockVO();
        record.setWarehouseCode(stockRecordVO.getWarehouseCode());
        record.setSkuCode(stockRecordVO.getSkuCode());
        record.setAmount(stockRecordVO.getQuantity());
        record.setInOutType(stockRecordVO.getInOutType());
        record.setReceiptNo(stockRecordVO.getCommandCode());
        WhWarehouse whWarehouse = whWarehouseMapper.findWarehouseByCode(record.getWarehouseCode());
        if (EmptyUtil.isEmpty(whWarehouse)){
            throw new WarehouseException(WarehouseExceptionErrorCode.WAREHOUSE_NOT_FIND, "["+record.getWarehouseCode()+"]逻辑仓不存在!");
        }
        WhPhysicalWarehouse physicalWarehouse = whInfoService.findPhysicalWarehouseByCode(rcd.getPhysicalWarehouseCode());
        if (EmptyUtil.isEmpty(physicalWarehouse)){
            throw new WarehouseException(WarehouseExceptionErrorCode.WAREHOUSE_NOT_FIND, "["+rcd.getPhysicalWarehouseCode()+"]物理仓不存在!");
        }
        if (!WhPhysicalWarehouseVO.WAREHOUSE_TYPE_WH_WMS.equals(physicalWarehouse.getWarehouseType())){
            //int skuStatus = getSkuStatusByWarehouseType(whWarehouse.getWarehouseType());
            int skuStatus = getSkuStatusByWarehouseType(whWarehouse.getCommodityStatus());
            WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
            cond.setPhysicalWarehouseCode(physicalWarehouse.getCode());
            cond.setSkuStatus(skuStatus);
            List<WhWmsHouseShelvesVO> whWmsHouseShelvesVOs = whWmsHouseShelvesService.getHouseShelvesByCond(cond);
            if (CollectionUtils.isEmpty(whWmsHouseShelvesVOs)){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                        "物理仓["+cond.getPhysicalWarehouseCode()+"],SKU状态["+WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(cond.getSkuStatus())+"]"+",库位不存在!");
            }
            if (whWmsHouseShelvesVOs.size()>1){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                        "物理仓["+cond.getPhysicalWarehouseCode()+"],SKU状态["+WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(cond.getSkuStatus())+"]"+",查询有多个库位!");
            }
            String houseType = whWmsHouseShelvesVOs.get(0).getHouseType();
            String barcode = record.getSkuCode()+"_0001";
            String shelvesCode = whWmsHouseShelvesVOs.get(0).getCode();
            String skuCode = record.getSkuCode();
            String memo = "";
            Integer isUpdateScm = 2;
            Long operatorId=1L;
            if (EmptyUtil.isNotEmpty(rcd.getOperatorId())){
                operatorId = rcd.getOperatorId();
            }
            return whWmsSkuStockService.updateStockByCond(record.getAmount(),physicalWarehouse.getCode(),houseType,barcode,
                    shelvesCode,skuCode,skuStatus,record.getInOutType(),record.getReceiptNo()
                    ,operatorId,memo,isUpdateScm);
        }
        return true;
    }

    @Override
    public int getSkuStatusByWarehouseType(Integer commodityStatus){
        return WhWarehouseVO.convertSkuStatusByCommodityStatus(commodityStatus);
    }
    
    /**
     * 完成指令
     *
     * @param rcd 指令
     * @return 是否成功
     * @throws Exception 
     */
    private boolean finishCommandForPrdc(WhCommand rcd) throws Exception {
        if (rcd != null && WhCommand.STATUS_IN_PROCESSING.equals(rcd.getCommandStatus())) {
            rcd.setCommandStatus(WhCommand.STATUS_FINISHED);
            rcd.setProcessTime(rcd.getProcessTime() == null ? new Date() : rcd.getProcessTime());
            whCommandMapper.updateByPrimaryKeySelective(rcd);

            if (EmptyUtil.isEmpty(rcd.getWhCommandSkuList())) {
                rcd.setWhCommandSkuList(this.findCommandSkuByCommandCode(rcd.getCode()));
            }

            WhWarehouse whWarehouse = whInfoService.findWarehouseByCode(rcd.getWarehouseCode());
            if (EmptyUtil.isEmpty(whWarehouse)){
                throw new WarehouseException(WarehouseExceptionErrorCode.WAREHOUSE_NOT_FIND, "逻辑仓不存在!");
            }
            // WhPhysicalWarehouse physicalWarehouse = whInfoService.findPhysicalWarehouseByWarehouse(whWarehouse.getCode());
            WhPhysicalWarehouse physicalWarehouse = whInfoService.findPhysicalWarehouseByCode(rcd.getPhysicalWarehouseCode());
            if (EmptyUtil.isEmpty(physicalWarehouse)){
                throw new WarehouseException(WarehouseExceptionErrorCode.WAREHOUSE_NOT_FIND, "物理仓不存在!");
            }
            boolean needUpdateWmsSkuStock = false;
            if(!WhPhysicalWarehouseVO.WAREHOUSE_TYPE_WH_WMS.equals(physicalWarehouse.getWarehouseType())){
                needUpdateWmsSkuStock = true;
            }

            Map<String,WhWarehouse> whMap = new HashMap<>();
            whMap.put(whWarehouse.getCode(),whWarehouse);
            List<WhWmsSkuStockRecord> skuStockRecordList = new ArrayList<>();
            for (WhCommandSku whCommandSku : rcd.getWhCommandSkuList()) {
                // 如果数量为空，加载并设置 [实际数量=计划数量,残次数量=0]
                if (whCommandSku.getQuantity() == null) {
                    whCommandSku.setQuantity(whCommandSku.getPlanedQuantity());
                }
                if (whCommandSku.getDamagedQuantity() == null) {
                    whCommandSku.setDamagedQuantity(0);
                }

                // 更新行
                whCommandSkuMapper.updateByPrimaryKeySelective(whCommandSku);

                // 如果是入库指令
                if (rcd.isIn()) {
                	String goodWareHouseCode = rcd.getWarehouseCode();
                	String damagedWarehouseCode = "";
                	if(whCommandSku.getDamagedQuantity() > 0){
//                        WhWarehouse damagedWarehouse = whInfoService.findUniqDamagedWarehouse(rcd.getWarehouseCode());
                        WhWarehouse damagedWarehouse =whInfoService.findDefaultInDefectiveWarehouseByPhyWhCode(rcd.getPhysicalWarehouseCode());
                    	if(NullUtil.isNull(damagedWarehouse)){
                    		throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,"残次仓不存在!");
                    	}
                        whMap.put(damagedWarehouse.getCode(),damagedWarehouse);
                    	damagedWarehouseCode = damagedWarehouse.getCode();
                    	if(damagedWarehouseCode.equals(rcd.getWarehouseCode())){//残次仓良品入良品待分配仓
//                    		WhWarehouse waitWarehouse = whInfoService.findUniqWaitForDispatchingWarehouse(rcd.getWarehouseCode());
                            WhWarehouse waitWarehouse = whInfoService.findDefaultInNondefectiveWarehouseByPhyWhCode(rcd.getPhysicalWarehouseCode());
                    		if(NullUtil.isNull(waitWarehouse)){
                        		throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,"良品待分配仓不存在!");
                        	}
                    		goodWareHouseCode = waitWarehouse.getCode();
                            whMap.put(waitWarehouse.getCode(),waitWarehouse);
                    	}
                	}
    
                    // (非残次数量,记录SKU库存记录)
                    if (whCommandSku.getQuantity() > 0) {
                        WhInvRcd whInvRcd = new WhInvRcd();
                        whInvRcd.setCommandCode(rcd.getCode());
                        whInvRcd.setWarehouseCode(goodWareHouseCode);
                        whInvRcd.setInOutType(rcd.getInOutType());
                        whInvRcd.setSkuCode(whCommandSku.getSkuCode());
                        whInvRcd.setQuantity(whCommandSku.getQuantity());
                        whInvRcd.setSubmitTime(DateUtil.getNow());
                        whInvRcd.setSubmitUserId(rcd.getOperatorId());
                        whInvService.record(whInvRcd);
                        //物理仓出入库记录
                        if(needUpdateWmsSkuStock){
                            skuStockRecordList.add(buildPhyWhSkuStockRcd(whInvRcd,whMap,physicalWarehouse));
                        }
                    }
                    
                    if (whCommandSku.getDamagedQuantity() > 0) {
                        WhInvRcd whInvRcd = new WhInvRcd();
                        whInvRcd.setCommandCode(rcd.getCode());
                        whInvRcd.setWarehouseCode(damagedWarehouseCode);
                        whInvRcd.setInOutType(rcd.getInOutType());
                        whInvRcd.setSkuCode(whCommandSku.getSkuCode());
                        whInvRcd.setQuantity(whCommandSku.getDamagedQuantity());
                        whInvRcd.setSubmitTime(DateUtil.getNow());
                        whInvRcd.setSubmitUserId(rcd.getOperatorId());
                        whInvService.record(whInvRcd);
                        //物理仓出入库记录
                        if(needUpdateWmsSkuStock){
                            skuStockRecordList.add(buildPhyWhSkuStockRcd(whInvRcd,whMap,physicalWarehouse));
                        }
                    }
                    
                }else if (rcd.isOut()) {// 如果是出库指令
                    // 记录SKU库存记录
                    WhInvRcd whInvRcd = new WhInvRcd();
                    whInvRcd.setCommandCode(rcd.getCode());
                    whInvRcd.setWarehouseCode(rcd.getWarehouseCode());
                    whInvRcd.setInOutType(rcd.getInOutType());
                    whInvRcd.setSkuCode(whCommandSku.getSkuCode());
                    // 记负数
                    whInvRcd.setQuantity((0 - whCommandSku.getQuantity()));
                    whInvRcd.setSubmitTime(DateUtil.getNow());
                    whInvRcd.setSubmitUserId(rcd.getOperatorId());
                    whInvService.record(whInvRcd);
                    //物理仓出入库记录
                    if(needUpdateWmsSkuStock){
//                        skuStockRecordList.add(buildPhyWhSkuStockRcd(whInvRcd,whMap,physicalWarehouse));
                        updatePhysicalStockForPrdcOut(whInvRcd,rcd);
                    }

                    // 释放占用
                    WhReleaseOccupationVO whReleaseOccupationVO = new WhReleaseOccupationVO();
                    whReleaseOccupationVO.setOccupyType(rcd.getInOutType());
                    whReleaseOccupationVO.setReferenceCode(whCommandSku.getCode());
                    whInvService.releaseOccupation(whReleaseOccupationVO);
                }
            }

            //更新物理仓库存
            updatePhyWhSkuStock(skuStockRecordList);


            // 处理需要回调的类型
            processAfterFinishCommand(rcd);

            return true;
        } else {
            throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                "指令状态不是待处理");
        }
    }

    private boolean updatePhysicalStockForPrdcOut(WhInvRcd whInvRcd,WhCommand cmd){
        SStockRecordVO sStockRecordVO = new SStockRecordVO();
        BeanUtils.copyProperties(whInvRcd, sStockRecordVO);
        if(NullUtil.isNotNull(whInvRcd.getTakeStockRcdId())){
            sStockRecordVO.setTakeStockRcdId(whInvRcd.getTakeStockRcdId());
        }
        if(NullUtil.isNotNull(whInvRcd.getSubmitUserId())){
            sStockRecordVO.setSubmitUserId(whInvRcd.getSubmitUserId().intValue());
        }
        return updatePhysicalStockByCond(Collections.singletonList(sStockRecordVO),cmd);
    }

    private void updatePhyWhSkuStock(List<WhWmsSkuStockRecord> skuStockRecordList){
        if(EmptyUtil.isNotEmpty(skuStockRecordList)){
            for(WhWmsSkuStockRecord skuStockRecord : skuStockRecordList){
                whWmsSkuStockService.updateStockByCond(skuStockRecord.getQuantity()
                        ,skuStockRecord.getPhysicalWarehouseCode()
                        ,skuStockRecord.getHouseType()
                        ,skuStockRecord.getBarCode(),skuStockRecord.getShelvesCode(),skuStockRecord.getSkuCode(),skuStockRecord.getSkuStatus()
                        ,skuStockRecord.getInOutType(),skuStockRecord.getReceiptNo(),skuStockRecord.getCreateUserId(),skuStockRecord.getMemo(),2);
            }
        }
    }

    private WhWmsSkuStockRecord buildPhyWhSkuStockRcd(WhInvRcd whInvRcd,Map<String,WhWarehouse> whMap,WhPhysicalWarehouse physicalWarehouse){
        WhWarehouse wh = whMap.get(whInvRcd.getWarehouseCode());
        //Integer skuStatus = getSkuStatusByWarehouseType(wh.getWarehouseType());
        Integer skuStatus = getSkuStatusByWarehouseType(wh.getCommodityStatus());
        WhWmsHouseShelvesVO shelvesVO = getWhWmsHouseShelves(physicalWarehouse.getCode(),skuStatus);

        WhWmsSkuStockRecord skuStockRecord = new WhWmsSkuStockRecord();
        skuStockRecord.setPhysicalWarehouseCode(shelvesVO.getPhysicalWarehouseCode());
        skuStockRecord.setSkuStatus(skuStatus);
        skuStockRecord.setQuantity(whInvRcd.getQuantity());
        skuStockRecord.setSkuCode(whInvRcd.getSkuCode());
        skuStockRecord.setBarCode(skuStockRecord.getSkuCode()+"_0000");
        skuStockRecord.setShelvesCode(shelvesVO.getCode());
        skuStockRecord.setHouseType(shelvesVO.getHouseType());
        skuStockRecord.setMemo("加工");
        skuStockRecord.setInOutType(whInvRcd.getInOutType());
        skuStockRecord.setReceiptNo(whInvRcd.getCommandCode());
        skuStockRecord.setCreateTime(DateUtil.getNow());
        skuStockRecord.setCreateUserId(NullUtil.isNull(whInvRcd.getSubmitUserId())?1L:whInvRcd.getSubmitUserId());
        return skuStockRecord;
    }

    private WhWmsHouseShelvesVO getWhWmsHouseShelves(String physicalWarehouseCode,Integer skuStatus){
        WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
        cond.setPhysicalWarehouseCode(physicalWarehouseCode);
        cond.setSkuStatus(skuStatus);
        List<WhWmsHouseShelvesVO> whWmsHouseShelvesList = whWmsHouseShelvesService.getHouseShelvesByCond(cond);
        if (CollectionUtils.isEmpty(whWmsHouseShelvesList)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                    "物理仓["+cond.getPhysicalWarehouseCode()+"],SKU["+cond.getSkuCode()+"],SKU状态["+ WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(cond.getSkuStatus())+"]"+",库位不存在!");
        }
        if (whWmsHouseShelvesList.size()>1){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                    "物理仓["+cond.getPhysicalWarehouseCode()+"],SKU["+cond.getSkuCode()+"],SKU状态["+WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(cond.getSkuStatus())+"]"+",查询有多个库位!");
        }
        return whWmsHouseShelvesList.get(0);
    }



    @Override
    public WhCommandSku findCommandSku(String skuCode, Long commandId) {
        WhCommandSkuExample example = new WhCommandSkuExample();
        example.createCriteria().andSkuCodeEqualTo(skuCode).andCommandIdEqualTo(commandId);
        List<WhCommandSku> commandSkuList = whCommandSkuMapper.selectByExample(example);
        if(CollectionUtils.isEmpty(commandSkuList))return null;
        return commandSkuList.get(0);
    }

    @Override
    @Transactional
    public void failureStartConnect(String cmdCode) {
        WhCommand whCommand = findCommandByCode(cmdCode, false);
        whCommand.setFailureStartConnect(whCommand.getFailureStartConnect()+1);
//        if(whCommand.getFailureStartConnect()>3){
//            //更新当前cmd为缺货状态
//            commandInProcessingToShortages(whCommand.getCode());
//        }else{
            //仅仅保存失败次数
            whCommandMapper.updateByPrimaryKey(whCommand);
//        }
    }

    @Override
    @Transactional
    public void failureStartConnect(List<String> cmdCodes) {
        whCommandMapper.failureStartConnect(cmdCodes);
    }

    @Override
    public WhCommand findCommandByReferenceCode(String referenceCode) {
        WhCommandExample example = new WhCommandExample();
        example.createCriteria().andReferenceCodeEqualTo(referenceCode);
        List<WhCommand> whCommands = whCommandMapper.selectByExample(example);
        if(CollectionUtils.isNotEmpty(whCommands)){
            if(whCommands.size()>1){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"一个相关单据号对应多条仓库指令");
            }else{
                whCommands.get(0).setWhCommandSkuList(
                        findCommandSkuByCommandId(whCommands.get(0).getId()));
                return whCommands.get(0);
            }
        }else{
            return null;
        }
    }

    @Override
    @Transactional
    public boolean commandStatusToShortages(String whCommandCode) {
        WhCommand rcd = findCommandByCode(whCommandCode, false);
        if(NullUtil.isNull(rcd)){
            throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                    "指令不存在");
        }
        if(WhCommand.STATUS_SHORTAGES.equals(rcd.getCommandStatus())){
            throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                    "指令已取消");
        }
        WhCommandExample example = new WhCommandExample();
        example.createCriteria().andIdEqualTo(rcd.getId()).andCommandStatusEqualTo(rcd.getCommandStatus());
        WhCommand update = new WhCommand();
        update.setCommandStatus(WhCommand.STATUS_SHORTAGES);
        boolean success = whCommandMapper.updateByExampleSelective(update,example) == 1;
        if(!success){
            throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                    String.format("[%s]指令状态取消失败",whCommandCode));
        }
        return true;
    }

    @Override
    @Transactional
    public boolean commandStatusToShortages(List<String> whCommandCodes) {
        List<WhCommand> rcds = findCommandByCodes(whCommandCodes, false);
        if(CollectionUtils.isEmpty(rcds)){
            throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                    "指令不存在");
        }
        for (WhCommand rcd : rcds){
            if(WhCommand.STATUS_SHORTAGES.equals(rcd.getCommandStatus())){
                throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                        "["+rcd.getCode()+"]指令已取消");
            }
        }
        for (WhCommand rcd : rcds){
            WhCommandExample example = new WhCommandExample();
            example.createCriteria().andIdEqualTo(rcd.getId()).andCommandStatusEqualTo(rcd.getCommandStatus());
            WhCommand update = new WhCommand();
            update.setCommandStatus(WhCommand.STATUS_SHORTAGES);
            boolean success = whCommandMapper.updateByExampleSelective(update,example) == 1;
            if(!success){
                throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                        String.format("[%s]指令状态取消失败",rcd.getCode()));
            }
        }
        return true;
    }

    /**
     * 指令从处理中到待拣货
     * @param whCommandCode
     * @return
     */
    @Transactional
    @Override
    public boolean commandInProcessingToPicking(String whCommandCode) {
        WhCommand rcd = findCommandByCode(whCommandCode, false);
        if (rcd != null && WhCommand.STATUS_IN_PROCESSING.equals(rcd.getCommandStatus())) {
//            rcd.setCommandStatus(WhCommand.STATUS_PICKING);
//            whCommandMapper.updateByPrimaryKeySelective(rcd);
//            return true;
            boolean reslut = whCommandMapper.updateCommandStatus(rcd.getId(),WhCommand.STATUS_IN_PROCESSING,WhCommand.STATUS_PICKING)==1;
            if(!reslut){
                throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                        String.format("指令状态异常"));
            }
            return reslut;
        } else {
            throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                    "failed,current status is not STATUS_IN_PROCESSING.");
        }
    }

    /**
     * 指令从待拣货到待分拨
     * @param whCommandCode
     * @return
     */
    @Transactional
    @Override
    public boolean commandInPickingToDistribution(String whCommandCode) {
        WhCommand rcd = findCommandByCode(whCommandCode, false);
        if (rcd != null && WhCommand.STATUS_PICKING.equals(rcd.getCommandStatus())) {
//            rcd.setCommandStatus(WhCommand.STATUS_DISTRIBUTION);
//            whCommandMapper.updateByPrimaryKeySelective(rcd);
//            return true;
            boolean reslut = whCommandMapper.updateCommandStatus(rcd.getId(),WhCommand.STATUS_PICKING,WhCommand.STATUS_DISTRIBUTION)==1;
            if(!reslut){
                throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                        String.format("指令状态异常"));
            }
            return reslut;
        } else {
            throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                    "failed,current status is not STATUS_PICKING.");
        }
    }
    
    /**
     * 指令从待拣货到待交接-调拨
     * @param whCommandCode
     * @return
     */
    @Transactional
    @Override
    public boolean commandInPickingToHandover(String whCommandCode) {
        WhCommand rcd = findCommandByCode(whCommandCode, false);
        if (rcd != null && WhCommand.STATUS_PICKING.equals(rcd.getCommandStatus())) {
//            rcd.setCommandStatus(WhCommand.STATUS_HANDOVER);
//            whCommandMapper.updateByPrimaryKeySelective(rcd);
//            return true;
            boolean reslut = whCommandMapper.updateCommandStatus(rcd.getId(),WhCommand.STATUS_PICKING,WhCommand.STATUS_HANDOVER)==1;
            if(!reslut){
                throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                        String.format("指令状态异常"));
            }
            return reslut;
        } else {
            throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                    "当前状态不是是待拣货");
        }
    }


    /**
     * 指令从待分拨到待包装
     * @param whCommandCode
     * @return
     */
    @Transactional
    @Override
    public boolean commandInDistributionToPacking(String whCommandCode) {
        WhCommand rcd = findCommandByCode(whCommandCode, false);
        if (rcd != null && WhCommand.STATUS_DISTRIBUTION.equals(rcd.getCommandStatus())) {
//            rcd.setCommandStatus(WhCommand.STATUS_PACKING);
//            whCommandMapper.updateByPrimaryKeySelective(rcd);
//            return true;
            boolean reslut = whCommandMapper.updateCommandStatus(rcd.getId(),WhCommand.STATUS_DISTRIBUTION,WhCommand.STATUS_PACKING)==1;
            if(!reslut){
                throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                        String.format("指令状态异常"));
            }
            return reslut;
        } else {
            throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                    "failed,current status is not STATUS_DISTRIBUTION.");
        }
    }

    @Override
    @Transactional
    public boolean batchUpdateCommandStatus(List<String> whCommandCodes, Integer newStatus, Integer oldStatus) {
        if(EmptyUtil.isEmpty(whCommandCodes)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"指令为空");
        }
        Set<String> codes = new HashSet<>();
        for(String code : whCommandCodes){
            codes.add(code);
        }
        int size = codes.size();
        boolean result = whCommandMapper.batchUpdateCommandStatus(Arrays.asList(codes.toArray(new String[size])),newStatus,oldStatus)==size;
        if(!result){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"指令状态异常");
        }
        return result;
    }

    @Override
    @Transactional
    public boolean batchUpdateCommandStatusAndFailure(List<String> whCommandCodes, Integer newStatus) {
        if(EmptyUtil.isEmpty(whCommandCodes)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"指令为空");
        }
        Set<String> codes = new HashSet<>();
        for(String code : whCommandCodes){
            codes.add(code);
        }
        int size = codes.size();
        boolean result = whCommandMapper.batchUpdateCommandStatusAndFailure(Arrays.asList(codes.toArray(new String[size])),newStatus)==size;
        if(!result){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"指令状态异常");
        }
        return result;
    }

    /**
     * 指令从待包装到待交接
     * @param whCommandCode
     * @return
     */
    @Transactional
    @Override
    public boolean commandInPackingToHandover(String whCommandCode) {
        WhCommand rcd = findCommandByCode(whCommandCode, false);
        if (rcd != null && WhCommand.STATUS_PACKING.equals(rcd.getCommandStatus())) {
            rcd.setCommandStatus(WhCommand.STATUS_HANDOVER);
            //whCommandMapper.updateByPrimaryKeySelective(rcd);
            //return true;
            boolean reslut = whCommandMapper.updateCommandStatus(rcd.getId(),WhCommand.STATUS_PACKING,WhCommand.STATUS_HANDOVER)==1;
            if(!reslut){
                throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                        String.format("指令状态异常"));
            }
            return reslut;
        } else {
            throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                    "failed,current status is not STATUS_PACKING.");
        }
    }

    @Transactional
    @Override
    public boolean batchCommandInPackingToHandover(List<String> whCommandCodes) {
        boolean reslut = whCommandMapper.batchUpdateCommandStatus(whCommandCodes,WhCommand.STATUS_HANDOVER,WhCommand.STATUS_PACKING)>0;
        if(!reslut){
            throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                    String.format("指令状态异常"));
        }
        return reslut;
    }

    /**
     * 指令从执行中到待交接
     * @param whCommandCode
     * @return
     */
    @Transactional
    @Override
    public boolean commandInProcessingToHandover(String whCommandCode) {
        WhCommand rcd = findCommandByCode(whCommandCode, false);
        if (rcd != null && WhCommand.STATUS_IN_PROCESSING.equals(rcd.getCommandStatus())) {
//            rcd.setCommandStatus(WhCommand.STATUS_HANDOVER);
//            whCommandMapper.updateByPrimaryKeySelective(rcd);
//            return true;
            boolean reslut = whCommandMapper.updateCommandStatus(rcd.getId(),WhCommand.STATUS_IN_PROCESSING,WhCommand.STATUS_HANDOVER)==1;
            if(!reslut){
                throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                        String.format("指令状态异常"));
            }
            return reslut;
        } else {
            throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                    "状态不是待处理.");
        }
    }

    /**
     * 指令从缺货中到处理中
     * @param whCommandCode
     * @return
     */
    @Transactional
    @Override
    public boolean commandShortagesToInProcessing(String whCommandCode) {
        WhCommand rcd = findCommandByCode(whCommandCode, false);
        if (rcd != null && WhCommand.STATUS_SHORTAGES.equals(rcd.getCommandStatus())) {
//            rcd.setCommandStatus(WhCommand.STATUS_IN_PROCESSING);
//            whCommandMapper.updateByPrimaryKeySelective(rcd);
//            return true;
            boolean reslut = whCommandMapper.updateCommandStatus(rcd.getId(),WhCommand.STATUS_SHORTAGES,WhCommand.STATUS_IN_PROCESSING)==1;
            if(!reslut){
                throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                        String.format("指令状态异常"));
            }
            return reslut;
        } else {
            throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                    "failed,current status is not STATUS_SHORTAGES.");
        }
    }

    /**
     * 指令从处理中到缺货中
     * @param whCommandCode
     * @return
     */
    @Transactional
    @Override
    public boolean commandInProcessingToShortages(String whCommandCode) {
        WhCommand rcd = findCommandByCode(whCommandCode, false);
        if (rcd != null && WhCommand.STATUS_IN_PROCESSING.equals(rcd.getCommandStatus())) {
//            rcd.setCommandStatus(WhCommand.STATUS_SHORTAGES);
//            whCommandMapper.updateByPrimaryKeySelective(rcd);
//            return true;
            boolean reslut = whCommandMapper.updateCommandStatus(rcd.getId(),WhCommand.STATUS_IN_PROCESSING,WhCommand.STATUS_SHORTAGES)==1;
            if(!reslut){
                throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                        String.format("指令状态异常"));
            }
            return reslut;
        } else {
            throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                    "failed,current status is not STATUS_IN_PROCESSING.");
        }
    }

    /**
     * 指令从待包装到缺货中
     * @param whCommandCode
     * @return
     */
    @Transactional
    @Override
    public boolean commandInPackingToShortages(String whCommandCode) {
        WhCommand rcd = findCommandByCode(whCommandCode, false);
        if (rcd != null && WhCommand.STATUS_PACKING.equals(rcd.getCommandStatus())) {
//            rcd.setCommandStatus(WhCommand.STATUS_SHORTAGES);
//            whCommandMapper.updateByPrimaryKeySelective(rcd);
//            return true;
            boolean reslut = whCommandMapper.updateCommandStatus(rcd.getId(),WhCommand.STATUS_PACKING,WhCommand.STATUS_SHORTAGES)==1;
            if(!reslut){
                throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                        String.format("指令状态异常"));
            }
            return reslut;
        } else {
            throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                    "failed,current status is not STATUS_PACKING.");
        }
    }


    @Override
    public List<WhWmsWaitOutStockVO> findWaitOutStockCommandByCond(WhWmsWaitOutStockCond cond) {
        List<WhWmsWaitOutStockVO> result = whCommandMapper.findWaitOutStockCommandByCond(cond);
        if (cond.isFetch()) {
            fullWhCommandSku(result);
        }
        return result;

    }

    @Override
    public List<WhWmsWaitOutStockVO> findWaitOutStockCommandSaleOutByCond(WhWmsWaitOutStockCond cond) {
        List<WhWmsWaitOutStockVO> result = whCommandMapper.findWaitOutStockCommandSaleOutByCond(cond);
        if (cond.isFetch()) {
            fullWhCommandSku(result);
        }
        return result;
    }

    @Override
    public List<WhWmsWaitOutStockVO> findWaitOutStockCommandAltByCond(WhWmsWaitOutStockCondAlt cond) {
        List<WhWmsWaitOutStockVO> result = whCommandMapper.findWaitOutStockCommandAltByCond(cond);
        if (cond.isFetch()) {
            fullWhCommandSku(result);
        }
        return result;

    }
    
    @Override
    public List<WhWmsWaitOutStockVO> findWaitOutStockCommandPcsRtnByCond(WhWmsWaitOutStockCondPcsRtn cond) {
        List<WhWmsWaitOutStockVO> result = whCommandMapper.findWaitOutStockCommandPcsRtnByCond(cond);
        if (cond.isFetch()) {
            fullWhCommandSku(result);
        }
        return result;

    }

    @Override
    public Pagination<WhWmsWaitOutStockVO> findWaitOutStockCommandRecWasteByCond(WhWmsWaitOutStockCondRecWaste cond) {
        Pagination<WhWmsWaitOutStockVO> page = new Pagination<>(cond.getCurrpage(),cond.getPagenum());
        int total = whCommandMapper.countWaitOutStockCommandRecWasteByCond(cond);
        page.setRecord(total);
        if(!NumberUtil.isNullOrZero(total)){
            List<WhWmsWaitOutStockVO> list = whCommandMapper.findWaitOutStockCommandRecWasteByCond(cond);
            if (cond.isFetch()) {
                fullWhCommandSku(list);
            }
            fullReceiveReason(list);
            page.setResultList(list);
        }
        return page;
    }

    private void fullReceiveReason(List<WhWmsWaitOutStockVO> list) {
        if (CollectionUtils.isNotEmpty(list)){
            List<String> refCodes = new ArrayList<>();
            for (WhWmsWaitOutStockVO stockVO : list){
                refCodes.add(stockVO.getReferenceCode());
            }
            if (refCodes.size() > 0){
                WhWmsWaitOutStockCondRecWaste cond = new WhWmsWaitOutStockCondRecWaste();
                cond.setRefCodes(refCodes);
                List<WhWmsWaitOutStockVO> waitOutStockVOs = whCommandMapper.listReceiveOrderByCond(cond);
                if (CollectionUtils.isNotEmpty(waitOutStockVOs)){
                    Map<String, String> refCodeReasonMap = new HashMap<>();
                    for (WhWmsWaitOutStockVO waitOutStockVO : waitOutStockVOs){
                        refCodeReasonMap.put(waitOutStockVO.getReferenceCode(), waitOutStockVO.getReceiveReason());
                    }
                    for (WhWmsWaitOutStockVO stockVO : list){
                        stockVO.setReceiveReason(refCodeReasonMap.get(stockVO.getReferenceCode()));
                    }
                }
            }
        }
    }

    private void fullWhCommandSku(List<WhWmsWaitOutStockVO> list){
        if (EmptyUtil.isNotEmpty(list)) {
            List<Long> whCommandIdList = new ArrayList<>();
            for (WhCommand whCommand : list) {
                whCommandIdList.add(whCommand.getId());
            }
            List<WhCommandSku> whCommandSkuList = findCommandSkuByCommandIds(whCommandIdList);
            // 组装成map
            Map<Long, List<WhCommandSku>> map = new HashMap<>();
            for (WhCommandSku whCommandSku : whCommandSkuList) {
                Long commandId = whCommandSku.getCommandId();
                List<WhCommandSku> listInMap = map.get(commandId);
                if (listInMap == null) {
                    listInMap = new ArrayList<>();
                    map.put(commandId, listInMap);
                }
                listInMap.add(whCommandSku);
            }
            // 填充
            for (WhCommand whCommand : list) {
                List<WhCommandSku> listInMap = map.get(whCommand.getId());
                whCommand.setWhCommandSkuList(listInMap);
            }
        }
    }
    
    /**
     * 根据条件查找待出库的仓库指令
     * 单品单件 top5 sku
     * @param cond
     * @return
     */
    public List<WhSkuInfoVO> findWaitOutStockCommandSkuByCond(WhWmsWaitOutStockCond cond){
    	return whCommandMapper.findWaitOutStockCommandSkuByCond(cond);
    }

    /**
     * 处理需要回调的类型
     *
     * @param rcd
     * @throws Exception 
     */
    private void processAfterFinishCommand(WhCommand rcd){
        if (rcd == null) {
            return;
        }
        Integer inOutType = rcd.getInOutType();
        String referenceCode = rcd.getReferenceCode();
        try{
            if (WhCommand.TYPE_ALLOT_OUT.equals(inOutType)) {
                if (rcd.isNoUpdateAllot()){
                    return;
                }
                // 调拨出，需要设置调拨状态为待入库
                whAllotService.updateAllotRcdStatusByCode(referenceCode,
                        WhAllotRcd.STATUS_WAIT_FOR_INBOUND);
            } else if (WhCommand.TYPE_ALLOT_IN.equals(inOutType)) {
                if (rcd.isNoUpdateAllot()){
                    return;
                }
                // 调拨入，需要设置调拨状态为完成
                whAllotService.updateAllotRcdStatusByCode(referenceCode, WhAllotRcd.STATUS_FINISHED);
            } else if (WhCommand.TYPE_PURCHASE_RETURN_OUT.equals(inOutType)){
                // 采退出库完成
                finishPurchaseRtnByWhCommand(rcd);
            }
        }catch (Exception e){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                    e.getMessage());
        }
    }

    /**
     * 填充行
     * 
     * @param result
     */
    private void fillCommandSku(List<WhCommand> result) {
        if (EmptyUtil.isNotEmpty(result)) {
            List<Long> whCommandIdList = new ArrayList<>();
            for (WhCommand whCommand : result) {
                whCommandIdList.add(whCommand.getId());
            }

            List<WhCommandSku> whCommandSkuList = findCommandSkuByCommandIds(whCommandIdList);
            // 组装成map
            Map<Long, List<WhCommandSku>> map = new HashMap<>();
            for (WhCommandSku whCommandSku : whCommandSkuList) {
                Long commandId = whCommandSku.getCommandId();
                List<WhCommandSku> listInMap = map.get(commandId);
                if (listInMap == null) {
                    listInMap = new ArrayList<>();
                    map.put(commandId, listInMap);
                }
                listInMap.add(whCommandSku);
            }

            // 填充
            for (WhCommand whCommand : result) {
                List<WhCommandSku> listInMap = map.get(whCommand.getId());
                whCommand.setWhCommandSkuList(listInMap);
            }
        }
    }

    /**
     * 退货异常SKU查询
     * @param
     */
    @Override
    public WhSalesReturnExceptionSkuVO findSalesReturnExceptionSkuByCond(WhSalesReturnExceptionSkuCond cond) {
        List<WhSalesReturnExceptionSkuVO> list = listSalesReturnExceptionSkuByCond(cond);
        if (CollectionUtils.isNotEmpty(list)){
            return list.get(0);
        }
        return null;
    }

    /**
     * 退货异常SKU列表查询
     * @param
     */
    @Override
    public List<WhSalesReturnExceptionSkuVO> listSalesReturnExceptionSkuByCond(WhSalesReturnExceptionSkuCond cond) {
        return whSalesReturnExceptionSkuCustomMapper.listWhSalesReturnExceptionSkuByCond(cond);
    }

    /**
     * 退货异常SKU列表查询
     * @param
     */
    @Override
    public List<WhSalesReturnExceptionSku> selectSalesReturnExceptionSkuByCond(WhSalesReturnExceptionSkuCond cond) {
        WhSalesReturnExceptionSkuExample example = buildSalesReturnExceptionSkuExampleByCond(cond);
        return whSalesReturnExceptionSkuMapper.selectByExample(example);
    }


    /**
     * 退货异常查询
     * @param
     */
    @Override
    public WhSalesReturnExceptionVO findSalesReturnExceptionByCond(WhSalesReturnExceptionCond cond) {
        List<WhSalesReturnExceptionVO> list = listSalesReturnExceptionByCond(cond);
        if (CollectionUtils.isNotEmpty(list)){
            WhSalesReturnExceptionVO vo = list.get(0);
            if (cond.isFetch()){
               WhSalesReturnExceptionSkuCond skuCond = new WhSalesReturnExceptionSkuCond();
               skuCond.setRefId(vo.getId());
               vo.setSalesReturnExceptionSkus(selectSalesReturnExceptionSkuByCond(skuCond));
            }
            return vo;
        }
        return null;
    }

    /**
     * 退货异常列表查询
     * @param
     */
    @Override
    public List<WhSalesReturnExceptionVO> listSalesReturnExceptionByCond(WhSalesReturnExceptionCond cond) {
        return whSalesReturnExceptionCustomMapper.listWhSalesReturnExceptionByCond(cond);
    }

    @Override
    public WhSalesReturnException selectSalesReturnExceptionById(Long id) {
        return whSalesReturnExceptionMapper.selectByPrimaryKey(id);
    }

    /**
     * 退货异常列表查询
     * @param
     */
    @Override
    public List<WhSalesReturnException> selectSalesReturnExceptionByCond(WhSalesReturnExceptionCond cond) {
        WhSalesReturnExceptionExample example = buildSalesReturnExceptionExampleByCond(cond);
        return whSalesReturnExceptionMapper.selectByExample(example);
    }


    @Override
    @Transactional
    public boolean updateSalesReturnException(WhSalesReturnExceptionVO vo) throws Exception{
        WhSalesReturnException obj = BeanUtil.buildFrom(vo,WhSalesReturnException.class);
        WhSalesReturnExceptionExample example = new WhSalesReturnExceptionExample();
        WhSalesReturnExceptionExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty(vo.getId())){
            criteria.andIdEqualTo(vo.getId());
        }else if(CollectionUtils.isNotEmpty(vo.getIds())){
            criteria.andIdIn(vo.getIds());
        }
        Long refId = obj.getId();
        // 无需更新Id
        obj.setId(null);
        boolean result = whSalesReturnExceptionMapper.updateByExampleSelective(obj,example)>0;

        // 更新sku行信息
        if (result && vo.isFetch() && CollectionUtils.isNotEmpty(vo.getSalesReturnExceptionSkus())){
            // 新增时，先删除行信息
            if (deleteSalesReturnExceptionSkuByRefId(refId)){
                List<WhSalesReturnExceptionSku> skuList = vo.getSalesReturnExceptionSkus();
                for(WhSalesReturnExceptionSku sku : skuList){
                    sku.setRefId(refId);
                }
                result = whSalesReturnExceptionSkuCustomMapper.batchInsert(skuList)>0;
            }else{
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"删除sku异常");
            }
        }
        return result;
    }

    @Override
    @Transactional
    public boolean updateSalesReturnExceptionById(WhSalesReturnExceptionVO vo) throws Exception{
        WhSalesReturnException obj = BeanUtil.buildFrom(vo,WhSalesReturnException.class);
        boolean result = whSalesReturnExceptionMapper.updateByPrimaryKeySelective(obj)>0;
        if (result && vo.isFetch() && CollectionUtils.isNotEmpty(vo.getSalesReturnExceptionSkus())){
            for (WhSalesReturnExceptionSku exceptionSku : vo.getSalesReturnExceptionSkus()){
                whSalesReturnExceptionSkuMapper.updateByPrimaryKeySelective(exceptionSku);
            }
        }
        return result;
    }

    @Override
    @Transactional
    public boolean insertSalesReturnException(WhSalesReturnExceptionVO vo) throws Exception {
        WhSalesReturnException obj = BeanUtil.buildFrom(vo,WhSalesReturnException.class);
        obj.setCreateTime(DateUtil.getNow());
        boolean result = whSalesReturnExceptionMapper.insert(obj)>0;
        if (result && vo.isFetch() && CollectionUtils.isNotEmpty(vo.getSalesReturnExceptionSkus())){
            List<WhSalesReturnExceptionSku> skuList = vo.getSalesReturnExceptionSkus();
            for (WhSalesReturnExceptionSku sku : skuList){
                sku.setRefId(obj.getId());
            }
            result = whSalesReturnExceptionSkuCustomMapper.batchInsert(skuList)>0;
        }
        vo.setId(obj.getId());
        return result;
    }

    @Transactional
    public boolean deleteSalesReturnExceptionSkuByRefId(Long refId){
        WhSalesReturnExceptionSkuExample example = new WhSalesReturnExceptionSkuExample();
        WhSalesReturnExceptionSkuExample.Criteria criteria = example.createCriteria();
        criteria.andRefIdEqualTo(refId);
        if (CollectionUtils.isNotEmpty(whSalesReturnExceptionSkuMapper.selectByExample(example))){
            return deleteSalesReturnExceptionSkuByExample(example);
        }
        return true;
    }

    @Transactional
    public boolean deleteSalesReturnExceptionSkuByExample(WhSalesReturnExceptionSkuExample example){
        return whSalesReturnExceptionSkuMapper.deleteByExample(example)>0;
    }

    @Transactional
    public boolean updateSalesReturnExceptionSkuById(WhSalesReturnExceptionSku record){
        return whSalesReturnExceptionSkuMapper.updateByPrimaryKeySelective(record)>0;
    }

    @Override
    public Integer findCountSalesReturnExceptionByCond(WhSalesReturnExceptionCond cond) {
        WhSalesReturnExceptionExample example = buildSalesReturnExceptionExampleByCond(cond);
        return whSalesReturnExceptionMapper.countByExample(example);
    }

    private WhSalesReturnExceptionSkuExample buildSalesReturnExceptionSkuExampleByCond(WhSalesReturnExceptionSkuCond cond){
        WhSalesReturnExceptionSkuExample example = new WhSalesReturnExceptionSkuExample();
        WhSalesReturnExceptionSkuExample.Criteria criteria = example.createCriteria();

        // ID
        if (EmptyUtil.isNotEmpty(cond.getId())){
            criteria.andIdEqualTo(cond.getId());
        }else if(CollectionUtils.isNotEmpty(cond.getIds())){
            criteria.andIdIn(cond.getIds());
        }

        // refId
        if (EmptyUtil.isNotEmpty(cond.getRefId())){
            criteria.andRefIdEqualTo(cond.getRefId());
        }else if(CollectionUtils.isNotEmpty(cond.getRefIds())){
            criteria.andRefIdIn(cond.getRefIds());
        }

        // sku
        if (EmptyUtil.isNotEmpty(cond.getSkuCode())){
            criteria.andSkuCodeEqualTo(cond.getSkuCode());
        }
        return example;
    }

    private WhSalesReturnExceptionExample buildSalesReturnExceptionExampleByCond(WhSalesReturnExceptionCond cond){
        WhSalesReturnExceptionExample example = new WhSalesReturnExceptionExample();
        WhSalesReturnExceptionExample.Criteria criteria = example.createCriteria();

        if (EmptyUtil.isNotEmpty(cond.getId())){
            criteria.andIdEqualTo(cond.getId());
        }

        // 快递公司
        if (EmptyUtil.isNotEmpty(cond.getExpressType())){
            criteria.andExpressTypeEqualTo(cond.getExpressType());
        }

        // 快递单号
        if (EmptyUtil.isNotEmpty(cond.getExpressNo())){
            criteria.andExpressNoEqualTo(cond.getExpressNo());
        }else if(EmptyUtil.isNotEmpty(cond.getExpressNoLike())){
            criteria.andExpressNoLike(SQLUtils.allLike(cond.getExpressNoLike()));
        }

        // 收货日期
        if (EmptyUtil.isNotEmpty(cond.getReceiveDateStart())){
            criteria.andReceiveDateGreaterThanOrEqualTo(cond.getReceiveDateStart());
        }
        if (EmptyUtil.isNotEmpty(cond.getReceiveDateEnd())){
            criteria.andReceiveDateLessThanOrEqualTo(cond.getReceiveDateEnd());
        }

        // 处理状态
        if (EmptyUtil.isNotEmpty(cond.getProcessStatus())){
            criteria.andProcessStatusEqualTo(cond.getProcessStatus());
        }else if (CollectionUtils.isNotEmpty(cond.getProcessStatusList())){
            criteria.andProcessStatusIn(cond.getProcessStatusList());
        }

        // 包裹号
        if (EmptyUtil.isNotEmpty(cond.getPackageCode())){
            criteria.andPackageCodeEqualTo(cond.getPackageCode());
        }else if(EmptyUtil.isNotEmpty(cond.getPackageCodeLike())){
            criteria.andPackageCodeLike(SQLUtils.allLike(cond.getPackageCodeLike()));
        }

        // 创建时间
        if (EmptyUtil.isNotEmpty(cond.getCreateTimeStart())){
            criteria.andCreateTimeGreaterThanOrEqualTo(cond.getCreateTimeStart());
        }
        if (EmptyUtil.isNotEmpty(cond.getCreateTimeEnd())){
            criteria.andCreateTimeLessThanOrEqualTo(cond.getCreateTimeEnd());
        }
        return example;
    }

    /**
     * 入库单列表查询
     * @param
     */
    @Override
    public List<WhReceiveShelvesVO> findReceiveShelvesByCon(WhReceiveShelvesVO vo) {
        List<Long> commandIdList = whCommandMapper.findCommandIdsReceiveShelvesByCond(vo);
        List<WhReceiveShelvesVO> rtn=new ArrayList<>();
        if(commandIdList != null && commandIdList.size() > 0){
            vo.setCommandIdList(commandIdList);
            List<WhReceiveShelvesVO> voList= whCommandMapper.findReceiveShelvesByCond(vo);
            Map<Integer,String> checkMap=new HashMap();
            Map<Integer,WhReceiveShelvesVO> voMap=new HashMap();
            //一个入库单中多个SKU汇总显示
            for(WhReceiveShelvesVO v:voList) {
                Integer key=v.getWhCommandId();
                String temp="["+v.getSkuCode()+"]"+v.getSkuName()+"<br/>";
                if(checkMap.containsKey(key)){
                    String skuInfo=checkMap.get(key)+temp;
                    checkMap.put(key,skuInfo);
                }else {
                    checkMap.put(key, temp);
                    rtn.add(v);
                }
            }
            for(WhReceiveShelvesVO v:rtn) {
                String skuDetail=checkMap.get(v.getWhCommandId());
                v.setSkuName(skuDetail);
                v.setSkuCode(skuDetail.lastIndexOf("[")>1?"more":v.getSkuCode());
            }

        }
        return rtn;
    }

    @Override
    public List<WhReceiveShelvesVO> findWaitClosePopCommandByCond(WhReceiveShelvesVO vo) {
        return whCommandMapper.findWaitClosePopCommandByCond(vo);
    }

    @Override
    public Integer findCountReceiveShelvesByCon(WhReceiveShelvesVO vo) {
        return whCommandMapper.findCountReceiveShelvesByCond(vo);
    }

    /**
     * 根据入库类型和t_wh_command_id查询入库单
     * @param whInType,whCommandId
     */
    @Override
    public List<WhReceiveShelvesVO> findReceiveShelvesDetail(Integer whInType,Integer whCommandId) {
        List<WhReceiveShelvesVO> voList=whCommandMapper.findReceiveShelvesDetail(whInType,whCommandId);
        Map<String,Integer> quantityMap=new HashMap();
        if(voList!=null) {
            List<WhWmsWaitPutawayVO> dtList=whWmsWaitPutawayService.findWmsWaitPutawayByReceiptsNo(voList.get(0).getWhCmdCode());//查询质检详情
            //按照SKU状态,分类汇总质检数量
            for(WhWmsWaitPutawayVO d:dtList) {
                String key=d.getSkuCode()+d.getSkuStatus(); //SKU_STATUS SKU状态 1良品0残次品2样品 3废品
                if(quantityMap.containsKey(key)) {
                    Integer val = parseInteger(quantityMap.get(key)) + d.getReceiveAmount();
                    quantityMap.put(key, val);
                }else{
                    quantityMap.put(key,d.getReceiveAmount());
                }
            }
            if (WhCommand.TYPE_PURCHASE_IN.equals(whInType)){
                // 获取 待定状态的残次图片
                fetchDefectiveDetail(voList, whInType,WhWarehouseVO.COMMODITY_STATUS_FOR_HOLD_PENDING);
            }
            for(WhReceiveShelvesVO v:voList) {
                int mildDamagedNum  = parseInteger(quantityMap.get(v.getSkuCode()+WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED));
                int nondefectiveNum  = parseInteger(quantityMap.get(v.getSkuCode()+WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE));
                int sampleNum  = parseInteger(quantityMap.get(v.getSkuCode()+WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE));
                int wastedNum  = parseInteger(quantityMap.get(v.getSkuCode()+WhWarehouseVO.COMMODITY_STATUS_FOR_WASTED));
                int displayNum  = parseInteger(quantityMap.get(v.getSkuCode()+WhWarehouseVO.COMMODITY_STATUS_FOR_DISPLAY));
                int propNum  = parseInteger(quantityMap.get(v.getSkuCode()+WhWarehouseVO.COMMODITY_STATUS_FOR_PROP));
                int holdPendingNum  = parseInteger(quantityMap.get(v.getSkuCode()+WhWarehouseVO.COMMODITY_STATUS_FOR_HOLD_PENDING));
                /*if(mildDamagedNum >= v.getPlanedQuantity()){
                    quantityMap.put(v.getSkuCode()+WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED,mildDamagedNum-v.getPlanedQuantity());
                    mildDamagedNum = v.getPlanedQuantity();
                    nondefectiveNum = 0;
                    sampleNum = 0;
                    wastedNum = 0;
                    displayNum = 0;
                    propNum = 0;
                }
                if(nondefectiveNum > 0 && (mildDamagedNum+nondefectiveNum) >= v.getPlanedQuantity()){
                    quantityMap.put(v.getSkuCode()+WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE,(mildDamagedNum+nondefectiveNum)-v.getPlanedQuantity());
                    nondefectiveNum = v.getPlanedQuantity() - mildDamagedNum;
                    sampleNum = 0;
                    wastedNum = 0;
                    displayNum = 0;
                    propNum = 0;
                }
                if(sampleNum > 0 && (mildDamagedNum+nondefectiveNum+sampleNum) >= v.getPlanedQuantity()){
                    quantityMap.put(v.getSkuCode()+WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE,(mildDamagedNum+nondefectiveNum+sampleNum)-v.getPlanedQuantity());
                    sampleNum = v.getPlanedQuantity() - mildDamagedNum - nondefectiveNum;
                    wastedNum = 0;
                    displayNum = 0;
                    propNum = 0;
                }
                if(wastedNum > 0 && (mildDamagedNum+nondefectiveNum+sampleNum+wastedNum) >= v.getPlanedQuantity()){
                    quantityMap.put(v.getSkuCode()+WhWarehouseVO.COMMODITY_STATUS_FOR_WASTED,(mildDamagedNum+nondefectiveNum+sampleNum+wastedNum)-v.getPlanedQuantity());
                    wastedNum = v.getPlanedQuantity() - mildDamagedNum - nondefectiveNum - sampleNum;
                    displayNum = 0;
                    propNum = 0;
                }
                if(displayNum > 0 && (mildDamagedNum+nondefectiveNum+sampleNum+wastedNum+displayNum) >= v.getPlanedQuantity()){
                    quantityMap.put(v.getSkuCode()+WhWarehouseVO.COMMODITY_STATUS_FOR_DISPLAY,(mildDamagedNum+nondefectiveNum+sampleNum+wastedNum+displayNum)-v.getPlanedQuantity());
                    displayNum = v.getPlanedQuantity() - mildDamagedNum - nondefectiveNum - sampleNum - wastedNum;
                    propNum = 0;
                }
                if(propNum > 0 && (mildDamagedNum+nondefectiveNum+sampleNum+wastedNum+displayNum + propNum) >= v.getPlanedQuantity()){
                    quantityMap.put(v.getSkuCode()+WhWarehouseVO.COMMODITY_STATUS_FOR_PROP,(mildDamagedNum+nondefectiveNum+sampleNum+wastedNum+displayNum+propNum)-v.getPlanedQuantity());
                    propNum = v.getPlanedQuantity() - mildDamagedNum - nondefectiveNum - sampleNum - wastedNum-displayNum;
                    holdPendingNum = 0;
                }
                if(holdPendingNum > 0 && (holdPendingNum+mildDamagedNum+nondefectiveNum+sampleNum+wastedNum+displayNum + propNum) >= v.getPlanedQuantity()){
                    quantityMap.put(v.getSkuCode()+WhWarehouseVO.COMMODITY_STATUS_FOR_HOLD_PENDING,(holdPendingNum+mildDamagedNum+nondefectiveNum+sampleNum+wastedNum+displayNum+propNum)-v.getPlanedQuantity());
                    holdPendingNum = v.getPlanedQuantity()- mildDamagedNum - nondefectiveNum - sampleNum - wastedNum-displayNum-propNum;
                }*/
                if (WhCommand.TYPE_PURCHASE_IN.equals(whInType)){
                    if (holdPendingNum == 0 && mildDamagedNum > 0){
                        v.setAllDefectiveQuantity(mildDamagedNum);
                    }else{
                        v.setAllDefectiveQuantity(holdPendingNum);
                    }
                }else{
                    v.setAllDefectiveQuantity(mildDamagedNum);
                }
                v.setAllNondefectiveQuantity(nondefectiveNum);
                v.setAllSampleQuantity(sampleNum);
                v.setAllWasteQuantity(wastedNum);
                v.setAllDisplayQuantity(displayNum);
                v.setAllPropQuantity(propNum);
                int allQcNum = v.getAllDefectiveQuantity()
                        +v.getAllNondefectiveQuantity()
                        +v.getAllSampleQuantity()
                        +v.getAllWasteQuantity()
                        +v.getAllDisplayQuantity()
                        +v.getAllPropQuantity();
                v.setQcDetailList(dtList);
                v.setAllQcQuantity(allQcNum);
            }
        }
        return  voList;
    }

    private void fetchDefectiveDetail(List<WhReceiveShelvesVO> voList,Integer whInType, Integer skuStatus) {
        WhReceiveShelvesVO receiveShelvesVO = voList.get(0);
        WhWmsReceiveShelvesDetailCond cond = new WhWmsReceiveShelvesDetailCond();
        cond.setRefCode(receiveShelvesVO.getReferenceCode());
        cond.setRefType(whInType);
        // cond.setSkuStatus(skuStatus);
        cond.setOriginType(WhWmsReceiveShelvesDetailVO.ORIGIN_TYPE_WMS_QC);
        List<WhWmsReceiveShelvesDetailVO> receiveShelvesDetailVOs = whWmsReceiveShelvesDetailService.listWhWmsReceiveShelvesDetailVOByCond(cond);
        Map<String,List<WhWmsReceiveShelvesDetailVO>> skuDetailImgMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(receiveShelvesDetailVOs)){
            for (WhWmsReceiveShelvesDetailVO detailVO : receiveShelvesDetailVOs){
                List<WhWmsReceiveShelvesDetailVO> receiveShelvesDetailVOs1 = skuDetailImgMap.get(detailVO.getSkuCode());
                if (CollectionUtils.isEmpty(receiveShelvesDetailVOs1)){
                    receiveShelvesDetailVOs1 = new ArrayList<>();
                    skuDetailImgMap.put(detailVO.getSkuCode(),receiveShelvesDetailVOs1);
                }
                receiveShelvesDetailVOs1.add(detailVO);
            }
            for (WhReceiveShelvesVO shelvesVO : voList){
                if (CollectionUtils.isNotEmpty(skuDetailImgMap.get(shelvesVO.getSkuCode()))){
                    shelvesVO.setReceiveShelvesDetailVOs(skuDetailImgMap.get(shelvesVO.getSkuCode()));
                }
            }
        }
    }


    public Long getSupplierIdByPurchaseReturnCode(String purchaseReturnCode){
    	return whCommandMapper.getSupplierIdByPurchaseReturnCode(purchaseReturnCode);
    }
    
    public String getOriPhyCodeByPurchaseReturnCode(String purchaseReturnCode){
    	return whCommandMapper.getOriPhyCodeByPurchaseReturnCode(purchaseReturnCode);
    }
    
    public void cancelPurchaseRtnByWhCommand(WhCommand command){
    	WmsPurchaseReturn vo = whCommandMapper.getPurchaseReturnByCode(command.getReferenceCode());
    	if(NullUtil.isNull(vo)){
    		throw new WarehouseException("采退单不存在");
    	}
    	WmsPurchaseReturn update = new WmsPurchaseReturn();
    	update.setId(vo.getId());
    	update.setReturnStatus(WmsPurchaseReturn.PURCHASE_RETURN_STATUS_WHCANCEL);
    	update.setFinishTime(DateUtil.getNow());
    	whCommandMapper.updatePurchaseRtn(update);
    	List<WmsPurchaseReturnSku> rtnSkuList = whCommandMapper.getPurchaseReturnSku(vo.getId());
    	if(EmptyUtil.isEmpty(rtnSkuList)){
    		throw new WarehouseException("采退单无行记录");
    	}
    	for(WmsPurchaseReturnSku rtnSku : rtnSkuList){
    		WmsPurchaseReturnSku updateRtnSku = new WmsPurchaseReturnSku();
    		updateRtnSku.setId(rtnSku.getId());
    		updateRtnSku.setRealityQuantity(0);
    		updateRtnSku.setRefundedGoodQuantity(0);
    		updateRtnSku.setRefundedWasteQuantity(0);
    		whCommandMapper.updatePurchaseRtnSku(updateRtnSku);
    	}
    }
    
    public WmsPurchaseReturn getPurchaseReturnByCode(String code,boolean fetch){
    	WmsPurchaseReturn vo = whCommandMapper.getPurchaseReturnByCode(code);
    	if(NullUtil.isNotNull(vo) && fetch){
    		List<WmsPurchaseReturnSku> rtnSkuList = whCommandMapper.getPurchaseReturnSku(vo.getId());
    		vo.setReturnSkuList(rtnSkuList);
    	}
    	return vo;
    }
    
    public void finishPurchaseRtnByWhCommand(WhCommand command){
    	WmsPurchaseReturn vo = whCommandMapper.getPurchaseReturnByCode(command.getReferenceCode());
    	if(NullUtil.isNull(vo)){
    		throw new WarehouseException("采退单不存在");
    	}
    	WmsPurchaseReturn update = new WmsPurchaseReturn();
    	update.setId(vo.getId());
    	update.setReturnStatus(WmsPurchaseReturn.PURCHASE_RETURN_STATUS_ALREADY_FINISH);
    	update.setFinishTime(DateUtil.getNow());
    	whCommandMapper.updatePurchaseRtn(update);
    	List<WmsPurchaseReturnSku> rtnSkuList = whCommandMapper.getPurchaseReturnSku(vo.getId());
    	if(EmptyUtil.isEmpty(rtnSkuList)){
    		throw new WarehouseException("采退单无行记录");
    	}
    	/*for(WmsPurchaseReturnSku rtnSku : rtnSkuList){
    		for(WhCommandSku commandSku : command.getWhCommandSkuList()){
    			if(rtnSku.getSkuCode().equals(commandSku.getSkuCode())){
    				WmsPurchaseReturnSku updateRtnSku = new WmsPurchaseReturnSku();
    				updateRtnSku.setId(rtnSku.getId());
    				updateRtnSku.setRealityQuantity(commandSku.getQuantity()+commandSku.getDamagedQuantity());
    				updateRtnSku.setRefundedGoodQuantity(commandSku.getQuantity());
    				updateRtnSku.setRefundedWasteQuantity(commandSku.getDamagedQuantity());
    				whCommandMapper.updatePurchaseRtnSku(updateRtnSku);
    				break;
    			}
    		}
    	}*/
        Map<String,WhCommandSku> commandSkuMap = new HashMap<>();
        for(WhCommandSku commandSku : command.getWhCommandSkuList()){
            commandSkuMap.put(commandSku.getSkuCode(),commandSku);
        }
        WhCommandSku commandSku = null;
        for(WmsPurchaseReturnSku rtnSku : rtnSkuList){
            commandSku = commandSkuMap.get(rtnSku.getSkuCode());
            if (EmptyUtil.isNotEmpty(commandSku)){
                WmsPurchaseReturnSku updateRtnSku = new WmsPurchaseReturnSku();
                updateRtnSku.setId(rtnSku.getId());
                updateRtnSku.setRealityQuantity(commandSku.getQuantity()+commandSku.getDamagedQuantity());
                // 指令良品对应采退良品
                if (WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE.equals(rtnSku.getSkuType())){
                    updateRtnSku.setRefundedGoodQuantity(commandSku.getQuantity());
                }else if(WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED.equals(rtnSku.getSkuType())){
                    // 指令残次 对应采退 残次
                    updateRtnSku.setRefundedWasteQuantity(commandSku.getDamagedQuantity());
                }else{
                    // 指令其它商品状态 保存在quantity上  对应 采退其它商品状态 保存在 refundedWasteQuantity
                    updateRtnSku.setRefundedWasteQuantity(commandSku.getQuantity());
                }
                whCommandMapper.updatePurchaseRtnSku(updateRtnSku);
            }
        }
    }

    @Override
    public String getBarCode(String skuCode, Date prodDate) {
        return getBarCode(skuCode,prodDate,null);
    }

    @Override
    public String getBarCode(String skuCode,Date prodDate,Date expirationDate){
    	WhQualityControlVO qc = new WhQualityControlVO();
    	qc.setQcSku(skuCode);
    	qc.setQcProdDate(prodDate);
        qc.setQcExpirationDate(expirationDate);
    	return getBarCode(qc);
    }

    public String getBarCodeByInOutType(WhReceiveShelvesVO vo,WhQualityControlVO qc){
        // 调拨入库、退货入库 批次生成规则修改 #5722
        if (WhCommand.TYPE_ALLOT_IN.equals(vo.getWhInType()) || WhCommand.TYPE_RETURN_IN.equals(vo.getWhInType())){
            Integer shelfLife = whWmsSkuBarcodeService.findSkuShelfLifeBySkuCode(qc.getQcSku());
            if (EmptyUtil.isEmpty(shelfLife) || shelfLife == 0){
                // 非效期商品不存在批次号则全部以默认批次0001入库
                if (EmptyUtil.isEmpty(qc.getBarCode())){
                    return createBarCodeWhenNotExists(qc.getQcSku(),qc.getQcSku()+"_0001",1,null);
                }else{
                    WhWmsSkuBarcodeVO barcodeVO = new WhWmsSkuBarcodeVO();
                    barcodeVO.setBarCode(qc.getBarCode());
                    List<WhWmsSkuBarcodeVO> barcodeVOs = whWmsSkuBarcodeService.getWmsSkuBarcodeByCond(barcodeVO);
                    if (CollectionUtils.isEmpty(barcodeVOs)){
                        throw new RuntimeException("批次号不存在!");
                    }
                    return qc.getBarCode();
                }
            }else{
                // #6854 第3条 扫描批次生成规则
                if (EmptyUtil.isNotEmpty(qc.getBarCode())){

                    // [ID1000069]海淘商品退货入库无需校验效期  直接返回_0001批次
                    String barcode = getBarcodeBySkuCrossBorderFlag(qc);
                    if (barcode != null){
                        return barcode;
                    }

                    WhWmsSkuBarcodeVO barcodeVO = new WhWmsSkuBarcodeVO();
                    barcodeVO.setProdDate(qc.getQcProdDate());
                    barcodeVO.setExpirationDate(qc.getQcExpirationDate());
                    barcodeVO.setBarCode(qc.getBarCode());
                    List<WhWmsSkuBarcodeVO> barcodeVOs = whWmsSkuBarcodeService.getWmsSkuBarcodeByCond(barcodeVO);
                    if (CollectionUtils.isEmpty(barcodeVOs)){
                        if (WhCommand.TYPE_RETURN_IN.equals(vo.getWhInType())){
                            throw new RuntimeException("扫描的批次号不存在["+qc.getBarCode()+"]!");
                        }else{
                            return getBarCode(qc);
                        }
                    }
                    return qc.getBarCode();
                }
                return getBarCode(qc);
            }
        }else{
            return getBarCode(qc);
        }
    }

    @Override
    public String getPrePrintBarCode(WhQualityControlVO qc) {
        if (WhQualityControlVO.PRINT_TYPE_OTHER.equals(qc.getWhInType())){
            // #6781 提前打印中，源业务单据类型=其它，则通过sku及时间查找批次，找到则返回，找不到则生成0001的批次
            List<String> barCodes = whWmsSkuBarcodeService.findBarCodesConditionBySkuCodeAndSortByExpiredAsc(qc.getQcSku());
            if (CollectionUtils.isEmpty(barCodes)){
                return createBarCodeWhenNotExists(qc.getQcSku(),qc.getQcSku()+"_0001",1,DateUtil.getNow());
            }else if(barCodes.size() == 1){
                return barCodes.get(0);
            }else{
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"当前SKU找到多个批次，不能打印!");
            }
        }
        return getBarCode(qc);
    }

    /**
     * 【ID1000069】 海淘且是校期商品，退货入库无需校验效期, 直接返回 _0001批次
     * @param qc
     * @return
     */
    private String getBarcodeBySkuCrossBorderFlag(WhQualityControlVO qc){
        if (WhInvRcd.TYPE_RETURN_IN.equals(qc.getWhInType())){
            WhWmsSkuBarcodeVO wmsSkuBarcodeVO = whWmsSkuBarcodeService.findSkuInfoBySkuCode(qc.getQcSku());
            if (EmptyUtil.isEmpty(wmsSkuBarcodeVO)){
                throw new RuntimeException("["+qc.getQcSku()+"],当前SKU不存在!");
            }
            if (isExpirySku(wmsSkuBarcodeVO.getShelfLife())){
                if (EmptyUtil.isNotEmpty(wmsSkuBarcodeVO.getCrossBorderFlag())
                        && wmsSkuBarcodeVO.getCrossBorderFlag() == 1){
                    return createBarCodeWhenNotExists(qc.getQcSku(),qc.getQcSku()+"_0001",1,null);
                }
            }
        }
        return null;
    }

    @Override
    public String getBarCode(WhQualityControlVO qc){
        Date expirationDate = qc.getQcExpirationDate();
        Date prodDate = qc.getQcProdDate();
        int batchNo = 2;// 创建批次 改成以2开始，0001的是默认批次
        Integer shelfLife = 0;

        // [ID1000069]海淘商品退货入库无需校验效期  直接返回_0001批次
        String barcode = getBarcodeBySkuCrossBorderFlag(qc);
        if (barcode != null){
            return barcode;
        }

        if(prodDate != null){
           shelfLife = whWmsSkuBarcodeService.findSkuShelfLifeBySkuCode(qc.getQcSku());
            // 不是手动设置，则通过生产日期及保质期  计算出 过期日期
            if(isExpirySku(shelfLife) && !qc.isManualCalculate()){
                expirationDate = DateUtil.addDay(prodDate,shelfLife);
            }
        }
        // #6478 新的 批次查询规则[sku、refCode、生产日期、过期日期]
        qc.setShelfLife(shelfLife);
        WhWmsSkuBarcodeCond cond = buildWhWmsSkuBarcodeCond(qc,expirationDate,prodDate);
        WhWmsSkuBarcode skuBarcodeVo = whWmsSkuBarcodeService.findMaxBatchNoByCond(cond);
        // 查询不到，则生成新的批次号
        if(skuBarcodeVo == null){
            // 退货入库,找不到则抛异常 #5722
            if(WhInvRcd.TYPE_RETURN_IN.equals(qc.getWhInType())){
                throw new RuntimeException("SKU["+qc.getQcSku()+"]未找到此生产日期对应的批次号");
            }
            // 入库类型为 ‘采购入库’时校验[校验规则：单个POP的当前SKU的批次数量不能超过2个]
            // 去除 单个POP只能收两个批次的限制 by #6768
            /*if (WhInvRcd.TYPE_PURCHASE_IN.equals(qc.getWhInType())){
                int batchCount = whWmsSkuBarcodeService.countBatchByReferenceCode(qc.getWhCmdCode(),qc.getQcSku(),qc.getReferenceCode());
                if (batchCount >= 2){
                    throw new RuntimeException("单个POP批次数量不能超过2个");
                }
            }*/
            skuBarcodeVo = whWmsSkuBarcodeService.findMaxBatchNo(qc.getQcSku(),null,null);
            if(skuBarcodeVo != null){
                batchNo = skuBarcodeVo.getBatchNo() + 1;
            }
        }else{
            return skuBarcodeVo.getBarCode();
        }
        // 非效期sku 生成批次时 生产截止日期为空
        if (!isExpirySku(shelfLife)){
            expirationDate = null;
            prodDate = null;
        }
        // 在生产加工入库完成时用到:即[如果 产生新批次,则需要记录所有主耗材批次信息]
        qc.setMakeNewBarcode(true);
        return createBarCode(qc,batchNo,expirationDate,prodDate);
    }

    private WhWmsSkuBarcodeCond buildWhWmsSkuBarcodeCond(WhQualityControlVO qc,Date expirationDate,Date prodDate){
        WhWmsSkuBarcodeCond cond = new WhWmsSkuBarcodeCond();
        cond.setSkuCode(qc.getQcSku());
        if (isExpirySku(qc.getShelfLife())){
            cond.setExpirationDateStr(DateUtil.format(expirationDate, "yyyy-MM-dd"));
            cond.setProdDateStr(DateUtil.format(prodDate, "yyyy-MM-dd"));
        }
        // 目前 只有采购入库、生产加工入库时才用到 refCode条件
        if (WhCommand.TYPE_PURCHASE_IN.equals(qc.getWhInType())
                || WhCommand.TYPE_PRODUCE_IN.equals(qc.getWhInType())){
            if (EmptyUtil.isNotEmpty(qc.getReferenceCode())){
                cond.setRefCode(qc.getReferenceCode().toUpperCase());
            }
        }
        if (qc.isFetchEmptyRefCode()){
            cond.setFetchEmptyRefCode(qc.isFetchEmptyRefCode());
        }
        return cond;
    }

    private boolean isExpirySku(Integer shelfLife){
        if (EmptyUtil.isNotEmpty(shelfLife) && shelfLife > 0){
            return true;
        }
        return false;
    }

    @Override
    public String createBarCodeWhenNotExists(String skuCode,String barcode,int batchNo,Date firstInDate){
        WhWmsSkuBarcodeCond cond = new WhWmsSkuBarcodeCond();
        cond.setBarCode(barcode);
        List<WhWmsSkuBarcodeVO> skuBarcodeVOs = whWmsSkuBarcodeService.findExpiryDateSkuInfo(cond);
        if (CollectionUtils.isEmpty(skuBarcodeVOs)){
            WhQualityControlVO qc = new WhQualityControlVO();
            qc.setQcSku(skuCode);
            if (EmptyUtil.isNotEmpty(firstInDate)){
                qc.setFirstInDate(firstInDate);
            }else{
                // qc.setFirstInDate(DateUtil.getCurrDateByDateStr("2018-04-16")); // 给个默认值，批次上线时间
                qc.setFirstInDate(DateUtil.getNow()); // 给个默认值
            }
            return createBarCode(qc,batchNo,null,null);
        }
        return barcode;
    }

    private String createBarCode(WhQualityControlVO qc,int batchNo,Date expirationDate,Date prodDate){
        WhWmsSkuBarcodeVO bcVO = new WhWmsSkuBarcodeVO();
        bcVO.setSkuCode(qc.getQcSku());
        bcVO.setBatchNo(batchNo);
        bcVO.setExpirationDate(expirationDate);
        bcVO.setProdDate(prodDate);
        if (EmptyUtil.isNotEmpty(qc.getReferenceCode())){
            bcVO.setRefCode(qc.getReferenceCode().toUpperCase());
        }
        bcVO.setInType(qc.getWhInType());
        if (EmptyUtil.isNotEmpty(qc.getFirstInDate())){
            bcVO.setFirstInDate(qc.getFirstInDate());
        }else{
            bcVO.setFirstInDate(DateUtil.getNow());
        }
        StringBuilder batch = new StringBuilder();
        batch.append(batchNo);
        while(batch.length() < 4){
            batch.insert(0,"0");
        }
        String barcode = bcVO.getSkuCode()+"_" + batch.toString();
        bcVO.setBarCode(barcode);
        whWmsSkuBarcodeService.create(bcVO);
        return barcode;
    }

    private boolean checkNotEmpty(Integer quantity){
        if (quantity != null && quantity > 0){
            return true;
        }
        return false;
    }
    /**
     * 质检
     * @param vo
     * @return
     */
    @Override
    @Transactional
    public boolean qualityControl(WhReceiveShelvesVO vo) {
        //仓库指令状态更新
        this.updateCommandStatusById(vo.getWhCommandId(),WhCommand.STATUS_QUALITY_PROCESSING);
        List<WhQualityControlVO>  qcVoList=vo.getQcList();
        for(WhQualityControlVO qc:qcVoList) {
            int amount = 0;
            // 良品数
            if(checkNotEmpty(qc.getNondefectiveQuantity())){
                amount += qc.getNondefectiveQuantity();
            }
            // 待定数
            if(checkNotEmpty(qc.getDefectiveQuantity())){
                amount += qc.getDefectiveQuantity();
            }
            // 样品数
            if(checkNotEmpty(qc.getSampleQuantity())){
                amount += qc.getSampleQuantity();
            }
            // 废品数
            if(checkNotEmpty(qc.getWasteQuantity())){
                amount += qc.getWasteQuantity();
            }
            // 陈列品数
            if(checkNotEmpty(qc.getDisplayQuantity())){
                amount += qc.getDisplayQuantity();
            }
            // 道具品数
            if(checkNotEmpty(qc.getPropQuantity())){
                amount += qc.getPropQuantity();
            }

            if(amount > 0){
            	String remark=qc.getRemark();
            	// 查询条件
            	qc.setWhInType(vo.getWhInType());
            	qc.setWhCmdCode(vo.getWhCmdCode());
                qc.setReferenceCode(vo.getReferenceCode());
                qc.setShelfLife(vo.getShelfLife());
                //条形码
                String barcode=getBarCodeByInOutType(vo,qc);
                qc.setBarCode(barcode);

                // 采购入库时 效期商品收货标准校验 #6768 并且不是特批收货
                if (WhCommand.TYPE_PURCHASE_IN.equals(vo.getWhInType())){
                    Integer shelfLife = whWmsSkuBarcodeService.findSkuShelfLifeBySkuCode(qc.getQcSku());
                    if (EmptyUtil.isNotEmpty(shelfLife) && shelfLife > 0){
                        // 特批收货不校验
                        if (!vo.isSpecialReceive()){
                            checkExpiryDataForBarcode(qc,vo.isSpecialReceive());
                        }
                    }
                }

                WhCommand whCommand = whCommandMapper.selectByPrimaryKey(Long.parseLong(vo.getWhCommandId().toString()));
                WhPhysicalWarehouse whPhysicalWarehouse =  whInfoService.findPhysicalWarehouseByCode(whCommand.getPhysicalWarehouseCode());
                vo.setWhCmdCode(whCommand.getCode());
                WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
                cond.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_RECEIVE);
                cond.setPhysicalWarehouseCode(whPhysicalWarehouse.getCode());
                List<WhWmsHouseShelvesVO> shelvesList = whWmsHouseShelvesService.getHouseShelvesByCond(cond);
                String shelves = null;
                if(shelvesList != null && shelvesList.size() > 0){
                    shelves = shelvesList.get(0).getCode();
                }else{
                    throw new RuntimeException("请先设置收货暂存区库位");
                }

                Long operatorId = Long.parseLong(vo.getOperatorId().toString());
                qc.setPhysicalWarehouseCode(whPhysicalWarehouse.getCode());
                qc.setOperatorId(operatorId);
                qc.setPutawayQc(true);
                // 目标逻辑仓的商品状态
                qc.setWarehouseCommodityStatus(vo.getCommodityStatus());
                if (qc.getNondefectiveQuantity() != null && qc.getNondefectiveQuantity() > 0){
                    recordWaitPutaway(vo,barcode,qc.getNondefectiveQuantity(),WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE,whPhysicalWarehouse.getCode(),qc.getQcSku(),"",qc); //质检记录
                    recordSkuStock(qc,barcode,qc.getNondefectiveQuantity(),WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE,whPhysicalWarehouse.getCode(),WhWmsWarehouseAreaVO.HOUSE_TYPE_RECEIVE,shelves,whCommand,operatorId,"",1);   //库

                    // scm 库存
                    qc.setCommodityStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
                    qc.setRemark("");
                    updateScmStock(qc,whCommand,qc.getNondefectiveQuantity());
                }
                if (WhCommand.TYPE_PURCHASE_IN.equals(vo.getWhInType())){
                    if (qc.getDefectiveQuantity() != null && qc.getDefectiveQuantity() > 0){
                        recordWaitPutaway(vo,barcode,qc.getDefectiveQuantity(),WhWarehouseVO.COMMODITY_STATUS_FOR_HOLD_PENDING,whPhysicalWarehouse.getCode(),qc.getQcSku(), remark,qc); //质检记录
                        recordSkuStock(qc,barcode,qc.getDefectiveQuantity(),WhWarehouseVO.COMMODITY_STATUS_FOR_HOLD_PENDING,whPhysicalWarehouse.getCode(),WhWmsWarehouseAreaVO.HOUSE_TYPE_RECEIVE,shelves,whCommand,operatorId,remark,1); //库存

                        // scm 库存
                        qc.setCommodityStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_HOLD_PENDING);
                        qc.setRemark(remark);
                        updateScmStock(qc,whCommand,qc.getDefectiveQuantity());
                    }
                }else{
                    if (qc.getDefectiveQuantity() != null && qc.getDefectiveQuantity() > 0){
                        recordWaitPutaway(vo,barcode,qc.getDefectiveQuantity(),WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED,whPhysicalWarehouse.getCode(),qc.getQcSku(), remark,qc); //质检记录
                        recordSkuStock(qc,barcode,qc.getDefectiveQuantity(),WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED,whPhysicalWarehouse.getCode(),WhWmsWarehouseAreaVO.HOUSE_TYPE_RECEIVE,shelves,whCommand,operatorId,remark,1); //库存

                        // scm 库存
                        qc.setCommodityStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED);
                        qc.setRemark(remark);
                        updateScmStock(qc,whCommand,qc.getDefectiveQuantity());
                    }
                }

                if (qc.getSampleQuantity() != null && qc.getSampleQuantity() > 0){
                    recordWaitPutaway(vo,barcode,qc.getSampleQuantity(),WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE,whPhysicalWarehouse.getCode(),qc.getQcSku(), remark,qc);//质检记录
                    recordSkuStock(qc,barcode,qc.getSampleQuantity(),WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE,whPhysicalWarehouse.getCode(),WhWmsWarehouseAreaVO.HOUSE_TYPE_RECEIVE,shelves,whCommand,operatorId,remark,1); //库存

                    // scm 库存
                    qc.setCommodityStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE);
                    qc.setRemark(remark);
                    updateScmStock(qc,whCommand,qc.getSampleQuantity());
                }
                if (qc.getWasteQuantity() != null && qc.getWasteQuantity() > 0){
                    recordWaitPutaway(vo,barcode,qc.getWasteQuantity(),WhWarehouseVO.COMMODITY_STATUS_FOR_WASTED,whPhysicalWarehouse.getCode(),qc.getQcSku(), remark,qc);//质检记录
                    recordSkuStock(qc,barcode,qc.getWasteQuantity(),WhWarehouseVO.COMMODITY_STATUS_FOR_WASTED,whPhysicalWarehouse.getCode(),WhWmsWarehouseAreaVO.HOUSE_TYPE_RECEIVE,shelves,whCommand,operatorId,remark,1); //库存

                    // scm 库存
                    qc.setCommodityStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_WASTED);
                    qc.setRemark(remark);
                    updateScmStock(qc,whCommand,qc.getWasteQuantity());
                }
                if (NullUtil.isNotNull(qc.getDisplayQuantity()) && qc.getDisplayQuantity() > 0){
                    recordWaitPutaway(vo,barcode,qc.getDisplayQuantity(),WhWarehouseVO.COMMODITY_STATUS_FOR_DISPLAY,whPhysicalWarehouse.getCode(),qc.getQcSku(), remark,qc);//质检记录
                    recordSkuStock(qc,barcode,qc.getDisplayQuantity(),WhWarehouseVO.COMMODITY_STATUS_FOR_DISPLAY,whPhysicalWarehouse.getCode(),WhWmsWarehouseAreaVO.HOUSE_TYPE_RECEIVE,shelves,whCommand,operatorId,remark,1); //库存

                    // scm 库存
                    qc.setCommodityStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_DISPLAY);
                    qc.setRemark(remark);
                    updateScmStock(qc,whCommand,qc.getDisplayQuantity());
                }
                if (NullUtil.isNotNull(qc.getPropQuantity()) && qc.getPropQuantity() > 0){
                    recordWaitPutaway(vo,barcode,qc.getPropQuantity(),WhWarehouseVO.COMMODITY_STATUS_FOR_PROP,whPhysicalWarehouse.getCode(),qc.getQcSku(), remark,qc);//质检记录
                    recordSkuStock(qc,barcode,qc.getPropQuantity(),WhWarehouseVO.COMMODITY_STATUS_FOR_PROP,whPhysicalWarehouse.getCode(),WhWmsWarehouseAreaVO.HOUSE_TYPE_RECEIVE,shelves,whCommand,operatorId,remark,1); //库存

                    // scm 库存
                    qc.setCommodityStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_PROP);
                    qc.setRemark(remark);
                    updateScmStock(qc,whCommand,qc.getPropQuantity());
                }

                // 记录下采用供应商编码入库的 供应商编码
                if (EmptyUtil.isNotEmpty(qc.getSupplierCode())){
                    WhWmsShelvesSkuInfo whWmsShelvesSkuInfo = whWmsShelvesSkuInfoService.getSkuInfoByCode(qc.getQcSku());
                    if (EmptyUtil.isNotEmpty(whWmsShelvesSkuInfo) && EmptyUtil.isEmpty(whWmsShelvesSkuInfo.getSupplierCode())){
                        WhWmsShelvesSkuInfo record = new WhWmsShelvesSkuInfo();
                        record.setId(whWmsShelvesSkuInfo.getId());
                        record.setSupplierCode(qc.getSupplierCode());
                        whWmsShelvesSkuInfoMapper.updateByPrimaryKeySelective(record);
                    }
                }
            }
        }
        return true;
    }

    private void checkExpiryDataForBarcode(WhQualityControlVO qc,boolean specialReceive) {
        WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
        cond.setBarCode(qc.getBarCode());
        cond.setSkuCode(qc.getQcSku());
        List<WhWmsSkuStockVO> skuStockVOs = whWmsSkuStockService.listExpiryDateSkuForCheckRule(cond);
        if (CollectionUtils.isNotEmpty(skuStockVOs)){
            WhWmsSkuStockVO skuStockVO = skuStockVOs.get(0);
            // 限定的美妆品类
            Set<Long> beautySecondCategorySet = getGlobalConfigByKey(WhWmsSkuBarcodeVO.GLOBAL_CATEGORY_BEAUTY);
            if (beautySecondCategorySet != null && beautySecondCategorySet.contains(skuStockVO.getSecondLevelCategoryID())){
                checkReceiveRuleByExpiryDate(WhWmsSkuBarcodeVO.CATEGORY_TYPE_BEAUTY,skuStockVO);
            }else{
                // 限定的蜡烛品类
                Set<Long> candleSecondCategorySet = getGlobalConfigByKey(WhWmsSkuBarcodeVO.GLOBAL_CATEGORY_CANDLE);
                if (candleSecondCategorySet != null && candleSecondCategorySet.contains(skuStockVO.getSecondLevelCategoryID())){
                    checkReceiveRuleByExpiryDate(WhWmsSkuBarcodeVO.CATEGORY_TYPE_CANDLE,skuStockVO);
                }else{
                    // 限定的食品品类
                    /*Set<Long> foodstuffSecondCategorySet = getGlobalConfigByKey(WhWmsSkuBarcodeVO.GLOBAL_CATEGORY_FOODSTUFF);
                    if (foodstuffSecondCategorySet != null && foodstuffSecondCategorySet.contains(skuStockVO.getSecondLevelCategoryID())){
                        checkReceiveRuleByExpiryDate(WhWmsSkuBarcodeVO.CATEGORY_TYPE_FOODSTUFF,skuStockVO);
                    }*/

                    // 收货标准(新逻辑+旧逻辑)，除了以上两种品类，其它品类都要校验)
                    if (!specialReceive){
                        checkReceiveRuleByExpiryDate(WhWmsSkuBarcodeVO.CATEGORY_TYPE_FOODSTUFF,skuStockVO);
                    }
                }
            }
        }
    }

    /**
     * * 通过保质期,剩余天数 校验收货规则
     * @param categoryType 品类类型：美妆、蜡烛、食品
     * @param skuStockVO
     */
    private void checkReceiveRuleByExpiryDate(String categoryType,WhWmsSkuStockVO skuStockVO) {
        String warnMsg = "商品[%s],剩余天数<[%s]天,不能质检收货!";
        int expiryDateDays = skuStockVO.getShelfLife(),surplusDays = skuStockVO.getSurplusDays();
        String skuCode = skuStockVO.getSkuCode();
        // 进口
        boolean isImported = EmptyUtil.isNotEmpty(skuStockVO.getIsImported()) && skuStockVO.getIsImported() == 1;
        if (WhWmsSkuBarcodeVO.CATEGORY_TYPE_BEAUTY.equals(categoryType) ||
                WhWmsSkuBarcodeVO.CATEGORY_TYPE_CANDLE.equals(categoryType)){
            if (expiryDateDays > 0 && expiryDateDays<1080 && surplusDays <= 540){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                        String.format(warnMsg,skuCode,"540"));
            }else if(expiryDateDays >= 1080 && expiryDateDays<1800 && surplusDays <= 720){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                        String.format(warnMsg,skuCode,"720"));
            }else if(expiryDateDays >= 1800 && surplusDays <= 1080){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                        String.format(warnMsg,skuCode,"1080"));
            }
        }else if (WhWmsSkuBarcodeVO.CATEGORY_TYPE_FOODSTUFF.equals(categoryType)){
            int shelfLife;
            if (isImported){
                // 向下取整
                shelfLife = (int) Math.floor(expiryDateDays*0.5);
                // 进口 剩余保质期应大于实际保质期的50%
                if (surplusDays <= shelfLife){
                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                            String.format(warnMsg,skuCode,"["+shelfLife+"]50%"));
                }
            }else{
                // 向下取整
                shelfLife = (int) Math.floor(expiryDateDays*0.7);//分批数
                // 国产 剩余保质期应大于实际保质期的70%
                if (surplusDays <= shelfLife){
                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                            String.format(warnMsg,skuCode,"["+shelfLife+"]70%"));
                }
            }
        }
    }

    public Set<Long> getGlobalConfigByKey(String configKey){
        final CommGlobalConfig config = pegasusUtilFacade.findConfigByKey(configKey);
        if(EmptyUtil.isNotEmpty(config) && EmptyUtil.isNotEmpty(config.getConfigValue())) {
            String[] configValues = config.getConfigValue().split(",");
            Set<Long> secondCategoryIds = new HashSet<>();
            for (String configValue : configValues){
                secondCategoryIds.add(Long.parseLong(configValue));
            }
            return secondCategoryIds;
        }
        return null;
    }

    private void updateScmStock(WhQualityControlVO qualityControlVO,WhCommand whCommand,Integer quantity){
        /*WhPhysicalWarehouseExample whPhysicalWarehouseExample = new WhPhysicalWarehouseExample();
        whPhysicalWarehouseExample.createCriteria().andCodeEqualTo(physicalWarehouseCode);
        List<WhPhysicalWarehouse> whPhysicalWarehouseList = whPhysicalWarehouseMapper.selectByExample(whPhysicalWarehouseExample);
        WhWarehouseExample whWarehouseExample = new WhWarehouseExample();
        WhWarehouseExample.Criteria criteria = whWarehouseExample.createCriteria();
        criteria.andPhysicalWarehouseIdEqualTo(whPhysicalWarehouseList.get(0).getId());
        criteria.andWarehouseTypeEqualTo(warehouseType);
        List<WhWarehouse> whWarehouseList = whWarehouseMapper.selectByExample(whWarehouseExample);*/
        // 逻辑仓为：物理仓对应的默认入库仓
        WhWarehouse whWarehouse = null;

        // rd#6405 收货上架 作调拨收货操作时
        if (qualityControlVO.isPutawayQc()
                && EmptyUtil.isNotEmpty(qualityControlVO.getWarehouseCommodityStatus())
                && WhCommand.TYPE_ALLOT_IN.equals(qualityControlVO.getWhInType())){
            // 如果收货的商品状态=调拨目标逻辑仓的商品状态，则该部分库存增加在调拨单的目标逻辑仓(同 指令逻辑仓)
            if (qualityControlVO.getCommodityStatus().equals(qualityControlVO.getWarehouseCommodityStatus())){
                whWarehouse = whInfoService.findWarehouseByCode(whCommand.getWarehouseCode());
            }
        }
        if (whWarehouse == null){
            whWarehouse = whInfoService.findDefaultInWarehouseByPhyWhCodeAndCommodityStatus(qualityControlVO.getPhysicalWarehouseCode(),qualityControlVO.getCommodityStatus());
        }
        if(NullUtil.isNotNull(whWarehouse)){
            WhInvRcd whInvRcd = new WhInvRcd();
            whInvRcd.setCommandCode(whCommand.getCode());
            whInvRcd.setWarehouseCode(whWarehouse.getCode());
            whInvRcd.setInOutType(whCommand.getInOutType());
            whInvRcd.setSkuCode(qualityControlVO.getQcSku());
            whInvRcd.setQuantity(quantity);
            whInvRcd.setSubmitUserId(qualityControlVO.getOperatorId());
            whInvRcd.setMemo(qualityControlVO.getRemark());
            whInvRcd.setSubmitTime(Calendar.getInstance().getTime());
            whInvService.record(whInvRcd);
        }else{
            throw new RuntimeException("上架失败，["+qualityControlVO.getPhysicalWarehouseCode()+"],["+WhWarehouseVO.getSkuStatusName(qualityControlVO.getCommodityStatus())+"]找不到默认的入库逻辑仓");
        }
    }

    /**
     * 质检
     * @param vo
     * @return
     */
    @Override
    @Transactional
    public String qualityControl(WhReceiveShelvesVO vo,String targetHouseType) {
        //仓库指令状态更新
       this.updateCommandStatusById(vo.getWhCommandId(),WhCommand.STATUS_QUALITY_PROCESSING);
        List<WhQualityControlVO>  qcVoList=vo.getQcList();
        String shelves = null;
        for(WhQualityControlVO qc:qcVoList) {
        	String remark=qc.getRemark();
            //条形码
        	qc.setWhInType(vo.getWhInType());
            if (EmptyUtil.isEmpty(qc.getReferenceCode())){
                qc.setReferenceCode(vo.getReferenceCode());
            }
            String barcode = "";
            if (vo.isExistsBarcode()){
                barcode = qc.getBarCode();
            }else{
                barcode = getBarCode(qc);
            }
            WhCommand whCommand = whCommandMapper.selectByPrimaryKey(Long.parseLong(vo.getWhCommandId().toString()));
            vo.setWhCmdCode(whCommand.getCode());
            //  WhPhysicalWarehouse whPhysicalWarehouse =  whPhysicalWarehouseMapper.findPhysicalWarehouseByWarehouse(whCommand.getWarehouseCode());
            WhPhysicalWarehouse whPhysicalWarehouse =  whPhysicalWarehouseMapper.findPhysicalWarehouseByCode(whCommand.getPhysicalWarehouseCode());
            WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
            cond.setHouseType(targetHouseType);
            cond.setPhysicalWarehouseCode(whPhysicalWarehouse.getCode());
            List<WhWmsHouseShelvesVO> shelvesList = whWmsHouseShelvesService.getHouseShelvesByCond(cond);
            if(shelvesList != null && shelvesList.size() > 0){
                shelves = shelvesList.get(0).getCode();
            }else{
                throw new RuntimeException("请先设置目标库位:"+targetHouseType);
            }
            Long operatorId = Long.parseLong(vo.getOperatorId().toString());
            qc.setPhysicalWarehouseCode(whPhysicalWarehouse.getCode());
            qc.setOperatorId(operatorId);
            if (qc.getNondefectiveQuantity() != null && qc.getNondefectiveQuantity() > 0){
                recordWaitPutaway(vo,barcode,qc.getNondefectiveQuantity(),WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE,whPhysicalWarehouse.getCode(),qc.getQcSku(),remark,qc); //质检记录
                recordSkuStock(qc,barcode,qc.getNondefectiveQuantity(),WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE,whPhysicalWarehouse.getCode(),targetHouseType,shelves,whCommand,Long.parseLong(vo.getOperatorId().toString()),"",1);   //库

                qc.setCommodityStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
                qc.setRemark("");
                updateScmStock(qc,whCommand,qc.getNondefectiveQuantity());
            }
            if (qc.getDefectiveQuantity() != null && qc.getDefectiveQuantity() > 0){
                recordWaitPutaway(vo,barcode,qc.getDefectiveQuantity(),WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED,whPhysicalWarehouse.getCode(),qc.getQcSku(),remark,qc); //质检记录
                recordSkuStock(qc,barcode,qc.getDefectiveQuantity(),WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED,whPhysicalWarehouse.getCode(),targetHouseType,shelves,whCommand,Long.parseLong(vo.getOperatorId().toString()),remark,1); //库存

                qc.setCommodityStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED);
                qc.setRemark(remark);
                updateScmStock(qc,whCommand,qc.getDefectiveQuantity());
            }
            if (qc.getSampleQuantity() != null && qc.getSampleQuantity() > 0){
                recordWaitPutaway(vo,barcode,qc.getSampleQuantity(),WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE,whPhysicalWarehouse.getCode(),qc.getQcSku(),remark,qc);//质检记录
                recordSkuStock(qc,barcode,qc.getSampleQuantity(),WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE,whPhysicalWarehouse.getCode(),targetHouseType,shelves,whCommand,Long.parseLong(vo.getOperatorId().toString()),remark,1); //库存

                qc.setCommodityStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE);
                qc.setRemark(remark);
                updateScmStock(qc,whCommand,qc.getSampleQuantity());
            }
        }
        return shelves;
    }

    private void recordWaitPutaway(WhReceiveShelvesVO vo,String barcode,Integer amount,Integer skuStatus,String whPhysicalWarehouseCode,
                                   String skuCode,String remark,WhQualityControlVO qc) {
        WhWmsWaitPutawayVO waitputVO = new WhWmsWaitPutawayVO();
        waitputVO.setReceiptsNo(vo.getReferenceCode());//相关单据号
        waitputVO.setBarCode(barcode);
        waitputVO.setCreateTime(new Date());
        waitputVO.setCreateUserId(vo.getOperatorId());
        waitputVO.setReceiveAmount(amount);
        waitputVO.setSkuStatus(skuStatus);
        waitputVO.setPutawayStatus(WhWmsWaitPutaway.STATUS_WAIT_PUTAWAY);
        waitputVO.setCancelFlag(0);
        waitputVO.setCommandCode(vo.getWhCmdCode());
        waitputVO.setPhysicalWarehouseCode(whPhysicalWarehouseCode);
        waitputVO.setRemark(remark);
        waitputVO.setInOutType(vo.getWhInType());//入库类型
        // 质检明细记录生产过期日期
        waitputVO.setProdDate(qc.getQcProdDate());
        waitputVO.setExpirationDate(qc.getQcExpirationDate());
        whWmsWaitPutawayService.create(waitputVO);
        WhCommandCond whCommandCond = new WhCommandCond();
        whCommandCond.setCode(vo.getWhCmdCode());
        List<WhCommand> whCommandList = whCommandMapper.findCommandByCond(whCommandCond);
        if(whCommandList != null && whCommandList.size() > 0){
            WhCommandSkuExample example = new WhCommandSkuExample();
            WhCommandSkuExample.Criteria criteria = example.createCriteria();
            criteria.andCommandIdEqualTo(whCommandList.get(0).getId());
            criteria.andSkuCodeEqualTo(skuCode);
            List<WhCommandSku> whCommandSkuList = whCommandSkuMapper.selectByExample(example);
            if(whCommandSkuList != null && whCommandSkuList.size() >0){
                WhCommandSku whCommandSku = whCommandSkuList.get(0);
                if(WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED.equals(skuStatus)
                        || WhWarehouseVO.COMMODITY_STATUS_FOR_HOLD_PENDING.equals(skuStatus)){
                   int damagedQuantity = whCommandSku.getDamagedQuantity()==null?0:whCommandSku.getDamagedQuantity();
                    damagedQuantity += amount;
                    whCommandSku.setDamagedQuantity(damagedQuantity);
                    if(whCommandSku.getQuantity() == null){
                        whCommandSku.setQuantity(0);
                    }
                }else{
                    int quantity = whCommandSku.getQuantity()==null?0:whCommandSku.getQuantity();
                    quantity += amount;
                    whCommandSku.setQuantity(quantity);
                    if(whCommandSku.getDamagedQuantity()==null){
                        whCommandSku.setDamagedQuantity(0);
                    }
                }
                whCommandSkuMapper.updateByPrimaryKey(whCommandSku);
            }
        }

        if (WhCommand.TYPE_PURCHASE_IN.equals(vo.getWhInType())
                && WhWarehouseVO.COMMODITY_STATUS_FOR_HOLD_PENDING.equals(waitputVO.getSkuStatus())){
            // 保存采购入库 残次收货详情
            if (CollectionUtils.isNotEmpty(qc.getReceiveShelvesDetails())){
                for (WhWmsReceiveShelvesDetail shelvesDetail : qc.getReceiveShelvesDetails()){
                    shelvesDetail.setQcId(waitputVO.getId());
                    shelvesDetail.setCreateUserId(vo.getCreateUserId());
                    shelvesDetail.setCreateTime(new Date());
                    shelvesDetail.setOriginType(WhWmsReceiveShelvesDetailVO.ORIGIN_TYPE_WMS_QC);
                }
                whWmsReceiveShelvesDetailService.batchCreate(qc.getReceiveShelvesDetails());

                // 针对scm qc处理，先附带存储个默认初始值
                /*for (WhWmsReceiveShelvesDetail shelvesDetail : qc.getReceiveShelvesDetails()){
                    shelvesDetail.setOriginType(WhWmsReceiveShelvesDetailVO.ORIGIN_TYPE_SCM_QC);
                    shelvesDetail.setQuantity(0);
                    shelvesDetail.setReason("");
                }
                whWmsReceiveShelvesDetailService.batchCreate(qc.getReceiveShelvesDetails());*/
            }
        }else{
            // 如果有残次图片，则将质检id关联到残次图片上
            if (CollectionUtils.isNotEmpty(qc.getDefectivePicIds())){
                CommFileRef record = new CommFileRef();
                CommFileRefExample example = new CommFileRefExample();
                record.setReferenceSecondCode(waitputVO.getId()+"");
                example.createCriteria().andIdIn(qc.getDefectivePicIds());
                PegasusUtilFacade.getInstance().updateByCond(record,example);
            }
        }
    }

    private void recordSkuStock(WhQualityControlVO qc, String barcode,Integer amount,Integer skuStatus,String whPhysicalWarehouseCode,String houseType,String shelvesCode,WhCommand whCommand,Long operationId,String memo,Integer isUpdateScm) {

        boolean isSuccess = whWmsSkuStockService.updateStockByCond(amount,whPhysicalWarehouseCode,houseType,barcode,shelvesCode,qc.getQcSku(),skuStatus,whCommand.getInOutType(),whCommand.getCode(),operationId,memo,isUpdateScm);

    }

    private void recordSkuStockRecord(WhQualityControlVO qc, String barcode,Integer amount,Integer skuStatus) {
        WhWmsSkuStockRecordVO recordVO = new WhWmsSkuStockRecordVO();
        recordVO.setSkuCode(qc.getQcSku());
        recordVO.setBarCode(barcode);
        recordVO.setOldQuantity(amount);
        recordVO.setSkuStatus(skuStatus);
        whWmsSkuStockRecordService.create(recordVO);
    }

    public Integer parseInteger(Integer i) {
        return i == null? 0: i;
    }

    /**
     *根据id更新指令状态
     */
    @Override
    @Transactional
    public boolean updateCommandStatusById(Integer id, Integer status) {
        WhCommand cmd =new WhCommand();
        cmd.setId(id.longValue());
        cmd.setCommandStatus(status);
        if(status.equals(WhCommand.STATUS_QUALITY_FINISHED) || status.equals(WhCommand.STATUS_FINISHED)){
            cmd.setProcessTime(Calendar.getInstance().getTime());
        }
        return whCommandMapper.updateByPrimaryKeySelective(cmd)!=0;
    }

    /**
	 * 查找出库订单信息
	 * */
	public List<WhWmsCommandInfoVO> findCommandInfoByCond(WhWmsCommandInfoCond cond){
		List<WhWmsCommandInfoVO> commandInfoVOs = whCommandMapper.findCommandInfoByCond(cond);
		Set<Long> commandIds = new HashSet<Long>();
		if(commandInfoVOs!=null && !commandInfoVOs.isEmpty()){
			for(WhWmsCommandInfoVO commandInfoVO : commandInfoVOs){
				commandIds.add(commandInfoVO.getId());
			}
		}
		List<WhWmsCommandSkuVO> commandSkuInfos = null;
		if(!commandIds.isEmpty()){
			commandSkuInfos = whCommandMapper.findCommandSkuInfoByCond(commandIds);
		}
		
		if(commandInfoVOs!=null && !commandInfoVOs.isEmpty()){
			for(WhWmsCommandInfoVO commandInfoVO : commandInfoVOs){
				List<WhWmsCommandSkuVO> comSkus = filterCommandSkuInfoByCommandId(commandSkuInfos,commandInfoVO.getId());
				commandInfoVO.setCommandSkuInfos(comSkus);
			}
		}
		return commandInfoVOs;
	}
	
	public Pagination<WhWmsCommandInfoVO> findPaginationCommandInfoByCond(WhWmsCommandInfoCond cond){
		Pagination<WhWmsCommandInfoVO> page = new Pagination<>(cond.getCurrpage(),cond.getPagenum());
		WhPhysicalWarehouse whPhysicalWarehouse = whPhysicalWarehouseMapper.selectByPrimaryKey(cond.getPhysicalWarehouseId());
		if(whPhysicalWarehouse != null){
			cond.setPhysicalWarehouseId(null);
			cond.setPhysicalWarehouseCode(whPhysicalWarehouse.getCode());
		}
		Integer count = whCommandMapper.countFindByCond(cond);
		List<WhWmsCommandInfoVO> commandInfoVOs = whCommandMapper.findNewCommandInfoByCond(cond);
		Set<Long> commandIds = new HashSet<Long>();
		if(commandInfoVOs!=null && !commandInfoVOs.isEmpty()){
			for(WhWmsCommandInfoVO commandInfoVO : commandInfoVOs){
				commandIds.add(commandInfoVO.getId());
			}
		}
		List<WhWmsCommandSkuVO> commandSkuInfos = null;
		if(!commandIds.isEmpty()){
			commandSkuInfos = whCommandMapper.findCommandSkuInfoByCond(commandIds);
		}
		
		if(commandInfoVOs!=null && !commandInfoVOs.isEmpty()){
			for(WhWmsCommandInfoVO commandInfoVO : commandInfoVOs){
				List<WhWmsCommandSkuVO> comSkus = filterCommandSkuInfoByCommandId(commandSkuInfos,commandInfoVO.getId());
				commandInfoVO.setCommandSkuInfos(comSkus);
			}
		}
        page.setResultList(commandInfoVOs);
        page.setRecord(count);
        return page;
	}
	
	/**
	 * 查找出库订单信息
	 * */
	public List<WhWmsCommandInfoVO> findNewCommandInfoByCond(WhWmsCommandInfoCond cond){
		List<WhWmsCommandInfoVO> commandInfoVOs = whCommandMapper.findNewCommandInfoByCond(cond);
		Set<Long> commandIds = new HashSet<Long>();
		if(commandInfoVOs!=null && !commandInfoVOs.isEmpty()){
			for(WhWmsCommandInfoVO commandInfoVO : commandInfoVOs){
				commandIds.add(commandInfoVO.getId());
			}
		}
		List<WhWmsCommandSkuVO> commandSkuInfos = null;
		if(!commandIds.isEmpty()){
			commandSkuInfos = whCommandMapper.findCommandSkuInfoByCond(commandIds);
		}
		
		if(commandInfoVOs!=null && !commandInfoVOs.isEmpty()){
			for(WhWmsCommandInfoVO commandInfoVO : commandInfoVOs){
				List<WhWmsCommandSkuVO> comSkus = filterCommandSkuInfoByCommandId(commandSkuInfos,commandInfoVO.getId());
				commandInfoVO.setCommandSkuInfos(comSkus);
			}
		}
		return commandInfoVOs;
	}
	
	/**
	 * 统计出库订单信息
	 * */
	public Map<String,Object> countCommandInfoByCond(WhWmsCommandInfoCond cond){
		WhPhysicalWarehouse whPhysicalWarehouse = whPhysicalWarehouseMapper.selectByPrimaryKey(cond.getPhysicalWarehouseId());
		if(whPhysicalWarehouse != null){
			cond.setPhysicalWarehouseId(null);
			cond.setPhysicalWarehouseCode(whPhysicalWarehouse.getCode());
		}
		return whCommandMapper.countCommandInfoByCond(cond);
	}
	
	
	/**
	 * 查询附加信息
	 * */
	public List<Map<String, Object>> findAdditionalInfosByCond(WhWmsCommandInfoCond cond){
		return whCommandMapper.findAdditionalInfosByCond(cond);
	}
	
	/**
	 * 根据commandId 过滤 command sku  
	 * */
	private List<WhWmsCommandSkuVO> filterCommandSkuInfoByCommandId(List<WhWmsCommandSkuVO> commandSkuInfos,Long commandId){
		List<WhWmsCommandSkuVO> tmp = new ArrayList<WhWmsCommandSkuVO>();
		if(commandSkuInfos!=null && !commandSkuInfos.isEmpty()){
			for(WhWmsCommandSkuVO comSku : commandSkuInfos){
				if(commandId.equals(comSku.getCommandId())){
					tmp.add(comSku);
				}
			}
		}
		return tmp;
	}
    
    /**
     * 更改快递单号
     * @param commandCode
     * @param expressCode
     * @return
     */
    @Override
    @Transactional
    public boolean commandAssociateExpress(String commandCode, String expressCode) {
        WhCommand commandByExpressCode = findCommandByExpressCode(expressCode);
        if(commandByExpressCode!=null && !commandByExpressCode.getCode().equals(commandCode)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"该快递单号已被绑定");
        }
        WhCommand cmd = findCommandByCode(commandCode, false);
        if(cmd!=null){
            WhCommand update =new WhCommand();
            update.setId(cmd.getId());
            update.setExpressNo(expressCode);
            return whCommandMapper.updateByPrimaryKeySelective(update)!=0;
        }else{
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"找不到仓库指令");
        }
    }

    /**
     * 更改快递单号
     * @param commandCode
     * @param expressCode
     * @param operationSource
     * @return
     */
    @Override
    @Transactional
    public boolean commandAssociateExpress(String commandCode, String expressCode,String operationSource) {
        WhCommand commandByExpressCode = findCommandByExpressCode(expressCode);
        if(commandByExpressCode!=null && !commandByExpressCode.getCode().equals(commandCode)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"该快递单号已被绑定");
        }

        WhCommand cmd = findCommandByCode(commandCode, false);
        if(cmd!=null){
            WhCommand update =new WhCommand();
            update.setId(cmd.getId());
            update.setExpressNo(expressCode);
            return whCommandMapper.updateByPrimaryKeySelective(update)!=0;
            // 去除限制
            /*if(cmd.getCommandStatus().equals(WhCommand.STATUS_HANDOVER)){
                WhCommand update =new WhCommand();
                update.setId(cmd.getId());
                update.setExpressNo(expressCode);
                return whCommandMapper.updateByPrimaryKeySelective(update)!=0;
            }else{
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"必须是待交接的指令");
            }*/
        }else{
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"找不到仓库指令");
        }
    }

    /**
     * 更改快递单号
     */
    @Override
    @Transactional
    public boolean commandAssociateExpress(WhCommandAssoExpressVO vo) {
    	String expressCode = vo.getExpressCode();
    	String commandCode = vo.getCommandCode();
    	if(EmptyUtil.isNotEmpty(expressCode)){
    		WhCommand commandByExpressCode = findCommandByExpressCode(expressCode);
            if(commandByExpressCode!=null && !commandByExpressCode.getCode().equals(commandCode)){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"该快递单号已被绑定");
            }
    	}

        WhCommand cmd = findCommandByCode(commandCode, false);
        if(cmd!=null){
            if(cmd.getCommandStatus().equals(WhCommand.STATUS_HANDOVER) || cmd.getCommandStatus().equals(WhCommand.STATUS_DELIVERYCOMPLETION) ){
                WhCommand update =new WhCommand();
                update.setId(cmd.getId());
                update.setExpressType(vo.getDeliveryType());
                if(NullUtil.isNotNull(vo.getExpressCode())){
                	update.setExpressNo(expressCode);
                }
                return whCommandMapper.updateByPrimaryKeySelective(update)!=0;
            }else{
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"必须是待交接或发货完成的指令");
            }
        }else{
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"找不到仓库指令");
        }
    }

    @Override
    public WhCommand findCommandByExpressCode(String expressCode) {
        WhCommandExample example = new WhCommandExample();
        example.createCriteria().andExpressNoEqualTo(expressCode);
        List<WhCommand> whCommands = whCommandMapper.selectByExample(example);
        if(CollectionUtils.isNotEmpty(whCommands)){
            if(whCommands.size()>1){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"一个快递单号对应多条仓库指令");
            }else{
                whCommands.get(0).setWhCommandSkuList(
                        findCommandSkuByCommandId(whCommands.get(0).getId()));
             return whCommands.get(0);
            }
        }else{
            return null;
        }
    }
    @Override
    public List<WhCommand> findCommandByConnectIdAndBarCode(String barCode, Long connectId) {
        return whCommandMapper.findCommandByConnectIdAndBarCode(barCode,connectId);
    }

    @Override
    public boolean colseCommandByReferenceCode(int inoutType, String referenceCode) {
        WhCommandExample example = new WhCommandExample();
        WhCommandExample.Criteria criteria = example.createCriteria();
        criteria.andInOutTypeEqualTo(inoutType);
        criteria.andReferenceCodeEqualTo(referenceCode);
        List<WhCommand> whCommandList = whCommandMapper.selectByExample(example);
        if(whCommandList != null && whCommandList.size() > 0){
            WhCommand whCommand =  whCommandList.get(0);
            whCommand.setCommandStatus(WhCommand.STATUS_CANCELED);
            return whCommandMapper.updateByPrimaryKey(whCommand)> 0 ?true:false;
        }
        return false;
    }
	@Override
	public WhWmsConnectInfoVO findWhWmsConnectInfoVOByCommandCode(
			String commandCode) {
		return whCommandMapper.findWhWmsConnectInfoVOByCommandCode(commandCode);
	}

    @Override
    @Transactional
    public void packageAssoExpressFED(PackageInfo pi) {
        whCommandMapper.packageAssoExpressFED(pi);
    }

    @Override
    @Transactional
    public void packageAssoExpressFEDAndCommand(PackageInfo pi) {
        whCommandMapper.packageAssoExpressFED(pi);
        whCommandMapper.packageAssoExpressCommand(pi);
        whCommandMapper.packageAssoExpressDispatchBill(pi);
    }

    @Override
    @Transactional
    public void packageAssoExpressExFreshAndCommand(PackageInfo pi) {
        whCommandMapper.packageAssoExpressExFresh(pi);
        whCommandMapper.packageAssoExpressCommand(pi);
    }

    @Override
    @Transactional
    public void packageAssoExpressSF(PackageInfo pi) {
        whCommandMapper.packageAssoExpressSF(pi);
    }

    @Override
    @Transactional
    public void packageAssoExpressSFAndPackage(PackageInfo pi) {
        whCommandMapper.packageAssoExpressSF(pi);
        whCommandMapper.packageAssoExpressCommand(pi);
        whCommandMapper.packageAssoExpressDispatchBill(pi);
    }

    @Override
    @Transactional
    public void packageAssoExpressZTAndPackage(ZTOrderSubmitResponse ztOrderSubmitResponse) {
        ZTOrderSubmitKeys keys = ztOrderSubmitResponse.getKeys();
        whCommandMapper.packageAssoExpressZT(keys);
        whCommandMapper.packageAssoExpressCommandZT(keys);
        whCommandMapper.packageAssoExpressDispatchBillZT(keys);
    }

    @Override
    public void packageAssoExpressTmsAndCommand(PackageInfo pi) {
        whCommandMapper.packageAssoTms(pi);
        whCommandMapper.packageAssoExpressCommand(pi);
        whCommandMapper.packageAssoExpressDispatchBill(pi);
    }

    @Override
    @Transactional
    public void updateCommand(WhCommand whCommand) {
        whCommandMapper.updateByPrimaryKey(whCommand);
    }

    @Override
    @Transactional
    public WhCommand updateCommandV2(WhCommand whCommand) {
        SWhCommandVO sWhCmd = sWhCommandService.updateWhCommandByKey(BeanUtil.buildFrom(whCommand, SWhCommandVO.class));
        return convertDtoToCommand(sWhCmd);
    }

    @Override
    @Transactional
    public void batchUpdateCommand(WhCommand whCommand,WhCommandExample example) {
        whCommandMapper.updateByExampleSelective(whCommand,example);
    }
    
    @Override
    public void commandWithPackageExpress(){
    	whCommandMapper.commandWithPackageExpress();
    }

    @Override
    @Transactional
    public void recordCommandShortSku(String commandCode, String skuCode, int shortAmount) {
        WhWmsCommandShortRecordExample example = new WhWmsCommandShortRecordExample();
        WhWmsCommandShortRecordExample.Criteria criteria = example.createCriteria();
        criteria.andCommandCodeEqualTo(commandCode);
        criteria.andSkuCodeEqualTo(skuCode);
        List<WhWmsCommandShortRecord> records = whWmsCommandShortRecordMapper.selectByExample(example);
        if(records != null && records.size() > 0){
            WhWmsCommandShortRecord record = records.get(0);
            record.setShortAmount(shortAmount);
            record.setSubmitTime(Calendar.getInstance().getTime());
            whWmsCommandShortRecordMapper.updateByPrimaryKey(record);
        }else{
            WhWmsCommandShortRecord record = new WhWmsCommandShortRecord();
            record.setCommandCode(commandCode);
            record.setSubmitTime(Calendar.getInstance().getTime());
            record.setSkuCode(skuCode);
            record.setShortAmount(shortAmount);
            whWmsCommandShortRecordMapper.insert(record);
        }
    }

    @Override
    @Transactional
    public boolean recordCommandShortSku(List<WhWmsCommandShortRecord> shortRecordList) {
        if(EmptyUtil.isNotEmpty(shortRecordList)){
            Set<String> commandCodes = new HashSet<>();
            for(WhWmsCommandShortRecord shortRecord : shortRecordList){
                commandCodes.add(shortRecord.getCommandCode());
            }
            WhWmsCommandShortRecordExample example = new WhWmsCommandShortRecordExample();
            WhWmsCommandShortRecordExample.Criteria criteria = example.createCriteria();
            criteria.andCommandCodeIn(Arrays.asList(commandCodes.toArray(new String[commandCodes.size()])));
            whWmsCommandShortRecordMapper.deleteByExample(example);
            whWmsCommandShortRecordMapper.batchCreate(shortRecordList);
        }
        return true;
    }

    @Override
    public List<WhWmsCommandShortRecord> findWhWmsCommandShortRecordByCommandCode(String commandCode) {
        WhWmsCommandShortRecordExample example = new WhWmsCommandShortRecordExample();
        example.createCriteria().andCommandCodeEqualTo(commandCode);
        return whWmsCommandShortRecordMapper.selectByExample(example);
    }

    @Override
  	public String synCommodityStocks(Long numIid, String outerId, long quantity, String channelCode, int syncType, String referenceCode,Long operatorId) throws Exception {
    	final TmallStockLog tmallStockLog = new TmallStockLog();
    	tmallStockLog.setGoodsId(numIid);
    	tmallStockLog.setQuantity((int) quantity);
    	tmallStockLog.setSkuCode(outerId);
    	tmallStockLog.setReferenceCode(referenceCode);
    	tmallStockLog.setSyncType(syncType);
    	tmallStockLog.setCreateTime(new Date());
    	tmallStockLog.setChannelCode(channelCode);
    	if(numIid == null) { //是否有商品
    		tmallStockLog.setRemark("天猫后台商品异常【不存在商品或者非活动链接】");
    		tmallStockLog.setSyncStatus((short) 0);
            if (syncType ==1) {
                tmallStockLog.setDealStatus((short) 1);
            }
    		myScheduler.execute(new Runnable() {
				@Override
				public void run() {
					tmallStockLogMapper.insertSelective(tmallStockLog);
				}
			});
  			throw new WarehouseException(WarehouseExceptionErrorCode.OCCUPY_FAILED_INV_IS_NOT_ENOUGH,
      					"SKU【"+ outerId +"】天猫后台商品异常【不存在商品或者非活动链接】");
      	}
    	
      	if(quantity < 0) { //减库存先查询天猫库存是否充足
      		
      		int tmallQuantity = pegasusUtilFacade.getSkuQuantity(outerId, channelCode, numIid);
      		//库存不足
      		if((tmallQuantity + quantity) < 0) {
      			 //return "INV_IS_NOT_ENOUGH";
      			tmallStockLog.setRemark("天猫后台库存不足");
        		tmallStockLog.setSyncStatus((short) 0);
                if (syncType ==1) {
                    tmallStockLog.setDealStatus((short) 1);
                }
        		myScheduler.execute(new Runnable() {
    				@Override
    				public void run() {
    					tmallStockLogMapper.insertSelective(tmallStockLog);
    				}
    			});
      			 throw new WarehouseException(WarehouseExceptionErrorCode.OCCUPY_FAILED_INV_IS_NOT_ENOUGH,
      		                "SKU【"+ outerId +"】天猫后台库存不足,当前库存" + tmallQuantity);
      		}
      	}
      	
      
      	
      	if(quantity != 0 && numIid != null) {
      		ItemQuantityUpdateResponse rsp = pegasusUtilFacade.synCommodityStocks(channelCode, numIid, outerId, quantity);
          if(EmptyUtil.isNotEmpty(rsp.getErrorCode())) {
            throw  new WarehouseException(rsp.getErrorCode(), rsp.getSubMsg());
          }
      		log.info("天猫库存同步:商品数字ID(" +  numIid + ") " + "SKU(" + outerId + ") 变更数量" + quantity);
      		JSONObject error = JSONObject.parseObject(rsp.getBody()).getJSONObject("error_response");
      		if(JSONObject.parseObject(rsp.getBody()).getString("error_response") != null) {
      			tmallStockLog.setRemark(error.getString("sub_msg"));
        		tmallStockLog.setSyncStatus((short) 0);
                if (syncType ==1) {
                    tmallStockLog.setDealStatus((short) 1);
                }
        		myScheduler.execute(new Runnable() {
    				@Override
    				public void run() {
    					tmallStockLogMapper.insertSelective(tmallStockLog);
    				}
    			});
        		
        		String errorMsg = error.getString("sub_msg");
        		if("保存库存信息失败, 实际库存数不能小于已分配的渠道库存数".equals(errorMsg)) {
        			errorMsg = "天猫后台商品正在参加活动库存锁定，不能调拨！";
        		}

        		throw new WarehouseException(WarehouseExceptionErrorCode.OCCUPY_FAILED_INV_IS_NOT_ENOUGH,
      					"SKU【"+ outerId +"】" + errorMsg);
      		}
      		tmallStockLog.setRemark("同步成功");
    		tmallStockLog.setSyncStatus((short) 1);
            tmallStockLog.setDealStatus((short) 1);
    		myScheduler.execute(new Runnable() {
				@Override
				public void run() {
					tmallStockLogMapper.insertSelective(tmallStockLog);
				}
			});
      	}
  		
  		return "成功";
  	}

    @Override
    public Map<String,JdStockSyncResult> syncJdSkuStock(String warehouseCode
            ,Map<String,Integer> skuQuantityMap
            ,Integer syncType
            ,List<String> referenceCodes
            ,Long operatorId){
        Map<String,JdStockSyncResult> resultMap = syncJdSkuStock(
                warehouseCode
                ,skuQuantityMap
                ,syncType
                ,referenceCodes
                ,operatorId
                ,false);
        return resultMap;
    }


    @Override
    public Map<String, JdStockSyncResult> syncJdSkuStock(String warehouseCode, Map<String, Integer> skuQuantityMap, Integer syncType, List<String> referenceCodes, Long operatorId, boolean failThenThrowException) {
        if(!failThenThrowException){
            return syncJdSkuStockBatch(warehouseCode
                    ,skuQuantityMap
                    ,syncType
                    ,referenceCodes
                    ,operatorId);
        }else{
            //一个一个处理
            Map<String,JdStockSyncResult> resultMap = new HashMap<>();
            for(Map.Entry<String,Integer> entry : skuQuantityMap.entrySet()){
                Map<String,JdStockSyncResult> tmpResultMap = syncJdSkuStockBatch(
                        warehouseCode
                        ,Collections.singletonMap(entry.getKey(),entry.getValue())
                        ,syncType
                        ,referenceCodes
                        ,operatorId);
                resultMap.putAll(tmpResultMap);
                for(JdStockSyncResult syncResult : tmpResultMap.values()){
                    //库存同步失败抛异常
                    if(NullUtil.isNull(syncResult.getJdSkuId()) || !syncResult.isSuccess()){
                        throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                                ,String.format("[%s]同步失败:%s",entry.getKey(),syncResult.getErrorMsg()));
                    }
                }
            }
            return resultMap;
        }
    }

    private Map<String, JdStockSyncResult> syncJdSkuStockBatch(String warehouseCode, Map<String, Integer> skuQuantityMap, Integer syncType, List<String> referenceCodes, Long operatorId){
        Map<String,JdStockSyncResult> resultMap = pegasusUtilFacade.syncJdSkuStock(warehouseCode,skuQuantityMap);
        int refSize = referenceCodes == null ? 0 : referenceCodes.size();
        int refIndex = 0;
        String publicReferenceCode = null;
        if (referenceCodes.size() == 1) {
          publicReferenceCode = referenceCodes.get(0);
        }
        for(JdStockSyncResult syncResult : resultMap.values()){
            final TmallStockLog syncStockLog = new TmallStockLog();
            syncStockLog.setGoodsId(syncResult.getJdSkuId());
            syncStockLog.setQuantity(syncResult.getQuantity());
            syncStockLog.setSkuCode(syncResult.getSkuCode());
            if (publicReferenceCode != null) {
                syncStockLog.setReferenceCode(publicReferenceCode);
            } else {
                //防止list越界
                if (refIndex < refSize) {
                    syncStockLog.setReferenceCode(referenceCodes.get(refIndex));
                } else {
                    syncStockLog.setReferenceCode(referenceCodes.get(refSize - 1));
                }
                refIndex ++;
            }

            syncStockLog.setSyncType(syncType);
            syncStockLog.setCreateTime(DateUtil.getNow());
            syncStockLog.setChannelCode(syncResult.getChannelCode());
            syncStockLog.setRemark(syncResult.getErrorMsg());
            syncStockLog.setCreateOperatorId(operatorId);
            if(NullUtil.isNull(syncResult.getJdSkuId())
                    || !syncResult.isSuccess()){//jd无商品
                syncStockLog.setSyncStatus((short) 0);
                if (syncType ==1) {
                    syncStockLog.setDealStatus((short) 1);
                }
            }else{
                syncStockLog.setRemark("同步成功");
                syncStockLog.setSyncStatus((short) 1);
                syncStockLog.setDealStatus((short) 1);
            }
            myScheduler.execute(new Runnable() {
                @Override
                public void run() {
                    tmallStockLogMapper.insertSelective(syncStockLog);
                }
            });
        }
        return resultMap;
    }

    @Override
    public TmallStockLog synCommodityStocksAllot(Long numIid, String outerId, long quantity, String channelCode, int syncType, String referenceCode) throws Exception {
        final TmallStockLog tmallStockLog = new TmallStockLog();
        tmallStockLog.setGoodsId(numIid);
        tmallStockLog.setQuantity((int) quantity);
        tmallStockLog.setSkuCode(outerId);
        tmallStockLog.setReferenceCode(referenceCode);
        tmallStockLog.setSyncType(syncType);
        tmallStockLog.setCreateTime(new Date());
        tmallStockLog.setChannelCode(channelCode);
        if(numIid == null) { //是否有商品
            tmallStockLog.setRemark("天猫后台商品异常【不存在商品或者非活动链接】");
            tmallStockLog.setSyncStatus((short) 0);
            if (syncType ==1) {
                tmallStockLog.setDealStatus((short) 1);
            }
            log.error("SKU【"+ outerId +"】天猫后台商品异常【不存在商品或者非活动链接】");
            return tmallStockLog;
        }

        if(quantity < 0) { //减库存先查询天猫库存是否充足
            int tmallQuantity = pegasusUtilFacade.getSkuQuantity(outerId, channelCode, numIid);
            //库存不足
            if((tmallQuantity + quantity) < 0) {
                //return "INV_IS_NOT_ENOUGH";
                tmallStockLog.setRemark("天猫后台库存不足");
                tmallStockLog.setSyncStatus((short) 0);
                if (syncType ==1) {
                    tmallStockLog.setDealStatus((short) 1);
                }
                log.error("SKU【"+ outerId +"】天猫后台库存不足,当前库存" + tmallQuantity);
                return tmallStockLog;
            }
        }

        if(quantity != 0 && numIid != null) {
            ItemQuantityUpdateResponse rsp = pegasusUtilFacade.synCommodityStocks(channelCode, numIid, outerId, quantity);
            if(EmptyUtil.isNotEmpty(rsp.getErrorCode())) {
                tmallStockLog.setRemark("["+rsp.getErrorCode()+"]"+rsp.getMsg());
                tmallStockLog.setSyncStatus((short) 0);
                if (syncType ==1) {
                    tmallStockLog.setDealStatus((short) 1);
                }
                return tmallStockLog;
            }
            log.info("天猫库存同步:商品数字ID(" +  numIid + ") " + "SKU(" + outerId + ") 变更数量" + quantity);
            JSONObject error = JSONObject.parseObject(rsp.getBody()).getJSONObject("error_response");
            if(JSONObject.parseObject(rsp.getBody()).getString("error_response") != null) {
                tmallStockLog.setRemark(error.getString("sub_msg"));
                tmallStockLog.setSyncStatus((short) 0);
                if (syncType ==1) {
                    tmallStockLog.setDealStatus((short) 1);
                }
                String errorMsg = error.getString("sub_msg");
                if("保存库存信息失败, 实际库存数不能小于已分配的渠道库存数".equals(errorMsg)) {
                    errorMsg = "天猫后台商品正在参加活动库存锁定，不能调拨！";
                }
                log.error("SKU【"+ outerId +"】" + errorMsg);
                return tmallStockLog;
            }
            tmallStockLog.setRemark("同步成功");
            tmallStockLog.setSyncStatus((short) 1);
            tmallStockLog.setDealStatus((short) 1);

        }

        return tmallStockLog;
    }

    @Override
    @Transactional
    public void insertWhCommandOutFinish(WhCommandOutFinish whCommandOutFinish) {
        whCommandOutFinishMapper.insert(whCommandOutFinish);
    }

    @Override
    public List<WhCommandOutFinish> findWhCommandOutFinishNoFinish() {
        WhCommandOutFinishExample example = new WhCommandOutFinishExample();
        example.createCriteria().andStatusEqualTo(PegasusConstants.NO);
        return whCommandOutFinishMapper.selectByExample(example);
    }
    
    @Override
    public List<WhCommandCountVO> getCommandOutCountByCond(WhCommandCond cond){
        if(NullUtil.isNotNull(cond.getPhysicalWarehouseId())){
            WhPhysicalWarehouse phyWh = whInfoService.findPhysicalWarehouseById(cond.getPhysicalWarehouseId());
            if(NullUtil.isNull(phyWh)){
                return Collections.emptyList();
            }
            cond.setPhysicalWarehouseCode(phyWh.getCode());
        }
    	if(EmptyUtil.isEmpty(cond.getGroupBy())){
    		return whCommandMapper.getCommandOutCountByCond(cond);
    	}else if(WhCommand.TYPE_ALLOT_OUT.toString().equals(cond.getGroupBy())){
    		return whCommandMapper.getAltOutCommandCountByCond(cond);
    	}else if(WhCommand.TYPE_SALES_OUT.toString().equals(cond.getGroupBy())){
    		return whCommandMapper.getSaleOutCommandCountByCond(cond);
    	}else if(WhCommand.TYPE_CHANGE_OUT.toString().equals(cond.getGroupBy())){
    		return whCommandMapper.getChangeOutCommandCountByCond(cond);
    	}else if(WhCommand.TYPE_PURCHASE_RETURN_OUT.toString().equals(cond.getGroupBy())){
    		return whCommandMapper.getPurchaseRtnOutCommandCountByCond(cond);
    	}
    	return new ArrayList<>();
    }

    @Override
    public List<WhPackageInfoVO> findCHN2053PackageInfo() {
        return whCommandMapper.findCHN2053PackageInfo();
    }

    @Override
    public List<WhWmsSubmitHandRecord> autoProcessSubmitHandData() {
        WhWmsSubmitHandRecordExample example = new WhWmsSubmitHandRecordExample();
        example.createCriteria().andStatusEqualTo(0);
        example.setOrderByClause("SKU_CODE");
        return whWmsSubmitHandRecordMapper.selectByExample(example);

    }
    @Transactional
    public void processSubmitData(List<WhWmsSubmitHandRecord> submitList){
        Map<String,WhWmsSubmitHandRecord> map = new HashMap<>();
        for(WhWmsSubmitHandRecord record:submitList){
            WhWmsSkuStockRecord whWmsSkuStockRecord = new WhWmsSkuStockRecord();
            whWmsSkuStockRecord.setPhysicalWarehouseCode(record.getPhysicalWarehouseCode());
            whWmsSkuStockRecord.setHouseType(record.getHouseType());
            whWmsSkuStockRecord.setSkuCode(record.getSkuCode());
            whWmsSkuStockRecord.setBarCode(record.getBarCode());
            whWmsSkuStockRecord.setCreateTime(Calendar.getInstance().getTime());
            whWmsSkuStockRecord.setCreateUserId(record.getSubmitUserId()==null?1l:Long.parseLong(record.getSubmitUserId().toString()));
            whWmsSkuStockRecord.setInOutType(record.getInoutType());
            whWmsSkuStockRecord.setQuantity(record.getAmount());
            whWmsSkuStockRecord.setReceiptNo(record.getReceiptNo());
            whWmsSkuStockRecord.setSkuStatus(record.getSkuStatus());
            whWmsSkuStockRecord.setShelvesCode(record.getShelvesCode());
            whWmsSkuStockRecord.setMemo(record.getMemo());
            whWmsSkuStockRecord.setIsUpdateScm(record.getIsUpdateScm());
            whWmsSkuStockRecord.setOldQuantity(0);
            whWmsSkuStockRecordMapper.insert(whWmsSkuStockRecord);
//            WhWmsSkuStock whWmsSkuStock = new WhWmsSkuStock();
//            whWmsSkuStock.setPhysicalWarehouseCode(record.getPhysicalWarehouseCode());
//            whWmsSkuStock.setShelvesCode(record.getShelvesCode());
//            List<WhWmsSkuStock> whWmsSkuStockList = whWmsSkuStockMapper.getByCond(whWmsSkuStock);
//            int isOccu = 0;
//            if(whWmsSkuStockList != null && whWmsSkuStockList.size() > 0){
//                for(WhWmsSkuStock whWmsSkuStock1:whWmsSkuStockList){
//                    if(whWmsSkuStock1.getAmount() > 0){
//                        isOccu = 1;
//                        break;
//                    }
//                }
//            }
//            WhWmsHouseShelvesExample example = new WhWmsHouseShelvesExample();
//            WhWmsHouseShelvesExample.Criteria criteria = example.createCriteria();
//            criteria.andPhysicalWarehouseCodeEqualTo(record.getPhysicalWarehouseCode());
//            criteria.andCodeEqualTo(record.getShelvesCode());
//            List<WhWmsHouseShelves> whWmsHouseShelvesList = whWmsHouseShelvesMapper.selectByExample(example);
//            if(whWmsHouseShelvesList != null && whWmsHouseShelvesList.size() > 0){
//                WhWmsHouseShelves whWmsHouseShelves = whWmsHouseShelvesList.get(0);
//                int shelveStatus = whWmsHouseShelves.getShelvesStatus() == null?0:whWmsHouseShelves.getShelvesStatus();
//                if(shelveStatus != isOccu){
//                    whWmsHouseShelves.setShelvesStatus(isOccu);
//                    whWmsHouseShelvesMapper.updateByPrimaryKey(whWmsHouseShelves);
//                }
//            }
            record.setStatus(1);
            whWmsSubmitHandRecordMapper.updateByPrimaryKey(record);
            StringBuffer key = new StringBuffer();
            key.append(record.getPhysicalWarehouseCode());
            key.append("_");
            key.append(record.getHouseType());
            key.append("_");
            key.append(record.getBarCode());
            key.append("_");
            key.append(record.getShelvesCode());
            key.append("_");
            key.append(record.getSkuCode());
            key.append("_");
            key.append(record.getSkuStatus());
            WhWmsSubmitHandRecord value = map.get(key.toString());
            if(value == null){
                map.put(key.toString(),record);
            }else{
                value.setAmount(value.getAmount() + record.getAmount());
            }
        }
        for(String key:map.keySet()){
            WhWmsSubmitHandRecord value = map.get(key);
            WhWmsSkuStockVO cond=new WhWmsSkuStockVO();
            cond.setPhysicalWarehouseCode(value.getPhysicalWarehouseCode());
            cond.setHouseType(value.getHouseType());
            cond.setBarCode(value.getBarCode());
            cond.setShelvesCode(value.getShelvesCode());
            cond.setSkuCode(value.getSkuCode());
            cond.setSkuStatus(value.getSkuStatus());
            List<WhWmsSkuStock> list = whWmsSkuStockMapper.getByCond(cond);
            WhWmsSkuStock sk = null;
            if(null!=list && list.size()==1){
                sk=list.get(0);
                if(sk.getAmount() + value.getAmount() < 0){
                    //throw new RuntimeException("库存不足，不可以出库");
                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"["+value.getShelvesCode()+"]["+value.getBarCode()+"]["+WhCommand.getSkuStatusName(value.getSkuStatus())+"]["+(sk.getAmount())+"<"+(-value.getAmount())+"]库存不足，不可以出库");
                }else{
                    int i = 0;
                    boolean isTurn = true;
                    do{
                        int updateCount = whWmsSkuStockMapper.updateStockByPrimaryKey(value.getAmount(),sk.getVersion(),sk.getId());
                        if(i >=3 || updateCount >0){
                            isTurn = false;
                        }else{
                            List<WhWmsSkuStock> newList = whWmsSkuStockMapper.getByCond(cond);
                            if(newList != null && newList.size() > 0){
                                sk = newList.get(0);
                            }
                        }
                        i+= 1;
                    }while(isTurn);
                    if(i > 3){
                        //throw new RuntimeException("库存修改失败");
                        throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"["+value.getShelvesCode()+"]["+value.getBarCode()+"]["+WhCommand.getSkuStatusName(value.getSkuStatus())+"]["+value.getAmount()+"]库存修改失败");
                    }
                }
            }else{
                if(value.getAmount() < 0){
                    //throw new RuntimeException("还没有库存记录不可以出库");
                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"["+value.getShelvesCode()+"]["+value.getBarCode()+"]["+WhCommand.getSkuStatusName(value.getSkuStatus())+"]["+(-value.getAmount())+"]还没有库存记录不可以出库");
                }else{
                    WhWmsSkuStockVO stockVO = new WhWmsSkuStockVO();
                    stockVO.setBarCode(value.getBarCode());
                    stockVO.setSkuCode(value.getSkuCode());
                    stockVO.setVersion(1);
                    stockVO.setAmount(value.getAmount());
                    stockVO.setSkuStatus(value.getSkuStatus());
                    stockVO.setPhysicalWarehouseCode(value.getPhysicalWarehouseCode());
                    stockVO.setHouseType(value.getHouseType());
                    stockVO.setShelvesCode(value.getShelvesCode());
                    whWmsSkuStockMapper.insert(stockVO);
                }
            }
        }
    }
    @Override
	public Boolean checkTmallSku(Long numIid, String outerId, long quantity, String sessionKey) throws Exception {
		
    	if(numIid == null) { //是否有商品
  			throw new WarehouseException(WarehouseExceptionErrorCode.OCCUPY_FAILED_INV_IS_NOT_ENOUGH,
      					"SKU【"+ outerId +"】天猫后台商品异常【不存在商品或者非活动链接】");
      	}
    	
      	if(quantity < 0) { //减库存先查询天猫库存是否充足
      		//库存不足
      		if((pegasusUtilFacade.getSkuQuantity(outerId, sessionKey, numIid) + quantity) < 0) {
      			 throw new WarehouseException(WarehouseExceptionErrorCode.OCCUPY_FAILED_INV_IS_NOT_ENOUGH,
      		                "SKU【"+ outerId +"】天猫后台库存不足，无法调出");
      		}
      	}
		return true;
	}

    @Override
    public String findSalesOrderAddressByCond(String cond) {
        return whCommandMapper.findSalesOrderAddressByCond(cond);
    }

    @Override
    public Integer findSalesOrderTypeByCond(String cond) {
        return whCommandMapper.findSalesOrderTypeByCond(cond);
    }

    @Override
	public boolean cancelAllotRcdCommandByTypeAndReferenceCode(Integer type, String referenceCode) {
		WhCommand whCommand =  findCommandByTypeAndReferenceCode(WhCommand.TYPE_MOVE_OUT, referenceCode, true);
    	if(whCommand != null && whCommand.getWhCommandSkuList() != null) {
    		List<WhReleaseOccupationVO> whReleaseOccupationVOList = new ArrayList<>();
    		for(WhCommandSku whCommandSku : whCommand.getWhCommandSkuList()) {
    			WhReleaseOccupationVO whReleaseOccupationVO = new WhReleaseOccupationVO();
    			whReleaseOccupationVO.setReferenceCode(whCommandSku.getCode());
    			whReleaseOccupationVO.setOccupyType(WhCommand.TYPE_MOVE_OUT);
    		}
    		cancelCommand(whCommand);
    		whInvService.releaseOccupation(whReleaseOccupationVOList);
    	}
		return true;
	}

    @Override
    public Integer autoCloseCommandInEndMonth() {
        return whCommandMapper.autoCloseCommandInEndMonth();
    }

    @Override
    public void updateCommandSku(WhCommandSku whCommandSku) {
        whCommandSkuMapper.updateByPrimaryKeySelective(whCommandSku);
    }

    @Override
    public List<WhCommandSku> findDiffCommandSkuByCommandReferenceCodes(List<String> allotCodeList) {
        return whCommandSkuMapper.findDiffCommandSkuByCommandReferenceCodes(allotCodeList);
    }

    @Override
    public Map<String, String> findReferenceCodesByCommdCodes(List<String> commdCodeList) {
        Map<String, String>  map = new  HashMap<>();
        List<Map> referenceCodeMaps = null;
        if (CollectionUtils.isNotEmpty(commdCodeList)){
            referenceCodeMaps = whCommandMapper.selectReferenceCodesByCommdCodes(commdCodeList);
        }
        if (EmptyUtil.isNotEmpty(referenceCodeMaps)) {
            for (Map referenceCodeMap : referenceCodeMaps) {
                String referenceCode = referenceCodeMap.get("REFERENCE_CODE").toString();
                if(referenceCodeMap.get("IN_OUT_TYPE").toString().equals("15") || referenceCodeMap.get("IN_OUT_TYPE").toString().equals("27")){
                    String taskCode = null;
                    if( referenceCodeMap.get("REFERENCE_CODE").toString().indexOf("TKD") >= 0){
                        WhWmsPrdcJobTaskDetail whWmsPrdcJobTaskDetail = whWmsPrdcJobTaskDetailService.getTaskDetailBycode(referenceCodeMap.get("REFERENCE_CODE").toString());
                        if(whWmsPrdcJobTaskDetail != null){
                            taskCode = whWmsPrdcJobTaskDetail.getTaskCode();
                        }
                    }else if( referenceCodeMap.get("REFERENCE_CODE").toString().indexOf("TK") >= 0){
                        taskCode = referenceCodeMap.get("REFERENCE_CODE").toString();
                    }
                    if(taskCode != null && !taskCode.equals("")){
                        WhWmsPrdcJobTaskVO whWmsPrdcJobTaskVO  = whWmsPrdcJobTaskService.getPrdcJobTaskByTaskCode(taskCode);
                        if(whWmsPrdcJobTaskVO != null){
                            referenceCode = whWmsPrdcJobTaskVO.getPrdcJobCode();
                        }
                    }
                }
                map.put(referenceCodeMap.get("CODE").toString(), referenceCode);
            }
        }
        return  map;
    }

    @Override
    public int updatePlanedDyDateByReCodes(List<WhCommand> whCommandList) {
        return whCommandMapper.updatePlanedDyDateByReCodes(whCommandList);
    }

    @Override
    @Transactional
    public String createAllotRcdAndFinishCommand(WhAllotRcd whAllotRcd, Integer type, boolean fetch) throws Exception {
        String allotCode = whAllotService.createAllotRcd(whAllotRcd);
        WhCommand whCommand = findCommandByTypeAndReferenceCode(type,allotCode,fetch);
        finishCommand(whCommand);
        return allotCode;
    }
}
