package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.WMSConstants;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsHouseShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsMoveStockCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhCommandOutCancelMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.*;
import com.thebeastshop.pegasus.service.warehouse.service.*;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

import java.util.*;

/**
 * Created by Administrator on 2016/10/20.
 */
@Service("whCommandOutCancelService")
public class WhCommandOutCancelServiceImpl implements WhCommandOutCancelService {

    @Autowired
    private WhCommandOutCancelMapper whCommandOutCancelMapper;

    @Autowired
    private WhWmsConnectInfoService whWmsConnectInfoService;

    @Autowired
    private WhWmsCommandCheckService whWmsCommandCheckService;

    @Autowired
    private WhCommandService whCommandService;

    @Autowired WhInfoService whInfoService;

    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;

    @Autowired
    private WhWmsWaitPutawayService whWmsWaitPutawayService;

    @Autowired
    private WhWmsConnectDistributionService whWmsConnectDistributionService;

    @Autowired
    private WhWmsCommandConnectService whWmsCommandConnectService;

    @Autowired
    private WhWmsConnectPickSkuService whWmsConnectPickSkuService;

    @Autowired
    private WhWmsMoveStockService whWmsMoveStockService;

    @Override
    public List<WhCommandOutCancel> findUnHandleCommand() {
        WhCommandOutCancelExample example = new WhCommandOutCancelExample();
        example.createCriteria().andStatusEqualTo(WhCommandOutCancel.STATUS_PENDING);
        List<WhCommandOutCancel> list = whCommandOutCancelMapper.selectByExample(example);
        return list;
    }

    @Override
    @Transactional
    public boolean insert(WhCommandOutCancel whCommandOutCancel){
        whCommandOutCancelMapper.insert(whCommandOutCancel);
        return true;
    }

    @Override
    @Transactional
    public String cancelMakeCommandOnCheckOut(WhWmsMoveStockVO move, WhCommand command) {
        String commandCode = command.getCode();
        WhWmsCommandConnectVO commandConnectVO = whWmsCommandConnectService.findNotCanceledByWhCommandCode(commandCode);
        WhWmsConnectInfoVO connect = whWmsConnectInfoService.findById(commandConnectVO.getConnectId());
        if(NullUtil.isNull(connect)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"波次不存在");
        }
        if(WMSConstants.ConnectType.BULK_ORDER.equals(connect.getConnectType())){
            whWmsConnectPickSkuService.deleteConnectBox(connect.getId());
        }else{
            whWmsConnectDistributionService.deleteConnectDistribution(connect.getId(),commandCode);
        }
//        whCommandService.commandStatusToShortages(commandCode);
        //直接取消指令
        whCommandService.cancelCommandforShortage(commandCode);
        if (!(EmptyUtil.isNotEmpty(command.isNoCreateMoveStock()) && command.isNoCreateMoveStock())){
            whWmsMoveStockService.newMoveStock(move);
            return move.getCode();
        }
        return null;
    }

    @Override
    @Transactional
    public String commandCheckOutByParam(WhWmsCommandCheckPara whWmsCommandCheckPara) {
        WhCommand command =whWmsCommandCheckPara.getCancelCommand();
        WhWmsMoveStockVO move = whWmsCommandCheckPara.getCancelMoveStockVO();
        String commandCode = command.getCode();
        WhWmsCommandConnectVO commandConnectVO = whWmsCommandConnectService.findNotCanceledByWhCommandCode(commandCode);
        WhWmsConnectInfoVO connect = whWmsConnectInfoService.findById(commandConnectVO.getConnectId());
        if(NullUtil.isNull(connect)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"波次不存在");
        }
        whWmsConnectDistributionService.deleteConnectDistribution(connect.getId(),commandCode);
        whCommandService.commandStatusToShortages(commandCode);
        if (!(EmptyUtil.isNotEmpty(command.isNoCreateMoveStock()) && command.isNoCreateMoveStock())){
            whWmsMoveStockService.newMoveStock(move);
            return move.getCode();
        }
        return null;
    }

    @Override
    @Transactional
    public boolean cancelMakeCommandHandover(WhCommand command,Long operatorId) {
        if(NullUtil.isNull(command) || EmptyUtil.isEmpty(command.getWhCommandSkuList())){
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"参数异常");
        }
        String commandCode = command.getCode();
        WhWmsCommandConnectVO commandConnectVO = whWmsCommandConnectService.findNotCanceledByWhCommandCode(commandCode);
        WhWmsConnectInfoVO connect = whWmsConnectInfoService.findById(commandConnectVO.getConnectId());
        if(NullUtil.isNull(connect)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"波次不存在");
        }
        //检查是否已移库
        WhWmsMoveStockCond moveCond = new WhWmsMoveStockCond();
        String dispatchBillCode = command.getReferenceCode().split("_")[0];
        List<String> codes = new ArrayList<>();
        codes.add(dispatchBillCode);
        moveCond.setReferenceCodeList(codes);
        Pagination<WhWmsMoveStockVO> list = whWmsMoveStockService.getMoveStockByCond(moveCond);
        if(EmptyUtil.isEmpty(list)){

            WhPhysicalWarehouse physicalWarehouse = whInfoService.findPhysicalWarehouseByCode(command.getPhysicalWarehouseCode());
            WhWmsHouseShelvesCond shelvesCond = new WhWmsHouseShelvesCond();
            shelvesCond.setPhysicalWarehouseCode(physicalWarehouse.getCode());
            shelvesCond.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_HANDOVER);//交接
            List<WhWmsHouseShelvesVO> shelvesList = whWmsHouseShelvesService.getHouseShelvesByCond(shelvesCond);
            if(EmptyUtil.isEmpty(shelvesList)){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"无可用库位");
            }
            WhWmsHouseShelvesVO oriShelves = shelvesList.get(0);
            String tarShelvesCode = PegasusUtilFacade.getInstance().findCancelStockToShelvesCode(physicalWarehouse.getCode(),connect.getSkuStatus());
            if(EmptyUtil.isEmpty(tarShelvesCode)){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,String.format("[%s][%s]包裹取消移库库位未设置",physicalWarehouse.getCode(),connect.getSkuStatus()));
            }
            WhWmsHouseShelvesVO tarShelves = whWmsHouseShelvesService.getHouseShelvesByCode(tarShelvesCode);
            if(NullUtil.isNull(tarShelves)){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,String.format("[%s]包裹取消移库库位[%s]不存在",physicalWarehouse.getCode(),tarShelvesCode));
            }
            //分拨数据优先
            List<WhWmsMoveSkuVO> moveSkuVOList = buildMoveStockSkuFormDistribution(command,oriShelves,tarShelves);
            if(EmptyUtil.isNotEmpty(moveSkuVOList)){
                List<WhWmsConnectPickSkuVO> pickSkuList = whWmsConnectPickSkuService.findByConnectId(connect.getId());
                if(EmptyUtil.isEmpty(pickSkuList)){
                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"无拣货数据");
                }
                moveSkuVOList = buildMoveStockSku(command.getWhCommandSkuList(),pickSkuList,oriShelves,tarShelves);
            }
            //移库-交接移库需要打移库单
            String moveCode = doMoveStock(command,moveSkuVOList,operatorId);
        }
        //删除周转箱
        whWmsConnectDistributionService.deleteConnectDistribution(connect.getId(),command.getCode());
        //更新指令状态
        //command.setCommandStatus(WhCommand.STATUS_SHORTAGES);
        //whCommandService.updateCommand(command);
//        whCommandService.commandStatusToShortages(commandCode);
        //直接取消
        whCommandService.cancelCommandforShortage(commandCode);
        boolean result = finishCommandOutCancel(commandCode,null);
        if(!result){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,String.format("[%s]指令未取消或已处理",command.getCode()));
        }
        //解绑礼品卡
        whWmsCommandCheckService.unBoundCheckGiftCard(dispatchBillCode);
        return true;
    }

    @Override
    public List<WhWmsMoveSkuVO> buildMoveStockSku(List<WhCommandSku> commandSkuList, List<WhWmsConnectPickSkuVO> picSkuList, WhWmsHouseShelvesVO oriShelves, WhWmsHouseShelvesVO tarShelves) {
        //聚合数据
        Map<String,Set<String>> skuBarcodeMap = new HashMap<>();
        Map<String,List<WhWmsConnectPickSkuVO>> barCodePickMap = new HashMap<>();
        for(WhWmsConnectPickSkuVO pickSku: picSkuList){
            Set<String> barCodes = skuBarcodeMap.get(pickSku.getSkuCode());
            if(NullUtil.isNull(barCodes)){
                barCodes = new HashSet<>();
                skuBarcodeMap.put(pickSku.getSkuCode(),barCodes);
            }
            barCodes.add(pickSku.getBarCode());
            List<WhWmsConnectPickSkuVO> barCodePickList = barCodePickMap.get(pickSku.getBarCode());
            if(NullUtil.isNull(barCodePickList)){
                barCodePickList = new ArrayList<>();
                barCodePickMap.put(pickSku.getBarCode(),barCodePickList);
            }
            barCodePickList.add(pickSku);
        }
        //构建移库行
        List<WhWmsMoveSkuVO> moveSkuList = new ArrayList<>();
        for(WhCommandSku commandSku:commandSkuList){
            Set<String> barCodes = skuBarcodeMap.get(commandSku.getSkuCode());
            if(NullUtil.isNull(barCodes) || barCodes.isEmpty()){
                continue;
            }
            int needAmount = commandSku.getPlanedQuantity();
            for(String barCode : barCodes){
                if(needAmount <= 0){
                    break;
                }
                List<WhWmsConnectPickSkuVO> barCodePickList = barCodePickMap.get(barCode);
                if(EmptyUtil.isEmpty(barCodePickList)){
                    break;
                }
                for(WhWmsConnectPickSkuVO pickSku : barCodePickList){
                    if(needAmount <= 0){
                        break;
                    }
                    if(pickSku.getActualAmount()<= 0){
                        continue;
                    }
                    int moveAmount = pickSku.getActualAmount() >= needAmount?needAmount:pickSku.getActualAmount();
                    pickSku.setActualAmount(pickSku.getActualAmount()-moveAmount);
                    needAmount -= moveAmount;
                    WhWmsMoveSkuVO moveSkuVO = new WhWmsMoveSkuVO();
                    moveSkuVO.setSkuCode(pickSku.getSkuCode());
                    moveSkuVO.setSkuStatus(pickSku.getSkuStatus());
                    moveSkuVO.setBarCode(pickSku.getBarCode());
                    moveSkuVO.setPhysicalWarehouseCode(oriShelves.getPhysicalWarehouseCode());
                    moveSkuVO.setOriginalShelvesCode(oriShelves.getCode());
                    moveSkuVO.setOriginalHouseType(oriShelves.getHouseType());
                    moveSkuVO.setTargetShelvesCode(tarShelves.getCode());
                    moveSkuVO.setTargetHouseType(tarShelves.getHouseType());
                    moveSkuVO.setAmount(moveAmount);
                    moveSkuList.add(moveSkuVO);
                }
            }
        }
        return moveSkuList;
    }

    @Override
    public List<WhWmsMoveSkuVO> buildMoveStockSkuFormDistribution(WhCommand command, WhWmsHouseShelvesVO oriShelves, WhWmsHouseShelvesVO tarShelves) {
        WhWmsCommandConnectVO commandConnectVO = whWmsCommandConnectService.findNotCanceledByWhCommandCode(command.getCode());
        if(commandConnectVO==null){
            return null;
        }
        WhWmsConnectInfoVO connect = whWmsConnectInfoService.findById(commandConnectVO.getConnectId());
        WhWmsConnectDistributionVO distributeCond = new WhWmsConnectDistributionVO();
        distributeCond.setCommandCode(command.getCode());
        distributeCond.setConnectId(connect.getId());
        List<WhWmsConnectDistributionVO> distributeList = whWmsConnectDistributionService.findByCond(distributeCond);
        if(EmptyUtil.isNotEmpty(distributeList)){
            List<WhWmsMoveSkuVO> moveSkuList = new ArrayList<>();
            for(WhWmsConnectDistributionVO distribution : distributeList){
                WhWmsMoveSkuVO moveSkuVO = new WhWmsMoveSkuVO();
                moveSkuVO.setSkuCode(distribution.getSkuCode());
                moveSkuVO.setSkuStatus(distribution.getSkuStatus());
                moveSkuVO.setBarCode(distribution.getBarCode());
                moveSkuVO.setPhysicalWarehouseCode(oriShelves.getPhysicalWarehouseCode());
                moveSkuVO.setOriginalShelvesCode(oriShelves.getCode());
                moveSkuVO.setOriginalHouseType(oriShelves.getHouseType());
                moveSkuVO.setTargetShelvesCode(tarShelves.getCode());
                moveSkuVO.setTargetHouseType(tarShelves.getHouseType());
                moveSkuVO.setAmount(distribution.getDistributAmount());
                moveSkuList.add(moveSkuVO);
            }
            if(EmptyUtil.isNotEmpty(moveSkuList)){
                return moveSkuList;
            }
        }
        return null;
    }

    private String doMoveStock(WhCommand whCommand, List<WhWmsMoveSkuVO> moveSkuList, Long operatorId){
        if(EmptyUtil.isNotEmpty(moveSkuList)){
            WhWmsMoveStockVO move = new WhWmsMoveStockVO();
            move.setMoveSkuList(moveSkuList);
            move.setPhysicalWarehouseCode(moveSkuList.get(0).getPhysicalWarehouseCode());
            move.setCreateUserId(operatorId);
            move.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_CANCEL_MAKE);
            move.setReferenceCode(whCommand.getReferenceCode().split("_")[0]);
            whWmsMoveStockService.newMoveStock(move);
            return move.getCode();
        }
        throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"指令已取消");
    }



    //防止并发错误
    private boolean finishCommandOutCancel(String commandCode,String moveCode){
        WhCommandOutCancelExample example = new WhCommandOutCancelExample();
        example.createCriteria().andCommandCodeEqualTo(commandCode);
        List<WhCommandOutCancel> list = whCommandOutCancelMapper.selectByExample(example);
        if(EmptyUtil.isEmpty(list)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"指令取消不存在");
        }
        WhCommandOutCancel update = new WhCommandOutCancel();
        update.setId(list.get(0).getId());
        update.setStatus(WhCommandOutCancel.STATUS_FINISHED);
        update.setMoveCode(moveCode);
        update.setFinishDate(DateUtil.getNow());
        return whCommandOutCancelMapper.finishCommandOutCancel(update)==1;
        //whCommandOutCancelMapper.updateByPrimaryKeySelective(update);
    }
}
