package com.thebeastshop.pegasus.service.warehouse.service.impl;


import java.util.ArrayList;
import java.util.List;

import com.thebeastshop.pegasus.integration.express.PackageInfo;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.thebeastshop.pegasus.service.warehouse.cond.WhCommandCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhCommandMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandAssociateExpressService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhCommandAssoExpressVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.exception.CommExceptionErrorCode;


/**
 * @author Royan
 * @version $Id: WhAllotServiceImpl.java, v 0.1 2015-07-08 上午11:30
 */
@Service("whCommandAssociateExpressService")
public class WhCommandAssociateExpressServiceImpl implements WhCommandAssociateExpressService{

	private final Logger         log = LoggerFactory.getLogger(WhCommandAssociateExpressServiceImpl.class);

    @Autowired
    private WhCommandMapper      whCommandMapper;

	@Autowired
	private WhCommandService whCommandService;
	
	@Override
	public Boolean commandAssociateExpress(String commandCode,String expressCode) {
		validate(commandCode,expressCode);
		WhCommand command = whCommandService.findCommandByCode(commandCode, false);
        WhCommandAssoExpressVO cond = new WhCommandAssoExpressVO();
        cond.setPackageCode(command.getReferenceCode());
		List<WhCommandAssoExpressVO> infos = whCommandMapper.findCommandAssoExpressInfoByPackageCode(cond);
		if(CollectionUtils.isNotEmpty(infos) && infos.size()==1){
			WhCommandAssoExpressVO statusInfo = infos.get(0);
			if(EmptyUtil.isEmpty(statusInfo.getDeliveryType())  || WhCommandAssoExpressVO.DELIVERY_TYPE_NOT_EXPRESS.equals(statusInfo.getDeliveryType())){
				throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED, "只有配送类型是快递的包裹可以关联快递单");
			}
			if(EmptyUtil.isEmpty(statusInfo.getPackageDeliveryInfoId())){
				throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED, "该包裹没有配送信息无法关联快递单,packageCode:" + command.getReferenceCode());
			}
			if(whCommandMapper.existExpressCode(expressCode,statusInfo.getPackageDeliveryInfoId())>0){
				throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM, "快递单号重复:" + expressCode);
			}
			whCommandMapper.packageAssoExpress(statusInfo.getPackageId(),expressCode);
		}
		return whCommandService.commandAssociateExpress(commandCode,expressCode);
	}

    @Override
	public Boolean batchCommandAssociateExpress(List<WhCommand> whCommands) {
        List<String> commandCodes = new ArrayList<>();
        List<String> expressCodes = new ArrayList<>();
        for (WhCommand whCommand : whCommands){
            commandCodes.add(whCommand.getCode());
            expressCodes.add(whCommand.getReferenceCode());
        }
		validate(commandCodes,expressCodes);
        WhCommandAssoExpressVO cond = new WhCommandAssoExpressVO();
        cond.setPackageCodeList(expressCodes);
		List<WhCommandAssoExpressVO> infos = whCommandMapper.findCommandAssoExpressInfoByPackageCode(cond);
		if(CollectionUtils.isNotEmpty(infos)){
            for (WhCommandAssoExpressVO statusInfo : infos){
                if(EmptyUtil.isEmpty(statusInfo.getDeliveryType())  || WhCommandAssoExpressVO.DELIVERY_TYPE_NOT_EXPRESS.equals(statusInfo.getDeliveryType())){
                    throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED, "只有配送类型是快递的包裹可以关联快递单");
                }
                if(EmptyUtil.isEmpty(statusInfo.getPackageDeliveryInfoId())){
                    throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED, "该包裹没有配送信息无法关联快递单,packageCode:" + statusInfo.getPackageCode());
                }
                if(whCommandMapper.existExpressCode(statusInfo.getPackageCode(),statusInfo.getPackageDeliveryInfoId())>0){
                    throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM, "快递单号重复:" + statusInfo.getPackageCode());
                }
                whCommandMapper.packageAssoExpress(statusInfo.getPackageId(),statusInfo.getPackageCode());
            }
		}
        for (WhCommand whCommand : whCommands){
            whCommandService.commandAssociateExpress(whCommand.getCode(),whCommand.getReferenceCode());
        }
		return true;
	}

    @Override
    public Boolean commandAssociateExpress(String commandCode,String expressCode,String operationSource) {
        validate(commandCode,expressCode,operationSource);
        WhCommand command = whCommandService.findCommandByCode(commandCode, false);
        WhCommandAssoExpressVO cond = new WhCommandAssoExpressVO();
        cond.setPackageCode(command.getReferenceCode());
        List<WhCommandAssoExpressVO> infos = whCommandMapper.findCommandAssoExpressInfoByPackageCode(cond);
        if(CollectionUtils.isNotEmpty(infos) && infos.size()==1){
            WhCommandAssoExpressVO statusInfo = infos.get(0);
//			if(EmptyUtil.isNotEmpty(statusInfo.getPackageStatus()) && !WhCommandAssoExpressVO.PACKAGE_STATUS_WAITING_SEND.equals(statusInfo.getPackageStatus())){
//				throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED, "只有待发货的包裹可以关联快递单");
//			}
            if(EmptyUtil.isEmpty(statusInfo.getDeliveryType())  || WhCommandAssoExpressVO.DELIVERY_TYPE_NOT_EXPRESS.equals(statusInfo.getDeliveryType())){
                throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED, "只有配送类型是快递的包裹可以关联快递单");
            }
            if(EmptyUtil.isEmpty(statusInfo.getPackageDeliveryInfoId())){
                throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED, "该包裹没有配送信息无法关联快递单,packageCode:" + command.getReferenceCode());
            }
            if(whCommandMapper.existExpressCode(expressCode,statusInfo.getPackageDeliveryInfoId())>0){
                throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM, "快递单号重复:" + expressCode);
            }
            whCommandMapper.packageAssoExpress(statusInfo.getPackageId(),expressCode);
        }
        return whCommandService.commandAssociateExpress(commandCode,expressCode,operationSource);
    }
	
	@Override
	public Boolean commandAssociateExpress(WhCommandAssoExpressVO vo) {
		String commandCode = vo.getCommandCode();
		String expressCode = vo.getExpressCode();
		if (NullUtil.isNull(commandCode)) {
			throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM, "无效的出库单号");
		}
		if (EmptyUtil.isEmpty(vo.getDeliveryType())) {
			throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM, "无效的快递类型");
		}
		WhCommand command = whCommandService.findCommandByCode(commandCode, false);
		if(EmptyUtil.isEmpty(command)){
			throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM, "指令无效:" + commandCode);
		}
		//出库单状态判定
		Integer status = command.getCommandStatus();
		if(!WhCommand.STATUS_HANDOVER.equals(status) && !WhCommand.STATUS_DELIVERYCOMPLETION.equals(status)){
			throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,"出货单是必须是待交接状态或发货完成状态,不可操作！");
		}

        if(command.getInOutType().equals(WhCommand.TYPE_SALES_OUT)
                ||command.getInOutType().equals(WhCommand.TYPE_CHANGE_OUT)
                ||command.getInOutType().equals(WhCommand.TYPE_SAMPLE_OUT)
                ||command.getInOutType().equals(WhCommand.TYPE_GIFT_OUT)){
        	//销售出库
        	List<WhCommandAssoExpressVO> infos = new ArrayList<>();
            WhCommandAssoExpressVO cond = new WhCommandAssoExpressVO();
            if(CollectionUtils.isNotEmpty(vo.getPackageCodeList())){
            	cond.setPackageCodeList(vo.getPackageCodeList());
            	infos = whCommandMapper.findCommandAssoExpressInfoByPackageCode(cond);
            }
    		if(EmptyUtil.isEmpty(infos)){
    			throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,"包裹不存在:"+command.getReferenceCode());
    		}
    		WhCommandAssoExpressVO info = infos.get(0);
    		if(EmptyUtil.isEmpty(info.getDeliveryType())  || WhCommandAssoExpressVO.DELIVERY_TYPE_NOT_EXPRESS.equals(info.getDeliveryType())){
    			throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED, "只有配送类型是快递的包裹可以关联快递单");
    		}
    		if(EmptyUtil.isEmpty(info.getPackageDeliveryInfoId()) && EmptyUtil.isNotEmpty(expressCode) ){
    			throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED, "该包裹没有配送信息无法关联快递单,packageCode:" + command.getReferenceCode());
    		}
    		if(EmptyUtil.isNotEmpty(expressCode) && whCommandMapper.existExpressCode(expressCode,info.getPackageDeliveryInfoId())>0){
    			throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM, "快递单号重复:" + expressCode);
    		}
    		if(NullUtil.isNotNull(vo.getExpressCode())){
    			info.setExpressCode(vo.getExpressCode());
    		}

    		// 修改包裹配送信息
    		info.setCommandCode(vo.getCommandCode());
    		info.setDeliveryType(vo.getDeliveryType());
    		info.setPackageCodeList(vo.getPackageCodeList());
    		whCommandMapper.packageAssoExpressWithExpressType(info);
    		// 修改发货单快递类型，快递单号
    		whCommandMapper.dispatchAssoExpressWithExpressType(info);
    		return whCommandService.commandAssociateExpress(info);
        }else if(command.getInOutType().equals(WhCommand.TYPE_ALLOT_OUT)){
        	//调拨
        	return whCommandService.commandAssociateExpress(vo);
        }else if(command.getInOutType().equals(WhCommand.TYPE_PURCHASE_RETURN_OUT)){
        	//采退
        	WhCommand cmd = whCommandService.findCommandByExpressCode(expressCode);
        	if(NullUtil.isNotNull(cmd) && !cmd.getCode().equals(commandCode)){
        		throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM, "快递单号重复:" + expressCode);
        	}
        	vo.setPackageCode(command.getReferenceCode());
        	whCommandMapper.purchaseReturnAssoExpress(vo);
        	return whCommandService.commandAssociateExpress(vo);
        }
		return false;
	}

	@Override
	public Boolean commandAssociateExpressSF(String commandCode, PackageInfo pi) {
		validate(commandCode,pi.getDeliveryCode());
		whCommandMapper.packageAssoExpressSF(pi);
		return whCommandService.commandAssociateExpress(commandCode,pi.getDeliveryCode());
	}

	@Override
	public Boolean commandAssociateExpressFED(String commandCode, PackageInfo pi) {
		validate(commandCode,pi.getDeliveryCode());
		whCommandMapper.packageAssoExpressFED(pi);
		return whCommandService.commandAssociateExpress(commandCode,pi.getDeliveryCode());
	}

	private boolean validate(String commandCode,String expressCode){
		if (NullUtil.isNull(commandCode)) {
			throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM, "无效的出库单号:" + commandCode);
		}
		if (EmptyUtil.isEmpty(expressCode)) {
			throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM, "无效的快递单号:" + expressCode);
		}
		WhCommand command = whCommandService.findCommandByCode(commandCode,false);
		if(NullUtil.isNull(command)){
			throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,"出货单不存在,请联系程序员！");
		}
		//出库单状态判定
		/*Integer status = command.getCommandStatus();
		if(!WhCommand.STATUS_HANDOVER.equals(status)){
			throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,"["+command.getCode()+"]出货单是必须是待交接状态,不可操作！");
		}*/
		return true;
	}

    private boolean validate(List<String> commandCodes,List<String> expressCodes){
        for (String commandCode : commandCodes){
            if (NullUtil.isNull(commandCode)) {
                throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM, "无效的出库单号:" + commandCode);
            }
        }
        for (String expressCode : expressCodes){
            if (EmptyUtil.isEmpty(expressCode)) {
                throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM, "无效的快递单号:" + expressCode);
            }
        }
		List<WhCommand> commands = whCommandService.findCommandByCodes(commandCodes,false);
		if(CollectionUtils.isEmpty(commands)){
			throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,"出货单不存在,请联系程序员！");
		}
        for (WhCommand whCommand : commands){
            //出库单状态判定
            if(!WhCommand.STATUS_HANDOVER.equals(whCommand.getCommandStatus())){
                throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,"["+whCommand.getCode()+"]出货单是必须是待交接状态,不可操作！");
            }
        }
		return true;
	}

	private boolean validate(String commandCode,String expressCode,String operatorSource){
		if (NullUtil.isNull(commandCode)) {
			throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM, "无效的出库单号:" + commandCode);
		}
		if (EmptyUtil.isEmpty(expressCode)) {
			throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM, "无效的快递单号:" + expressCode);
		}
		WhCommandCond cond = new WhCommandCond();
		cond.setCode(commandCode);
		List<WhCommand> commands = whCommandMapper.findCommandByCond(cond);
		WhCommand command = null;
		if(commands!=null&&!commands.isEmpty()){
			command = commands.get(0);
		}else{
			throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,"出货单不存在,请联系程序员！");
		}
		//出库单状态判定  不校验
		/*Integer status = command.getCommandStatus();
		if(!WhCommand.STATUS_HANDOVER.equals(status)){
			throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,"出货单是必须是待交接状态,不可操作！");
		}*/
		return true;
	}

}
