package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.redis.RedisClient;
import com.thebeastshop.pegasus.merchandise.exception.OperationExceptionErrorCode;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCustomVO;
import com.thebeastshop.pegasus.service.warehouse.cond.WhTlBuyerApplyCondVO;
import com.thebeastshop.pegasus.service.warehouse.dao.WhTlBuyerApplyLineMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhTlBuyerApplyMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhTlBuyerPackageLineMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhTlBuyerPackageMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.*;
import com.thebeastshop.pegasus.service.warehouse.service.WhBondedWarehouseAllotApplyService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInvService;
import com.thebeastshop.pegasus.service.warehouse.service.WhTlBuyerPackageService;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import com.thebeastshop.pegasus.util.PegasusConstants;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.pegasus.util.exception.CommExceptionErrorCode;
import com.thebeastshop.stock.dto.SStockOccupyDTO;
import com.thebeastshop.stock.enums.SStockOccupyTypeEnum;
import com.thebeastshop.stock.enums.SStockOperationTypeEnum;
import com.thebeastshop.stock.service.SStockService;
import com.thebeastshop.stock.vo.SOccupyResultVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

import java.util.*;

/**
 * @version V1.0
 * @Description:${todo}(用一句话描述该文件做什么)
 * @author: ljj
 * @date: 2018/10/12 14:51
 */
@Service("whBondedWarehouseAllotApplyService")
public class WhBondedWarehouseAllotApplyServiceImpl implements WhBondedWarehouseAllotApplyService {

    @Autowired
    private WhTlBuyerApplyMapper whTlBuyerApplyMapper;

    @Autowired
    private WhTlBuyerApplyLineMapper whTlBuyerApplyLineMapper;

    @Autowired
    private WhTlBuyerPackageService whTlBuyerPackageService;

    @Autowired
    private WhInvService whInvService;

    @Autowired
    private SStockService sStockService;

    @Autowired
    private McPcsSkuService mcPcsSkuService;



    private final static String ISYSPA = "ISYSPA";

    @Autowired
    private RedisClient redisClient;


    @Override
    @Transactional
    public Integer addOrEditBondedWarehouseAllotApply(BondedWarehouseAllotApplyVO allotApplyVO) {
        StringBuilder sb = new StringBuilder("");
        Boolean buildOccupy = false;
        Integer result = 0;
        if (allotApplyVO.getWhTlBuyerApply().getId() == null) {
            buildOccupy = true;
            result = whTlBuyerApplyMapper.insert(allotApplyVO.getWhTlBuyerApply());
            final Map<String, Object> params = new HashMap<String, Object>();
            params.put("createTime", DateUtil.getNow());
            params.put("id", allotApplyVO.getWhTlBuyerApply().getId());
            String code = CodeGenerator.getInstance().generate("WH_BONDED_WAREHOUSE_APPLY_CODE", params);
            allotApplyVO.getWhTlBuyerApply().setCode(code);
            whTlBuyerApplyMapper.updateByPrimaryKeySelective(allotApplyVO.getWhTlBuyerApply());
            for (WhTlBuyerApplyLine whTlBuyerApplyLine : allotApplyVO.getWhTlBuyerApplyLines()) {
                Boolean skuTitle = true;
                if (null == whTlBuyerApplyLine.getBeastSourceWarehouseInv()) {
                    if (skuTitle) {
                        sb.append("SKU【"+whTlBuyerApplyLine.getSkuCode()+"】"+whTlBuyerApplyLine.getSkuName()+"<br/>");
                        skuTitle = false;
                    }
                    sb.append("源仓库库存不足,");
                } else if (whTlBuyerApplyLine.getBeastSourceWarehouseInv()<whTlBuyerApplyLine.getQuality()) {
                    if (skuTitle) {
                        sb.append("SKU【"+whTlBuyerApplyLine.getSkuCode()+"】"+whTlBuyerApplyLine.getSkuName());
                        skuTitle = false;
                    }
                    sb.append("源仓库库存不足,");
                }
                if (null == whTlBuyerApplyLine.getGaojieWarehouseInv()) {
                    if (skuTitle) {
                        sb.append("SKU【"+whTlBuyerApplyLine.getSkuCode()+"】"+whTlBuyerApplyLine.getSkuName());
                        skuTitle = false;
                    }
                    sb.append("高捷仓库存不足,");
                } else if (whTlBuyerApplyLine.getGaojieWarehouseInv()<whTlBuyerApplyLine.getQuality()) {
                    if (skuTitle) {
                        sb.append("SKU【"+whTlBuyerApplyLine.getSkuCode()+"】"+whTlBuyerApplyLine.getSkuName());
                        skuTitle = false;
                    }
                    sb.append("高捷仓库存不足,");
                }
                whTlBuyerApplyLine.setApplyId(allotApplyVO.getWhTlBuyerApply().getId());
            }
            if (sb.length()>0) {
                throw new WarehouseException("",sb.toString());
            }
            whTlBuyerApplyLineMapper.batchInsertRecord(allotApplyVO.getWhTlBuyerApplyLines());
        } else {
            whTlBuyerApplyMapper.updateByPrimaryKeySelective(allotApplyVO.getWhTlBuyerApply());
            WhTlBuyerApplyLineExample example = new WhTlBuyerApplyLineExample();
            example.createCriteria().andApplyIdEqualTo(allotApplyVO.getWhTlBuyerApply().getId());
            whTlBuyerApplyLineMapper.deleteByExample(example);
            for (WhTlBuyerApplyLine whTlBuyerApplyLine : allotApplyVO.getWhTlBuyerApplyLines()) {
                whTlBuyerApplyLine.setApplyId(allotApplyVO.getWhTlBuyerApply().getId());
            }
            whTlBuyerApplyLineMapper.batchInsertRecord(allotApplyVO.getWhTlBuyerApplyLines());

            //编辑的时候,把原先的释放掉，在重新占用
            List<WhInvOccupy> whInvOccupyList = whInvService.findOccupyQttByReferenceCodeLike(allotApplyVO.getWhTlBuyerApply().getCode());
            List<WhReleaseOccupationVO> whReleaseOccupationVOList = Lists.newArrayList();
            for (WhInvOccupy whInvOccupy : whInvOccupyList) {
                WhReleaseOccupationVO whReleaseOccupationVO = new WhReleaseOccupationVO();
                whReleaseOccupationVO.setOccupyType(SStockOperationTypeEnum.DEFAULT.getId());
                whReleaseOccupationVO.setReferenceCode(whInvOccupy.getReferenceCode());
                whReleaseOccupationVOList.add(whReleaseOccupationVO);
            }
            whInvService.releaseOccupation(whReleaseOccupationVOList);
        }

        //1:占用逻辑仓库存
        final List<SStockOccupyDTO> occupyList = new ArrayList<SStockOccupyDTO>();
        buildWhOccupy(occupyList,allotApplyVO.getWhTlBuyerApplyLines() , SStockOccupyTypeEnum.QT.getCode(),allotApplyVO.getWhTlBuyerApply().getId(),allotApplyVO.getWhTlBuyerApply().getCode());
        try {
            ServiceResp<List<SOccupyResultVO>> serviceResp = sStockService.occupy(occupyList);
            if (serviceResp.isFailure()) {
                throw new WarehouseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
            }
        } catch (final WarehouseException e) {
            throw new WarehouseException(e.getErrorCode(), e.getMessage());
        }


        //2:如果调入仓为[WH02840060]深圳保税仓，且 sku 料件号为空，则生成料件号，生成规则：IS+YSPA+自增 6 位序号，不可重复
        //现在仓库写死，则一定会执行
        if (allotApplyVO.getWhTlBuyerApply().getSourceWarehouseCode().equals("WH20250047")) {
            for (WhTlBuyerApplyLine whTlBuyerApplyLine : allotApplyVO.getWhTlBuyerApplyLines()) {
                mcPcsSkuService.saveOrUpdateItemNumber(whTlBuyerApplyLine.getSkuCode());
            }
        }
        return result;
    }

    /**
     * 占用库存方法需要的list
     *
     * @param occupyList
     * @param occupyType
     */
    private void buildWhOccupy(final List<SStockOccupyDTO>  occupyList, final List<WhTlBuyerApplyLine> applyLineList, final Integer occupyType,Integer applyId,String applyCode) {
        if (CollectionUtils.isEmpty(applyLineList)) {
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED, "构造占用库存的LIST失败,applyLineList不能为空");
        }
        int index = 0;
        for (final WhTlBuyerApplyLine whTlBuyerapplyLine : applyLineList) {
            // 数量小于等于0,报错
            if (whTlBuyerapplyLine.getQuality().compareTo(0) <= 0) {
                continue;
            }
            List<String> warehouseCodeList = Lists.newArrayList();
            warehouseCodeList.add(WhWarehouseVO.WAREHOUSE_WH020600010096);//颛兴路-良品待分配
            warehouseCodeList.add(WhWarehouseVO.WAREHOUSE_WH020600010102);//颛兴路-官网渠道销售仓
            Integer availiableQty = 0;
            Integer warehouse_wh020600010096Inv = 0;
            Integer warehouse_wh020600010102Inv = 0;
            List<WhWarehouseSkuInvVO> whWarehouseSkuInvVOList =whInvService.findWarehousesSkuInvByCond(warehouseCodeList,whTlBuyerapplyLine.getSkuCode());
            for (WhWarehouseSkuInvVO whWarehouseSkuInvVO : whWarehouseSkuInvVOList) {
                availiableQty+=whWarehouseSkuInvVO.getCanUseInv();
                if (whWarehouseSkuInvVO.getWarehouseCode().equals(WhWarehouseVO.WAREHOUSE_WH020600010096)) {
                    warehouse_wh020600010096Inv = whWarehouseSkuInvVO.getCanUseInv();
                } else {
                    warehouse_wh020600010102Inv = whWarehouseSkuInvVO.getCanUseInv();
                }
            }
            if (whTlBuyerapplyLine.getQuality()>availiableQty) {
                throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM, "SKU【"+whTlBuyerapplyLine.getSkuCode()+"】库存不足");
            }
            Boolean needMoreOne = false;
            //优先占用良品待分配仓
            final SStockOccupyDTO whInvOccupy = new SStockOccupyDTO();
            whInvOccupy.setWarehouseCode(WhWarehouseVO.WAREHOUSE_WH020600010096);
            whInvOccupy.setOccupyType(SStockOccupyTypeEnum.getEnumByCode(occupyType));
            whInvOccupy.setReferenceCode(applyCode+"_"+index);
            whInvOccupy.setSkuCode(whTlBuyerapplyLine.getSkuCode());
            if (warehouse_wh020600010096Inv == 0 ) {
                needMoreOne =true;
            } else {
                if (whTlBuyerapplyLine.getQuality() >= warehouse_wh020600010096Inv) {
                    whInvOccupy.setQuantity(warehouse_wh020600010096Inv);
                    needMoreOne = true;
                } else {
                    whInvOccupy.setQuantity(whTlBuyerapplyLine.getQuality());
                }
                whInvOccupy.setOperationType(SStockOperationTypeEnum.DEFAULT);
                occupyList.add(whInvOccupy);
                index++;
            }
            if (needMoreOne) {
                final SStockOccupyDTO whInvOccupy2 = new SStockOccupyDTO();
                whInvOccupy2.setWarehouseCode(WhWarehouseVO.WAREHOUSE_WH020600010102);
                whInvOccupy2.setOccupyType(SStockOccupyTypeEnum.getEnumByCode(occupyType));
                whInvOccupy2.setReferenceCode(applyCode+"_"+index);
                whInvOccupy2.setSkuCode(whTlBuyerapplyLine.getSkuCode());
                whInvOccupy2.setQuantity(whTlBuyerapplyLine.getQuality()-warehouse_wh020600010096Inv);
                whInvOccupy2.setOperationType(SStockOperationTypeEnum.DEFAULT);
                occupyList.add(whInvOccupy2);
                index++;
            }

        }
    }


    @Override
    public Pagination<WhTlBuyerApplyVO> findByCond(WhTlBuyerApplyCondVO whTlBuyerApplyCondVO) {
        Pagination<WhTlBuyerApplyVO> page = new Pagination<>(whTlBuyerApplyCondVO.getCurrpage(), whTlBuyerApplyCondVO.getPagenum());
        Integer count = whTlBuyerApplyMapper.countByCond(whTlBuyerApplyCondVO);
        page.setRecord(count);
        if (NumberUtil.isNullOrZero(count)) return null;
        page.setResultList(whTlBuyerApplyMapper.findByCond(whTlBuyerApplyCondVO));
        return page;
    }

    @Override
    public WhTlBuyerApplyVO findById(Integer id) {
        WhTlBuyerApplyVO vo = whTlBuyerApplyMapper.findById(id);
        List<WhTlBuyerApplyLine> lines = whTlBuyerApplyLineMapper.findByApplyId(id);
        for (Integer i =0 ;i<lines.size();i++) {
            WhTlBuyerApplyLine line = lines.get(i);
            line.setTbIdStr("skuLine_"+line.getSkuCode()+"_"+i);
        }
        vo.setWhTlBuyerApplyLines(lines);
        return vo;
    }

    @Override
    public List<WhTlBuyerApplyVO> findByIds(List<Integer> ids) {
        List<WhTlBuyerApplyVO> vos = whTlBuyerApplyMapper.findByIds(ids);
        for (WhTlBuyerApplyVO whTlBuyerApplyVO : vos) {
            List<WhTlBuyerApplyLine> lines = whTlBuyerApplyLineMapper.findByApplyId(whTlBuyerApplyVO.getId());
            whTlBuyerApplyVO.setWhTlBuyerApplyLines(lines);
        }
        return vos;
    }

    @Override
    public Integer updateApply(WhTlBuyerApply whTlBuyerApply) {
        return whTlBuyerApplyMapper.updateByPrimaryKeySelective(whTlBuyerApply);
    }

    @Override
    @Transactional
    public Integer approveApply(BondedWarehouseAllotApplyVO saveVO) {
        Integer res = 0;
        res = whTlBuyerApplyMapper.updateByPrimaryKeySelective(saveVO.getWhTlBuyerApply());
        if (saveVO.getWhTlBuyerApply().getStatus()!=WhTlBuyerApply.STATUS_REFUSED) {
            whTlBuyerApplyLineMapper.batchUpdate(saveVO.getWhTlBuyerApplyLines());
        }
        return res;
    }

    @Override
    public Integer cancelApply(Integer id) {
        //1：将申请单状态置为取消
        WhTlBuyerApply apply = new WhTlBuyerApply();
        apply.setId(id);
        apply.setStatus(WhTlBuyerApply.STATUS_CANCEL);
        Integer res = whTlBuyerApplyMapper.updateByPrimaryKeySelective(apply);
        WhTlBuyerApplyVO applyVO = whTlBuyerApplyMapper.findById(id);
        //2:释放库存占用
        List<WhReleaseOccupationVO> whReleaseOccupationVOList = Lists.newArrayList();
        List<WhInvOccupy> whInvOccupyList = whInvService.findOccupyQttByReferenceCodeLike(applyVO.getCode());
        for (WhInvOccupy whInvOccupy : whInvOccupyList) {
            WhReleaseOccupationVO whReleaseOccupationVO = new WhReleaseOccupationVO();
            whReleaseOccupationVO.setOccupyType(SStockOperationTypeEnum.DEFAULT.getId());
            whReleaseOccupationVO.setReferenceCode(whInvOccupy.getReferenceCode());
            whReleaseOccupationVOList.add(whReleaseOccupationVO);
        }
        whInvService.releaseOccupation(whReleaseOccupationVOList);
        return res;
    }

    @Override
    public Integer batchPackage(List<Integer> ids,String name,Long operatorId) throws Exception {
        return whTlBuyerPackageService.batchCreatePackageOrder(ids,name,operatorId);
    }

    @Override
    public Integer batchUpdate(List<Integer> applyIds, Integer buyerPackageId) {
        return whTlBuyerApplyMapper.batchUpdate(applyIds,buyerPackageId);
    }
}
