package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageRowBounds;
import com.google.common.collect.Lists;
import com.thebeastshop.commdata.service.ChannelQueryService;
import com.thebeastshop.commdata.vo.ChannelWarehouseVO;
import com.thebeastshop.common.exception.BusinessException;
import com.thebeastshop.pegasus.integration.email.EmailUtil;
import com.thebeastshop.pegasus.integration.email.vo.EmailVO;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuDTO;
import com.thebeastshop.pegasus.service.warehouse.cond.WhAllotStoreApplicationCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhAllotStoreApplicationMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhAllotStoreApplicationSkuMapper;
import com.thebeastshop.pegasus.service.warehouse.enums.WhAllotStoreApplicationRejectTypeEnum;
import com.thebeastshop.pegasus.service.warehouse.enums.WhAllotStoreApplicationStatusEnum;
import com.thebeastshop.pegasus.service.warehouse.enums.WhAllotTypeEnum;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.*;
import com.thebeastshop.pegasus.service.warehouse.service.*;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.Constants;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
import com.thebeastshop.stock.service.SPresaleService;
import com.thebeastshop.stock.service.SStockService;
import com.thebeastshop.stock.vo.SSkuStockVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

import java.util.*;

@Service("whAllotStoreApplicationService")
public class WhAllotStoreApplicationServiceImpl implements WhAllotStoreApplicationService {

  private final static Logger LOGGER = LoggerFactory.getLogger(WhAllotStoreApplicationService.class);

  @Autowired
  private WhAllotStoreApplicationMapper whAllotStoreApplicationMapper;
  @Autowired
  private WhAllotStoreApplicationSkuMapper whAllotStoreApplicationSkuMapper;

  @Autowired
  private SPresaleService sPresaleService;
  @Autowired
  private SStockService sStockService;
  @Autowired
  private McOpChannelService mcOpChannelService;
  @Autowired
  private McPcsSkuService mcPcsSkuService;
  @Autowired
  private WhAllotService whAllotService;
  @Autowired
  private WhInfoService whInfoService;
  @Autowired
  private WhAutoAllotService whAutoAllotService;
  @Autowired
  private TransactionTemplate transactionTemplate;
  @Autowired
  private ChannelQueryService channelQueryService;

  @Autowired
  private WhTakeStockService whTakeStockService;

  @Autowired
  private WhInvService whInvService;





  @Override
  @Transactional
  public int applicationAllot(WhAllotStoreApplicationVO storeApplication) throws Exception {
    WhAllotStoreApplication storeApplicationDO = buildStoreApplicationVO2DO(storeApplication);
    String result =  canApplyAllot(takeOutSkuCode(storeApplication.getSkuList()), storeApplication.getChannelCode());
    if (EmptyUtil.isNotEmpty(result)) {
      throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED, result);
    }
    whAllotStoreApplicationMapper.insertSelective(storeApplicationDO);
    List<WhAllotStoreApplicationSku> skuList = buildStoreApplicationSkuVO2DO(storeApplication.getSkuList());
    setApplicationID2SkuDO(storeApplicationDO.getId(), skuList);
    whAllotStoreApplicationSkuMapper.batchInsert(skuList);
    return storeApplicationDO.getId();
  }

  @Override
  public PageInfo<WhAllotStoreApplicationSkuVO> listApplicationRecord(WhAllotStoreApplicationCond cond) {
    PageRowBounds pageRowBounds = new PageRowBounds(cond.getOffset(), cond.getPagenum());
    PageInfo<WhAllotStoreApplicationSkuVO> pageInfo = new PageInfo<WhAllotStoreApplicationSkuVO>();
    pageInfo.setList(whAllotStoreApplicationSkuMapper.selectByCond(cond, pageRowBounds));
    pageInfo.setTotal(pageRowBounds.getTotal());
    return pageInfo;
  }

  @Override
  public WhAllotStoreApplication findApplicationByKey(Integer id) {
    return whAllotStoreApplicationMapper.selectByPrimaryKey(id);
  }

  @Override
  public PageInfo<WhAllotStoreApplicationSkuVO> listApprovalListByCond(WhAllotStoreApplicationCond cond) {
    cond.setApplicationStatus(WhAllotStoreApplicationStatusEnum.APPROVAL.getStatus());
    PageRowBounds pageRowBounds = new PageRowBounds(cond.getOffset(), cond.getPagenum());
    PageInfo<WhAllotStoreApplicationSkuVO> pageInfo = new PageInfo<WhAllotStoreApplicationSkuVO>();
    List<WhAllotStoreApplicationSkuVO> list = whAllotStoreApplicationSkuMapper.selectApprovalListByCond(cond, pageRowBounds);
    buildApprovalListOtherInfo(list);
    pageInfo.setList(list);
    pageInfo.setTotal(pageRowBounds.getTotal());
    return pageInfo;
  }

  @Override
  public PageInfo<WhAllotStoreApplicationSkuVO> listChannelGroupApplicationBySkuCode(WhAllotStoreApplicationCond cond) {
    cond.setApplicationStatus(WhAllotStoreApplicationStatusEnum.APPROVAL.getStatus());
    PageRowBounds pageRowBounds = new PageRowBounds(cond.getOffset(), cond.getPagenum());
    PageInfo<WhAllotStoreApplicationSkuVO> pageInfo = new PageInfo<WhAllotStoreApplicationSkuVO>();
    List<WhAllotStoreApplicationSkuVO> list = whAllotStoreApplicationSkuMapper.selectChannelGroupApplicationBySkuCode(cond.getSkuCodes().get(0), pageRowBounds);
    buildApprovalListOtherInfo(list);
    pageInfo.setList(list);
    pageInfo.setTotal(pageRowBounds.getTotal());
    return pageInfo;
  }

  @Override
  @Transactional
  public int cancelApplication(Integer applicationLineId, Long cancelPerson) throws Exception {
    int ret = whAllotStoreApplicationSkuMapper.cancelApplication(applicationLineId, cancelPerson);
    if (ret != 1) {
      throw new WarehouseException("", "状态异常，无法取消，请刷新页面重试！");
    }
    return 1;
  }

  @Override
  @Transactional
  public List<WhAllotStoreApplicationSkuVO> approve(WhAllotStoreApplicationApproveVO approveVO,Map<String,WhAllotStoreApplicationSkuRefusedDateVO> skuPurchaseOrderMap) throws Exception {
    List<WhAllotStoreApplicationSkuVO> list = new ArrayList<>();
    if(approveVO.isPass()) {
      list = createAllotRcd(approveVO,skuPurchaseOrderMap);
    } else {
      list = rejectApplication(approveVO,skuPurchaseOrderMap);
    }
    return list;
  }

  //处理列表页审批中的问题 并发送邮件
  private void resolve(List<WhAllotStoreApplicationSkuVO> allotStoreApplicationSkuVOS) {
    String errorMsgResult = new String();
    Map<String,StringBuilder> skuErrorMsgMap = new HashMap<>();
    List<WhAllotStoreApplicationSkuVO> needToSendEmailList = Lists.newArrayList();
    if (CollectionUtils.isNotEmpty(allotStoreApplicationSkuVOS)) {
      Iterator iterator = allotStoreApplicationSkuVOS.iterator();
      while (iterator.hasNext()) {
        WhAllotStoreApplicationSkuVO allotStoreApplicationSkuVO = (WhAllotStoreApplicationSkuVO) iterator.next();
        List<ChannelWarehouseVO> warehouseVOS = channelQueryService.getWarehouseByCode(allotStoreApplicationSkuVO.getChannelCode());
        if (CollectionUtils.isEmpty(warehouseVOS)) {
          //没有渠道品牌仓   记录到需要发邮件的list
          needToSendEmailList.add(allotStoreApplicationSkuVO);
          if (skuErrorMsgMap.get(allotStoreApplicationSkuVO.getChannelCode()+"0")==null) {
            skuErrorMsgMap.put(allotStoreApplicationSkuVO.getChannelCode()+"0",new StringBuilder(allotStoreApplicationSkuVO.getChannelCode()+"未设置渠道分货仓"));
            skuErrorMsgMap.get(allotStoreApplicationSkuVO.getChannelCode()+"0").append("<br/>");
          }
          iterator.remove();
        } else {
          Integer checkMutiply = 0;
          for (ChannelWarehouseVO channelWarehouseVO : warehouseVOS) {
            if (channelWarehouseVO.getType().equals(2)) {
              allotStoreApplicationSkuVO.setWarehouseForChannel(channelWarehouseVO.getCode());
              checkMutiply ++;
            }
          }
          if (checkMutiply ==0) {
            if (skuErrorMsgMap.get(allotStoreApplicationSkuVO.getChannelCode()+"0")==null) {
              skuErrorMsgMap.put(allotStoreApplicationSkuVO.getChannelCode()+"0",new StringBuilder(allotStoreApplicationSkuVO.getChannelCode()+"未设置渠道分货仓"));
              skuErrorMsgMap.get(allotStoreApplicationSkuVO.getChannelCode()+"0").append("<br/>");
            }
            needToSendEmailList.add(allotStoreApplicationSkuVO);
          }
          if (checkMutiply > 1) {
            if (skuErrorMsgMap.get(allotStoreApplicationSkuVO.getChannelCode()+"1")==null) {
              skuErrorMsgMap.put(allotStoreApplicationSkuVO.getChannelCode(),new StringBuilder(allotStoreApplicationSkuVO.getChannelCode()+"存在多个分货仓位"));
              skuErrorMsgMap.get(allotStoreApplicationSkuVO.getChannelCode()).append("<br/>");
            }
          }
        }
      }
      for (Map.Entry<String, StringBuilder> entry : skuErrorMsgMap.entrySet()) {
        errorMsgResult+=entry.getValue().toString();
      }
      if (CollectionUtils.isNotEmpty(needToSendEmailList)) {
        sendEmailForApproveApply(needToSendEmailList,PegasusUtilFacade.getInstance()
                .findConfigByKey("wh.applyApprove.email").getConfigValue());
      }
      if (errorMsgResult.length()>0) {
        throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,errorMsgResult);
      }
    }

  }
  //审批通过分货  若没有满足条件品牌仓 发邮件
  private void sendEmailForApproveApply(List<WhAllotStoreApplicationSkuVO> applicationList, String contactEmails) {
    if (EmptyUtil.isNotEmpty(applicationList)) {
      StringBuffer emailContent = new StringBuffer();
      emailContent.append(
              "<html><style>#table-5 thead th {background-color: rgb(156, 186, 95);color: #fff;border-bottom-width: 0;}");
      emailContent.append("#table-5 td {color: #000;}");
      emailContent.append(
              "#table-5 tr, #table-5 th {border-width: 1px;border-style: solid;border-color: rgb(156, 186, 95);}");
      emailContent.append(
              "#table-5 td, #table-5 th {padding: 5px 10px;font-size: 12px;font-family: Verdana;font-weight: bold;}</style>");
      emailContent.append(
              "<table id='table-5'><caption>门店未配置品牌仓导致无法分货</caption><thead><th>SKU</th><th>渠道</th></thead>");
      emailContent.append("<tbody>");

      for (WhAllotStoreApplicationSkuVO application : applicationList) {
        emailContent.append("<tr>");
        emailContent.append("<td>" + application.getSkuCode() + "</td>");
        emailContent.append("<td>" + application.getChannelCode() + "</td>");
        emailContent.append("</tr>");
      }
      emailContent.append("</tbody></table></html>");
      // 收件人
      String[] toNotifyUsers = contactEmails.split(",");
      // 邮件VO
      EmailVO emailVO = new EmailVO();
      emailVO.setToAddressList(Arrays.asList(toNotifyUsers));
      emailVO.setSubject("审批通过分货未配置品牌仓报错邮件");
      emailVO.setContent(emailContent.toString());
      // 发邮件
      if (CollectionUtils.isNotEmpty(emailVO.getToAddressList())) {
        //邮件发送失败抛出异常
        if(!EmailUtil.getInstance().send(emailVO)) {
          throw  new WarehouseException("审批通过分货未配置品牌仓报错邮件发送失败");
        }
      }
    }
  }

  @Override
  public int batchUpdateSelective(List<WhAllotStoreApplicationSkuVO> recordList) {
    if (EmptyUtil.isEmpty(recordList)) {
      return 0;
    }
    return whAllotStoreApplicationSkuMapper.batchUpdateSelective(BeanUtil.buildListFrom(recordList, WhAllotStoreApplicationSku.class));
  }

  @Override
  @Transactional
  public int batchApprove(List<WhAllotStoreApplicationSkuVO> recordList) {
    if (EmptyUtil.isEmpty(recordList)) {
      return 0;
    }

    for (WhAllotStoreApplicationSkuVO applicationSkuVO : recordList) {
      List<WhAllotStoreApplicationSkuVO> list = new ArrayList<WhAllotStoreApplicationSkuVO>();
      list.add(applicationSkuVO);
      LOGGER.info("审批信息：{}", JSON.toJSONString(applicationSkuVO));
      int rct = whAllotStoreApplicationSkuMapper.batchApprove(BeanUtil.buildListFrom(list, WhAllotStoreApplicationSku.class));
      //部分审批失败
      if (rct == 0) {
        throw new WarehouseException("", "不能重复审批！！");
      }
    }


    return 1;
  }

  @Override
  public Map<String, List<WhAllotStoreApplicationSkuVO>> mapNotNotifyApplication() {
    List<WhAllotStoreApplicationSkuVO> list = whAllotStoreApplicationSkuMapper.selectNotNotifyApplication();
    Map<String, List<WhAllotStoreApplicationSkuVO>> map = new HashMap<String, List<WhAllotStoreApplicationSkuVO>>();
    if (EmptyUtil.isNotEmpty(list)) {
      int listSize = list.size();
      Set<String>  skuCodeSet = new HashSet<String>();
      for (int i = 0 ; i < listSize; i ++) {
        skuCodeSet.add(list.get(i).getSkuCode());
      }
      Map<String, PcsSkuDTO> skuMap = mcPcsSkuService.getSkuNameByCodes(skuCodeSet);
      for (int i = 0 ; i < listSize; i ++) {
        WhAllotStoreApplicationSkuVO storeApplicationSkuVO = list.get(i);
        String channelCode = storeApplicationSkuVO.getChannelCode();

        PcsSkuDTO pcsSkuDTO = skuMap.get(storeApplicationSkuVO.getSkuCode());
        storeApplicationSkuVO.setSkuName(pcsSkuDTO != null ? pcsSkuDTO.getNameCn() : "");
        if (map.containsKey(channelCode)) {
          map.get(channelCode).add(storeApplicationSkuVO);
        } else {
          List<WhAllotStoreApplicationSkuVO> newList = new ArrayList<WhAllotStoreApplicationSkuVO>();
          newList.add(storeApplicationSkuVO);
          map.put(channelCode, newList);
        }
      }
    }
    return map;
  }

  @Override
  public void nofityApplovalResult() {
    Map<String, List<WhAllotStoreApplicationSkuVO>> map  = mapNotNotifyApplication();
    List<String> channelCodes = new ArrayList<String>(map.keySet());
    List<OpChannelVO> opChannelList = mcOpChannelService.findByCode(channelCodes);
    Map<String, String> whOpChannelMap = new HashMap<String, String>();
    Map<String, String> channelWhEmailMap = new HashMap<String, String>();
    if (EmptyUtil.isNotEmpty(opChannelList)) {
      List<String> warehosueCodeList = new ArrayList<String>();
      int listSize = opChannelList.size();
      for (int i = 0 ; i < listSize; i ++) {
        OpChannelVO opChannel = opChannelList.get(i);
        /*whOpChannelMap.put(opChannel.getCode(), opChannel.getWarehouseForSales());
        warehosueCodeList.add(opChannel.getWarehouseForSales());*/
        channelWhEmailMap.put(opChannel.getCode(), opChannel.getNoticeEmails());
      }
     /* Map<String, WhWarehouseVO> warehouseMap = whInfoService.findWarehouseMapByCodes(warehosueCodeList);*/


    /*  for (Map.Entry<String, String> entry : whOpChannelMap.entrySet()) {
        String whCode = entry.getValue();
        WhWarehouseVO warehouseVO = warehouseMap.get(whCode);
        channelWhEmailMap.put(entry.getKey(), warehouseVO != null ? warehouseVO.getContactEmails() : "");
      }*/
      for (final Map.Entry<String, List<WhAllotStoreApplicationSkuVO>> entry : map.entrySet()) {
        String channelCode = entry.getKey();
        final String contactEmails = channelWhEmailMap.get(channelCode);
        try {
          transactionTemplate.execute(new TransactionCallback() {
            @Override
            public Object doInTransaction(TransactionStatus transactionStatus) {
              //先更新通知状态，邮件发送失败可以回滚
              successNotify(entry.getValue());
              sendEmail(entry.getValue(), contactEmails);
              return null;
            }
          });
        } catch (Exception e) {
          LOGGER.error("门店货品申请结果发送邮件失败：{}",channelCode, e);
        }
      }
    }
  }

  @Override
  public String canApplyAllot(List<String> skuCodes, String channelCode) {
    OpChannelVO opChannelVO = mcOpChannelService.findByCode(channelCode);
//    List<String> needAutoAllotSkuCodes = whAutoAllotService.checkWhetherNeedAutoAllot(skuCodes, opChannelVO.getWarehouseForSales());

//    CommGlobalConfig commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("storeAllotApplicationCategory");
//    if (commGlobalConfig == null || EmptyUtil.isEmpty(commGlobalConfig.getConfigValue())) {
//      LOGGER.error("缺少storeAllotApplicationCategory配置");
//      throw new WarehouseException("缺少storeAllotApplicationCategory配置");
//    }

    Map<String, PcsSkuDTO> map = mcPcsSkuService.getSkuNameByCodes(new HashSet<String>(skuCodes));
//    List<String> categoryIds = Arrays.asList(commGlobalConfig.getConfigValue().split(","));

//    List<Long> longCategoryIds = new ArrayList<Long>();
//    int categoryIdCnt = categoryIds.size();
//    for (int i = 0; i < categoryIdCnt; i++) {
//      longCategoryIds.add(Long.valueOf(categoryIds.get(i)));
//    }

    StringBuilder result = new StringBuilder();
    int skuCodeCnt = skuCodes.size();
    for (int i = 0; i < skuCodeCnt; i++) {
      String skuCode = skuCodes.get(i);
      PcsSkuDTO pcsSkuDTO = map.get(skuCode);
//      if (needAutoAllotSkuCodes.contains(skuCode) && !longCategoryIds.contains(pcsSkuDTO.getCategoryId())) {
//        result.append("[").append(skuCode).append("]").append(pcsSkuDTO.getNameCn()).append(", 该商品在自动补货清单中，无法申请</br>");
//      }
      if (pcsSkuDTO.getCrossBorderFlag() != 0) {
        result.append("[").append(skuCode).append("]").append(pcsSkuDTO.getNameCn()).append(", 该商品为跨境商品，不能申请</br>");
      }
      if (pcsSkuDTO.getIsJit() == 1) {
        result.append("[").append(skuCode).append("]").append(pcsSkuDTO.getNameCn()).append(", 该商品为来单商品，不能申请</br>");
      }

//    如果t_op_channel_warehouse中【没有该渠道的品牌仓】的数据，则提示"没有设置分货仓位，无法申请"
      List<ChannelWarehouseVO> warehouseVOS = channelQueryService.getWarehouseByCode(opChannelVO.getCode());
      Boolean flag = false;
      if (CollectionUtils.isEmpty(warehouseVOS)) {
        result.append("没有设置分货仓位，无法申请");
      } else {
        for (ChannelWarehouseVO channelWarehouseVO : warehouseVOS) {
          if (channelWarehouseVO.getType().equals(2)) {
            flag = true;
            break;
          }
        }
      }
      if (!flag) {
        result.append("没有设置分货仓位，无法申请");
      }
    }
    return result.toString();
  }

  @Override
  @Transactional
  public void createAllotsCron() throws Exception {
    //1:查出 WH000254910254、WH000255910255、WH000562910562、WH000563910563仓库的可用库存
    List<String> waitAllotWarhouseCodes = Lists.newArrayList();
    waitAllotWarhouseCodes.add("WH000254910254");
    waitAllotWarhouseCodes.add("WH000255910255");
    waitAllotWarhouseCodes.add("WH000562910562");
    waitAllotWarhouseCodes.add("WH000563910563");
    for (String warehouseCode : waitAllotWarhouseCodes) {
      Map<String, WhInvVO> whInvVOMap = whInvService.findCanUseQttByWarehouseCode(warehouseCode);
      if (!whInvVOMap.isEmpty()) {
        WhAllotRcd whAllotRcd = new WhAllotRcd();
        List<WhPhysicalWarehouseVO> targetWarehouseList = whInfoService.findPhysicalWarehouseByWarehouseCode("WH020600010096");
        if (CollectionUtils.isEmpty(targetWarehouseList)) {
          throw new WarehouseException(WarehouseExceptionErrorCode.WAREHOUSE_NOT_FIND,
                  "逻辑仓["+warehouseCode+"]在逻辑仓分组中找不到对应的物理仓，操作失败");
        }
        List<WhPhysicalWarehouseVO> sourceWarehouseList = whInfoService.findPhysicalWarehouseByWarehouseCode(warehouseCode);
        if (CollectionUtils.isEmpty(sourceWarehouseList)) {
          throw new WarehouseException(WarehouseExceptionErrorCode.WAREHOUSE_NOT_FIND,
                  "逻辑仓["+warehouseCode+"]在逻辑仓分组中找不到对应的物理仓，操作失败");
        }
        whAllotRcd.setAllotType(WhAllotRcd.TYPE_NORMAL);
        whAllotRcd.setTargetPhysicalWarehouseCode(targetWarehouseList.get(0).getCode());
        whAllotRcd.setTargetWarehouseCode("WH020600010096");
        whAllotRcd.setSourcePhysicalWarehouseCode(sourceWarehouseList.get(0).getCode());
        whAllotRcd.setSourceWarehouseCode(warehouseCode);
        whAllotRcd.setReferenceCode("");
        whAllotRcd.setRemark("门店货品申请可用库存自动调拨");
        List<WhAllotRcdSku> whAllotRcdSkuList = Lists.newArrayList();
        for (Map.Entry<String, WhInvVO> entry : whInvVOMap.entrySet()) {
          String skuCode = entry.getKey();
          Integer quality = entry.getValue().getCanUseInv();
          if (quality>0) {
            WhAllotRcdSku whAllotRcdSku = new WhAllotRcdSku();
            whAllotRcdSku.setSkuCode(skuCode);
            whAllotRcdSku.setQuantity(quality);
            whAllotRcdSkuList.add(whAllotRcdSku);
          }
        }
        if (CollectionUtils.isNotEmpty(whAllotRcdSkuList)) {
          whAllotRcd.setWhAllotRcdSkuList(whAllotRcdSkuList);
          whAllotService.createAllotRcd(whAllotRcd);
        }
      }

    }

  }

  private WhAllotRcd buildWhAllotRcd(WhAllotRcd vo,HashMap<String,Integer> map){
    WhAllotRcd whAllotRcd = new WhAllotRcd();
    whAllotRcd.setAllotType(WhAllotRcd.TYPE_NORMAL);
    whAllotRcd.setTargetPhysicalWarehouseCode(vo.getTargetPhysicalWarehouseCode());
    whAllotRcd.setTargetWarehouseCode(vo.getTargetWarehouseCode());
    whAllotRcd.setSourcePhysicalWarehouseCode(vo.getSourcePhysicalWarehouseCode());
    whAllotRcd.setSourceWarehouseCode(vo.getSourceWarehouseCode());
    whAllotRcd.setReferenceCode(vo.getCode());
    whAllotRcd.setRemark(vo.getRemark());

    whAllotRcd.setCreateUserId(vo.getCreateUserId() == null ? 1 : vo.getCreateUserId().intValue());
    List<WhAllotRcdSku> skuList = new ArrayList<>();
    whAllotRcd.setWhAllotRcdSkuList(skuList);
    if(map != null && map.size() > 0){
      for(String key:map.keySet()){
        WhAllotRcdSku whAllotRcdSku = new WhAllotRcdSku();
        whAllotRcdSku.setSkuCode(key);
        whAllotRcdSku.setQuantity(map.get(key));
        skuList.add(whAllotRcdSku);
      }
    }else{
      return  null;
    }
    return whAllotRcd;
  }

  private void sendEmail(List<WhAllotStoreApplicationSkuVO> applicationList, String contactEmails) {
    if (EmptyUtil.isNotEmpty(applicationList)) {
      StringBuffer emailContent = new StringBuffer();
      emailContent.append(
        "<html><style>#table-5 thead th {background-color: rgb(156, 186, 95);color: #fff;border-bottom-width: 0;}");
      emailContent.append("#table-5 td {color: #000;}");
      emailContent.append(
        "#table-5 tr, #table-5 th {border-width: 1px;border-style: solid;border-color: rgb(156, 186, 95);}");
      emailContent.append(
        "#table-5 td, #table-5 th {padding: 5px 10px;font-size: 12px;font-family: Verdana;font-weight: bold;}</style>");
      emailContent.append(
        "<table id='table-5'><thead><th>SKU</th><th>SKU中文名称</th><th>申请数量</th><th>申请人</th><th>申请时间</th><th>审批结果</th></thead>");
      emailContent.append("<tbody>");
      for (WhAllotStoreApplicationSkuVO application : applicationList) {
        emailContent.append("<tr>");
        emailContent.append("<td>" + application.getSkuCode() + "</td>");
        emailContent.append("<td>" + application.getSkuName() + "</td>");
        emailContent.append("<td>" + application.getChannelCnt() + "</td>");
        emailContent.append("<td>" + application.getApplicantName() + "</td>");
        emailContent.append("<td>" + DateUtil.format(application.getApplicationDate(), "yyyy-MM-dd HH:mm:ss") + "</td>");
        emailContent.append("<td>(" + application.getApplicationStatusDesc() + ")</td>");
        emailContent.append("</tr>");
      }
      emailContent.append("</tbody></table></html>");
      // 收件人
      String[] toNotifyUsers = contactEmails.split(",");
      // 邮件VO
      EmailVO emailVO = new EmailVO();
      emailVO.setToAddressList(Arrays.asList(toNotifyUsers));
      emailVO.setSubject("门店货品申请结果");
      emailVO.setContent(emailContent.toString());
      // 发邮件
      if (CollectionUtils.isNotEmpty(emailVO.getToAddressList())) {
        //邮件发送失败抛出异常
        if(!EmailUtil.getInstance().send(emailVO)) {
           throw  new WarehouseException("门店货品申请结果通知邮件发送失败");
        }
      }
    }
  }

  private void  successNotify(List<WhAllotStoreApplicationSkuVO> applicationList) {
    if (EmptyUtil.isNotEmpty(applicationList)) {
      List<WhAllotStoreApplicationSku> poList = BeanUtil.buildListFrom(applicationList, WhAllotStoreApplicationSku.class);
      int listSize = applicationList.size();
      for (int i = 0; i < listSize; i ++) {
        poList.get(i).setIsNotify(true);
      }
      whAllotStoreApplicationSkuMapper.batchUpdateSelective(poList);
    }
  }

  public List<WhAllotStoreApplicationSkuVO> createAllotRcd(WhAllotStoreApplicationApproveVO approveVO,Map<String,WhAllotStoreApplicationSkuRefusedDateVO> skuPurchaseOrderMap) throws Exception {
    List<String> skuCodes = approveVO.getSkuCodes();
    List<WhAllotStoreApplicationSkuVO> list = whAllotStoreApplicationSkuMapper.selectApprovalDetailListBySkuCode(skuCodes, approveVO.getChannelCodes());
    resolve(list);
    List<String> warehouseCodes = Lists.newArrayList();
    Map<String, List<WhAllotStoreApplicationSkuVO>> map = new HashMap<String, List<WhAllotStoreApplicationSkuVO>>();
    List<WhAllotRcd> rcdList = new ArrayList<WhAllotRcd>();
    int listSize = list.size();
    for (int i = 0; i < listSize; i ++) {
      WhAllotStoreApplicationSkuVO applicationSkuVO = list.get(i);
      String skuCode = applicationSkuVO.getSkuCode();
      if (map.containsKey(skuCode)) {
        List<WhAllotStoreApplicationSkuVO> existsList = map.get(skuCode);
        existsList.add(applicationSkuVO);
      } else {
        List<WhAllotStoreApplicationSkuVO> newList = new LinkedList<WhAllotStoreApplicationSkuVO>();
        newList.add(applicationSkuVO);
        map.put(skuCode, newList);
      }
      warehouseCodes.add(applicationSkuVO.getWarehouseForChannel());
    }
    Map<String, Integer> unAllotedCntMap = sPresaleService.mapUnAllotedCntBySkuCode(skuCodes);
//    Map<String, Map<String, SSkuStockVO>> stockMap =  sStockService.getSkuStocks(skuCodes, warehouseCodes);
    Map<String, SSkuStockVO> stockMap =  sStockService.getSkuStocks(skuCodes, Constants.WAREHOUSECODE);
    Map<String, SSkuStockVO> chn2018StockMap = sStockService.getSkuStocks(skuCodes, Constants.CHN2018_WAREHOUSE_CODE);
    for (Map.Entry<String, List<WhAllotStoreApplicationSkuVO>> entry : map.entrySet()) {
      String skuCode = entry.getKey();
      SSkuStockVO skuStockVO = stockMap.get(skuCode);
      SSkuStockVO chn2018SkuStockVO = chn2018StockMap.get(skuCode);
      //颛兴路良品仓可用库存
      int canUseQuantity = skuStockVO.getCanUseQuantity();

      int unAllotedCnt = 0;
      if (EmptyUtil.isNotEmpty(unAllotedCntMap)) {
        unAllotedCnt = unAllotedCntMap.get(skuCode) != null ? unAllotedCntMap.get(skuCode) : 0;
      }
      if(unAllotedCnt < 0){
        unAllotedCnt = 0;
      }
      canUseQuantity = canUseQuantity - unAllotedCnt;
      //官网仓库存
      int chn2018CanUseQuantity = chn2018SkuStockVO.getCanUseQuantity();
      List<WhAllotStoreApplicationSkuVO> applicationList = entry.getValue();
      int applicationListSize = applicationList.size();
      Date approvalTime = new Date();
      for (int i = 0; i < applicationListSize; i ++) {
        WhAllotStoreApplicationSkuVO applicationSkuVO = applicationList.get(i);
        //等下要改
        WhAllotStoreApplicationRcdVO applicationRcdVO = buildWhAllotRcd(canUseQuantity, chn2018CanUseQuantity, applicationSkuVO, approveVO.getApprover());
        applicationSkuVO.setApprovalTime(approvalTime);
        applicationSkuVO.setApprover(approveVO.getApprover());
        if (applicationRcdVO != null) {
            List<WhAllotRcd> whAllotRcds = applicationRcdVO.getRcds();
            if(whAllotRcds != null && whAllotRcds.size() > 0) {
                canUseQuantity = applicationRcdVO.getCanUseQuantity();
                chn2018CanUseQuantity = applicationRcdVO.getChn2018CanUseQuantity();
                rcdList.addAll(whAllotRcds);
                applicationSkuVO.setApplicationStatus(WhAllotStoreApplicationStatusEnum.APPROVED.getStatus());
            }
        } else {
          applicationSkuVO.setApplicationStatus(WhAllotStoreApplicationStatusEnum.REJECT.getStatus());
          applicationSkuVO.setRejectReason(WhAllotStoreApplicationRejectTypeEnum.STOCK_NOT_ENOUGH.getType());
          if (null != skuPurchaseOrderMap.get(applicationSkuVO.getSkuCode())) {
            WhAllotStoreApplicationSkuRefusedDateVO dateVO = skuPurchaseOrderMap.get(applicationSkuVO.getSkuCode());
            applicationSkuVO.setPlanReceiveDate(dateVO.getPlanReceiveDate());
          }
        }
      }
    }
    batchApprove(list);
    whAllotService.createAllotRcds(rcdList);
    return list;
  }

  private final WhAllotStoreApplicationRcdVO buildWhAllotRcd(int canUseQuantity, int chn2018CanUseQuantity
                          , WhAllotStoreApplicationSkuVO applicationSkuVO, Long approver) {

    WhAllotStoreApplicationRcdVO applicationRcdVO = new WhAllotStoreApplicationRcdVO();
    List<WhAllotRcd> rcds = new ArrayList<WhAllotRcd>();
    int totalCanUseQuantity = canUseQuantity + chn2018CanUseQuantity;
    //需要调拨数量
    int needAllotQuantity = applicationSkuVO.getQuantity();
    //总库存不足
    if (totalCanUseQuantity < needAllotQuantity) {
      return  null;
    }
    int allotQuantity = 0;
    int chn2018AllotQuantity = 0;


    if (canUseQuantity >= needAllotQuantity) {
      allotQuantity = needAllotQuantity;
      canUseQuantity -= needAllotQuantity;
      needAllotQuantity = 0;
    } else {
      allotQuantity = canUseQuantity;
      needAllotQuantity = needAllotQuantity - canUseQuantity;
      canUseQuantity = 0;
      if (chn2018CanUseQuantity >= needAllotQuantity &&  needAllotQuantity > 0) {
        chn2018AllotQuantity = needAllotQuantity;
        chn2018CanUseQuantity -= needAllotQuantity;
      }
    }


    if (allotQuantity > 0) {
      WhAllotRcd whAllotRcd = new WhAllotRcd();
      whAllotRcd.setSourcePhysicalWarehouseCode(Constants.PHYSICAL_WAREHOUSE);
      whAllotRcd.setSourceWarehouseCode(Constants.WAREHOUSECODE);
      whAllotRcd.setCreateUserId(approver.intValue());
      whAllotRcd.setTargetPhysicalWarehouseCode(Constants.PHYSICAL_WAREHOUSE);
      whAllotRcd.setTargetWarehouseCode(applicationSkuVO.getWarehouseForChannel());
      whAllotRcd.setAllotType(WhAllotTypeEnum.STORE_ALLOT_APPLICATION.getVal());

      WhAllotRcdSku whAllotRcdSku = new WhAllotRcdSku();
      whAllotRcdSku.setSkuCode(applicationSkuVO.getSkuCode());
      whAllotRcdSku.setQuantity(allotQuantity);
      List<WhAllotRcdSku> whAllotRcdSkuList = new ArrayList<WhAllotRcdSku>();
      whAllotRcdSkuList.add(whAllotRcdSku);
      whAllotRcd.setWhAllotRcdSkuList(whAllotRcdSkuList);
      rcds.add(whAllotRcd);
    }

    if(chn2018AllotQuantity > 0) {
      WhAllotRcd whAllotRcd = new WhAllotRcd();
      whAllotRcd.setSourcePhysicalWarehouseCode(Constants.PHYSICAL_WAREHOUSE);
      whAllotRcd.setSourceWarehouseCode(Constants.CHN2018_WAREHOUSE_CODE);
      whAllotRcd.setCreateUserId(approver.intValue());
      whAllotRcd.setTargetPhysicalWarehouseCode(Constants.PHYSICAL_WAREHOUSE);
      whAllotRcd.setTargetWarehouseCode(applicationSkuVO.getWarehouseForChannel());
      whAllotRcd.setAllotType(WhAllotTypeEnum.STORE_ALLOT_APPLICATION.getVal());

      WhAllotRcdSku whAllotRcdSku = new WhAllotRcdSku();
      whAllotRcdSku.setSkuCode(applicationSkuVO.getSkuCode());
      whAllotRcdSku.setQuantity(chn2018AllotQuantity);
      List<WhAllotRcdSku> whAllotRcdSkuList = new ArrayList<WhAllotRcdSku>();
      whAllotRcdSkuList.add(whAllotRcdSku);
      whAllotRcd.setWhAllotRcdSkuList(whAllotRcdSkuList);
      rcds.add(whAllotRcd);
    }
      applicationRcdVO.setCanUseQuantity(canUseQuantity);
      applicationRcdVO.setChn2018CanUseQuantity(chn2018CanUseQuantity);
      applicationRcdVO.setRcds(rcds);
    return  applicationRcdVO;
  }

  private List<WhAllotStoreApplicationSkuVO> rejectApplication(WhAllotStoreApplicationApproveVO approveVO,Map<String,WhAllotStoreApplicationSkuRefusedDateVO> skuPurchaseOrderMap) {
    List<WhAllotStoreApplicationSkuVO> list = whAllotStoreApplicationSkuMapper.selectApprovalDetailListBySkuCode(approveVO.getSkuCodes(), approveVO.getChannelCodes());
    if (EmptyUtil.isEmpty(list)) {
      throw new WarehouseException("不存在待审批中的记录！");
    }
    int listSize = list.size();
    Date approvalTime = new Date();
    Boolean stockNotEnough = false;
    if (approveVO.getRejectReason().equals((short) 1)) {
      stockNotEnough =true;
    }
    for (int i = 0; i < listSize; i ++) {
      WhAllotStoreApplicationSkuVO applicationSkuVO = list.get(i);
      applicationSkuVO.setApplicationStatus(WhAllotStoreApplicationStatusEnum.REJECT.getStatus());
      applicationSkuVO.setRejectReason(approveVO.getRejectReason());
      applicationSkuVO.setApprover(approveVO.getApprover());
      applicationSkuVO.setApprovalTime(approvalTime);
      applicationSkuVO.setApprover(approveVO.getApprover().longValue());
      applicationSkuVO.setApprovalNote(approveVO.getApprovalNote());
      if (null != skuPurchaseOrderMap.get(applicationSkuVO.getSkuCode()) && stockNotEnough) {
        WhAllotStoreApplicationSkuRefusedDateVO dateVO = skuPurchaseOrderMap.get(applicationSkuVO.getSkuCode());
        applicationSkuVO.setPlanReceiveDate(dateVO.getPlanReceiveDate());
      }
    }
    batchApprove(list);
    return list;
  }

  private final WhAllotStoreApplication buildStoreApplicationVO2DO(WhAllotStoreApplicationVO storeApplication) {
    if (storeApplication == null) {
      throw new BusinessException("storeApplication not be null");
    }
    return BeanUtil.buildFrom(storeApplication, WhAllotStoreApplication.class);
  }

  private  final List<WhAllotStoreApplicationSku> buildStoreApplicationSkuVO2DO(List<WhAllotStoreApplicationSkuVO> storeApplicationSkuVOList) {
    if (storeApplicationSkuVOList == null) {
      throw new BusinessException("storeApplicationSkuVOList not be null");
    }
    return BeanUtil.buildListFrom(storeApplicationSkuVOList, WhAllotStoreApplicationSku.class);
  }

  private final void setApplicationID2SkuDO(Integer applicationId, List<WhAllotStoreApplicationSku> skuList) {
    if (applicationId == null || EmptyUtil.isEmpty(skuList)) {
      throw new BusinessException("applicationId or skuList not be empty");
    }
    int listSize = skuList.size();
    for (int i = 0 ; i < listSize; i ++) {
      skuList.get(i).setApplicationId(applicationId);
    }
  }

  private final void buildApprovalListOtherInfo(List<WhAllotStoreApplicationSkuVO> list) {
    if (EmptyUtil.isNotEmpty(list)) {
      List<String> skuCodeList = new ArrayList<String>();
      int listSize = list.size();
      for (int i = 0 ; i < listSize; i ++) {
        skuCodeList.add(list.get(i).getSkuCode());
      }
      Map<String, Integer> unAllotedCntMap = sPresaleService.mapUnAllotedCntBySkuCode(skuCodeList);
      Map<String, SSkuStockVO> stockMap =  sStockService.getSkuStocks(skuCodeList, Constants.WAREHOUSECODE);
      Map<String, SSkuStockVO> chn2018StockMap = sStockService.getSkuStocks(skuCodeList, Constants.CHN2018_WAREHOUSE_CODE);
      for (int i = 0 ; i < listSize; i ++) {
        WhAllotStoreApplicationSkuVO applicationSkuVO = list.get(i);
        String skuCode = applicationSkuVO.getSkuCode();
        SSkuStockVO chn2018Stock = chn2018StockMap != null ? chn2018StockMap.get(skuCode) : null;
        applicationSkuVO.setOfficialWebsiteQuantity(chn2018Stock != null ? chn2018Stock.getCanUseQuantity() : 0);

        SSkuStockVO skuStockVO = stockMap != null ? stockMap.get(skuCode) : null;
        int unAllotedCnt = unAllotedCntMap.get(skuCode) != null ? unAllotedCntMap.get(skuCode) : 0;
        applicationSkuVO.setGoodWarehouseQuantity(skuStockVO != null ? skuStockVO.getCanUseQuantity() - unAllotedCnt : - unAllotedCnt);
      }
    }
  }

  private List<String> takeOutSkuCode(List<WhAllotStoreApplicationSkuVO> skuList) {
     List<String> skuCodes = new ArrayList<String>();
     int listSize = skuList.size();
     for (int i = 0 ; i < listSize; i ++) {
       skuCodes.add(skuList.get(i).getSkuCode());
     }
    return skuCodes;
  }
}
