/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.validation.Validation;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuService;
import com.thebeastshop.pegasus.service.warehouse.cond.PhyWhStockCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhAllotCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhCommandCond;
import com.thebeastshop.pegasus.service.warehouse.dao.*;
import com.thebeastshop.pegasus.service.warehouse.dao.custom.WhAllotDiffDetailCustomMapper;
import com.thebeastshop.pegasus.service.warehouse.enums.WarehouseCommodityStatusEnum;
import com.thebeastshop.pegasus.service.warehouse.enums.WhAllotTypeEnum;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.*;
import com.thebeastshop.pegasus.service.warehouse.service.*;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import com.thebeastshop.pegasus.util.PegasusConstants;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.*;
import com.thebeastshop.pegasus.util.exception.CommExceptionErrorCode;
import com.thebeastshop.pegasus.util.vo.JdStockSyncResult;
import com.thebeastshop.stock.dto.SStockOccupyDTO;
import com.thebeastshop.stock.dto.SStockReleaseDTO;
import com.thebeastshop.stock.enums.SStockOccupyTypeEnum;
import com.thebeastshop.stock.enums.SStockOperationTypeEnum;
import com.thebeastshop.stock.service.SStockService;
import com.thebeastshop.stock.service.SWhCommandService;
import com.thebeastshop.stock.vo.SOccupyResultVO;
import com.thebeastshop.stock.vo.SWhCommandVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

import java.util.*;

/**
 * @author Royan
 * @version $Id: WhAllotServiceImpl.java, v 0.1 2015-07-08 上午11:30
 */
@Service("whAllotService")
public class WhAllotServiceImpl implements WhAllotService {

    private final Logger        log = LoggerFactory.getLogger(WhAllotServiceImpl.class);

    @Autowired
    private WhAllotRcdMapper    whAllotRcdMapper;

    @Autowired
    private WhAllotRcdSkuMapper whAllotRcdSkuMapper;
    @Autowired
    private WhPreAllotRcdMapper whPreAllotRcdMapper;

    @Autowired
    private WhPreAllotRcdSkuMapper whPreAllotRcdSkuMapper;
    @Autowired
    private WhCommandService    whCommandService;

    @Autowired
    private WhInfoService       whInfoService;
    
    @Autowired
    private WhInvService whInvService;

    @Autowired
    private WhWarehouseGroupService whWarehouseGroupService;

    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;

    @Autowired
    private WhAllotDiffDetailMapper    whAllotDiffDetailMapper;

    @Autowired
    private WhAllotDiffDetailCustomMapper whAllotDiffDetailCustomMapper;

    @Autowired
    private TmallStockLogMapper tmallStockLogMapper;

    @Autowired
    private McPcsSkuService mcPcsSkuService;

    @Autowired
    private SWhCommandService sWhCommandService;

    @Autowired
    private WhWmsConnectAllotPackageService whWmsConnectAllotPackageService;

    @Autowired
    private WhJitPackageSkuReferenceService whJitPackageSkuReferenceService;

    @Autowired
    private WhWmsSkuBarcodeService whWmsSkuBarcodeService;
    @Autowired
    private SStockService sStockService;
    @Autowired
    private TransactionTemplate transactionTemplate;

    private PegasusUtilFacade pegasusUtilFacade = PegasusUtilFacade.getInstance();
     
    /**
     * 创建调拨单
     *
     * @param whAllotRcd 调拨单
     * @return 调拨单号
     */
    @Override
    @Transactional
    public String createAllotRcd(WhAllotRcd whAllotRcd) throws Exception  {
        //检查分组
        checkBeforCreate(Collections.singletonList(whAllotRcd));
        return createAllot(whAllotRcd);
    }

    @Override
    @Transactional
    public String createAllotRcdNoSynTmall(WhAllotRcd whAllotRcd) throws Exception {
        //检查分组
        checkBeforCreate(Collections.singletonList(whAllotRcd));
        return createAllotNoSynTmall(whAllotRcd);
    }


    private String createAllot(WhAllotRcd whAllotRcd) throws Exception{
        StringBuilder synErrorMsg = new StringBuilder("");

        String sourceWarehouseCode = whAllotRcd.getSourceWarehouseCode();
        String targetWarehouseCode = whAllotRcd.getTargetWarehouseCode();

        List<WhAllotRcdSku> whAllotRcdSkuList = whAllotRcd.getWhAllotRcdSkuList();

        if (EmptyUtil.isEmpty(whAllotRcdSkuList)){
            throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM, "调拨行信息不可为空");
        }

        //源仓库存检查
        WhWarehouse sourceWhWarehouse = checkSourcePhyWhSkuStock(whAllotRcd);
        if (EmptyUtil.isEmpty(sourceWhWarehouse)) {
            sourceWhWarehouse = whInfoService.findWarehouseByCode(whAllotRcd.getSourceWarehouseCode());
        }
        //原仓分组
        WhWarehouseGroupVO whGroup = whWarehouseGroupService.findById(sourceWhWarehouse.getWarehouseGroupId(), false);
        whAllotRcd.setAllotStatus(WhAllotRcd.STATUS_WAIT_FOR_CONFIRMATION);
        whAllotRcd.setCreateTime(DateUtil.getNow());
        buildAltEstimatedAllocationDate(whAllotRcd);

        whAllotRcdMapper.insert(whAllotRcd);
        //获取单号
        String code = generatorAltCode(whAllotRcd.getId(),whAllotRcd.getAllotType());

        whAllotRcd.setCode(code);
        whAllotRcdMapper.updateByPrimaryKeySelective(whAllotRcd);

        //----------天猫同步库存修改部分 start --------------
        if (CollectionUtils.isNotEmpty(whAllotRcd.getPcsSkus())){
            for(com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO pcsSkuVO : whAllotRcd.getPcsSkus()){
                // 包含定制商品，不同步天猫平台
                if (EmptyUtil.isNotEmpty(pcsSkuVO.getCanCustomize()) && pcsSkuVO.getCanCustomize()==1){
                    whAllotRcd.setNoSyncOtherPlatform(true);
                    break;
                }
            }
        }
        List<TmallStockLog> successSynTmall = Lists.newArrayList();
        //没有备注，或者备注里包含预售
        // 临时注释，上线再展开
        Boolean buildFlag = true;
        if(EmptyUtil.isEmpty(whAllotRcd.getRemark()) || whAllotRcd.getRemark().indexOf("预售") == -1) {
            //调拨到天猫仓,异步
            if(Constants.warehouseMap.containsKey(targetWarehouseCode) && !whAllotRcd.isNoSyncOtherPlatform()) {
                List<TmallStockLog> list = syncTmallStockAllot(getSyncSkuList(whAllotRcdSkuList, 1), Constants.warehouseMap.get(targetWarehouseCode), code);
                for (TmallStockLog tmallStockLog : list) {
                    if (tmallStockLog.getSyncStatus() == 1) {
                        successSynTmall.add(tmallStockLog);
                    } else {
                        synErrorMsg.append("SKU["+tmallStockLog.getSkuCode()+"]"+tmallStockLog.getRemark()+"\r\n");
                    }
                }
                //whCommandService.syncTmallStock(getSyncSkuList(whAllotRcdSkuList, 1), );
                whAllotRcdSkuList = buildTmallAllotSkus(successSynTmall);
                buildFlag = false;
            }

            //天猫仓库存调出,异步
            if(Constants.warehouseMap.containsKey(sourceWarehouseCode) && !whAllotRcd.isNoSyncOtherPlatform()) {
                List<TmallStockLog> list = syncTmallStockAllot(getSyncSkuList(whAllotRcdSkuList, 0), Constants.warehouseMap.get(sourceWarehouseCode), code);
                for (TmallStockLog tmallStockLog : list) {
                    if (tmallStockLog.getSyncStatus() == 1) {
                        successSynTmall.add(tmallStockLog);
                    } else {
                        synErrorMsg.append("SKU["+tmallStockLog.getSkuCode()+"]"+tmallStockLog.getRemark()+"\r\n");
                    }
                }
                if (buildFlag) {
                    whAllotRcdSkuList = buildTmallAllotSkus(successSynTmall);
                }
            }
        }

        whAllotRcd.setWhAllotRcdSkuList(whAllotRcdSkuList);

        //京东库存同步
        String jdWarningMsg = trySyncJdStock(whAllotRcd);


        List<WhAllotDiffDetailVO> allotDiffDetailVOs = new ArrayList<>();

        Iterator<WhAllotRcdSku> it = whAllotRcdSkuList.iterator();
        while(it.hasNext()){
            WhAllotRcdSku whAllotRcdSku = it.next();
            //若该SKU是同步成功的SKU，则插入调拨行
            whAllotRcdSku.setAllotRcdId(whAllotRcd.getId());
            whAllotRcdSkuMapper.insert(whAllotRcdSku);
            // 如果是调拨差异创建的调拨单，则更新差异处理数量 累加 (具体详情则在 调拨差异详情表查看)
            if (whAllotRcd.isDiffProcess()){
                if (EmptyUtil.isNotEmpty(whAllotRcdSku.getNeedUpdateRefId())){
                    WhAllotRcdSku record = new WhAllotRcdSku();
                    record.setId(whAllotRcdSku.getNeedUpdateRefId());
                    record.setProcessedQuantity(whAllotRcdSku.getQuantity());
                    whAllotRcdSkuMapper.updateProcessedQuantityByPrimaryKey(record);
                }
                // 构建调拨差异详情
                buildAllotDiffDetailVOs(whAllotRcd,whAllotRcdSku,allotDiffDetailVOs);
            }
        }

        if (CollectionUtils.isNotEmpty(allotDiffDetailVOs)){
            whAllotDiffDetailCustomMapper.batchInsert(allotDiffDetailVOs);
        }
        //----------天猫同步库存修改部分 end  ---------------

        WhWarehouse targetWhWarehouse = whInfoService.findWarehouseByCode(targetWarehouseCode);
        Validation.paramNotNull(targetWhWarehouse, "目标逻辑仓为空");
        // 创建耗材调拨时
        WhPhysicalWarehouse targetPhysicalWarehouse = null;
        if(EmptyUtil.isNotEmpty(whAllotRcd.getTargetPhysicalWarehouseCode())){
            targetPhysicalWarehouse = whInfoService.findPhysicalWarehouseByCode(whAllotRcd.getTargetPhysicalWarehouseCode());
        }
        //目标仓分组
        WhWarehouseGroupVO targetWhGroup = whWarehouseGroupService.findById(targetWhWarehouse.getWarehouseGroupId(), false);

        checkWhCommodityStatus(sourceWhWarehouse, whGroup, targetWhWarehouse, targetWhGroup);

        boolean isWarehouseGroupChannelMove = isWarehouseGroupChannelMove(whAllotRcd);
        // 调拨差异处理且物理仓不为“仓库”时，直接完成
        boolean diffProcessAndNoWarehouse = whAllotRcd.isDiffProcess() && NullUtil.isNotNull(targetPhysicalWarehouse)
                && !WhPhysicalWarehouseVO.WAREHOUSE_TYPE_WH_WMS.equals(targetPhysicalWarehouse.getWarehouseType());



        // 如果是定制类型的调拨单，则记录关联包裹及定制信息
        if ((WhAllotRcd.TYPE_CUSTOMIZE_OUT.equals(whAllotRcd.getAllotType()) || WhAllotRcd.TYPE_CUSTOMIZE_IN.equals(whAllotRcd.getAllotType())
                || WhAllotRcd.AUTO_TRANSFER_ALLOT.equals(whAllotRcd.getAllotType()))
                && CollectionUtils.isNotEmpty(whAllotRcd.getJitPackageSkuReferenceVOs())){
            for (WhJitPackageSkuReferenceVO jitPackageSkuReferenceVO : whAllotRcd.getJitPackageSkuReferenceVOs()){
                jitPackageSkuReferenceVO.setReferenceCode(whAllotRcd.getCode());
            }
            whJitPackageSkuReferenceService.createWhJitPackageSkuReference(whAllotRcd.getJitPackageSkuReferenceVOs());
        }

        // 调拨单创建完成后，根据相关单据号 更新来单包裹状态为：完成
        if (EmptyUtil.isNotEmpty(whAllotRcd.getJitPackageSkuRefCode())){
            whJitPackageSkuReferenceService.finishByReferenceCode(whAllotRcd.getJitPackageSkuRefCode());
        }

        String errorMsg = synErrorMsg.toString();
        if(EmptyUtil.isNotEmpty(jdWarningMsg)){
            errorMsg += jdWarningMsg;
        }
        if (CollectionUtils.isEmpty(successSynTmall) && synErrorMsg.length()>0
                || (EmptyUtil.isEmpty(whAllotRcd.getWhAllotRcdSkuList())
                        && EmptyUtil.isNotEmpty(jdWarningMsg)) ) {
            //若没有，删除改调拨单 不继续
            WhAllotRcdSkuExample example = new WhAllotRcdSkuExample();
            example.createCriteria().andAllotRcdIdEqualTo(whAllotRcd.getId());
            whAllotRcdSkuMapper.deleteByExample(example);
            whAllotRcdMapper.deleteByPrimaryKey(whAllotRcd.getId());
            return "创建调拨单失败，失败原因:"+errorMsg.toString();
        }
        //自动分货的调拨单都需要确认（自动分货回调不需要确认）
        if ( whAllotRcd.getAllotType() == WhAllotTypeEnum.AUTO_ALLOT.getVal()
                && !whAllotRcd.getTargetWarehouseCode().equals(Constants.WAREHOUSECODE)) {
            // 需要确认，先占用库存
            // 记录调拨占用
            WhCommand whCommandOut = buildAltOutCommand(whAllotRcd);
            whCommandOut.setInOutType(WhCommand.TYPE_ALLOT_OCCUPY);
            whCommandOut.setExpressNo(whAllotRcd.getCode());
            whCommandService.createCommand(whCommandOut);
        } else {
            // 判断是否库间操作
            if (isWarehouseGroupChannelMove || isWarehouseInnerMove(whAllotRcd)) {
                whAllotRcd.setIsChannelGoods(1);//渠道分货
                boolean cleanCmdPhyWhCode = false;
                if (WhWarehouseGroupVO.WAREHOUSE_NO.equals(whGroup.getType())
                        && NullUtil.isNotNull(sourceWhWarehouse.getCommodityStatus())
                        && sourceWhWarehouse.getCommodityStatus().equals(targetWhWarehouse.getCommodityStatus())) {
                    cleanCmdPhyWhCode = true;
                } else if (isWarehouseGroupChannelMove
                        && WhWarehouseGroupVO.WAREHOUSE_NO.equals(whGroup.getType())
                        && NullUtil.isNotNull(sourceWhWarehouse.getCommodityStatus())
                        && !sourceWhWarehouse.getCommodityStatus().equals(targetWhWarehouse.getCommodityStatus())) {
                    List<WhPhysicalWarehouseVO> phyWhList = whInfoService.findPhysicalWarehouseByGroupId(Collections.singletonList(whGroup.getId()));
                    if (EmptyUtil.isEmpty(phyWhList) || phyWhList.size() > 1) {
                        throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED, "数据异常");
                    }
                    WhPhysicalWarehouseVO phyWh = phyWhList.get(0);
                    //需要扣除物理仓库存
                    whAllotRcd.setSourcePhysicalWarehouseCode(phyWh.getCode());
                    whAllotRcd.setTargetPhysicalWarehouseCode(phyWh.getCode());
                }
                // 记录调拨出库指令
                allotFinishCommand(whAllotRcd,true,cleanCmdPhyWhCode);
            }else if(diffProcessAndNoWarehouse){
                allotFinishCommand(whAllotRcd,false,false);
            }else {
                // 如不需确认
                if (!whAllotRcd.isNeedConfirm()
                        && (StringUtils.isEmpty(whAllotRcd.getConfirmWarehouseCode())
                        && EmptyUtil.isEmpty(whAllotRcd.getConfirmPhysicalWarehouseCode())
                        || (NullUtil.isNotNull(targetPhysicalWarehouse)
                        && NullUtil.isNotNull(targetPhysicalWarehouse.getIsOnline())
                        && targetPhysicalWarehouse.getIsOnline() == PegasusConstants.YES ) ) ) {
                    if (whAllotRcd.isDiffProcess()){
                        whAllotRcd.setNeedWaitInBound(true);
                    }
                    boolean result = updateAllotRcdStatus(whAllotRcd, WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND);
                    if (whAllotRcd.isDiffProcess() && result){
                        // 如果是 调拨差异处理,则继续做出库操作
                        outBoundProcess(whAllotRcd);
                    }
                } else {
                    // 需要确认，先占用库存
                    // 记录调拨占用
                    WhCommand whCommandOut = buildAltOutCommand(whAllotRcd);
                    whCommandOut.setInOutType(WhCommand.TYPE_ALLOT_OCCUPY);
                    whCommandOut.setExpressNo(whAllotRcd.getCode());
                    whCommandService.createCommand(whCommandOut);
                }
            }
        }

        if (errorMsg.length()>0) {
            return code + ":部分SKU调拨失败，失败原因："+errorMsg.toString();
        }
        return code;

    }

    @Override
    public String trySyncJdStock(WhAllotRcd allotRcd){
        if((EmptyUtil.isNotEmpty(allotRcd.getRemark()) && allotRcd.getRemark().contains("预售"))
                || allotRcd.isNoSyncOtherPlatform()){
            return null;
        }
        StringBuilder waringMsg = new StringBuilder();
        //京东库存需扣减
        if(pegasusUtilFacade.needSyncJdStock(allotRcd.getSourceWarehouseCode())){
            String msg = processSyncJdStock(allotRcd,true);
            if(EmptyUtil.isNotEmpty(msg)){
                waringMsg.append(msg);
            }
        }
        //京东库存需增加
        if(pegasusUtilFacade.needSyncJdStock(allotRcd.getTargetWarehouseCode())){
            String msg = processSyncJdStock(allotRcd,false);
            if(EmptyUtil.isNotEmpty(msg)){
                waringMsg.append(msg);
            }
        }
        return waringMsg.toString();
    }

    @Override
    public String trySyncJdStockNew(WhAllotRcd allotRcd, boolean inStorage){
        if((EmptyUtil.isNotEmpty(allotRcd.getRemark()) && allotRcd.getRemark().contains("预售"))
                || allotRcd.isNoSyncOtherPlatform()){
            return null;
        }
        StringBuilder waringMsg = new StringBuilder();
        //京东库存需扣减
        if(pegasusUtilFacade.needSyncJdStock(allotRcd.getSourceWarehouseCode()) && !inStorage){
            String msg = processSyncJdStockNew(allotRcd,true);
            if(EmptyUtil.isNotEmpty(msg)){
                waringMsg.append(msg);
            }
        }
        //京东库存需增加
        if(pegasusUtilFacade.needSyncJdStock(allotRcd.getTargetWarehouseCode()) && inStorage){
            String msg = processSyncJdStockNew(allotRcd,false);
            if(EmptyUtil.isNotEmpty(msg)){
                waringMsg.append(msg);
            }
        }
        return waringMsg.toString();
    }

    private String processSyncJdStockNew(WhAllotRcd allotRcd,boolean out){
        List<WhAllotRcdSku> rcdSkuList = allotRcd.getWhAllotRcdSkuList();
        List<String> referenceCodes = new LinkedList<String>();
        Map<String,Integer> skuQuantityMap = getSyncJdSkuQuantiyMap(rcdSkuList,out, referenceCodes);
        Long operatorId = null;
        if(NullUtil.isNotNull(allotRcd.getCreateUserId())){
            operatorId = allotRcd.getCreateUserId().longValue();
        }
        StringBuilder waringMsg = new StringBuilder();
        if(!skuQuantityMap.isEmpty()){
            Map<String,JdStockSyncResult> syncResultMap = whCommandService.syncJdSkuStock(
                    out?allotRcd.getSourceWarehouseCode():allotRcd.getTargetWarehouseCode()
                    ,skuQuantityMap
                    ,Constants.STOCK_SYNC_TYPE_ALLOT
                    ,referenceCodes
                    ,operatorId);
            Iterator<WhAllotRcdSku> iterator = rcdSkuList.iterator();
            //同步失败需移除
            while (iterator.hasNext()){
                WhAllotRcdSku rcdSku = iterator.next();
                JdStockSyncResult syncResult = syncResultMap.get(rcdSku.getSkuCode());
                if(!syncResult.isSuccess()){
                    iterator.remove();
                    waringMsg.append(String.format("SKU[%s]%s\r\n"
                            ,syncResult.getSkuCode(),syncResult.getErrorMsg()));
                }
            }
        }
        return waringMsg.toString();
    }

    private String processSyncJdStock(WhAllotRcd allotRcd,boolean out){
        List<WhAllotRcdSku> rcdSkuList = allotRcd.getWhAllotRcdSkuList();
        List<String> referenceCodes = new LinkedList<String>();
        referenceCodes.add(allotRcd.getCode());
        Map<String,Integer> skuQuantityMap = getSyncJdSkuQuantiyMap(rcdSkuList,out);
        Long operatorId = null;
        if(NullUtil.isNotNull(allotRcd.getCreateUserId())){
            operatorId = allotRcd.getCreateUserId().longValue();
        }
        StringBuilder waringMsg = new StringBuilder();
        if(!skuQuantityMap.isEmpty()){
            Map<String,JdStockSyncResult> syncResultMap = whCommandService.syncJdSkuStock(
                    out?allotRcd.getSourceWarehouseCode():allotRcd.getTargetWarehouseCode()
                    ,skuQuantityMap
                    ,Constants.STOCK_SYNC_TYPE_ALLOT
                    ,referenceCodes
                    ,operatorId);
            Iterator<WhAllotRcdSku> iterator = rcdSkuList.iterator();
            //同步失败需移除
            while (iterator.hasNext()){
                WhAllotRcdSku rcdSku = iterator.next();
                JdStockSyncResult syncResult = syncResultMap.get(rcdSku.getSkuCode());
                if(!syncResult.isSuccess()){
                    iterator.remove();
                    waringMsg.append(String.format("SKU[%s]%s\r\n"
                            ,syncResult.getSkuCode(),syncResult.getErrorMsg()));
                }
            }
        }
        return waringMsg.toString();
    }


    private Map<String,Integer> getSyncJdSkuQuantiyMap(List<WhAllotRcdSku> rcdSkuList,boolean out){
        Map<String,Integer> skuQuantityMap = new LinkedHashMap<String, Integer>();
        for(WhAllotRcdSku rcdSku : rcdSkuList){
            if(rcdSku.isSyncThridParty()){
                if(out){
                    skuQuantityMap.put(rcdSku.getSkuCode(),-rcdSku.getQuantity());
                }else{
                    skuQuantityMap.put(rcdSku.getSkuCode(),rcdSku.getQuantity());
                }
            }
        }
        return skuQuantityMap;
    }

    private Map<String,Integer> getSyncJdSkuQuantiyMap(List<WhAllotRcdSku> rcdSkuList,boolean out, List<String> referenceCodes){
        Map<String,Integer> skuQuantityMap = new LinkedHashMap<String, Integer>();
        for(WhAllotRcdSku rcdSku : rcdSkuList){
            if(rcdSku.isSyncThridParty()){
                if(out){
                    skuQuantityMap.put(rcdSku.getSkuCode(),-rcdSku.getQuantity());
                }else{
                    skuQuantityMap.put(rcdSku.getSkuCode(),rcdSku.getQuantity());
                }
                referenceCodes.add(rcdSku.getPreOccupyRefCode());
            }
        }
        return skuQuantityMap;
    }

    private List<WhAllotRcdSku> buildTmallAllotSkus(List<TmallStockLog> successSynTmall) {
        List<WhAllotRcdSku> lines = new ArrayList<WhAllotRcdSku>();
        //根据同步成功的记录处理调拨行
        for (TmallStockLog tmallStockLog : successSynTmall) {
            WhAllotRcdSku whAllotRcdSku = new WhAllotRcdSku();
            whAllotRcdSku.setSkuCode(tmallStockLog.getSkuCode());
            whAllotRcdSku.setQuantity(Math.abs(tmallStockLog.getQuantity()));
            whAllotRcdSku.setPreOccupyRefCode(tmallStockLog.getReferenceCode());
            lines.add(whAllotRcdSku);
        }
       return lines;
    }


    private String createAllotNoSynTmall(WhAllotRcd whAllotRcd) throws Exception{
        String sourceWarehouseCode = whAllotRcd.getSourceWarehouseCode();
        String targetWarehouseCode = whAllotRcd.getTargetWarehouseCode();

        List<WhAllotRcdSku> whAllotRcdSkuList = whAllotRcd.getWhAllotRcdSkuList();

        if (EmptyUtil.isEmpty(whAllotRcdSkuList)){
            throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM, "调拨行信息不可为空");
        }

        //源仓库存检查
        WhWarehouse sourceWhWarehouse = checkSourcePhyWhSkuStock(whAllotRcd);
        if (EmptyUtil.isEmpty(sourceWhWarehouse)) {
            sourceWhWarehouse = whInfoService.findWarehouseByCode(whAllotRcd.getSourceWarehouseCode());
        }
        //原仓分组
        WhWarehouseGroupVO whGroup = whWarehouseGroupService.findById(sourceWhWarehouse.getWarehouseGroupId(), false);
        whAllotRcd.setAllotStatus(WhAllotRcd.STATUS_WAIT_FOR_CONFIRMATION);
        whAllotRcd.setCreateTime(DateUtil.getNow());
        buildAltEstimatedAllocationDate(whAllotRcd);

        whAllotRcdMapper.insert(whAllotRcd);
        //获取单号
        String code = generatorAltCode(whAllotRcd.getId(),whAllotRcd.getAllotType());

        whAllotRcd.setCode(code);
        whAllotRcdMapper.updateByPrimaryKeySelective(whAllotRcd);


        List<WhAllotDiffDetailVO> allotDiffDetailVOs = new ArrayList<>();
        for (WhAllotRcdSku whAllotRcdSku : whAllotRcdSkuList) {
            //若该SKU是同步成功的SKU，则插入调拨行
            whAllotRcdSku.setAllotRcdId(whAllotRcd.getId());
            whAllotRcdSkuMapper.insert(whAllotRcdSku);
            // 如果是调拨差异创建的调拨单，则更新差异处理数量 累加 (具体详情则在 调拨差异详情表查看)
            if (whAllotRcd.isDiffProcess()){
                if (EmptyUtil.isNotEmpty(whAllotRcdSku.getNeedUpdateRefId())){
                    WhAllotRcdSku record = new WhAllotRcdSku();
                    record.setId(whAllotRcdSku.getNeedUpdateRefId());
                    record.setProcessedQuantity(whAllotRcdSku.getQuantity());
                    whAllotRcdSkuMapper.updateProcessedQuantityByPrimaryKey(record);
                }
                // 构建调拨差异详情
                buildAllotDiffDetailVOs(whAllotRcd,whAllotRcdSku,allotDiffDetailVOs);
            }
        }
        if (CollectionUtils.isNotEmpty(allotDiffDetailVOs)){
            whAllotDiffDetailCustomMapper.batchInsert(allotDiffDetailVOs);
        }

        WhWarehouse targetWhWarehouse = whInfoService.findWarehouseByCode(targetWarehouseCode);
        Validation.paramNotNull(targetWhWarehouse, "目标逻辑仓为空");
        // 创建耗材调拨时
        WhPhysicalWarehouse targetPhysicalWarehouse = null;
        if(EmptyUtil.isNotEmpty(whAllotRcd.getTargetPhysicalWarehouseCode())){
            targetPhysicalWarehouse = whInfoService.findPhysicalWarehouseByCode(whAllotRcd.getTargetPhysicalWarehouseCode());
        }
        //目标仓分组
        WhWarehouseGroupVO targetWhGroup = whWarehouseGroupService.findById(targetWhWarehouse.getWarehouseGroupId(), false);

        checkWhCommodityStatus(sourceWhWarehouse, whGroup, targetWhWarehouse, targetWhGroup);

        boolean isWarehouseGroupChannelMove = isWarehouseGroupChannelMove(whAllotRcd);
        // 调拨差异处理且物理仓不为“仓库”时，直接完成
        boolean diffProcessAndNoWarehouse = whAllotRcd.isDiffProcess() && NullUtil.isNotNull(targetPhysicalWarehouse)
                && !WhPhysicalWarehouseVO.WAREHOUSE_TYPE_WH_WMS.equals(targetPhysicalWarehouse.getWarehouseType());

        //自动分货的调拨单都需要确认（自动分货回调不需要确认）
        if ( whAllotRcd.getAllotType() == WhAllotTypeEnum.AUTO_ALLOT.getVal()
                && !whAllotRcd.getTargetWarehouseCode().equals(Constants.WAREHOUSECODE)) {
            // 需要确认，先占用库存
            // 记录调拨占用
            WhCommand whCommandOut = buildAltOutCommand(whAllotRcd);
            whCommandOut.setInOutType(WhCommand.TYPE_ALLOT_OCCUPY);
            whCommandOut.setExpressNo(whAllotRcd.getCode());
            whCommandService.createCommand(whCommandOut);
        } else {
            // 判断是否库间操作
            if (isWarehouseGroupChannelMove || isWarehouseInnerMove(whAllotRcd)) {
                whAllotRcd.setIsChannelGoods(1);//渠道分货
                boolean cleanCmdPhyWhCode = false;
                if (WhWarehouseGroupVO.WAREHOUSE_NO.equals(whGroup.getType())
                        && NullUtil.isNotNull(sourceWhWarehouse.getCommodityStatus())
                        && sourceWhWarehouse.getCommodityStatus().equals(targetWhWarehouse.getCommodityStatus())) {
                    cleanCmdPhyWhCode = true;
                } else if (isWarehouseGroupChannelMove
                        && WhWarehouseGroupVO.WAREHOUSE_NO.equals(whGroup.getType())
                        && NullUtil.isNotNull(sourceWhWarehouse.getCommodityStatus())
                        && !sourceWhWarehouse.getCommodityStatus().equals(targetWhWarehouse.getCommodityStatus())) {
                    List<WhPhysicalWarehouseVO> phyWhList = whInfoService.findPhysicalWarehouseByGroupId(Collections.singletonList(whGroup.getId()));
                    if (EmptyUtil.isEmpty(phyWhList) || phyWhList.size() > 1) {
                        throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED, "数据异常");
                    }
                    WhPhysicalWarehouseVO phyWh = phyWhList.get(0);
                    //需要扣除物理仓库存
                    whAllotRcd.setSourcePhysicalWarehouseCode(phyWh.getCode());
                    whAllotRcd.setTargetPhysicalWarehouseCode(phyWh.getCode());
                }
                // 记录调拨出库指令
                allotFinishCommand(whAllotRcd,true,cleanCmdPhyWhCode);
            }else if(diffProcessAndNoWarehouse){
                allotFinishCommand(whAllotRcd,false,false);
            }else {
                // 如不需确认
                if (!whAllotRcd.isNeedConfirm()
                        && (StringUtils.isEmpty(whAllotRcd.getConfirmWarehouseCode())
                        && EmptyUtil.isEmpty(whAllotRcd.getConfirmPhysicalWarehouseCode())
                        || (NullUtil.isNotNull(targetPhysicalWarehouse)
                        && NullUtil.isNotNull(targetPhysicalWarehouse.getIsOnline())
                        && targetPhysicalWarehouse.getIsOnline() == PegasusConstants.YES ) ) ) {
                    if (whAllotRcd.isDiffProcess()){
                        whAllotRcd.setNeedWaitInBound(true);
                    }
                    boolean result = updateAllotRcdStatus(whAllotRcd, WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND);
                    if (whAllotRcd.isDiffProcess() && result){
                        // 如果是 调拨差异处理,则继续做出库操作
                        outBoundProcess(whAllotRcd);
                    }
                } else {
                    // 需要确认，先占用库存
                    // 记录调拨占用
                    WhCommand whCommandOut = buildAltOutCommand(whAllotRcd);
                    whCommandOut.setInOutType(WhCommand.TYPE_ALLOT_OCCUPY);
                    whCommandOut.setExpressNo(whAllotRcd.getCode());
                    whCommandService.createCommand(whCommandOut);
                }
            }
        }

        // 如果是定制类型的调拨单，则记录关联包裹及定制信息
        if ((WhAllotRcd.TYPE_CUSTOMIZE_OUT.equals(whAllotRcd.getAllotType()) || WhAllotRcd.TYPE_CUSTOMIZE_IN.equals(whAllotRcd.getAllotType())
                || WhAllotRcd.AUTO_TRANSFER_ALLOT.equals(whAllotRcd.getAllotType()))
                && CollectionUtils.isNotEmpty(whAllotRcd.getJitPackageSkuReferenceVOs())){
            for (WhJitPackageSkuReferenceVO jitPackageSkuReferenceVO : whAllotRcd.getJitPackageSkuReferenceVOs()){
                jitPackageSkuReferenceVO.setReferenceCode(whAllotRcd.getCode());
            }
            whJitPackageSkuReferenceService.createWhJitPackageSkuReference(whAllotRcd.getJitPackageSkuReferenceVOs());
        }

        // 调拨单创建完成后，根据相关单据号 更新来单包裹状态为：完成
        if (EmptyUtil.isNotEmpty(whAllotRcd.getJitPackageSkuRefCode())){
            whJitPackageSkuReferenceService.finishByReferenceCode(whAllotRcd.getJitPackageSkuRefCode());
        }
        return code;


    }

    /**
     * 检查调拨仓库 商品状态
     */
    private void checkWhCommodityStatus(WhWarehouse sourceWhWarehouse, WhWarehouseGroupVO sourceWhGroup,
                                        WhWarehouse targetWhWarehouse, WhWarehouseGroupVO targetWhGroup) {

        Integer sourceCommodityStatus = sourceWhWarehouse.getCommodityStatus();
        Integer targetCommodityStatus = targetWhWarehouse.getCommodityStatus();

        boolean sameCommodityStatus = true;
        //不同物理仓调拨才校验商品状态
        if (!sourceWhWarehouse.getPhysicalWarehouseId().equals(targetWhWarehouse.getPhysicalWarehouseId())) {
            if (sourceWhGroup.getType().equals(targetWhGroup.getType())) {
                //源仓库与目标仓库逻辑仓的商品状态必须一致
                if (!sourceCommodityStatus.equals(targetCommodityStatus)) {
                    sameCommodityStatus = false;
                }
            } else {
                if ((WhWarehouseVO.NOT_DEFECTIVE_COMMODITY_STATUS_DETAIL_MAP.containsKey(sourceCommodityStatus))
                    && !sourceCommodityStatus.equals(targetCommodityStatus)) {
                    sameCommodityStatus = false;
                }

                if ((sourceCommodityStatus.equals(WarehouseCommodityStatusEnum.LIGHT_RESIDUE.getKey())
                     || sourceCommodityStatus.equals(WarehouseCommodityStatusEnum.MIDDLE_RESIDUE.getKey())
                     || sourceCommodityStatus.equals(WarehouseCommodityStatusEnum.HEAVY_RESIDUE.getKey()))
                    && (WhWarehouseVO.NOT_DEFECTIVE_COMMODITY_STATUS_DETAIL_MAP.containsKey(targetCommodityStatus))
                    ) {
                    sameCommodityStatus = false;
                }
            }
        }


        //源仓库与目标仓库逻辑仓的商品状态必须一致
        if (!sameCommodityStatus) {
            throw new WarehouseException(
              WarehouseExceptionErrorCode.ILLEGAL_PARAM,
              String.format("逻辑仓[%s]%s,[%s]%s 商品状态不一致，不能调拨"
                , sourceWhWarehouse.getCode()
                , sourceWhWarehouse.getName()
                , targetWhWarehouse.getCode()
                , targetWhWarehouse.getName())
            );
        }

        Integer sourceWhType = sourceWhGroup.getType();
        Integer targetWhType = targetWhGroup.getType();

        //非仓库往仓库调拨，且源仓库逻辑仓商品状态为残次时，目标仓逻辑仓只能选择商品状态为轻残的
        if (sourceWhType.equals(WhWarehouseGroupVO.WAREHOUSE_NO)
            && targetWhType.equals(WhWarehouseGroupVO.WAREHOUSE_YES)
            && (sourceCommodityStatus.equals(WarehouseCommodityStatusEnum.LIGHT_RESIDUE.getKey()))) {
            if (!targetCommodityStatus.equals(WarehouseCommodityStatusEnum.LIGHT_RESIDUE.getKey())) {
                throw new WarehouseException(
                  WarehouseExceptionErrorCode.ILLEGAL_PARAM,
                  String.format("非仓库往仓库调拨，且源仓库逻辑仓商品状态为残次时，目标仓逻辑仓只能选择商品状态为轻残的")
                );
            }
        }

        if (sourceWhType.equals(WhWarehouseGroupVO.WAREHOUSE_YES)
            && targetWhType.equals(WhWarehouseGroupVO.WAREHOUSE_NO)
            && (sourceCommodityStatus.equals(WarehouseCommodityStatusEnum.LIGHT_RESIDUE.getKey())
                || sourceCommodityStatus.equals(WarehouseCommodityStatusEnum.MIDDLE_RESIDUE.getKey())
                || sourceCommodityStatus.equals(WarehouseCommodityStatusEnum.HEAVY_RESIDUE.getKey()))) {
            if (!targetCommodityStatus.equals(WarehouseCommodityStatusEnum.LIGHT_RESIDUE.getKey())) {
                throw new WarehouseException(
                  WarehouseExceptionErrorCode.ILLEGAL_PARAM,
                  String.format("仓库往非仓库调拨，且源仓库逻辑仓商品状态为轻残、中残、重残时，目标仓逻辑仓只能选择商品状态为残次的")
                );
            }
        }
    }

    /**
     * 调拨完成指令
     * @param whAllotRcd 调拨信息
     * @param isMoveOpt 是否是库间操作 ture:库间操作 false:调拨操作
     * @param cleanCmdPhyWhCode 是否扣减物理仓库存
     * @throws Exception
     */
    private void allotFinishCommand(WhAllotRcd whAllotRcd,boolean isMoveOpt,boolean cleanCmdPhyWhCode) throws Exception{
        // 记录调拨出库指令
        WhCommand whCommandOut = buildAltOutCommand(whAllotRcd);
        if (isMoveOpt){
            whCommandOut.setInOutType(WhCommand.TYPE_MOVE_OUT);//库间移动
        }
        //调拨类型
        Integer allotType = whAllotRcd.getAllotType();
        String outCmdCode = null;
        //线上自动分货已经预占用了库存
        if (WhAllotTypeEnum.AUTO_ALLOT_ONLINE.getVal() == allotType) {
            outCmdCode = whCommandService.createCommandAfterReleasePreOccupy(whCommandOut, whAllotRcd.getPreOccupyReleaseList());
        } else {
            outCmdCode = whCommandService.createCommand(whCommandOut);
        }
        WhCommand tmpCmdOut = whCommandService.findCommandByCode(outCmdCode, false);
        if (cleanCmdPhyWhCode) {
            tmpCmdOut.setPhysicalWarehouseCode(null);//不扣减物理仓库存
        }
        if (EmptyUtil.isNotEmpty(whAllotRcd.getCreateUserId())) {
            tmpCmdOut.setOperatorId(whAllotRcd.getCreateUserId().longValue());
        } else {
            tmpCmdOut.setOperatorId(1L);
        }
        tmpCmdOut.setNoUpdateAllot(true);
        whCommandService.finishCommand(tmpCmdOut);
        // 记录调拨入库指令
        WhCommand whCommandIn = buildAltInCommand(whAllotRcd);
        if (isMoveOpt){
            whCommandIn.setInOutType(WhCommand.TYPE_MOVE_IN);//库间移动
        }
        String inCmdCode = whCommandService.createCommand(whCommandIn);
        WhCommand tmpCmdIn = whCommandService.findCommandByCode(inCmdCode, false);
        if (cleanCmdPhyWhCode) {
            tmpCmdIn.setPhysicalWarehouseCode(null);//不扣减物理仓库存
        }
        /*if (EmptyUtil.isNotEmpty(whAllotRcd.getCreateUserId())) {
            tmpCmdIn.setOperatorId(whAllotRcd.getCreateUserId().longValue());
        } else {
            tmpCmdOut.setOperatorId(1L);
        }*/
        tmpCmdIn.setOperatorId(tmpCmdOut.getOperatorId());
        tmpCmdIn.setNoUpdateAllot(true);
        whCommandService.finishCommand(tmpCmdIn);
        // 设置完成
        whAllotRcd.setAllotStatus(WhAllotRcd.STATUS_FINISHED);
        whAllotRcd.setFinishTime(new Date());
        whAllotRcdMapper.updateByPrimaryKeySelective(whAllotRcd);
    }


    private List<SStockReleaseDTO> buildAllotPreOccupyReleaseList(WhAllotRcd whAllotRcd){
        List<SStockReleaseDTO> releaseList = new ArrayList<SStockReleaseDTO>();
        if (whAllotRcd != null) {
            List<WhAllotRcdSku>  rcdSkuList = whAllotRcd.getWhAllotRcdSkuList();
            for (WhAllotRcdSku rcdSku : rcdSkuList) {
              SStockReleaseDTO  releaseDTO = new SStockReleaseDTO(SStockOccupyTypeEnum.ALLOT_PRE_OCCUPY);
              releaseDTO.setReferenceCode(rcdSku.getPreOccupyRefCode());
              releaseDTO.setOperationType(SStockOperationTypeEnum.DEFAULT);
              releaseList.add(releaseDTO);
            }
        }
        return releaseList;
    }

    /**
     * 调拨完成指令
     * @param whAllotRcd 调拨信息
     * @param isMoveOpt 是否是库间操作 ture:库间操作 false:调拨操作
     * @param cleanCmdPhyWhCode 是否扣减物理仓库存
     * @throws Exception
     */
    private void finishAllotRcdCommand(WhAllotRcd whAllotRcd,boolean isMoveOpt,boolean cleanCmdPhyWhCode) throws Exception{

        WhCommand whCommandOut = whCommandService.findCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_OCCUPY, whAllotRcd.getCode(), true);
        if (EmptyUtil.isEmpty(whCommandOut)) {
            // 记录调拨出库指令
            whCommandOut = buildAltOutCommand(whAllotRcd);
        } else {
            whCommandOut.setInOutType(WhCommand.TYPE_ALLOT_OUT);

            if (isMoveOpt){
                whCommandOut.setInOutType(WhCommand.TYPE_MOVE_OUT);//库间移动
            }
            whCommandOut.setPlanedDeliveryDate(whAllotRcd.getEstimatedAllocationDate());//冗余预计发货日期
            sWhCommandService.updateWhCommandByKey(BeanUtil.buildFrom(whCommandOut, SWhCommandVO.class));
            List<WhCommandSku> commandSkuList = whCommandOut.getWhCommandSkuList();
            if(EmptyUtil.isNotEmpty(commandSkuList)) {
                for(WhCommandSku whCommandSku : commandSkuList) {
                    WhInvOccupy record = new WhInvOccupy();
                    record.setReferenceCode(whCommandSku.getCode());
                    record.setOccupyType(WhCommand.TYPE_ALLOT_OUT);
                    if (isMoveOpt){
                        record.setOccupyType(WhCommand.TYPE_MOVE_OUT);
                    }
                    whInvService.updateOccupyType(record);
                }
            }
        }

        //String outCmdCode = whCommandService.createCommand(whCommandOut);
        WhCommand tmpCmdOut = whCommandService.findCommandByCode(whCommandOut.getCode(), false);
        if (cleanCmdPhyWhCode) {
            tmpCmdOut.setPhysicalWarehouseCode(null);//不扣减物理仓库存
        }
        if (EmptyUtil.isNotEmpty(whAllotRcd.getCreateUserId())) {
            tmpCmdOut.setOperatorId(whAllotRcd.getCreateUserId().longValue());
        } else {
            tmpCmdOut.setOperatorId(1L);
        }

        tmpCmdOut.setNoUpdateAllot(true);
        whCommandService.finishCommand(tmpCmdOut);
        // 记录调拨入库指令
        WhCommand whCommandIn = buildAltInCommand(whAllotRcd);
        if (isMoveOpt){
            whCommandIn.setInOutType(WhCommand.TYPE_MOVE_IN);//库间移动
        }
        String inCmdCode = whCommandService.createCommand(whCommandIn);
        WhCommand tmpCmdIn = whCommandService.findCommandByCode(inCmdCode, false);
        if (cleanCmdPhyWhCode) {
            tmpCmdIn.setPhysicalWarehouseCode(null);//不扣减物理仓库存
        }
        /*if (EmptyUtil.isNotEmpty(whAllotRcd.getCreateUserId())) {
            tmpCmdIn.setOperatorId(whAllotRcd.getCreateUserId().longValue());
        } else {
            tmpCmdOut.setOperatorId(1L);
        }*/
        tmpCmdIn.setOperatorId(tmpCmdOut.getOperatorId());
        tmpCmdIn.setNoUpdateAllot(true);
        whCommandService.finishCommand(tmpCmdIn);
        // 设置完成
        whAllotRcd.setAllotStatus(WhAllotRcd.STATUS_FINISHED);
        whAllotRcd.setFinishTime(new Date());
        whAllotRcdMapper.updateByPrimaryKeySelective(whAllotRcd);
    }


    private void outBoundProcess(WhAllotRcd whAllotRcd) throws Exception {
        WhCommand whCommand = whCommandService.findCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_OUT,
                whAllotRcd.getCode(), true);
        if (EmptyUtil.isEmpty(whCommand) || CollectionUtils.isEmpty(whCommand.getWhCommandSkuList())){
            throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM,
                    "command and commandSku not null");
        }
        if (EmptyUtil.isEmpty(whCommand.getOperatorId())){
            if (EmptyUtil.isNotEmpty(whAllotRcd.getCreateUserId())){
                whCommand.setOperatorId(whAllotRcd.getCreateUserId().longValue());
            }
        }
        whCommandService.finishCommand(whCommand);
    }

    private boolean checkBeforCreate(List<WhAllotRcd> whAllotRcds){
        Set<String> phyWhCodes = new HashSet<>();
        String sourceWarehouseCode = null,targetWarehouseCode = null;
        for(WhAllotRcd rcd : whAllotRcds){
            if(EmptyUtil.isNotEmpty(rcd.getSourcePhysicalWarehouseCode())){
                phyWhCodes.add(rcd.getSourcePhysicalWarehouseCode());
            }
            if(EmptyUtil.isNotEmpty(rcd.getTargetPhysicalWarehouseCode())){
                phyWhCodes.add(rcd.getTargetPhysicalWarehouseCode());
            }
            sourceWarehouseCode = rcd.getSourceWarehouseCode();
            targetWarehouseCode = rcd.getTargetWarehouseCode();
            if (EmptyUtil.isEmpty(sourceWarehouseCode) || EmptyUtil.isEmpty(targetWarehouseCode)) {
                throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM,
                        "目标仓和源仓不能为空.");
            } else if (sourceWarehouseCode.equals(targetWarehouseCode)) {
                throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM,
                        "目标仓和源仓不能一样.");
            }
        }
        if(phyWhCodes.isEmpty()){
            return true;
        }
        List<WhWarehouseGroupVO> groupList = whWarehouseGroupService.findAll(true);
        Map<String,Long> whGroupMap = new HashMap<>();
        Map<String,Long> phyWhGroupMap = new HashMap<>();
        for(WhWarehouseGroupVO group : groupList){
            List<WhWarehouseVO> whList = group.getRelateWarehouses();
            if(EmptyUtil.isNotEmpty(whList)){
                for(WhWarehouseVO wh : whList){
                    whGroupMap.put(wh.getCode(),group.getId());
                }
            }
            List<WhPhysicalWarehouseVO> phyWhList = group.getRelatePhysicalWarehouses();
            if(EmptyUtil.isNotEmpty(phyWhList)){
                for(WhPhysicalWarehouseVO phyWh : phyWhList){
                    phyWhGroupMap.put(phyWh.getCode(),group.getId());
                }
            }
        }
        Long phyWhGroupId = null,whGroupId = null;
        for(WhAllotRcd rcd : whAllotRcds){
            if(EmptyUtil.isNotEmpty(rcd.getSourcePhysicalWarehouseCode())){
                phyWhGroupId = phyWhGroupMap.get(rcd.getSourcePhysicalWarehouseCode());
                whGroupId = whGroupMap.get(rcd.getSourceWarehouseCode());
                if(NullUtil.isNull(phyWhGroupId)
                        || NullUtil.isNull(whGroupId)
                        || !phyWhGroupId.equals(whGroupId) ){
                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                            ,String.format("[%s][%s]不是同一逻辑仓分组",rcd.getSourcePhysicalWarehouseCode(),rcd.getSourceWarehouseCode()));
                }
            }
            if(EmptyUtil.isNotEmpty(rcd.getTargetPhysicalWarehouseCode())){
                phyWhGroupId = phyWhGroupMap.get(rcd.getTargetPhysicalWarehouseCode());
                whGroupId = whGroupMap.get(rcd.getTargetWarehouseCode());
                if(NullUtil.isNull(phyWhGroupId)
                        || NullUtil.isNull(whGroupId)
                        || !phyWhGroupId.equals(whGroupId) ){
                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                            ,String.format("[%s][%s]不是同一逻辑仓分组",rcd.getTargetPhysicalWarehouseCode(),rcd.getTargetWarehouseCode()));
                }
            }
        }
        return true;
    }

    @Override
    public boolean isAllotDirectComplete(WhAllotRcd whAllotRcd){
        // 判断是否库间操作  或者 调拨差异处理且物理仓不为“仓库”时，直接完成
        WhPhysicalWarehouse targetPhysicalWarehouse = null;
        if(EmptyUtil.isNotEmpty(whAllotRcd.getTargetPhysicalWarehouseCode())){
            targetPhysicalWarehouse = whInfoService.findPhysicalWarehouseByCode(whAllotRcd.getTargetPhysicalWarehouseCode());
        }
        if (isWarehouseGroupChannelMove(whAllotRcd) || isWarehouseInnerMove(whAllotRcd)
                || (whAllotRcd.isDiffProcess()
                && NullUtil.isNotNull(targetPhysicalWarehouse)
                && !WhPhysicalWarehouseVO.WAREHOUSE_TYPE_WH_WMS.equals(targetPhysicalWarehouse.getWarehouseType())) ){
            return true;
        }
        return false;
    }

    @Override
    public boolean isAllotSecondConfirm(WhAllotRcd whAllotRcd){
       WhWarehouse sourceWh = whInfoService.findWarehouseByCode(whAllotRcd.getSourceWarehouseCode());
        WhWarehouse targetWh = whInfoService.findWarehouseByCode(whAllotRcd.getTargetWarehouseCode());
        if (isWarehouseInnerMove(whAllotRcd) || NullUtil.isNotNull(sourceWh.getWarehouseGroupId())
                && NullUtil.isNotNull(targetWh.getWarehouseGroupId())
                && sourceWh.getWarehouseGroupId().equals(targetWh.getWarehouseGroupId())){
            WhWarehouseGroupVO whGroup = whWarehouseGroupService.findById(sourceWh.getWarehouseGroupId(),false);
            if(WhWarehouseGroupVO.WAREHOUSE_YES.equals(whGroup.getType())
                    && !sourceWh.getCommodityStatus().equals(targetWh.getCommodityStatus())){
                return true;
            }
        }
        return false;
    }



    //库间移动
    public boolean isWarehouseInnerMove(WhAllotRcd whAllotRcd){
        return EmptyUtil.isNotEmpty(whAllotRcd.getTargetPhysicalWarehouseCode())
                && EmptyUtil.isNotEmpty(whAllotRcd.getSourcePhysicalWarehouseCode())
                && whAllotRcd.getSourcePhysicalWarehouseCode().equals(whAllotRcd.getTargetPhysicalWarehouseCode());
    }

    //渠道分货
    public boolean isWarehouseGroupChannelMove(WhAllotRcd whAllotRcd){
        if(EmptyUtil.isNotEmpty(whAllotRcd.getTargetPhysicalWarehouseCode()) || EmptyUtil.isNotEmpty(whAllotRcd.getSourcePhysicalWarehouseCode())){
            return false;
        }
        WhWarehouse sourceWh = whInfoService.findWarehouseByCode(whAllotRcd.getSourceWarehouseCode());
        WhWarehouse targetWh = whInfoService.findWarehouseByCode(whAllotRcd.getTargetWarehouseCode());
        return NullUtil.isNotNull(sourceWh.getWarehouseGroupId())
                && NullUtil.isNotNull(targetWh.getWarehouseGroupId())
                && sourceWh.getWarehouseGroupId().equals(targetWh.getWarehouseGroupId());
    }

    private WhWarehouse checkSourcePhyWhSkuStock(WhAllotRcd allotRcd){
        if(EmptyUtil.isEmpty(allotRcd.getSourcePhysicalWarehouseCode())
                || EmptyUtil.isEmpty(allotRcd.getSourceWarehouseCode()) || isWarehouseInnerMove(allotRcd)){
            return null;
        }
        List<WhAllotRcdSku> allotRcdSkuList = allotRcd.getWhAllotRcdSkuList();
        Map<String,Integer> altSkuQuantityMap = new HashMap<>();
        for(WhAllotRcdSku allotRcdSku : allotRcdSkuList){
            Integer total = altSkuQuantityMap.get(allotRcdSku.getSkuCode());
            if(NullUtil.isNull(total)){
                total = 0;
            }
            altSkuQuantityMap.put(allotRcdSku.getSkuCode(),total+allotRcdSku.getQuantity());
        }
        WhWarehouse warehouse = whInfoService.findWarehouseByCode(allotRcd.getSourceWarehouseCode());
        PhyWhStockCond cond = new PhyWhStockCond();
        cond.setPhysicalWarehouseCode(allotRcd.getSourcePhysicalWarehouseCode());
        cond.setSkuCodes(Arrays.asList(altSkuQuantityMap.keySet().toArray(new String[altSkuQuantityMap.size()])));
        cond.setSkuStatus(warehouse.getCommodityStatus());
        List<PhyWhStockVO> whStockList = whWmsSkuStockService.findPhyWhStockByCond(cond);
        Map<String,Integer> phyWhSkuStockMap = new HashMap<>();
        if(EmptyUtil.isNotEmpty(whStockList)){
            for(PhyWhStockVO stock : whStockList){
                phyWhSkuStockMap.put(stock.getSkuCode(),stock.getCanUseQuantity());
            }
        }
        for(Map.Entry<String,Integer> entry : altSkuQuantityMap.entrySet()){
            Integer altQuantity = entry.getValue();
            Integer skuCanQuantity = phyWhSkuStockMap.get(entry.getKey());
            if(NullUtil.isNull(skuCanQuantity)){
                skuCanQuantity = 0;
            }
            if(altQuantity > skuCanQuantity){
                com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO pcsSkuVO = mcPcsSkuService.findByCode(entry.getKey());
                if(NullUtil.isNull(pcsSkuVO)){
                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,String.format("[%s]不存在",entry.getKey()));
                }
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                        String.format("[%s]物理仓库存不足,[%s]%s,[%s][%s<%s]"
                        ,allotRcd.getSourcePhysicalWarehouseCode()
                        ,pcsSkuVO.getCode()
                        ,pcsSkuVO.getNameCn()
                        ,WhCommand.getSkuStatusName(warehouse.getCommodityStatus())
                        ,skuCanQuantity
                        ,altQuantity));
            }
        }
     return warehouse;
    }

    private String generatorAltCode(Long altId,Integer allotType){
        Map<String, Object> params = new HashMap<>();
        params.put("createTime", DateUtil.getNow());
        params.put("allotType", allotType);
        params.put("id", altId);
        return CodeGenerator.getInstance().generate("WH_ALLOT_RCD", params);
    }

    private WhCommand buildAltOutCommand(WhAllotRcd whAllotRcd){
        // 记录调拨出库指令
        WhCommand whCommandOut = new WhCommand();
        whCommandOut.setReferenceCode(whAllotRcd.getCode());
        whCommandOut.setPhysicalWarehouseCode(whAllotRcd.getSourcePhysicalWarehouseCode());
        whCommandOut.setInOutType(WhCommand.TYPE_ALLOT_OUT);
        whCommandOut.setWarehouseCode(whAllotRcd.getSourceWarehouseCode());
        whCommandOut.setPlanedDeliveryDate(whAllotRcd.getEstimatedAllocationDate());//冗余预计发货日期
        whCommandOut.setWhCommandSkuList(buildAltCommandSku(whAllotRcd));
        if (EmptyUtil.isNotEmpty(whAllotRcd.getCreateUserId())){
            whCommandOut.setOperatorId(Long.parseLong(whAllotRcd.getCreateUserId().toString()));
        }else{
            whCommandOut.setOperatorId(1L);
        }
        return whCommandOut;
    }

    private WhCommand buildAltInCommand(WhAllotRcd whAllotRcd){
        WhCommand whCommandIn = new WhCommand();
        whCommandIn.setReferenceCode(whAllotRcd.getCode());
        whCommandIn.setInOutType(WhCommand.TYPE_ALLOT_IN);
        whCommandIn.setPhysicalWarehouseCode(whAllotRcd.getTargetPhysicalWarehouseCode());
        whCommandIn.setWarehouseCode(whAllotRcd.getTargetWarehouseCode());
        whCommandIn.setWhCommandSkuList(buildAltCommandSku(whAllotRcd));
        return whCommandIn;
    }

    private List<WhCommandSku> buildAltCommandSku(WhAllotRcd whAllotRcd){
        List<WhCommandSku> whCommandSkuList = new ArrayList<>();
        if(EmptyUtil.isNotEmpty(whAllotRcd.getWhAllotRcdSkuList())){
            for (WhAllotRcdSku whAllotRcdSku : whAllotRcd.getWhAllotRcdSkuList()) {
                WhCommandSku whCommandSku = new WhCommandSku();
                whCommandSku.setSkuCode(whAllotRcdSku.getSkuCode());
                whCommandSku.setPlanedQuantity(whAllotRcdSku.getQuantity());
                // 调拨差异时，若直接进入待入库，则quantity=planedQuantity
                if (whAllotRcd.isDiffProcess() && whAllotRcd.isNeedWaitInBound()){
                    whCommandSku.setQuantity(whAllotRcdSku.getQuantity());
                }
                whCommandSkuList.add(whCommandSku);
            }
        }
        return whCommandSkuList;
    }

    private void buildAltEstimatedAllocationDate(WhAllotRcd whAllotRcd){
        if(NullUtil.isNull(whAllotRcd.getEstimatedAllocationDate())){
            Calendar cal = Calendar.getInstance();
            int currHour = cal.get(Calendar.HOUR_OF_DAY);
            if (currHour < 16){
                whAllotRcd.setEstimatedAllocationDate(DateUtil.getNow());
            }else{
                whAllotRcd.setEstimatedAllocationDate(DateUtil.addDay(DateUtil.getNow(),1));
            }
        }
    }

    private void buildAllotDiffDetailVOs(WhAllotRcd whAllotRcd, WhAllotRcdSku whAllotRcdSku, List<WhAllotDiffDetailVO> allotDiffDetailVOs) {
        // 由调拨异常创建的调拨单，记录调拨差异详情
        WhAllotDiffDetailVO whAllotDiffDetailVO = new WhAllotDiffDetailVO();
        whAllotDiffDetailVO.setCreateTime(DateUtil.getNow());
        whAllotDiffDetailVO.setOperatorId(whAllotRcd.getCreateUserId());
        whAllotDiffDetailVO.setSkuCode(whAllotRcdSku.getSkuCode());
        whAllotDiffDetailVO.setQuantity(whAllotRcdSku.getQuantity());
        whAllotDiffDetailVO.setProcessType(WhAllotDiffDetailVO.PROCESS_TYPE_CALLBACK);
        whAllotDiffDetailVO.setWarehouseCode(whAllotRcd.getTargetWarehouseCode());
        whAllotDiffDetailVO.setRefId(whAllotRcd.getOldAllotId());
        allotDiffDetailVOs.add(whAllotDiffDetailVO);
    }

    /**
     * 来单制作自动调拨
     *
     * @param whAllotRcd 调拨单
     * @return 调拨单号
     */
    @Override
    @Transactional
    public String createAutoTransferAllot(WhAllotRcd whAllotRcd) throws Exception  {
        String sourceWarehouseCode = whAllotRcd.getSourceWarehouseCode();
        String targetWarehouseCode = whAllotRcd.getTargetWarehouseCode();
        if (EmptyUtil.isEmpty(sourceWarehouseCode) || EmptyUtil.isEmpty(targetWarehouseCode)) {
            throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM,
                "目标仓和源仓不能为空.");
        }

        whAllotRcd.setAllotStatus(WhAllotRcd.STATUS_WAIT_FOR_CONFIRMATION);
        whAllotRcd.setCreateTime(DateUtil.getNow());
        buildAltEstimatedAllocationDate(whAllotRcd);
        whAllotRcdMapper.insert(whAllotRcd);

        String code = generatorAltCode(whAllotRcd.getId(),whAllotRcd.getAllotType());
        whAllotRcd.setCode(code);
        whAllotRcdMapper.updateByPrimaryKeySelective(whAllotRcd);//更新调拨记录表的CODE

        List<WhAllotRcdSku> whAllotRcdSkuList = whAllotRcd.getWhAllotRcdSkuList();
        if (EmptyUtil.isEmpty(whAllotRcdSkuList)) {
            throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM,"调拨行信息不可为空");
        }
        for (WhAllotRcdSku whAllotRcdSku : whAllotRcdSkuList) {
            whAllotRcdSku.setAllotRcdId(whAllotRcd.getId());
            whAllotRcdSkuMapper.insert(whAllotRcdSku);
        }
        //调拨单类型为”来单制作自动调拨”的调拨单,不同步外部平台库存
        if(whAllotRcd.getAllotType() != 12) {
	        //调拨到天猫仓,异步
	        if(Constants.warehouseMap.containsKey(targetWarehouseCode)) {
	    		syncTmallStock(getSyncSkuList(whAllotRcdSkuList, 1), Constants.warehouseMap.get(targetWarehouseCode), code);
	        }
	        //天猫仓库存调出,异步
	        if(Constants.warehouseMap.containsKey(sourceWarehouseCode)) {
	        	syncTmallStock(getSyncSkuList(whAllotRcdSkuList, 0), Constants.warehouseMap.get(sourceWarehouseCode), code);
	        }
    	}
    
        return code;
    }

    @Override
    @Transactional
    public String createPreAllotRcd(WhPreAllotRcd whPreAllotRcd) throws Exception {
        checkPreAllot(Collections.singletonList(whPreAllotRcd));
        return createPreAllot(whPreAllotRcd);
    }

    private String createPreAllot(WhPreAllotRcd whPreAllotRcd) throws Exception {
        whPreAllotRcdMapper.insert(whPreAllotRcd);
        List<WhPreAllotRcdSku> whAllotRcdSkuList = whPreAllotRcd.getWhPreAllotRcdSkuList();
        if (whAllotRcdSkuList != null && !whAllotRcdSkuList.isEmpty()) {
            for (WhPreAllotRcdSku whAllotRcdSku : whAllotRcdSkuList) {
                whAllotRcdSku.setPreAllotId(whPreAllotRcd.getId());
                whPreAllotRcdSkuMapper.insert(whAllotRcdSku);
            }
        } else {
            throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM,
                    "whAllotRcdSkuList can not be empty.");
        }
        return whPreAllotRcd.getCode();
    }

    private void checkPreAllot(List<WhPreAllotRcd> whPreAllotRcds){
        Set<String> phyWhCodes = new HashSet<>();
        String sourceWarehouseCode = null,targetWarehouseCode = null;
        for(WhPreAllotRcd rcd : whPreAllotRcds){
            if(EmptyUtil.isNotEmpty(rcd.getSourcePhysicalWarehouseCode())){
                phyWhCodes.add(rcd.getSourcePhysicalWarehouseCode());
            }
            if(EmptyUtil.isNotEmpty(rcd.getTargetPhysicalWarehouseCode())){
                phyWhCodes.add(rcd.getTargetPhysicalWarehouseCode());
            }
            sourceWarehouseCode = rcd.getSourceWarehouseCode();
            targetWarehouseCode = rcd.getTargetWarehouseCode();
            if (EmptyUtil.isEmpty(sourceWarehouseCode) || EmptyUtil.isEmpty(targetWarehouseCode)) {
                throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM,
                        "目标仓和源仓不能为空.");
            } else if (sourceWarehouseCode.equals(targetWarehouseCode)) {
                throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM,
                        "目标仓和源仓不能一样.");
            }
        }
        if(phyWhCodes.isEmpty()){
            return;
        }
        List<WhWarehouseGroupVO> groupList = whWarehouseGroupService.findAll(true);
        Map<String,Long> whGroupMap = new HashMap<>();
        Map<String,Long> phyWhGroupMap = new HashMap<>();
        for(WhWarehouseGroupVO group : groupList){
            List<WhWarehouseVO> whList = group.getRelateWarehouses();
            if(EmptyUtil.isNotEmpty(whList)){
                for(WhWarehouseVO wh : whList){
                    whGroupMap.put(wh.getCode(),group.getId());
                }
            }
            List<WhPhysicalWarehouseVO> phyWhList = group.getRelatePhysicalWarehouses();
            if(EmptyUtil.isNotEmpty(phyWhList)){
                for(WhPhysicalWarehouseVO phyWh : phyWhList){
                    phyWhGroupMap.put(phyWh.getCode(),group.getId());
                }
            }
        }
        Long phyWhGroupId = null,whGroupId = null;
        for(WhPreAllotRcd rcd : whPreAllotRcds){
            if(EmptyUtil.isNotEmpty(rcd.getSourcePhysicalWarehouseCode())){
                phyWhGroupId = phyWhGroupMap.get(rcd.getSourcePhysicalWarehouseCode());
                whGroupId = whGroupMap.get(rcd.getSourceWarehouseCode());
                if(NullUtil.isNull(phyWhGroupId)
                        || NullUtil.isNull(whGroupId)
                        || !phyWhGroupId.equals(whGroupId) ){
                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                            ,String.format("[%s][%s]不是同一逻辑仓分组",rcd.getSourcePhysicalWarehouseCode(),rcd.getSourceWarehouseCode()));
                }
            }
            if(EmptyUtil.isNotEmpty(rcd.getTargetPhysicalWarehouseCode())){
                phyWhGroupId = phyWhGroupMap.get(rcd.getTargetPhysicalWarehouseCode());
                whGroupId = whGroupMap.get(rcd.getTargetWarehouseCode());
                if(NullUtil.isNull(phyWhGroupId)
                        || NullUtil.isNull(whGroupId)
                        || !phyWhGroupId.equals(whGroupId) ){
                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                            ,String.format("[%s][%s]不是同一逻辑仓分组",rcd.getTargetPhysicalWarehouseCode(),rcd.getTargetWarehouseCode()));
                }
            }
        }
    }

    public List<TmallStockLog> syncTmallStock(List<PcsSkuVO> skuList, String sessionKey, String code) throws Exception {
        List<TmallStockLog> tmallStockLogList = Lists.newArrayList();
        if(EmptyUtil.isNotEmpty(skuList)) {
			for(PcsSkuVO pcsSkuVO : skuList) {
				//PcsSku pcsSku = pFacade.findTmallSkuByCode(pcsSkuVO.getCode());
				//pcsSku.setQuantity(pcsSkuVO.getQuantity());
				whCommandService.checkTmallSku(pegasusUtilFacade.getSkuNumIid(pcsSkuVO.getCode(), sessionKey), pcsSkuVO.getCode(), pcsSkuVO.getQuantity(), sessionKey);
			}
			for(PcsSkuVO pcsSkuVO : skuList) {
				//PcsSku pcsSku = pFacade.findTmallSkuByCode(pcsSkuVO.getCode());
				//pcsSku.setQuantity(pcsSkuVO.getQuantity());
                TmallStockLog tmallStockLog = whCommandService.synCommodityStocksAllot(pegasusUtilFacade.getSkuNumIid(pcsSkuVO.getCode(), sessionKey), pcsSkuVO.getCode(), pcsSkuVO.getQuantity(), sessionKey,
						1, code);
                //1:记录
                tmallStockLogMapper.insertSelective(tmallStockLog);
                //2:如果返回成功的，则加入执行调拨的list中
                if (tmallStockLog.getSyncStatus() == 1) {
                    tmallStockLogList.add(tmallStockLog);
                }
			}
		}
		return tmallStockLogList;
    }


    //返回天猫调拨成功的，用于在本系统中跟随调拨
    public List<TmallStockLog> syncTmallStockAllot(List<PcsSkuVO> skuList, String sessionKey, String code) throws Exception {
      List<TmallStockLog> tmallStockLogList = Lists.newArrayList();
      if(EmptyUtil.isNotEmpty(skuList)) {
          for(PcsSkuVO pcsSkuVO : skuList) {
            TmallStockLog tmallStockLog = whCommandService.synCommodityStocksAllot(pegasusUtilFacade.getSkuNumIid(pcsSkuVO.getCode(), sessionKey), pcsSkuVO.getCode(), pcsSkuVO.getQuantity(), sessionKey,
                1, code);
            //tmallStockLog.setReferenceCode(pcsSkuVO.getSkuLineCode());
            //1:日志记录不影响主流程
            try {
              tmallStockLogMapper.insertSelective(tmallStockLog);
            }catch (Exception e) {
              e.printStackTrace();
            }
            //2:如果返回成功的，则加入执行调拨的list中
            tmallStockLogList.add(tmallStockLog);
          }
		    }
		    return tmallStockLogList;
    }

    //返回天猫调拨成功的，用于在本系统中跟随调拨
    public List<TmallStockLog> syncTmallStockAllotNew(List<PcsSkuVO> skuList, String channelCode, String referenceCode) throws Exception {
        List<TmallStockLog> tmallStockLogList = Lists.newArrayList();
        if(EmptyUtil.isNotEmpty(skuList)) {
          for(PcsSkuVO pcsSkuVO : skuList) {
            TmallStockLog tmallStockLog = new TmallStockLog();
            try {
             tmallStockLog = whCommandService.synCommodityStocksAllot(pegasusUtilFacade.getSkuNumIid(pcsSkuVO.getCode(), channelCode)
                     , pcsSkuVO.getCode(), pcsSkuVO.getQuantity(), channelCode, 1, referenceCode);
            } catch (Exception e) {
                log.error(e.getMessage());
                tmallStockLog.setSkuCode(pcsSkuVO.getCode());
                tmallStockLog.setReferenceCode(referenceCode);
                tmallStockLog.setSyncType(1);
                tmallStockLog.setCreateTime(new Date());
                tmallStockLog.setChannelCode(channelCode);
                tmallStockLog.setSyncStatus((short)0);
                tmallStockLog.setDealStatus((short) 1);
                tmallStockLog.setQuantity(pcsSkuVO.getQuantity());
                tmallStockLog.setRemark("不明异常");
            } finally {
                tmallStockLog.setReferenceCode(pcsSkuVO.getSkuLineCode());
            }
              //1:日志记录不影响主流程
            try {
              tmallStockLogMapper.insertSelective(tmallStockLog);
            }catch (Exception e) {
              e.printStackTrace();
            }
            tmallStockLogList.add(tmallStockLog);
            //2:如果返回成功的，则加入执行调拨的list中
            }
        }
        return tmallStockLogList;
    }
    /**
     * 需要同步天猫后台的sku列表
     * @param whAllotRcdSkuList
     * @return
     */
    private List<PcsSkuVO> getSyncSkuList(List<WhAllotRcdSku> whAllotRcdSkuList, int in) {
    	List<PcsSkuVO> skuList = new ArrayList<PcsSkuVO>();
    	if(EmptyUtil.isNotEmpty(whAllotRcdSkuList)) {
    		for(WhAllotRcdSku whAllotRcdSku : whAllotRcdSkuList) {
            if (whAllotRcdSku.isSyncThridParty()) {
                PcsSkuVO pcsSku = new PcsSkuVO();
                pcsSku.setCode(whAllotRcdSku.getSkuCode());
                pcsSku.setSkuLineCode(whAllotRcdSku.getPreOccupyRefCode());
                if(in == 1) {
                    pcsSku.setQuantity(whAllotRcdSku.getQuantity());
                } else {
                    pcsSku.setQuantity(-whAllotRcdSku.getQuantity());
                }
                skuList.add(pcsSku);
            }
    		}
    	}
    	return skuList;
    }
    @Override
    @Transactional
    public List<String> createAllotRcds(List<WhAllotRcd> whAllotRcds) throws Exception {
        checkBeforCreate(whAllotRcds);
        List<String> codes = new ArrayList<>();
        for (WhAllotRcd whAllotRcd : whAllotRcds) {
            String code = createAllot(whAllotRcd);
            codes.add(code);
        }
        return codes;
    }

    @Override
    @Transactional
    public boolean recordAllotRcd(List<WhAllotRcd> whAllotRcds) {
        List<WhCommand> cmdList = new ArrayList<>();
        whAllotRcds.forEach(whAllotRcd->{
            whAllotRcdMapper.insert(whAllotRcd);
            //获取单号
            String code = generatorAltCode(whAllotRcd.getId(),whAllotRcd.getAllotType());
            whAllotRcd.setCode(code);
            whAllotRcdMapper.updateByPrimaryKeySelective(whAllotRcd);
            whAllotRcd.getWhAllotRcdSkuList().forEach(rcdSku->rcdSku.setAllotRcdId(whAllotRcd.getId()));
            whAllotRcdSkuMapper.batchInsert(whAllotRcd.getWhAllotRcdSkuList());
            //构建指令数据
            WhCommand outCmd = buildAltOutCommand(whAllotRcd);
            outCmd.getWhCommandSkuList().forEach(cmdSku->{
                cmdSku.setQuantity(cmdSku.getPlanedQuantity());
                cmdSku.setDamagedQuantity(0);
            });
            outCmd.setCommandStatus(WhCommand.STATUS_DELIVERYCOMPLETION);
            outCmd.setProcessTime(DateUtil.getNow());
            cmdList.add(outCmd);
            WhCommand inCmd = buildAltInCommand(whAllotRcd);
            inCmd.getWhCommandSkuList().forEach(cmdSku->{
                cmdSku.setQuantity(cmdSku.getPlanedQuantity());
                cmdSku.setDamagedQuantity(0);
            });
            inCmd.setCommandStatus(WhCommand.STATUS_QUALITY_FINISHED);
            inCmd.setProcessTime(DateUtil.getNow());
            cmdList.add(inCmd);
        });
        //记录指令数据
        whCommandService.recordCommand(cmdList);
        return true;
    }

    @Override
    public List<WhAllotRcd> autoAllotCreateRcds(List<WhAllotRcd> whAllotRcds) throws Exception {
        checkBeforCreate(whAllotRcds);
        if (whAllotRcds == null) {
          return  null;
        }
        autoAllotPreOccupy(whAllotRcds);
        final List<SStockReleaseDTO> preOccupyReleaseList = new ArrayList<SStockReleaseDTO>();
        final List<WhAllotRcd> newAllotRcds = new ArrayList<WhAllotRcd>();
        for (WhAllotRcd rcd : whAllotRcds) {
          //先出库
          syncTmallStock(rcd, false);
          trySyncJdStockNew(rcd, false);

          syncTmallStock(rcd, true);
          trySyncJdStockNew(rcd, true);
          rcd.setNoSyncOtherPlatform(true);
          List<WhAllotRcdSku> whAllotRcdSkuList = rcd.getWhAllotRcdSkuList();
          int lineSize = whAllotRcdSkuList == null ? 0 : whAllotRcdSkuList.size();
          if (lineSize > 0) {
            newAllotRcds.add(rcd);
           }
          //同步第三方库存都失败，需要释放预占用库存
          if (lineSize == 0) {
            preOccupyReleaseList.addAll(rcd.getPreOccupyReleaseList());
          }
        }

        transactionTemplate.execute(new TransactionCallback() {
            @Override
            public Object doInTransaction(TransactionStatus transactionStatus) {
                sStockService.release(preOccupyReleaseList);
                List<String> codes = new ArrayList<>();
                try {
                    for (WhAllotRcd whAllotRcd : newAllotRcds) {
                        String code = null;
                        code = createAllot(whAllotRcd);
                        codes.add(code);
                    }
                   /* Integer.parseInt("JJ");*/
                } catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException();
                }
                return null;
            }
        });
        return newAllotRcds;
    }

    @Override
    @Transactional
    public void autoAllotPreOccupy(List<WhAllotRcd> whAllotRcds) throws Exception {
      List<SStockOccupyDTO> occupyList = new ArrayList<>();
      for (WhAllotRcd  rcd : whAllotRcds) {
        String warehouseCode = rcd.getSourceWarehouseCode();
        List<WhAllotRcdSku> whAllotRcdSkuList = rcd.getWhAllotRcdSkuList();
        if (whAllotRcdSkuList== null || whAllotRcdSkuList.size() == 0) {
          continue;
        }
        for (WhAllotRcdSku whAllotRcdSku : whAllotRcdSkuList) {
            SStockOccupyDTO stockOccupyDTO = new SStockOccupyDTO();
            stockOccupyDTO.setQuantity(whAllotRcdSku.getQuantity());
            stockOccupyDTO.setWarehouseCode(warehouseCode);
            stockOccupyDTO.setSkuCode(whAllotRcdSku.getSkuCode());
            stockOccupyDTO.setOccupyType(SStockOccupyTypeEnum.ALLOT_PRE_OCCUPY);
            stockOccupyDTO.setOperationType(SStockOperationTypeEnum.DEFAULT);
            stockOccupyDTO.setReferenceCode(whAllotRcdSku.getPreOccupyRefCode());
            occupyList.add(stockOccupyDTO);
        }
        rcd.setPreOccupyReleaseList(buildAllotPreOccupyReleaseList(rcd));
      }
      ServiceResp<List<SOccupyResultVO>> rsp = sStockService.occupy(occupyList);
      if (rsp.isFailure()) {
        log.info("自动分货预占用失败参数：", JSON.toJSONString(occupyList));
        throw  new WarehouseException("预占用库存失败,", rsp.getRespMsg());
      }
    }

    /**
     * 同步天猫，返回成功记录
     * @param whAllotRcd
     * @param  inStorage 是否入库
     * @return
     * @throws Exception
     */
    private int syncTmallStock(WhAllotRcd whAllotRcd, boolean inStorage) throws Exception {
        StringBuilder synErrorMsg = new StringBuilder("");
        String sourceWarehouseCode = whAllotRcd.getSourceWarehouseCode();
        String targetWarehouseCode = whAllotRcd.getTargetWarehouseCode();

        List<WhAllotRcdSku> whAllotRcdSkuList = whAllotRcd.getWhAllotRcdSkuList();
       /* if (EmptyUtil.isEmpty(whAllotRcdSkuList)){
            throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM, "调拨行信息不可为空");
        }*/
        //----------天猫同步库存修改部分 start --------------
        if (CollectionUtils.isNotEmpty(whAllotRcd.getPcsSkus())){
            for(com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO pcsSkuVO : whAllotRcd.getPcsSkus()){
                // 包含定制商品，不同步天猫平台
                if (EmptyUtil.isNotEmpty(pcsSkuVO.getCanCustomize()) && pcsSkuVO.getCanCustomize()==1){
                    whAllotRcd.setNoSyncOtherPlatform(true);
                    break;
                }
            }
        }
        List<TmallStockLog> successSynTmall = Lists.newArrayList();
        //没有备注，或者备注里包含预售
        // 临时注释，上线再展开
        Boolean buildFlag = true;
        if(EmptyUtil.isEmpty(whAllotRcd.getRemark()) || whAllotRcd.getRemark().indexOf("预售") == -1) {
            //天猫仓库存调出,异步
            if(Constants.warehouseMap.containsKey(sourceWarehouseCode) && !whAllotRcd.isNoSyncOtherPlatform() && !inStorage) {
                List<TmallStockLog> list = syncTmallStockAllotNew(getSyncSkuList(whAllotRcdSkuList, 0), Constants.warehouseMap.get(sourceWarehouseCode), "");
                for (TmallStockLog tmallStockLog : list) {
                    if (tmallStockLog.getSyncStatus() == 1) {
                        successSynTmall.add(tmallStockLog);
                    } else {
                        synErrorMsg.append("SKU["+tmallStockLog.getSkuCode()+"]"+tmallStockLog.getRemark()+"\r\n");
                    }
                }
                if (buildFlag) {
                    whAllotRcdSkuList = buildTmallAllotSkus(successSynTmall);
                }
            }

            //调拨到天猫仓,异步
            if(Constants.warehouseMap.containsKey(targetWarehouseCode) && !whAllotRcd.isNoSyncOtherPlatform() && inStorage) {
                List<TmallStockLog> list = syncTmallStockAllotNew(getSyncSkuList(whAllotRcdSkuList, 1), Constants.warehouseMap.get(targetWarehouseCode), "");
                for (TmallStockLog tmallStockLog : list) {
                    if (tmallStockLog.getSyncStatus() == 1) {
                        successSynTmall.add(tmallStockLog);
                    } else {
                        synErrorMsg.append("SKU["+tmallStockLog.getSkuCode()+"]"+tmallStockLog.getRemark()+"\r\n");
                    }
                }
                whAllotRcdSkuList = buildTmallAllotSkus(successSynTmall);
                buildFlag = false;
            }
        }
        whAllotRcd.setWhAllotRcdSkuList(whAllotRcdSkuList);
        //----------天猫同步库存修改部分 end  ---------------
        //String errorMsg = synErrorMsg.toString();
//        if (CollectionUtils.isEmpty(successSynTmall) && synErrorMsg.length()>0
//                || (EmptyUtil.isEmpty(whAllotRcd.getWhAllotRcdSkuList())) ) {
//            //若没有，删除改调拨单 不继续
//            WhAllotRcdSkuExample example = new WhAllotRcdSkuExample();
//            example.createCriteria().andAllotRcdIdEqualTo(whAllotRcd.getId());
//            whAllotRcdSkuMapper.deleteByExample(example);
//            whAllotRcdMapper.deleteByPrimaryKey(whAllotRcd.getId());
//            return "创建调拨单失败，失败原因:"+errorMsg.toString();
//        }

      /*  if (errorMsg.length()>0) {
            return code + ":部分SKU调拨失败，失败原因："+errorMsg.toString();
        }*/
       //return code;
     return whAllotRcdSkuList.size();
    }


    @Override
    @Transactional
    public boolean createAllotRcdAndPrdcJobOccupy(List<WhAllotRcd> whAllotRcds, List<WhInvOccupy> whJobInvOccupyList, List<WhJitPackageSkuReferenceVO> whJobJitPackageSkuReferenceVOList) throws Exception {
        if(EmptyUtil.isNotEmpty(whAllotRcds)){
            createAllotRcds(whAllotRcds);
        }
        if(EmptyUtil.isNotEmpty(whJobInvOccupyList)){
            whInvService.occupy(whJobInvOccupyList,whJobJitPackageSkuReferenceVOList);
        }
        return true;
    }

    /**
     * 取消调拨单
     * @param code 调拨单CODE
     * @return 是否成功
     * @throws Exception 
     */
    @Override
    @Transactional
    public boolean cancelAllotRcdByCode(String code) throws Exception {
        WhAllotRcd whAllotRcd = findAllotRcdByCode(code, false);
        if(NullUtil.isNull(whAllotRcd)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                    ,String.format("[%s]调拨单不存在",code));
        }
        if(WhAllotRcd.STATUS_WAIT_FOR_CONFIRMATION.equals(whAllotRcd.getAllotStatus())
                || WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND.equals(whAllotRcd.getAllotStatus())){
            if(WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND.equals(whAllotRcd.getAllotStatus())){
                WhCommand cmd = whCommandService.findCommandByTypeAndReferenceCode(
                        WhCommand.TYPE_ALLOT_OUT
                        ,whAllotRcd.getCode(),false);
                if(NullUtil.isNotNull(cmd)
                        && !WhCommand.STATUS_IN_PROCESSING.equals(cmd.getCommandStatus())){
                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                            ,"仓库已经开始作业，如需取消请联系仓库");
                }
            }
            updateAllotRcdStatus(whAllotRcd, WhAllotRcd.STATUS_CANCELED);
            return true;
        }
        throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                ,String.format("[%s]状态[%s]无法取消!",code,whAllotRcd.getAllotStatusStr()));
    }

    public Map<String,Boolean> isAllotCanCancel(List<String> codes){
        WhCommandCond cmdCond = new WhCommandCond();
        cmdCond.setReferenceCodeList(codes);
        cmdCond.setInOutType(WhCommand.TYPE_ALLOT_OUT);
        List<WhCommand> cmdList = whCommandService.findCommandByCond(cmdCond);
        Map<String,WhCommand> cmdMap = new HashMap<>();
        if(EmptyUtil.isNotEmpty(cmdList)){
            for(WhCommand cmd : cmdList){
                cmdMap.put(cmd.getReferenceCode(),cmd);
            }
        }
        WhAllotCond cond = new WhAllotCond();
        cond.setCodes(codes);
        List<WhAllotRcd> list = selectAllotRcdByCond(cond);
        Map<String,Boolean> map = new HashMap<>();
        if(EmptyUtil.isNotEmpty(list)){
            for(WhAllotRcd allot : list){
                map.put(allot.getCode(),false);
                if(WhAllotRcd.STATUS_WAIT_FOR_CONFIRMATION.equals(allot.getAllotStatus())){
                    map.put(allot.getCode(),true);
                }else if(WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND.equals(allot.getAllotStatus())){
                    WhCommand cmd = cmdMap.get(allot.getCode());
                    if(NullUtil.isNotNull(cmd)
                            && WhCommand.STATUS_IN_PROCESSING.equals(cmd.getCommandStatus())){
                        map.put(allot.getCode(),true);
                    }
                }
            }
        }
        return map;
    }

    @Override
    @Transactional
    public boolean cancelAllotRcdByCodeForCustomization(String code) throws Exception {
        WhAllotRcd whAllotRcd = findAllotRcdByCode(code, false);
        if(NullUtil.isNotNull(whAllotRcd) &&(
                WhAllotRcd.STATUS_WAIT_FOR_CONFIRMATION.equals(whAllotRcd.getAllotStatus())
                        || (WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND.equals(whAllotRcd.getAllotStatus())
                            && WhAllotRcd.TYPE_CUSTOMIZE_OUT.equals(whAllotRcd.getAllotType()) )
                ) ){
            whJitPackageSkuReferenceService.finishByReferenceCode(code);
            updateAllotRcdStatus(whAllotRcd, WhAllotRcd.STATUS_CANCELED);
            return true;
        }
        throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                "调拨单当前状态不可取消");
    }

    @Override
    public boolean cancelAllotRcdByCodeFromWms(String code) throws Exception {
        WhAllotRcd whAllotRcd = findAllotRcdByCode(code, false);
        if (whAllotRcd == null) {
            throw new WarehouseException(CommExceptionErrorCode.STATUS_NOT_EXPECTED,
                    "whAllotRcd is null .");
        }
        updateAllotRcdStatus(whAllotRcd, WhAllotRcd.STATUS_CANCELED);
        return true;
    }

    /**
     * 根据CODE查找调拨单
     *
     * @param code     调拨单CODE
     * @param fetchSku 是否抓取调拨单SKU
     * @return 调拨单
     */
    @Override
    public WhAllotRcd findAllotRcdByCode(String code, boolean fetchSku) {
        WhAllotRcd result = null;
        WhAllotRcdExample example = new WhAllotRcdExample();
        example.createCriteria().andCodeEqualTo(code);
        List<WhAllotRcd> whAllotRcdList = whAllotRcdMapper.selectByExample(example);
        if ((whAllotRcdList != null && !whAllotRcdList.isEmpty())) {
            result = whAllotRcdList.get(0);
            if (fetchSku) {
                result.setWhAllotRcdSkuList(findAllotRcdSkuByAllotId(result.getId()));
            }
        }
        return result;
    }

    @Override
    public WhAllotRcd findAllotRcdByCode(String code, boolean fetchSku,boolean fetchRefPackageSku) {
        WhAllotRcd whAllotRcd = findAllotRcdByCode(code,fetchSku);
        if (whAllotRcd != null && fetchRefPackageSku){
            List<WhJitPackageSkuReferenceVO> jitPackageSkuReferenceVOs = whJitPackageSkuReferenceService.findByReferenceCode(code);
            if (CollectionUtils.isNotEmpty(jitPackageSkuReferenceVOs)){
                whAllotRcd.setJitPackageSkuReferenceVOs(jitPackageSkuReferenceVOs);
            }
        }
        return whAllotRcd;
    }

    @Override
    public List<WhAllotDiffDetailVO> findAllotDiffDetailByExample(WhAllotDiffDetailVO allotDiffDetailVO) {
        WhAllotDiffDetailExample example = new WhAllotDiffDetailExample();
        WhAllotDiffDetailExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty(allotDiffDetailVO.getRefId())){
            criteria.andRefIdEqualTo(allotDiffDetailVO.getRefId());
        }else if(CollectionUtils.isNotEmpty(allotDiffDetailVO.getRefIds())){
            criteria.andRefIdIn(allotDiffDetailVO.getRefIds());
        }
        if (EmptyUtil.isNotEmpty(allotDiffDetailVO.getSkuCode())){
            criteria.andSkuCodeEqualTo(allotDiffDetailVO.getSkuCode());
        }else if(CollectionUtils.isNotEmpty(allotDiffDetailVO.getSkuCodes())){
            criteria.andSkuCodeIn(allotDiffDetailVO.getSkuCodes());
        }
        if (EmptyUtil.isNotEmpty(allotDiffDetailVO.getWarehouseCode())){
            criteria.andWarehouseCodeEqualTo(allotDiffDetailVO.getWarehouseCode());
        }
        if (EmptyUtil.isNotEmpty(allotDiffDetailVO.getProcessType())){
            criteria.andProcessTypeEqualTo(allotDiffDetailVO.getProcessType());
        }
        List<WhAllotDiffDetail> allotDiffDetails = whAllotDiffDetailMapper.selectByExample(example);
        return BeanUtil.buildListFrom(allotDiffDetails,WhAllotDiffDetailVO.class);
    }

    @Override
    public List<WhAllotDiffDetailVO> listAllotDiffDetailByCode(WhAllotDiffDetailVO allotDiffDetailVO) {
        return whAllotDiffDetailCustomMapper.listAllotDiffDetailByCond(allotDiffDetailVO);
    }

    @Override
    public WhAllotRcd findAllotRcdById(Long id) {
        WhAllotRcdExample example = new WhAllotRcdExample();
        example.createCriteria().andIdEqualTo(id);
        WhAllotRcd whAllotRcd = whAllotRcdMapper.selectByPrimaryKey(id);
        return whAllotRcd;
    }

    @Override
    public Integer countRefPackCancelQuantityAfterAllotFinished(WhAllotCond cond) {
        Integer count = whAllotRcdMapper.countRefPackCancelQuantityAfterAllotFinished(cond);
        return count==null?0:count;
    }

    /**
     * 根据类型和相关单据查找调拨
     *
     * @param type
     * @param referenceCode
     * @param fetchSku
     * @return
     */
    @Override
    public WhAllotRcd findAllotRcdByTypeAndReferenceCode(Integer type, String referenceCode,
                                                         boolean fetchSku) {
        WhAllotRcd result = null;
        WhAllotRcdExample example = new WhAllotRcdExample();
        example.createCriteria().andAllotTypeEqualTo(type).andReferenceCodeEqualTo(referenceCode);
        List<WhAllotRcd> whAllotRcdList = whAllotRcdMapper.selectByExample(example);
        if ((whAllotRcdList != null && !whAllotRcdList.isEmpty())) {
            result = whAllotRcdList.get(0);
            if (fetchSku) {
                result.setWhAllotRcdSkuList(findAllotRcdSkuByAllotId(result.getId()));
            }
        }
        return result;
    }

    @Override
    public List<WhPreAllotRcdVO> findPreAllotRcdByCond(WhAllotCond cond) {
        List<WhPreAllotRcdVO> whAllotRcdList = whPreAllotRcdMapper.findPreAllotRcdByCond(cond);
        return whAllotRcdList;
    }

    @Override
    public List<WhPreAllotRcdVO> findPreAllotRcdByCond(WhAllotCond cond,boolean fetchSku,boolean fetchCountQuantity) {
        List<WhPreAllotRcdVO> whAllotRcdList = whPreAllotRcdMapper.findPreAllotRcdByCond(cond);
        if (fetchSku){
            for (WhPreAllotRcdVO vo : whAllotRcdList){
                vo.setWhPreAllotRcdSkuList(findPreAllotRcdSkuByPreId(vo.getId()));
            }
        }
        if (fetchCountQuantity){
            for (WhPreAllotRcdVO vo : whAllotRcdList){
                vo.setWhPreAllotRcdSkuCountQuantityList(findPreAllotRcdSkuCountQuantityByPreId(vo.getId()));
            }
        }
        return whAllotRcdList;
    }

    @Override
    public List<WhPreAllotRcdSku> findPreAllotRcdSkuByPreId(Long preId) {
        WhPreAllotRcdSkuExample example = new WhPreAllotRcdSkuExample();
        example.createCriteria().andPreAllotIdEqualTo(preId);
        return  whPreAllotRcdSkuMapper.findPreAllotRcdSkuByPreId(example);
    }

    @Override
    public List<WhPreAllotRcdSku> findPreAllotRcdSkuCountQuantityByPreId(Long preId) {
        WhPreAllotRcdSkuExample example = new WhPreAllotRcdSkuExample();
        example.createCriteria().andPreAllotIdEqualTo(preId);
        return  whPreAllotRcdSkuMapper.findPreAllotRcdSkuCountQuantityByPreId(example);
    }

    @Override
    public List<WhPreAllotRcdDownloadVO> findPreAllotRcdListByCond(WhAllotCond cond) {
        List<WhPreAllotRcdDownloadVO> whAllotRcdList = whPreAllotRcdMapper.findPreAllotRcdListByCond(cond);
        return whAllotRcdList;
    }

    @Override
    @Transactional
    public String autoCreateAllotRcd(WhPreAllotRcdVO vo) {
        String allotCode = null;
        Date finishDate = EmptyUtil.isNotEmpty(vo.getEstimatedFinishedDate())?DateUtil.dayEnd(vo.getEstimatedFinishedDate()):null;
//        Date allotDate = EmptyUtil.isNotEmpty(vo.getEstimatedAllocationDate())?DateUtil.dayStart(vo.getEstimatedAllocationDate()):null;
//        if(allotDate != null && Calendar.getInstance().getTimeInMillis() < allotDate.getTime()){
//            return null;
//        }
        if(finishDate!=null && Calendar.getInstance().getTimeInMillis() >= finishDate.getTime()){
            WhPreAllotRcd whPreAllotRcd = new WhPreAllotRcd();
            whPreAllotRcd.setId(vo.getId());
            whPreAllotRcd.setAllotStatus(WhPreAllotRcd.PRE_ALLOT_FINISH);
            int count = whPreAllotRcdMapper.updateByPrimaryKeySelective(whPreAllotRcd);
            if (count > 0){
                WhPreAllotRcd preAllotRcd =  whPreAllotRcdMapper.selectByPrimaryKey(whPreAllotRcd.getId());
                allotCode = preAllotRcd!=null?preAllotRcd.getCode():null;
            }
        }else{
            WhPreAllotRcdSkuExample example = new WhPreAllotRcdSkuExample();
            example.createCriteria().andPreAllotIdEqualTo(vo.getId());
            List<WhPreAllotRcdSku> whPreAllotRcdSkuList = whPreAllotRcdSkuMapper.selectByExample(example);
            boolean isAllFinish = true;
            HashMap<String,Integer> map = new HashMap<>();
            int totalAmount = 0;
            int totalNeedAmount = 0;
            WhWarehouse sourceWh = whInfoService.findWarehouseByCode(vo.getSourceWarehouseCode());
            for(WhPreAllotRcdSku whPreAllotRcdSku:whPreAllotRcdSkuList){
                if(whPreAllotRcdSku.getQuantity() > whPreAllotRcdSku.getFinishQuantity()){
                    totalNeedAmount += (whPreAllotRcdSku.getQuantity() - whPreAllotRcdSku.getFinishQuantity());
                    Integer canUseQuantity = findSkuCanUseQuantity(whPreAllotRcdSku.getSkuCode(),sourceWh,vo.getSourcePhysicalWarehouseCode());
                    if(canUseQuantity != null){
                        int needAmount = whPreAllotRcdSku.getQuantity() - whPreAllotRcdSku.getFinishQuantity();
                        if(canUseQuantity >= needAmount){
                            map.put(whPreAllotRcdSku.getSkuCode(),needAmount);
                            totalAmount += needAmount;
                        }else{
                            isAllFinish = false;
                            if(canUseQuantity > 0){
                                map.put(whPreAllotRcdSku.getSkuCode(),canUseQuantity);
                                totalAmount += canUseQuantity;
                            }
                        }
                    }else{
                        isAllFinish = false;
                    }
                }
            }
            WhAllotRcd whAllotRcd = null;
            if(totalAmount >= vo.getMinAmount()){
                whAllotRcd  = buildWhAllotRcd(vo,map);
            }else{
                if(totalNeedAmount < vo.getMinAmount() && totalAmount == totalNeedAmount){
                    whAllotRcd = buildWhAllotRcd(vo,map);
                }
            }
            if(whAllotRcd != null){
                try{
                    allotCode = createAllotRcd(whAllotRcd);
                    WhPreAllotRcd whPreAllotRcd = new WhPreAllotRcd();
                    whPreAllotRcd.setId(vo.getId());
                    if(isAllFinish){
                        whPreAllotRcd.setAllotStatus(WhPreAllotRcd.PRE_ALLOT_FINISH);
                        whPreAllotRcdMapper.updateByPrimaryKeySelective(whPreAllotRcd);
                    }else{
                        whPreAllotRcd.setAllotStatus(WhPreAllotRcd.PRE_ALLOTING);
                        whPreAllotRcdMapper.updateByPrimaryKeySelective(whPreAllotRcd);
                    }
                    for(WhPreAllotRcdSku whPreAllotRcdSku:whPreAllotRcdSkuList){
                        if(map.get(whPreAllotRcdSku.getSkuCode()) != null){
                            whPreAllotRcdSku.setFinishQuantity(whPreAllotRcdSku.getFinishQuantity() + map.get(whPreAllotRcdSku.getSkuCode()));
                            whPreAllotRcdSkuMapper.updateByPrimaryKeySelective(whPreAllotRcdSku);
                        }
                    }
                }catch (Exception e){
                    e.getMessage();
                }
            }
        }
        return allotCode;
    }

    private Integer findSkuCanUseQuantity(String skuCode,WhWarehouse warehouse,String physicalWarehouseCode){
        Integer whCanUseQuantity = 0,phyWhCanUseQuantity = 0;
        //逻辑仓库存
        WhInvVO whInvVO = whInvService.findCanUseQttBySkuCodeAndWarehouseCode(skuCode,warehouse.getCode());
        if(NullUtil.isNotNull(whInvVO)){
            whCanUseQuantity = whInvVO.getCanUseInv();
        }
        if(EmptyUtil.isEmpty(physicalWarehouseCode)){
            return whCanUseQuantity;
        }
        //物理仓库存--渠道分货不验证物理库存
        PhyWhStockCond cond = new PhyWhStockCond();
        cond.setPhysicalWarehouseCode(physicalWarehouseCode);
        cond.setSkuCode(skuCode);
        cond.setSkuStatus(warehouse.getCommodityStatus());
        List<PhyWhStockVO> whStockList = whWmsSkuStockService.findPhyWhStockByCond(cond);
        if(EmptyUtil.isNotEmpty(whStockList)){
            PhyWhStockVO stock = whStockList.get(0);
            phyWhCanUseQuantity = stock.getCanUseQuantity();
        }
        return Math.min(whCanUseQuantity,phyWhCanUseQuantity);
    }

    private WhAllotRcd buildWhAllotRcd(WhPreAllotRcdVO vo,HashMap<String,Integer> map){
        WhAllotRcd whAllotRcd = new WhAllotRcd();
        whAllotRcd.setAllotType(WhAllotRcd.TYPE_NORMAL);
        whAllotRcd.setTargetPhysicalWarehouseCode(vo.getTargetPhysicalWarehouseCode());
        whAllotRcd.setTargetWarehouseCode(vo.getTargetWarehouseCode());
        whAllotRcd.setSourcePhysicalWarehouseCode(vo.getSourcePhysicalWarehouseCode());
        whAllotRcd.setSourceWarehouseCode(vo.getSourceWarehouseCode());
        whAllotRcd.setReferenceCode(vo.getCode());
        whAllotRcd.setRemark(vo.getRemark());

        whAllotRcd.setCreateUserId(vo.getCreateUserId() == null ? 1 : vo.getCreateUserId().intValue());
        List<WhAllotRcdSku> skuList = new ArrayList<>();
        whAllotRcd.setWhAllotRcdSkuList(skuList);
        if(map != null && map.size() > 0){
            for(String key:map.keySet()){
                WhAllotRcdSku whAllotRcdSku = new WhAllotRcdSku();
                whAllotRcdSku.setSkuCode(key);
                whAllotRcdSku.setQuantity(map.get(key));
                skuList.add(whAllotRcdSku);
            }
        }else{
            return  null;
        }
        return whAllotRcd;
    }
    /**
     * 根据条件查找调拨
     *
     * @param cond     条件
     * @return
     */
    @Override
    public List<WhAllotRcd> findAllotRcdByCond(WhAllotCond cond) {
        List<WhAllotRcd> whAllotRcdList = whAllotRcdMapper.findAllotRcdByCond(cond);
        // 填充行记录
        if (cond.isFetch() && EmptyUtil.isNotEmpty(whAllotRcdList)) {
            List<Long> whAllotRcdIdList = new ArrayList<>();
            for (WhAllotRcd whAllotRcd : whAllotRcdList) {
                whAllotRcdIdList.add(whAllotRcd.getId());
            }

            List<WhAllotRcdSku> whAllotRcdSkuList = findAllotRcdSkuByAllotIds(whAllotRcdIdList);
            for (WhAllotRcd whAllotRcd : whAllotRcdList) {
                for (WhAllotRcdSku whAllotRcdSku : whAllotRcdSkuList) {
                    if (whAllotRcd.getId().equals(whAllotRcdSku.getAllotRcdId())) {
                        List<WhAllotRcdSku> t = whAllotRcd.getWhAllotRcdSkuList();
                        if (t == null) {
                            t = new ArrayList<>();
                            whAllotRcd.setWhAllotRcdSkuList(t);
                        }
                        t.add(whAllotRcdSku);
                    }
                }
            }
        }

        return whAllotRcdList;
    }

    @Override
    public List<WhAllotRcd> selectAllotRcdByCond(WhAllotCond cond) {
        WhAllotRcdExample example = new WhAllotRcdExample();
        WhAllotRcdExample.Criteria criteria = example.createCriteria();
        if (CollectionUtils.isNotEmpty(cond.getCodes())){
            criteria.andCodeIn(cond.getCodes());
        }
        List<WhAllotRcd> whAllotRcdList = whAllotRcdMapper.selectByExample(example);
        // 填充行记录
        if (cond.isFetch() && EmptyUtil.isNotEmpty(whAllotRcdList)) {
            List<Long> whAllotRcdIdList = new ArrayList<>();
            for (WhAllotRcd whAllotRcd : whAllotRcdList) {
                whAllotRcdIdList.add(whAllotRcd.getId());
            }

            List<WhAllotRcdSku> whAllotRcdSkuList = findAllotRcdSkuByAllotIds(whAllotRcdIdList);
            for (WhAllotRcd whAllotRcd : whAllotRcdList) {
                for (WhAllotRcdSku whAllotRcdSku : whAllotRcdSkuList) {
                    if (whAllotRcd.getId().equals(whAllotRcdSku.getAllotRcdId())) {
                        List<WhAllotRcdSku> t = whAllotRcd.getWhAllotRcdSkuList();
                        if (t == null) {
                            t = new ArrayList<>();
                            whAllotRcd.setWhAllotRcdSkuList(t);
                        }
                        t.add(whAllotRcdSku);
                    }
                }
            }
        }
        return whAllotRcdList;
    }
    
    /**
     * 根据条件查找调拨
     *
     * @param cond     条件
     * @return
     */
    @Override
    public List<WhAllotRcd> getAllotRcdByCond(WhAllotCond cond) {
        List<WhAllotRcd> whAllotRcdList = whAllotRcdMapper.getAllotRcdByCond(cond);
        return whAllotRcdList;
    }

    @Override
    @Transactional
    public void updateWhPreAllotRcdByCond(WhPreAllotRcd whPreAllotRcd) {
        if(whPreAllotRcd.getId() == null){
            if(whPreAllotRcd.getCode() != null){
                WhPreAllotRcdExample example = new WhPreAllotRcdExample();
                example.createCriteria().andCodeEqualTo(whPreAllotRcd.getCode());
                List<WhPreAllotRcd> list = whPreAllotRcdMapper.selectByExample(example);
                if(list != null && list.size() > 0){
                    whPreAllotRcd.setId(list.get(0).getId());
                }
            }
        }
        if(whPreAllotRcd.getId() != null){
            whPreAllotRcdMapper.updateByPrimaryKeySelective(whPreAllotRcd);
        }
    }

    /**
     * 根据调拨单ID查找调拨单SKU
     *
     * @param allotId 调拨单ID
     * @return 调拨单SKU列表
     */
    @Override
    public List<WhAllotRcdSku> findAllotRcdSkuByAllotId(Long allotId) {
        WhAllotRcdSkuExample example = new WhAllotRcdSkuExample();
        example.createCriteria().andAllotRcdIdEqualTo(allotId);
        example.setOrderByClause("id");
        return whAllotRcdSkuMapper.selectByExample(example);
    }

    /**
     * 根据调拨单ID查找调拨单SKU
     *
     * @param allotIdList 调拨单ID列表
     * @return 调拨单SKU列表
     */
    private List<WhAllotRcdSku> findAllotRcdSkuByAllotIds(List<Long> allotIdList) {
        WhAllotRcdSkuExample example = new WhAllotRcdSkuExample();
        example.createCriteria().andAllotRcdIdIn(allotIdList);
        example.setOrderByClause("id");
        return whAllotRcdSkuMapper.selectByExample(example);
    }

    /**
     * 根据调拨单CODE查找调拨单SKU
     *
     * @param allotCode 源调拨单CODE
     * @return 调拨单SKU列表
     */
    @Override
    public List<WhAllotRcdSku> findAllotRcdSkuByAllotCode(String allotCode) {
        WhAllotRcd whAllotRcd = findAllotRcdByCode(allotCode, false);
        return whAllotRcd != null ? findAllotRcdSkuByAllotId(whAllotRcd.getId())
            : new ArrayList<WhAllotRcdSku>();
    }

    /**
     * 根据仓库CODE查找待确认调拨单
     *
     * @param warehouseCode 仓库CODE
     * @return 调拨单
     */
    @Override
    public List<WhAllotRcd> findAllotRcdWaitForConfirmation(String warehouseCode) {
        WhAllotRcdExample example = new WhAllotRcdExample();
        example.createCriteria().andAllotStatusEqualTo(WhAllotRcd.STATUS_WAIT_FOR_CONFIRMATION)
            .andConfirmWarehouseCodeEqualTo(warehouseCode);
        example.setOrderByClause("id");
        return whAllotRcdMapper.selectByExample(example);
    }

    /**
     * 根据仓库CODE查找待出库调拨单
     *
     * @param warehouseCode 仓库CODE
     * @return 调拨单
     */
    @Override
    public List<WhAllotRcd> findAllotRcdWaitForOutbound(String warehouseCode) {
        WhAllotRcdExample example = new WhAllotRcdExample();
        example.createCriteria().andAllotStatusEqualTo(WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND)
            .andSourceWarehouseCodeEqualTo(warehouseCode);
        example.setOrderByClause("id");
        return whAllotRcdMapper.selectByExample(example);
    }

    /**
     * 根据仓库CODE查找待入库调拨单
     *
     * @param warehouseCode 仓库CODE
     * @return 调拨单
     */
    @Override
    public List<WhAllotRcd> findAllotRcdWaitForInbound(String warehouseCode) {
        WhAllotRcdExample example = new WhAllotRcdExample();
        example.createCriteria().andAllotStatusEqualTo(WhAllotRcd.STATUS_WAIT_FOR_INBOUND)
            .andTargetWarehouseCodeEqualTo(warehouseCode);
        example.setOrderByClause("id");
        return whAllotRcdMapper.selectByExample(example);
    }

    /**
     * 根据ID更新调拨单状态
     *
     * @param id        源调拨单ID
     * @param newStatus 新状态
     * @return 是否成功
     * @throws Exception 
     */
    @Override
    public boolean updateAllotRcdStatusById(Long id, Integer newStatus) throws Exception {
        WhAllotRcd rcd = whAllotRcdMapper.selectByPrimaryKey(id);
        return rcd != null ? updateAllotRcdStatus(rcd, newStatus) : false;
    }

    /**
     * 根据CODE更新调拨单状态
     *
     * @param code      源调拨单CODE
     * @param newStatus 新状态
     * @return 是否成功
     * @throws Exception 
     */
    @Override
    public boolean updateAllotRcdStatusByCode(String code, Integer newStatus) throws Exception {
        WhAllotRcd rcd = findAllotRcdByCode(code, false);
        return rcd != null ? updateAllotRcdStatus(rcd, newStatus) : false;
    }
    
    /**
     * 根据CODE更新调拨单状态
     *
     * @param code      源调拨单CODE
     * @param newStatus 新状态
     * @return 是否成功
     * @throws Exception 
     */
    @Override
    public boolean updateAllotRcdStatusByCodeNew(String code, Integer newStatus,String rejectedReason) throws Exception {
        WhAllotRcd rcd = findAllotRcdByCode(code, false);
        return rcd != null ? updateAllotRcdStatusNew(rcd, newStatus,rejectedReason) : false;
    }

    /**
     * 更新调拨单状态
     *
     * @param rcd       调拨单
     * @param newStatus 新状态
     * @return 是否成功
     * @throws Exception 
     */
    @Transactional
    public boolean updateAllotRcdStatus(WhAllotRcd rcd, Integer newStatus) throws Exception {
        Integer oldStatus = rcd.getAllotStatus();
        if (WhAllotRcd.STATUS_WAIT_FOR_CONFIRMATION.equals(oldStatus)
            && WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND.equals(newStatus)) {
            boolean diffProcess = rcd.isDiffProcess(), needWaitInBound = rcd.isNeedWaitInBound();
            //待确认-待出库，确认完成
            rcd = findAllotRcdByCode(rcd.getCode(), true);
            rcd.setDiffProcess(diffProcess);
            rcd.setNeedWaitInBound(needWaitInBound);
            //查询是否已经占用库存
            WhCommand whCommandOut = whCommandService.findCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_OCCUPY, rcd.getCode(), true);
            // 记录调拨出库指令
            if(EmptyUtil.isEmpty(whCommandOut)) {
        		whCommandOut = buildAltOutCommand(rcd);
                whCommandOut.setInOutType(WhCommand.TYPE_ALLOT_OUT);
    			whCommandOut.setExpressNo(rcd.getCode());
    			whCommandService.createCommand(whCommandOut);
            }else{
            	whCommandOut.setInOutType(WhCommand.TYPE_ALLOT_OUT);
                whCommandOut.setPlanedDeliveryDate(rcd.getEstimatedAllocationDate());//冗余预计发货日期
            	whCommandService.updateCommand(whCommandOut);
            	List<WhCommandSku> commandSkuList = whCommandOut.getWhCommandSkuList();
            	if(EmptyUtil.isNotEmpty(commandSkuList)) {
            		for(WhCommandSku whCommandSku : commandSkuList) {
            			WhInvOccupy record = new WhInvOccupy();
            			record.setReferenceCode(whCommandSku.getCode());
            			record.setOccupyType(WhCommand.TYPE_ALLOT_OUT);
            			whInvService.updateOccupyType(record);
            		}
            	}
            }
          
        } else if (WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND.equals(oldStatus)
                   && WhAllotRcd.STATUS_WAIT_FOR_INBOUND.equals(newStatus)) {
            //待出库->待入库
            rcd = findAllotRcdByCode(rcd.getCode(), false);
            // 查找调拨出库指令
            WhCommand whCommand = whCommandService.findCommandByTypeAndReferenceCode(
                WhCommand.TYPE_ALLOT_OUT, rcd.getCode(), true);

            // 指令SKU列表
            List<WhCommandSku> whCommandSkuList = new ArrayList<>();
            for (WhCommandSku allotOutWhCommandSku : whCommand.getWhCommandSkuList()) {
                WhCommandSku whCommandSku = new WhCommandSku();
                whCommandSku.setSkuCode(allotOutWhCommandSku.getSkuCode());
                int quantity = allotOutWhCommandSku.getQuantity();
                // 判断出库sku数量是否是0
                if (quantity != 0) {
                    whCommandSku.setPlanedQuantity(quantity);
                    whCommandSkuList.add(whCommandSku);
                }
            }

            // 判断出库sku数量是否都是0（whCommandSkuList.size()==0），如果是则设置新状态为完成（newStatus=4），并跳出（不创建入库指令）
            if (whCommandSkuList.size() == 0) {
                newStatus = WhAllotRcd.STATUS_FINISHED;
                rcd.setFinishTime(new Date());

                // 调拨状态完成时，且调拨类型为耗材调拨时，自动生成耗材领用单
                if (rcd.getAllotType() == WhAllotRcd.TYPE_CONSUMABLE){

                }
            } else {
                // 记录调拨入库指令
                WhCommand whCommandIn = buildAltInCommand(rcd);
                whCommandIn.setReferenceCode(rcd.getCode());
                whCommandIn.setWhCommandSkuList(whCommandSkuList);//出库指令组装
                whCommandService.createCommand(whCommandIn);
            }
        } else if (WhAllotRcd.STATUS_WAIT_FOR_INBOUND.equals(oldStatus)
                   && WhAllotRcd.STATUS_FINISHED.equals(newStatus)) {
            //待入库->完成
            rcd.setFinishTime(new Date());
        } else if (WhAllotRcd.STATUS_CANCELED.equals(newStatus)) {
            // 取消，且非待确认状态，则有command需要取消
            if(WhAllotRcd.STATUS_WAIT_FOR_CONFIRMATION.equals(oldStatus)){
                //待确认-》取消
                releaseAllotOccupation(rcd.getCode());
            }else if(WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND.equals(oldStatus)){
                //待出库-》取消
                String commandReferenceCode = rcd.getCode();
                //有出库指令
                if(whCommandService.findCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_OUT, commandReferenceCode, false) != null) {
                    if (!whCommandService.cancelCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_OUT,
                            commandReferenceCode)) {
                        throw new WarehouseException(WarehouseExceptionErrorCode.UPDATE_OCCUPY_FAILED,"调拨单取消失败");
                    }
                }
            }else if(!WhAllotRcd.STATUS_WAIT_FOR_CONFIRMATION.equals(oldStatus)) {
                String commandReferenceCode = rcd.getCode();
                //有出库指令
                if(whCommandService.findCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_OUT, commandReferenceCode, false) != null) {
                    if (!whCommandService.cancelCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_OUT,
                                                                              commandReferenceCode)) {
                        throw new WarehouseException(WarehouseExceptionErrorCode.UPDATE_OCCUPY_FAILED,
                                                     "updateAllotRcdStatus failed[cancel] , code = " + commandReferenceCode
                                                     + " , oldStatus = " + oldStatus + " , newStatus = " + newStatus);
                    }
                }
                if(whCommandService.findCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_IN, commandReferenceCode, false) != null) {
                    if (!whCommandService.cancelCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_IN, rcd.getCode())) {
                        throw new WarehouseException(WarehouseExceptionErrorCode.UPDATE_OCCUPY_FAILED,
                                                     "updateAllotRcdStatus failed[cancel] , code = " + rcd.getCode()
                                                     + " , oldStatus = " + oldStatus + " , newStatus = " + newStatus);
                    }
                }
            }
        } else if (WhAllotRcd.STATUS_WAIT_FOR_CONFIRMATION.equals(oldStatus)
                   && WhAllotRcd.STATUS_REJECTED.equals(newStatus)) {
            releaseAllotOccupation(rcd.getCode());
//        	WhCommand whCommand =  whCommandService.findCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_OCCUPY, rcd.getCode(), true);
//        	if(whCommand != null && whCommand.getWhCommandSkuList() != null) {
//        		List<WhReleaseOccupationVO> whReleaseOccupationVOList = new ArrayList<>();
//        		for(WhCommandSku whCommandSku : whCommand.getWhCommandSkuList()) {
//        			WhReleaseOccupationVO whReleaseOccupationVO = new WhReleaseOccupationVO();
//        			whReleaseOccupationVO.setReferenceCode(whCommandSku.getCode());
//        			whReleaseOccupationVO.setOccupyType(WhCommand.TYPE_ALLOT_OCCUPY);
//
//                    whInvService.releaseOccupation(whReleaseOccupationVO);
//        			whReleaseOccupationVOList.add(whReleaseOccupationVO);
//        		}
//        		//whInvService.releaseOccupation(whReleaseOccupationVOList);
//        	}
//        	whCommandService.cancelCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_OCCUPY, rcd.getCode());
            // 驳回
        } else if (WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND.equals(oldStatus)
                && WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND.equals(newStatus)){
        	//耗材调拨确认后再确认的情况
        	
        	return true;
        } else {
            throw new WarehouseException(WarehouseExceptionErrorCode.UPDATE_ALLOT_FAILED,
                "updateAllotRcdStatus failed,status illegal");
        }

        rcd.setAllotStatus(newStatus);
        return whAllotRcdMapper.updateByPrimaryKeySelective(rcd) != 0;
    }

    /**
     * 更新调拨单状态
     *
     * @param rcd       调拨单
     * @param newStatus 新状态
     * @return 是否成功
     * @throws Exception 
     */
    @Transactional
    public boolean updateAllotRcdStatusNew(WhAllotRcd rcd, Integer newStatus,String rejectedReason) throws Exception {
        Integer oldStatus = rcd.getAllotStatus();

        if (WhAllotRcd.STATUS_WAIT_FOR_CONFIRMATION.equals(oldStatus)
            && WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND.equals(newStatus)) {
            //待确认-待出库，确认完成
            rcd = findAllotRcdByCode(rcd.getCode(), true);
            rcd.setConfirmTime(DateUtil.getNow());//确认时间
            // 指令SKU列表
            List<WhCommandSku> whCommandSkuList = new ArrayList<>();
            for (WhAllotRcdSku whAllotRcdSku : rcd.getWhAllotRcdSkuList()) {
                WhCommandSku whCommandSku = new WhCommandSku();
                whCommandSku.setSkuCode(whAllotRcdSku.getSkuCode());
                whCommandSku.setPlanedQuantity(whAllotRcdSku.getQuantity());
                whCommandSkuList.add(whCommandSku);
            }
            
            //查询是否已经占用库存
            WhCommand whCommandOut = whCommandService.findCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_OCCUPY, rcd.getCode(), true);
            // 记录调拨出库指令
            if(EmptyUtil.isEmpty(whCommandOut)) {
        		whCommandOut = new WhCommand();
        		whCommandOut.setReferenceCode(rcd.getCode());
        		whCommandOut.setInOutType(WhCommand.TYPE_ALLOT_OUT);
                whCommandOut.setPlanedDeliveryDate(rcd.getEstimatedAllocationDate());//冗余预计发货日期
        		whCommandOut.setWarehouseCode(rcd.getSourceWarehouseCode());
        		whCommandOut.setWhCommandSkuList(whCommandSkuList);
    			  whCommandOut.setExpressNo(rcd.getCode());
    			  whCommandService.createCommand(whCommandOut);
            } else {
            	whCommandOut.setInOutType(WhCommand.TYPE_ALLOT_OUT);
                whCommandOut.setPlanedDeliveryDate(rcd.getEstimatedAllocationDate());//冗余预计发货日期
            	whCommandService.updateCommand(whCommandOut);
            	List<WhCommandSku> commandSkuList = whCommandOut.getWhCommandSkuList();
            	if(EmptyUtil.isNotEmpty(commandSkuList)) {
            		for(WhCommandSku whCommandSku : commandSkuList) {
            			WhInvOccupy record = new WhInvOccupy();
            			record.setReferenceCode(whCommandSku.getCode());
            			record.setOccupyType(WhCommand.TYPE_ALLOT_OUT);
            			whInvService.updateOccupyType(record);
            		}
            	}
            }
          
        } else if (WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND.equals(oldStatus)
                   && WhAllotRcd.STATUS_WAIT_FOR_INBOUND.equals(newStatus)) {
            //待确认-待出库，确认完成
            rcd = findAllotRcdByCode(rcd.getCode(), false);

            // 查找调拨出库指令
            WhCommand whCommand = whCommandService.findCommandByTypeAndReferenceCode(
                WhCommand.TYPE_ALLOT_OUT, rcd.getCode(), true);

            // 指令SKU列表
            List<WhCommandSku> whCommandSkuList = new ArrayList<>();
            for (WhCommandSku allotOutWhCommandSku : whCommand.getWhCommandSkuList()) {
                WhCommandSku whCommandSku = new WhCommandSku();
                whCommandSku.setSkuCode(allotOutWhCommandSku.getSkuCode());
                int quantity = allotOutWhCommandSku.getQuantity();
                // 判断出库sku数量是否是0
                if (quantity != 0) {
                    whCommandSku.setPlanedQuantity(quantity);
                    whCommandSkuList.add(whCommandSku);
                }
            }

            // 判断出库sku数量是否都是0（whCommandSkuList.size()==0），如果是则设置新状态为完成（newStatus=4），并跳出（不创建入库指令）
            if (whCommandSkuList.size() == 0) {
                newStatus = WhAllotRcd.STATUS_FINISHED;
                rcd.setFinishTime(new Date());

                // 调拨状态完成时，且调拨类型为耗材调拨时，自动生成耗材领用单
                if (rcd.getAllotType() == WhAllotRcd.TYPE_CONSUMABLE){

                }
            } else {
                // 记录调拨入库指令
                WhCommand whCommandIn = new WhCommand();
                whCommandIn.setReferenceCode(rcd.getCode());
                whCommandIn.setInOutType(WhCommand.TYPE_ALLOT_IN);
                whCommandIn.setWarehouseCode(rcd.getTargetWarehouseCode());
                whCommandIn.setWhCommandSkuList(whCommandSkuList);
                whCommandService.createCommand(whCommandIn);
            }
        } else if (WhAllotRcd.STATUS_WAIT_FOR_INBOUND.equals(oldStatus)
                   && WhAllotRcd.STATUS_FINISHED.equals(newStatus)) {
            rcd.setFinishTime(new Date());
        } else if (WhAllotRcd.STATUS_CANCELED.equals(newStatus)) {
            // 取消，且非待确认状态，则有command需要取消
            if (!WhAllotRcd.STATUS_WAIT_FOR_CONFIRMATION.equals(oldStatus)) {
                String commandReferenceCode = rcd.getCode();
                //有出库指令
                if(whCommandService.findCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_OUT, commandReferenceCode, false) != null) {
                    if (!whCommandService.cancelCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_OUT,
                                                                              commandReferenceCode)) {
                        throw new WarehouseException(WarehouseExceptionErrorCode.UPDATE_OCCUPY_FAILED,
                                                     "updateAllotRcdStatus failed[cancel] , code = " + commandReferenceCode
                                                     + " , oldStatus = " + oldStatus + " , newStatus = " + newStatus);
                    }
                }
                if(whCommandService.findCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_IN, commandReferenceCode, false) != null) {
                    if (!whCommandService.cancelCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_IN, rcd.getCode())) {
                        throw new WarehouseException(WarehouseExceptionErrorCode.UPDATE_OCCUPY_FAILED,
                                                     "updateAllotRcdStatus failed[cancel] , code = " + rcd.getCode()
                                                     + " , oldStatus = " + oldStatus + " , newStatus = " + newStatus);
                    }
                }

            }  else { //待确认状态也需要取消commd
            	releaseAllotOccupation(rcd.getCode());
            }
        } else if (WhAllotRcd.STATUS_WAIT_FOR_CONFIRMATION.equals(oldStatus)
                   && WhAllotRcd.STATUS_REJECTED.equals(newStatus)) {
            releaseAllotOccupation(rcd.getCode());
            rcd.setRejectedReason(rejectedReason);//驳回原因
//        	WhCommand whCommand =  whCommandService.findCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_OCCUPY, rcd.getCode(), true);
//        	if(whCommand != null && whCommand.getWhCommandSkuList() != null) {
//        		List<WhReleaseOccupationVO> whReleaseOccupationVOList = new ArrayList<>();
//        		for(WhCommandSku whCommandSku : whCommand.getWhCommandSkuList()) {
//        			WhReleaseOccupationVO whReleaseOccupationVO = new WhReleaseOccupationVO();
//        			whReleaseOccupationVO.setReferenceCode(whCommandSku.getCode());
//        			whReleaseOccupationVO.setOccupyType(WhCommand.TYPE_ALLOT_OCCUPY);
//
//                    whInvService.releaseOccupation(whReleaseOccupationVO);
//        			whReleaseOccupationVOList.add(whReleaseOccupationVO);
//        		}
//        		//whInvService.releaseOccupation(whReleaseOccupationVOList);
//        	}
//        	whCommandService.cancelCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_OCCUPY, rcd.getCode());
            // 驳回
        } else if (WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND.equals(oldStatus)
                && WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND.equals(newStatus)){
        	//耗材调拨确认后再确认的情况
        	
        	return true;
        } else {
            throw new WarehouseException(WarehouseExceptionErrorCode.UPDATE_ALLOT_FAILED,
                "updateAllotRcdStatus failed,status illegal");
        }

        rcd.setAllotStatus(newStatus);
        return whAllotRcdMapper.updateByPrimaryKeySelective(rcd) != 0;
    }
    
    //释放调拨占用库存
    private void releaseAllotOccupation(String referenceCode) {
    	WhCommand whCommand =  whCommandService.findCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_OCCUPY, referenceCode, true);
    	if(whCommand != null && whCommand.getWhCommandSkuList() != null) {
//    		List<WhReleaseOccupationVO> whReleaseOccupationVOList = new ArrayList<>();
    		for(WhCommandSku whCommandSku : whCommand.getWhCommandSkuList()) {
    			WhReleaseOccupationVO whReleaseOccupationVO = new WhReleaseOccupationVO();
    			whReleaseOccupationVO.setReferenceCode(whCommandSku.getCode());
    			whReleaseOccupationVO.setOccupyType(WhCommand.TYPE_ALLOT_OCCUPY);
                whInvService.releaseOccupation(whReleaseOccupationVO);
//                final int res = whInvOccupyMapper.releaseOccupation(whReleaseOccupationVO.getOccupyType(),
//                    whReleaseOccupationVO.getReferenceCode());
//    			whReleaseOccupationVOList.add(whReleaseOccupationVO);
    		}
    		//whInvService.releaseOccupation(whReleaseOccupationVOList);
    	}
    	whCommandService.cancelCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_OCCUPY, referenceCode);
    }
    @Override
    @Transactional
    public List<String> createAllotRcdByList(List<WhAllotRcdVO> whAllotRcdVOList) throws Exception {
        HashMap<String,WhAllotRcd> map = new HashMap<String,WhAllotRcd>();
        List<String> list = new ArrayList<>();
        if(whAllotRcdVOList != null && whAllotRcdVOList.size() > 0){
            for(WhAllotRcdVO whAllotRcdVO:whAllotRcdVOList){
                WhInvVO canUseQttByWhDispathing = whInvService.findCanUseQttBySkuCodeAndWarehouseCode(whAllotRcdVO.getSkuCode(), whAllotRcdVO.getSourceWarehouseCode());
                if(canUseQttByWhDispathing.getCanUseInv() < whAllotRcdVO.getPlanAmount()){
                    throw new RuntimeException("调拨数量不足");
                }
                if(map.get(whAllotRcdVO.getSourceWarehouseCode()+"_"+whAllotRcdVO.getTargetWarehouseCode()) == null){
                    WhAllotRcd whAllotRcd = new WhAllotRcd();
                    whAllotRcd.setAllotType(WhAllotRcd.TYPE_NORMAL);
                    whAllotRcd.setSourceWarehouseCode(whAllotRcdVO.getSourceWarehouseCode());
                    whAllotRcd.setTargetWarehouseCode(whAllotRcdVO.getTargetWarehouseCode());
                    whAllotRcd.setRemark("预售SKU库间自动调拨");
                    map.put(whAllotRcdVO.getSourceWarehouseCode()+"_"+whAllotRcdVO.getTargetWarehouseCode(),whAllotRcd);
                }
                WhAllotRcd whAllotRcd = map.get(whAllotRcdVO.getSourceWarehouseCode()+"_"+whAllotRcdVO.getTargetWarehouseCode());
                this.buildWhAllotRcd(whAllotRcd,whAllotRcdVO.getSkuCode(),whAllotRcdVO.getPlanAmount());
            }
        }
        if(map.size() > 0){
            for(WhAllotRcd whAllotRcd:map.values()){
                list.add(createAllotRcd(whAllotRcd));
            }
        }
        return list;
    }

    /**
     *
     * @param whAllotRcd
     * @param skuCode
     * @param quantity
     * @return
     */
    private void buildWhAllotRcd(WhAllotRcd whAllotRcd,String skuCode, Integer quantity){
        WhAllotRcdSku whAllotRcdSku = new WhAllotRcdSku();
        whAllotRcdSku.setSkuCode(skuCode);
        whAllotRcdSku.setQuantity(quantity);
        if(whAllotRcd.getWhAllotRcdSkuList() != null && whAllotRcd.getWhAllotRcdSkuList().size() > 0){
            whAllotRcd.getWhAllotRcdSkuList().add(whAllotRcdSku);
        }else{
            List<WhAllotRcdSku> whAllotRcdSkus = new ArrayList<>();
            whAllotRcdSkus.add(whAllotRcdSku);
            whAllotRcd.setWhAllotRcdSkuList(whAllotRcdSkus);
        }
    }

    @Override
    @Transactional
    public boolean revertAllotRcd(String code) throws Exception {
        WhAllotRcdExample example = new WhAllotRcdExample();
        example.createCriteria().andCodeEqualTo(code);
        List<WhAllotRcd> whAllotRcdList = whAllotRcdMapper.selectByExample(example);
        if(whAllotRcdList != null && whAllotRcdList.size() > 0){
            WhAllotRcd whAllotRcd = whAllotRcdList.get(0);
            WhAllotRcd whAllotRcd1 = new WhAllotRcd();
            whAllotRcd1.setAllotType(WhAllotRcd.TYPE_NORMAL);
            whAllotRcd1.setSourceWarehouseCode(whAllotRcd.getTargetWarehouseCode());
            whAllotRcd1.setTargetWarehouseCode(whAllotRcd.getSourceWarehouseCode());
            List<WhAllotRcdSku> list = new ArrayList<>();
            WhAllotRcdSkuExample example1 = new WhAllotRcdSkuExample();
            example1.createCriteria().andAllotRcdIdEqualTo(whAllotRcd.getId());

            List<WhAllotRcdSku> skuList = whAllotRcdSkuMapper.selectByExample(example1);
            for(WhAllotRcdSku whAllotRcdSku :skuList){
                WhAllotRcdSku whAllotRcdSku1 = new WhAllotRcdSku();
                whAllotRcdSku1.setQuantity(whAllotRcdSku.getQuantity());
                whAllotRcdSku1.setSkuCode(whAllotRcdSku.getSkuCode());
                list.add(whAllotRcdSku1);
            }
            whAllotRcd1.setWhAllotRcdSkuList(list);
            createAllotRcd(whAllotRcd1);
        }
        return true;
    }

    @Override
    @Transactional
    public List<String> batchCreatePreAllotRcd(List<WhPreAllotRcd> whPreAllotRcdList) throws Exception {
        checkPreAllot(whPreAllotRcdList);
        List<String>  allotCodeList = new ArrayList<String>();
        if(EmptyUtil.isNotEmpty(whPreAllotRcdList)) {
            for (WhPreAllotRcd whPreAllotRcd : whPreAllotRcdList) {
                allotCodeList.add(createPreAllot(whPreAllotRcd));
            }
        }
        return allotCodeList;
    }

    /**
     * 更新调拨单状态
     *
     * @return 是否成功
     */
    @Override
    public boolean updateAllotRcd(WhAllotRcd rcd) {
        return whAllotRcdMapper.updateByPrimaryKeySelective(rcd) != 0;
    }

    /**
     * 更新调拨记录行
     *
     * @return 是否成功
     */
    @Override
    public boolean updateAllotRcdSku(WhAllotRcdSku rcdSku){
        return whAllotRcdSkuMapper.updateByPrimaryKeySelective(rcdSku) !=0;
    }


    @Override
    @Transactional
    public boolean allotPackageInbound(WhAllotPackageInBoundVO altPackageInBound) {
        WhWmsConnectAllotPackageVO altPackage = whWmsConnectAllotPackageService
                .findConnectAltPackage(altPackageInBound.getCode());

        if(NullUtil.isNull(altPackage)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                    String.format("调拨箱号[%s]不存在",altPackageInBound.getCode()));
        }
        if(!WhWmsConnectAllotPackageVO.STATUS_WAITING_RECEIVE.equals(altPackage.getStatus())){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                    ,String.format("调拨箱号[%s]当前状态[%s]",altPackage.getCode(),altPackage.getStatusName()));
        }

        altPackage.setStatus(WhWmsConnectAllotPackageVO.STATUS_RECEIVED);
        whWmsConnectAllotPackageService.updateCnnectAltPackage(altPackage);

        //所有调拨装箱是否都已完成
        List<WhWmsConnectAllotPackageVO> altPackageList = whWmsConnectAllotPackageService
                .findByConnectId(altPackage.getConnectId());
        boolean allAltPackageDone = isAllAltPackageInBoundDone(altPackageList);

        altPackageInBound.setLastPackage(allAltPackageDone);
        altPackageInBound.setPhysicalWarehouseCode(altPackage.getTargetPhysicalWarehouseCode());
        altPackageInBound.setWarehouseCode(altPackage.getTargetWarehouseCode());

        WhWarehouse warehouse = whInfoService.findWarehouseByCode(altPackageInBound.getWarehouseCode());
        altPackageInBound.setWhCommodityStatus(warehouse.getCommodityStatus());

        //填充批次数据
        List<WhAllotPackageInBoundSkuDetailVO> fixInBoundSkuDetailList =
                rebuildAltPackageInboundSkuDetail(altPackageInBound,altPackage);
        altPackageInBound.setInBoundSkuDetailList(fixInBoundSkuDetailList);
        //更新指令数据，记录库存
        whCommandService.processAllotPackageInBound(altPackageInBound);
        return true;
    }

    private boolean isAllAltPackageInBoundDone(List<WhWmsConnectAllotPackageVO> altPackageList){
        for(WhWmsConnectAllotPackageVO altPackage : altPackageList){
            if(!WhWmsConnectAllotPackageVO.STATUS_RECEIVED.equals(altPackage.getStatus())){
                return false;
            }
        }
        return true;
    }

    //填充批次数据：以店员扫描数据为准，不足则填充
    private List<WhAllotPackageInBoundSkuDetailVO> rebuildAltPackageInboundSkuDetail(WhAllotPackageInBoundVO altPackageInBound
            ,WhWmsConnectAllotPackageVO altPackage){
        List<WhAllotPackageInBoundSkuDetailVO> inBoundSkuDetailList = altPackageInBound.getInBoundSkuDetailList();
        if(EmptyUtil.isEmpty(inBoundSkuDetailList)){
            return null;
        }
        Map<String,Integer> inSkuQtMap = new HashMap<>();//入库sku汇总
        Map<String,Integer> inBarcodeQtMap = new HashMap<>();//入库批次sku汇总
        Map<String,Integer> outSkuQtMap = new HashMap<>();//调拨出sku汇总
        Map<String,List<String>> outSkuBarcodeMap = new HashMap<>();//调拨出sku批次map
        Map<String,Integer> outBarcodeQtMap = new HashMap<>();//调拨出批次汇总
        //入库数据汇总
        altPackgeInBoundSkuGroup(altPackageInBound,inSkuQtMap,inBarcodeQtMap);
        //调拨出数据汇总
        altPackgeOutBoundSkuGroup(altPackage,outSkuQtMap,outSkuBarcodeMap,outBarcodeQtMap);
        //数量检查
        for(Map.Entry<String,Integer> inSkuQtEntry : inSkuQtMap.entrySet()){
            Integer outQt = outSkuQtMap.get(inSkuQtEntry.getKey());
            if(NullUtil.isNull(outQt)){
                outQt = 0;
            }
            if(outQt.compareTo(inSkuQtEntry.getValue()) < 0){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                        ,String.format("[%s]入库数量超出装箱单数量[%s>%s]"
                        ,inSkuQtEntry.getKey(),inSkuQtEntry.getKey(),outQt));
            }
        }
        //批次验证
        checkAltInBarcode(inBarcodeQtMap.keySet());
        //扣除扫描批次数量
        Map<String,Integer> restOutBarcodeQtMap = new HashMap<>(outBarcodeQtMap);//clone
        for(Map.Entry<String,Integer> inBarcodeQtEntry : inBarcodeQtMap.entrySet()){
            Integer outTotal = restOutBarcodeQtMap.get(inBarcodeQtEntry.getKey());
            if(NullUtil.isNull(outTotal)){
                continue;
            }
            restOutBarcodeQtMap.put(inBarcodeQtEntry.getKey(),outTotal - inBarcodeQtEntry.getValue());
        }
        //批次码填充
        List<WhAllotPackageInBoundSkuDetailVO> fixedInDetailList = new ArrayList<>();
        for(WhAllotPackageInBoundSkuDetailVO inBoundSkuDetail : inBoundSkuDetailList){
            if(EmptyUtil.isNotEmpty(inBoundSkuDetail.getBarCode())){
                fixedInDetailList.add(inBoundSkuDetail);
                continue;
            }
            Integer needQt = inBoundSkuDetail.getQuantity();
            if(needQt == 0){
                continue;
            }
            List<String> barcodeList = outSkuBarcodeMap.get(inBoundSkuDetail.getSkuCode());
            for(String barcode : barcodeList){
                Integer barcodeQt = restOutBarcodeQtMap.get(barcode);
                if(barcodeQt <= 0){
                    restOutBarcodeQtMap.remove(barcode);//移除无用key
                    continue;
                }
                Integer canUse = Math.min(needQt,barcodeQt);
                needQt -= canUse;
                barcodeQt -= canUse;
                restOutBarcodeQtMap.put(barcode,barcodeQt);
                WhAllotPackageInBoundSkuDetailVO partSkuDetail = BeanUtil
                        .buildFrom(inBoundSkuDetail,WhAllotPackageInBoundSkuDetailVO.class);
                partSkuDetail.setQuantity(canUse);
                partSkuDetail.setBarCode(barcode);
                fixedInDetailList.add(partSkuDetail);
                if(needQt == 0){
                    break;
                }
            }
            if(needQt != 0 ){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                        ,String.format("[%s]入库数量异常",inBoundSkuDetail.getQuantity()));
            }
        }
        return fixedInDetailList;
    }

    private void checkAltInBarcode(Set<String> barcodes){
        List<String> list = new ArrayList<>(barcodes);
        if(EmptyUtil.isEmpty(list)){
            return;
        }
        Map<String,WhWmsSkuBarcodeVO> bacodeMap = whWmsSkuBarcodeService.getBarcodeMap(list);

        for(String bacode : barcodes){
            WhWmsSkuBarcodeVO barcodeVO = bacodeMap.get(bacode);
            if(NullUtil.isNull(barcodeVO)){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                        ,String.format("不存在批次[%s]",bacode));
            }
        }
    }

    private void altPackgeOutBoundSkuGroup(WhWmsConnectAllotPackageVO altPackage
            ,Map<String,Integer> outSkuQtMap
            ,Map<String,List<String>> outSkuBarcodeMap
            ,Map<String,Integer> outBarcodeQtMap){
        for(WhWmsConnectAllotPackageDetailVO allotPackageDetail : altPackage.getDetails()){
            //调拨出数量汇总
            if(allotPackageDetail.getQuantity() == 0){
                continue;
            }
            Integer total = outSkuQtMap.get(allotPackageDetail.getSkuCode());
            if(NullUtil.isNull(total)){
                total = 0;
            }
            outSkuQtMap.put(allotPackageDetail.getSkuCode(),total + allotPackageDetail.getQuantity());

            Integer barcodeTotal = outBarcodeQtMap.get(allotPackageDetail.getBarCode());
            if(NullUtil.isNull(barcodeTotal)){
                barcodeTotal = 0;
            }
            outBarcodeQtMap.put(allotPackageDetail.getBarCode(),barcodeTotal + allotPackageDetail.getQuantity());

            //调拨出批次汇总
            List<String> barcodeList = outSkuBarcodeMap.get(allotPackageDetail.getSkuCode());
            if(NullUtil.isNull(barcodeList)){
                barcodeList = new ArrayList<>();
                outSkuBarcodeMap.put(allotPackageDetail.getSkuCode(),barcodeList);
            }
            if(!barcodeList.contains(allotPackageDetail.getBarCode())){
                barcodeList.add(allotPackageDetail.getBarCode());
            }
        }
    }

    private void altPackgeInBoundSkuGroup(WhAllotPackageInBoundVO altPackageInBound,Map<String,Integer> inSkuQtMap
            ,Map<String,Integer> inBarcodeQtMap){
        List<WhAllotPackageInBoundSkuDetailVO> inBoundSkuDetailList = altPackageInBound.getInBoundSkuDetailList();
        if(EmptyUtil.isEmpty(inBoundSkuDetailList)){
            return;
        }
        for(WhAllotPackageInBoundSkuDetailVO inBoundSkuDetail : inBoundSkuDetailList){
            //入库数量汇总
            if(inBoundSkuDetail.getQuantity() == 0){
                continue;
            }
            Integer total = inSkuQtMap.get(inBoundSkuDetail.getSkuCode());
            if(NullUtil.isNull(total)){
                total = 0;
            }
            inSkuQtMap.put(inBoundSkuDetail.getSkuCode(),total + inBoundSkuDetail.getQuantity());
            //入库批次汇总
            if(EmptyUtil.isNotEmpty(inBoundSkuDetail.getBarCode())){
                //转大写
                inBoundSkuDetail.setBarCode(inBoundSkuDetail.getBarCode().toUpperCase());
                Integer barcodeTotal = inBarcodeQtMap.get(inBoundSkuDetail.getBarCode());
                if(NullUtil.isNull(barcodeTotal)){
                    barcodeTotal = 0;
                }
                inBarcodeQtMap.put(inBoundSkuDetail.getBarCode(),barcodeTotal + inBoundSkuDetail.getQuantity());
            }
        }
    }

    @Override
	public List<WhAllotDiffSendMessageVO> getWhAllotDiffMessage(WhAllotCond cond) {
        if (CollectionUtils.isNotEmpty(cond.getCodes())){
            return whAllotRcdMapper.getWhAllotDiffMessage(cond.getCodes());
        }else{
            WhAllotRcdExample example = new WhAllotRcdExample();
            example.createCriteria()
                    .andAllotStatusEqualTo(WhAllotRcd.STATUS_FINISHED)
                    .andFinishTimeBetween(cond.getStartTime(), cond.getEndTime());
            List<WhAllotRcd> rcdList = whAllotRcdMapper.selectByExample(example);
            List<String> codeList = new ArrayList<String>(rcdList.size());
            if(CollectionUtils.isNotEmpty(rcdList)){
                for(WhAllotRcd rcd : rcdList){
                    codeList.add(rcd.getCode());
                }
                return whAllotRcdMapper.getWhAllotDiffMessage(codeList);
            }
        }
		return null;
	}

    @Override
    public void confirmExecuteAutoAllot(String allotRcdCode) throws Exception {
        WhAllotRcd rcd = findAllotRcdByCode(allotRcdCode, true);

        WhWarehouse whWarehouse = whInfoService.findWarehouseByCode(rcd.getTargetWarehouseCode());
        Long targetGroupId = whWarehouse.getWarehouseGroupId();
        //同分组自动完成
        if (targetGroupId == Constants.PHYSICAL_WAREHOUSE_DEFAULT_GROUP_ID) {
            finishAllotRcdCommand(rcd, true, false);
        } else {
            updateAllotRcdStatusByCodeNew(allotRcdCode ,WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND ,"自动分货确认");
        }
    }
}