package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.commdata.service.ChannelQueryService;
import com.thebeastshop.pegasus.service.warehouse.cond.TmallStockLogCond;
import com.thebeastshop.pegasus.service.warehouse.dao.TmallStockLogMapper;
import com.thebeastshop.pegasus.service.warehouse.model.TmallStockLog;
import com.thebeastshop.pegasus.service.warehouse.model.WhAllotRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhAllotRcdSku;
import com.thebeastshop.pegasus.service.warehouse.service.TmallStockLogService;
import com.thebeastshop.pegasus.service.warehouse.service.WhAllotService;
import com.thebeastshop.pegasus.service.warehouse.vo.TmallStockLogVO;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.pegasus.util.comm.StringUtil;
import com.thebeastshop.pegasus.util.model.CommEntityOpRcd;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import page.Pagination;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @version V1.0
 * @Description:${todo}(用一句话描述该文件做什么)
 * @author: ljj
 * @date: 2018/8/15 14:39
 */
@Service("tmallStockLogService")
public class TmallStockLogServiceImpl implements TmallStockLogService {

    @Autowired
    private TmallStockLogMapper tmallStockLogMapper;

    @Autowired
    private ChannelQueryService channelQueryService;

    @Autowired
    private WhAllotService whAllotService;

    @Override
    public Pagination<TmallStockLogVO> findByCond(TmallStockLogCond cond) {
        Pagination<TmallStockLogVO> page = new Pagination<>(cond.getCurrpage(), cond.getPagenum());
        int count = tmallStockLogMapper.countByCond(cond);
        page.setRecord(count);
        if (NumberUtil.isNullOrZero(count)){
            return page;
        }
        List<TmallStockLogVO> list = tmallStockLogMapper.findByCond(cond);
        page.setResultList(list);
        return page;
    }

    @Override
    public TmallStockLogVO findDetailById(Integer id) {
        return tmallStockLogMapper.findDetailById(id);
    }

    @Override
    public Boolean dealOuterStockSyn(Integer id, String remark) {
        TmallStockLog record = new TmallStockLog();
        record.setId(id.longValue());
        record.setRemark(remark);
        record.setDealStatus((short)1);
        return tmallStockLogMapper.updateByPrimaryKeySelective(record)>0;
    }

    @Override
    public String officialWebSiteAllot(Integer id,Long operatorId,String operatorName) throws Exception {
        TmallStockLogVO tmallStockLogVO = tmallStockLogMapper.findDetailById(id);
        String sellWarehouseCode = channelQueryService.getByCode(tmallStockLogVO.getChannelCode()).getWarehouseForSales();
        WhAllotRcd whAllotRcd = new WhAllotRcd();
        if (tmallStockLogVO.getQuantity()<0) {
//            如 果 数 量 为 负 数 （ 扣 减 天 猫 失败）， 则需要 从[WH020600010102]官网渠道销售仓往渠道对应的销售仓调拨
            whAllotRcd.setSourceWarehouseCode("WH020600010102");
            whAllotRcd.setTargetWarehouseCode(sellWarehouseCode);
        } else {
            whAllotRcd.setTargetWarehouseCode("WH020600010102");
            whAllotRcd.setSourceWarehouseCode(sellWarehouseCode);
        }
        whAllotRcd.setAllotType(WhAllotRcd.TYPE_BETWEEN_CHANNELS);
        whAllotRcd.setAllotStatus(4);
        whAllotRcd.setEstimatedAllocationDate(new Date());

        List<WhAllotRcdSku> whAllotRcdSkuList = Lists.newArrayList();
        WhAllotRcdSku whAllotRcdSku = new WhAllotRcdSku();
        whAllotRcdSku.setSkuCode(tmallStockLogVO.getSkuCode());
        whAllotRcdSku.setQuantity(Math.abs(tmallStockLogVO.getQuantity()));
        whAllotRcdSku.setSkuName(tmallStockLogVO.getSkuNameCn());
        whAllotRcdSku.setSyncThridParty(false);
        whAllotRcdSkuList.add(whAllotRcdSku);
        whAllotRcd.setWhAllotRcdSkuList(whAllotRcdSkuList);
        String allotCode = whAllotService.createAllotRcdNoSynTmall(whAllotRcd);
        whAllotRcd.setRemark("外部库存同步自动生成,同步数据ID"+whAllotRcd.getId());
        whAllotService.updateAllotRcd(whAllotRcd);
        TmallStockLog updateRecord = new TmallStockLog();
        updateRecord.setId(id.longValue());
        updateRecord.setDealStatus((short)1);
        tmallStockLogMapper.updateByPrimaryKeySelective(updateRecord);

        CommEntityOpRcd commEntityOpRcd = new CommEntityOpRcd();
        commEntityOpRcd.setOperatorId(operatorId);
        commEntityOpRcd.setOperatorName(operatorName);
        commEntityOpRcd.setOperationType(1);
        commEntityOpRcd.setOperationDesc("外部库存同步自动生成,同步数据ID"+whAllotRcd.getId());
        commEntityOpRcd.setEntityName("WhAllotRcd");
        commEntityOpRcd.setEntityId(whAllotRcd.getId() + "");
        PegasusUtilFacade.getInstance().insertEntityOperationRcd(commEntityOpRcd);
        return allotCode;
    }

    @Override
    public List<TmallStockLogVO> findFailedSyncByAllotCode(String allotCode) {
        return tmallStockLogMapper.findFailedSyncByAllotCode(allotCode);
    }

    @Override
    public Map<String, Integer> findSkuSynQtyCountByCond(TmallStockLogCond cond) {
        return resolveListMap(tmallStockLogMapper.findSkuSynQtyCountByCond(cond));
    }

    private Map<String,Integer> resolveListMap(List<Map<String,Object>> resultsList){
        Map<String,Integer> map = new HashMap<>();
        if(resultsList!=null && !resultsList.isEmpty()){
            if (null != resultsList.get(0)) {
                for (Map<String,Object> result : resultsList) {
                    String tempKey ="";
                    for (Map.Entry<String, Object> entry : result.entrySet()) {
                        if ("skuCode".equals(entry.getKey())) {
                            tempKey = entry.getValue().toString();
                        } else {
                            map.put(tempKey,((BigDecimal) entry.getValue()).intValue());
                            tempKey ="";
                        }
                    }
                }
            }
        }
        return map;
    }

    public static void main(String[] args) {
        Map<String, Integer> newMap = new HashMap<>();
        Map<String,String> result = new HashMap<>();
        result.put("skuCode","SO0310000013869");
        result.put("quality","56");
        String tempKey ="";
        for (Map.Entry<String, String> entry : result.entrySet()) {
            if ("skuCode".equals(entry.getKey())) {
                tempKey = entry.getValue();
            } else {
                newMap.put(tempKey,Integer.parseInt(entry.getValue()));
                tempKey ="";
            }
        }
        System.out.println(111);
    }
}
