/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.cond.OffSpotGoodsCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhCommandMapper;
import com.thebeastshop.pegasus.service.warehouse.model.*;

import com.thebeastshop.pegasus.service.warehouse.service.OffSpotGoodsService;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.List;

/**
 * @author Royan
 * @version $Id: WhCommandServiceImpl.java, v 0.1 2015-07-30 下午2:09
 */
@Service("offSpotGoodsService")
public class OffSpotGoodsServiceImpl implements OffSpotGoodsService {

    @Autowired
    private WhCommandMapper whCommandMapper;
    
    /**
     * 根据条件查找非现货商品
     *
     * @param cond 条件
     * @return
     */
    @Override
    public List<OffSpotGood> findOffSpotGoodsListByCond(OffSpotGoodsCond cond) {
        return whCommandMapper.findOffSpotGoodsListByCond(cond);
    }
    
    /**
     * 根据条件查找非现货商品未发货数量详情
     *
     * @param cond 条件
     * @return
     */
    @Override
    public List<OffSpotGood> findDetailOffSpotGoodsList(String skuCode) {
        return whCommandMapper.findDetailOffSpotGoodsList(skuCode);
    }
    
    /**
     * 根据条件查找非现货商品在途数量详情
     *
     * @param cond 条件
     * @return
     */
    @Override
    public List<OffSpotGood> findDetailOnTheWayOffSpotGoodsList(String skuCode) {
        return whCommandMapper.findDetailOnTheWayOffSpotGoodsList(skuCode);
    }

}