package com.thebeastshop.pegasus.service.warehouse.service;


import com.thebeastshop.pegasus.service.warehouse.vo.WhCountVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsPutawayExcuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsWaitPutawayTaskVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsWaitPutawayVO;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

import java.util.List;

/**
 * Created by Administrator on 2016/3/23.
 */
public interface WhWmsWaitPutawayTaskService {

    /**
     * 新增上架任务
     *
     * @param vo
     * @return
     */
    @Transactional
    public WhWmsWaitPutawayTaskVO create(WhWmsWaitPutawayTaskVO vo);

    /**
     * 更新上架任务
     *
     * @param vo
     * @return
     */
    @Transactional
    Boolean update(WhWmsWaitPutawayTaskVO vo);

    /**
     * 根据主键查找
     *
     * @param id
     * @return
     */
    WhWmsWaitPutawayTaskVO findById(Long id);

    List<WhCountVO> countPutawayTask(String physicalWarehouseCode);

    Pagination<WhWmsWaitPutawayTaskVO> findPutawayTaskList(WhWmsWaitPutawayTaskVO vo);

    List<WhWmsWaitPutawayTaskVO> findWhWmsWaitPutawayTaskVOList(WhWmsWaitPutawayTaskVO vo);

    @Transactional
    boolean putawayTaskExcu(WhWmsPutawayExcuVO vo,Long operatorId)throws Exception;

    //目标库位检查
    boolean targetShelvesCodeCheck(String shelvesCode,String barCode,boolean focus);
}
