package com.thebeastshop.pegasus.service.warehouse.service;


import com.thebeastshop.pegasus.service.warehouse.model.WhWmsHouseShelves;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsWaitPutaway;
import com.thebeastshop.pegasus.service.warehouse.vo.WhReceiveShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveSkuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsPutawaySearchVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsStartPutawayVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsWaitPutawayVO;

import org.springframework.transaction.annotation.Transactional;

import page.Pagination;

import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2016/3/23.
 */
public interface WhWmsWaitPutawayService {

    /**
     * 新增待上架记录
     *
     * @param waitPutawayVO
     * @return
     */
    @Transactional
    public WhWmsWaitPutawayVO create(WhWmsWaitPutawayVO waitPutawayVO);

    /**
     * 更新待上架记录
     *
     * @param waitPutawayVO
     * @return
     */
    @Transactional
    Boolean update(WhWmsWaitPutawayVO waitPutawayVO);

    /**
     * 根据主键查找
     *
     * @param id
     * @return
     */
    WhWmsWaitPutawayVO findById(Long id);

    /**
     * 根据关联单据编号查询
     *
     * @param receiptsNo
     * @return
     */
    List<WhWmsWaitPutawayVO> findWmsWaitPutawayByReceiptsNo(String receiptsNo);

    /**
     * 查询待上架列表
     *
     * @param waitPutawayVO
     * @return
     */
    Pagination<WhWmsWaitPutawayVO> findPutawayList(WhWmsWaitPutawayVO waitPutawayVO);

    /**
     * 通过SKU_CODE查询待上架列表
     *
     * @param waitPutawayVO
     * @return
     */
    Pagination<WhWmsWaitPutawayVO> getPutawayListBySkuCode(WhWmsWaitPutawayVO waitPutawayVO);

    List<WhWmsWaitPutawayVO> listPutawayListBySkuCode(WhWmsWaitPutawayVO waitPutawayVO);

    /**
     * 上架任务管理
     *
     * @param vo
     * @return
     */
    Pagination<WhWmsWaitPutawayVO> findPutawayTaskList(WhWmsWaitPutawayVO vo);

    /**
     * 上架开始
     *
     * @param vo
     * @return
     */
    @Transactional
    public String startPutaway(WhWmsWaitPutawayVO vo);

    /**
     * 收货是否完成
     *
     * @param cmdCode
     * @return
     */
    public boolean isReceiveOver(String cmdCode);

    /**
     * 查询要打印的上架清单
     *
     * @param vo
     * @return
     */
    List<WhWmsWaitPutawayVO> findPrintPutawayOrder(WhWmsPutawaySearchVO vo);

    /**
     * 推荐库位
     *
     * @param pvoList
     * @return 移库行
     */
    public List<WhWmsMoveSkuVO> recommendWmsHouseShelves(List<WhWmsStartPutawayVO> pvoList);


    public boolean checkQuInfo(WhReceiveShelvesVO vo);

    public List<WhWmsWaitPutaway> getAllRemearkByReceiptsNo(String receiptsNo);

    public List<WhWmsWaitPutawayVO> countQcQuantityByCond(List<String> receiptsNos, Integer inOutType);

    List<WhWmsWaitPutawayVO> findWaitPutawayWasteByCond(WhWmsWaitPutawayVO vo);

    public List<WhWmsWaitPutaway> getAllRemearkByCond(WhWmsWaitPutawayVO cond);

    public List<WhWmsWaitPutaway> listWaitPutawayByCond(WhWmsWaitPutawayVO vo);

}
