package com.thebeastshop.pegasus.service.warehouse.service;

import com.thebeastshop.pegasus.service.warehouse.cond.*;
import com.thebeastshop.pegasus.service.warehouse.model.*;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2016/3/23.
 */
public interface WhWmsSkuStockService {

    /**
     * 新增SKU库存
     * @param skuStockVO
     * @return
     */
    public WhWmsSkuStockVO create(WhWmsSkuStockVO skuStockVO);

    /**
     * (不推荐使用)更新库存相关信息，不能更新库存
     * @param skuStockVO
     * @return
     */
    @Deprecated
    Boolean update(WhWmsSkuStockVO skuStockVO);

    /**
     * 根据主键查找
     * @param id
     * @return
     */
    WhWmsSkuStockVO findById(Long id);


    /**
     * 根据ID更新WMS的SKU库存
     * @param id
     * @return
     */
    public boolean updateStockById(Integer id,Integer amount);

    /**
     * 根据物理仓库编码、仓库区域、条形码、库位编码、SKU_CODE、SKU状态,出入库类型，相关单据号，更新WMS的库存
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public boolean updateStockByCond(Integer amount,String physicalWarehouseCode,String houseType,String barcode,String shelvesCode,String skuCode,Integer skuStatus,Integer inoutType,String receiptNo,Long userId );


    void batchUpdateWhSkuStock(List<WhWmsSkuStockRecord> skuStockRecordList);
    /**
     * 根据物理仓库编码、仓库区域、条形码、库位编码、SKU_CODE、SKU状态,出入库类型，相关单据号，更新WMS的库存
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public boolean updateStockByCond(Integer amount,String physicalWarehouseCode,String houseType,String barcode,String shelvesCode,String skuCode,Integer skuStatus,Integer inoutType,String receiptNo,Long userId,String memo,Integer isUpdateScm );


    public boolean outSkuStockByCond(Integer amount,String physicalWarehouseCode,String houseType,String barcode,String shelvesCode,String skuCode,Integer skuStatus);


    boolean updatePhyWhSkuStock(String physicalWarehouseCode
            ,String skuCode,Integer skuStatus,Integer quantity
            ,Integer inOutType,String referenceCode,Long operatorId,String memo);

    @Transactional(rollbackFor = Exception.class)
    public boolean convertBarcodeUpdateSkuStock(WhWmsSkuStockVO vo);

    /**
     * 坑，底层是父类
     * 条件获取WMS的SKU库存
     * @param cond
     * @return
     */
    public List<WhWmsSkuStockVO> getWmsSkuStockByCond(WhWmsSkuStockVO cond);

    /**
     * 条件获取WMS的SKU库存
     * @param vo
     * @return
     */
    public List<WhWmsSkuStockVO> getWmsSkuStockByVO(WhWmsSkuStockVO vo);
    
    /**
     * 条件获取WMS的SKU库存<br/>
     * 行记录为 按 仓库,区域类型,skucode,skustatus 统计<br/>
     * 返回totalAmount,availableAmount<br/>
     * @param cond
     * @return
     * bao.yu
     */
    public List<WhWmsSkuStockVO> getWmsSkuStocksByCond(WhWmsSkuStockVO cond);

    
    /**
     * 条件获取WMS的SKU库存<br/>
     * 行记录为按 库位,skucode,skustatus,barcode 统计<br/>
     * 返回totalAmount,occupiedAmount,availableAmount<br/>
     * @param cond
     * @return
     * bao.yu
     */
    public List<WhWmsSkuStockVO> getWmsSkuStocksByShelvesCond(WhWmsSkuStockVO cond);
    
    
    /**
     * 条件获取WMS的SKU库存<br>
     * 行记录为 按 仓库,区域类型,skucode,skustatus 统计<br>
     * 返回totalAmount,availableAmount<br>
     * 且过滤totalAmount=0&&availableAmount=0的记录<br/>
     * @param cond
     * @return
     * bao.yu
     */
    public List<WhWmsSkuStockVO> getWmsSkuStocksByCondForReport(WhWmsSkuStockVO cond);

    
    /**
     * 条件获取WMS的SKU库存<br>
     * 行记录为按 库位,skucode,skustatus,barcode 统计<br>
     * 返回totalAmount,occupiedAmount,availableAmount<br>
     * 且过滤totalAmount=0&&availableAmount=0的记录
     * @param cond
     * @return
     * bao.yu
     */
    public Pagination<WhWmsSkuStockVO> getWmsSkuStocksByShelvesCondForReport(WhWmsSkuStockVO cond);
    public List<WhWmsSkuStockVO> listSkuStocksByCond(WhWmsSkuStockVO cond);

    public List<WhWmsSkuStockVO> getSkuStocksByShelvesCondForReport(WhWmsSkuStockVO cond);


    public WhWmsSkuStockVO countSkuAmountBySkuStatus(WhWmsSkuStockVO cond);

    /**
     * 根据物理仓code 和 sku状态良品、残次、样品 查找sku
     * @param physicalWarehouseCode
     * @param skuStatus
     * @param skuCode
     * @return
     */
    List<WhWmsSkuStockVO> findWmsSkuStockByPhysicalWarehouseCodeAndStatus(String physicalWarehouseCode,Integer skuStatus,String skuCode);

    /**
     * 根据vos 算出sku总数
     * @param vos
     * @return
     */
    int sumSkuQuantity(List<WhWmsSkuStockVO> vos);

    /**
     * 根据vos计算可用库存
     * @param vos
     * @return
     */
    List<WhWmsSkuStockVO> findWmsSkuAvailableAccount(WhWmsSkuStockVO vos);

    /**
     * 根据vos计算可用库存
     * @param vos
     * @return
     */
    List<WhWmsSkuStockVO> findWmsSkuAvailableAccount(WhWmsSkuStockVO vos,boolean gtZero);

    /**
     * 根据vos计算可用库存
     * 包含预占用
     * @param vos
     * @return
     */
    List<WhWmsSkuStockVO> findWmsSkuAvailableAccountWithPreOccupy(WhWmsSkuStockVO vos,boolean gtZero);

    /**
     * 查询库存记录
     * @param example
     * @return
     */
    List<WhWmsSkuStock> selectByExample(WhWmsSkuStockExample example);

    /**
     *条件查询库位数 (盘点用)
     * @param vo
     * @return
     */
    List<WhWmsSkuStock> getGroupByShelvesByCond(WhWmsSkuStockVO vo);

    /**
     *条件查询库存 (盘点用)
     * @param vo
     * @return
     */
    List<WhWmsSkuStock> getStockByCond(WhWmsSkuStockVO vo);

    List<PhyWhStockVO> findPhyWhStockByCond(PhyWhStockCond cond);
    
    List<WhGjStockVO> findWhGjStock();
    
    List<WhGjStockVO> findWhGjStockByLimit(int pageSize,int pageNum);

    List<PhyWhStockVO> findPhyWhSkuTotalQuantityByCond(PhyWhStockCond cond);

    List<WhWmsSkuStockDiffVO> findWhWmsSkuStockDiffList();

    List<WhWmsSkuStockRecordVO> findWhWmsStockRecord(WhWmsSkuStockRecordCond whWmsSkuStockRecordCond);

    Pagination<PhyWhSkuStockRcdVO> findPhyWhSkuStockRcdByCond(PhyWhSkuStockRcdCond cond);

    int findWhWmsStockRecordCount(WhWmsSkuStockRecordCond whWmsSkuStockRecordCond);

    WhPhysicalWarehouse computeDispatchPhysicalWarehouse(String dispatchWhCode, Map<String,Integer> skuQuantityMap, Long targetDistrict);

    /**
     * 效期商品列表
     * @param cond
     * @return
     */
	public List<WhWmsSkuStockVO> listExpiryDateSku(WhWmsSkuStockVO cond);

	public List<WhWmsSkuStockVO> listExpiryDateSkuForCheckRule(WhWmsSkuStockVO cond);
}
