package com.thebeastshop.pegasus.service.warehouse.service;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsSkuBarcodeCond;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuBarcode;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuBarcodeVO;
import page.Pagination;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2016/3/25.
 */
public interface WhWmsSkuBarcodeService {
    /**
     * 新增批次条形码记录
     * @param vo
     * @return
     */
    public WhWmsSkuBarcodeVO create(WhWmsSkuBarcodeVO vo);

    /**
     * 更新批次条形码记录
     * @param vo
     * @return
     */
    Boolean update(WhWmsSkuBarcodeVO vo);

    /**
     * 根据主键查找
     * @param id
     * @return
     */
    WhWmsSkuBarcodeVO findById(Long id);

    /**
     * 查询当前质检最大批次号码
     * @return
     */
    WhWmsSkuBarcode findMaxBatchNo(String skuCode,String date,String prodDate);

    WhWmsSkuBarcode findMaxBatchNoByCond(WhWmsSkuBarcodeCond cond);

    WhWmsSkuBarcodeVO findSkuInfoBySkuCode(String skuCode);

    // 通过sku获取批次量
    Integer countBatchBySkuCode(String skuCode);
    
    // 通过入库单号获取批次量
    Integer countBatchByReferenceCode(String whCmdCode,String skuCode,String referenceCode);
    
    /**
     * 多条件查询批次码
     * @param vo
     * @return
     */
    public List<WhWmsSkuBarcodeVO> getWmsSkuBarcodeByCond(WhWmsSkuBarcodeVO vo);

    Map<String,WhWmsSkuBarcodeVO> getBarcodeMap(List<String> barcodes);

    /**
     * 根据skuCode查出所有未过期的barCodes,结果根据过期日期升序
     * @param skuCode
     * @return
     */
    List<String> findBarCodesConditionBySkuCodeAndUnexpiredSortByExpiredAsc(String skuCode);


    /**
     * 根据skuCode查出所有barCodes,结果根据过期日期升序(不判断过期)
     * @param skuCode
     * @return
     */
    List<String> findBarCodesConditionBySkuCodeAndSortByExpiredAsc(String skuCode);

    /**
     * 根据skuCode查出所有没有过期日期的barCodes
     * @param skuCode
     * @return
     */
    List<String> findBarCodesConditionBySkuCodeAndNullExpired(String skuCode);

    List<WhWmsSkuBarcode> findBarCodesForPickSkuStock(String skuCode);

    List<WhWmsSkuBarcode> findBarCodesForPickSkuStock(List<String> skuCodes);

    List<WhWmsSkuBarcode> findBarcodesForAltOrPcsRtnConnect(List<String> skuCodes,boolean allowExpire);


    /**
     * 根据skuCode查出所有未过期的barCodes,结果根据过期日期升序
     * @param skuCode
     * @return
     */
    List<WhWmsSkuBarcode> findBarCodesEntityConditionBySkuCodeAndUnexpiredSortByExpiredAsc(String skuCode);

    WhWmsSkuBarcode findMinProdOrExpiryDateByBarCodes(List<String> barCodes);

    /**
     * 根据skuCode查出所有barCodes,结果根据过期日期升序(不判断过期)
     * @param skuCode
     * @return
     */
    List<WhWmsSkuBarcode> findBarCodesEntityConditionBySkuCodeAndSortByExpiredAsc(String skuCode);

    /**
     * 根据skuCode查出所有没有过期日期的barCodes
     * @param skuCode
     * @return
     */
    List<WhWmsSkuBarcode> findBarCodesEntityConditionBySkuCodeAndNullExpired(String skuCode);

    /**
     * 通过SKU_CODE查询SKU保质期
     * @param skuCode
     * @return
     */
    Integer findSkuShelfLifeBySkuCode(String skuCode);

    List<WhWmsSkuBarcodeVO> findExpiryDateSkuInfo(WhWmsSkuBarcodeCond cond);

    Pagination<WhWmsSkuBarcodeVO> findExpiryDateSkuInfoByCondPage(WhWmsSkuBarcodeCond cond);

    int compareBarCode(WhWmsSkuBarcode barcode1, WhWmsSkuBarcode barcode2);

    boolean modifyExpiryDate(WhWmsSkuBarcode cond);
}
