package com.thebeastshop.pegasus.service.warehouse.service;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsShelvesSkuInfoCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsSkuPickShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsShelvesSkuInfo;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuPickShelves;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsShelvesSkuInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuPickShelvesVO;

import java.util.List;

/**
 * Created by devin.li on 2016/3/17.
 */
public interface WhWmsShelvesSkuInfoService {

    /**
     * 条件查询仓库SkuInfo信息
     * @param cond
     * @return
     */
    public List<WhWmsShelvesSkuInfoVO> getSkuInfoByCond(WhWmsShelvesSkuInfoCond cond);

    public List<WhWmsSkuPickShelves> listSkuPickShelvesByCond(WhWmsSkuPickShelvesCond cond);

    public List<WhWmsSkuPickShelves> listSkuPickShelvesBySkuCode(String skuCode);

    public List<WhWmsSkuPickShelvesVO> listSkuPickShelvesVOBySkuCode(String skuCode);

    public List<WhWmsSkuPickShelvesVO> listSkuPickShelvesVOByCond(WhWmsSkuPickShelvesCond cond);

    /**
     * 新增仓库SkuInfo
     * @param skuInfo
     * @return
     */
    public Boolean newSkuInfo(WhWmsShelvesSkuInfo skuInfo);

    public Boolean newWhShelvesSkuInfoVO(WhWmsShelvesSkuInfoVO skuInfoVO);

    public Boolean delSkuPickShelvesBySkuCode(String skuCode);

    public Boolean delSkuPickShelvesByCond(WhWmsSkuPickShelvesCond cond);

    public Boolean createSkuPickShelves(WhWmsSkuPickShelves skuPickShelves);

    public Boolean batchCreateSkuPickShelves(List<WhWmsSkuPickShelves> skuPickShelves,String skuCode);

    /**
     * 更新仓库SkuInfo
     * @param skuInfo
     * @return
     */
    public Boolean updateSkuInfo(WhWmsShelvesSkuInfo skuInfo);

    public Boolean updateWhShelvesSkuInfoVO(WhWmsShelvesSkuInfoVO skuInfoVO);

    public Boolean saveOrUpdateWhWmsSkuPickShelves(List<WhWmsSkuPickShelves> whWmsSkuPickShelves);

    /**
     * 根据skuCode查询仓库skuInfo
     * @param skuCode
     * @return
     */
    public WhWmsShelvesSkuInfo getSkuInfoByCode(String skuCode);

    public WhWmsShelvesSkuInfoVO getSkuInfoVOBySkuCode(String skuCode,boolean fetchPickShelve);


    /**
     * 根据code关联WMS-skuInfo  autoComplete
     * @param codeLike
     * @return
     */
    public List<WhWmsShelvesSkuInfo> getSkuInfoLikeCode(String codeLike);
}
