/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.warehouse.service;

import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsHouseShelvesVO;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * wms 补货service
 * @author Eric.Lou
 * @version $Id: WhWmsReplenishService.java, v 0.1 2016-05-30 下午5:28
 */
public interface WhWmsReplenishService {

    /**
     * 返回需要补货的库位
     * @param type
     * @param shelvesType
     * @return
     */
    List<WhWmsHouseShelvesVO> findNeedToReplenishShelves(String type,Integer shelvesType);

    /**
     * 处理补货
     * @param shelvesVO
     */
    @Transactional
    void processReplenish(WhWmsHouseShelvesVO shelvesVO);

}
