package com.thebeastshop.pegasus.service.warehouse.service;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsReplenishInfoCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsReplenishRuleCond;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsReplenishRule;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsReplenishRuleBlacklistVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsReplenishRuleHousetypeVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsReplenishRuleVO;
import page.Pagination;

import java.util.List;

/**
 * @author xw
 * @create 2018-08-14 16:24
 */
public interface WhWmsReplenishRuleService {

    Pagination<WhWmsReplenishRuleVO> pageWhWmsReplenishRuleVOByCond(WhWmsReplenishRuleCond cond);

    List<WhWmsReplenishRuleVO> listWhWmsReplenishRuleVOByCond(WhWmsReplenishRuleCond cond);

    List<WhWmsReplenishRule> listWhWmsReplenishRuleByCond(WhWmsReplenishRuleCond cond);

    WhWmsReplenishRule findWhWmsReplenishRuleById(Long id);

    WhWmsReplenishRule findWhWmsReplenishRuleByPhyCode(String phyCode);

    WhWmsReplenishRuleVO findWhWmsReplenishRuleVOById(Long id,boolean fetchHouse,boolean fetchBlack);

    WhWmsReplenishRuleVO findWhWmsReplenishRuleVOByPhyCode(String phyCode,boolean fetchHouse,boolean fetchBlack);

    WhWmsReplenishRuleVO saveOrUpdateWhWmsReplenishRuleVO(WhWmsReplenishRuleVO replenishRuleVO);

    boolean saveWhWmsReplenishRuleVO(WhWmsReplenishRuleVO replenishRuleVO);

    boolean updateWhWmsReplenishRuleVO(WhWmsReplenishRuleVO replenishRuleVO);

    List<WhWmsReplenishRuleHousetypeVO> listWhWmsReplenishRuleHousetypeVOByCond(WhWmsReplenishRuleCond cond);

    List<WhWmsReplenishRuleHousetypeVO> listWhWmsReplenishRuleHousetypeVOByRuleId(Long ruleId);

    boolean deleteWhWmsReplenishRuleHousetypeByRuleId(Long ruleId);

    List<WhWmsReplenishRuleBlacklistVO> listWhWmsReplenishRuleBlacklistVOByCond(WhWmsReplenishRuleCond cond);

    List<WhWmsReplenishRuleBlacklistVO> listWhWmsReplenishRuleBlacklistVOByRuleId(Long ruleId);

    boolean deleteWhWmsReplenishRuleBlacklistByRuleId(Long ruleId);

    List<WhWmsReplenishRuleVO> listPcsSkuVOsByCond(WhWmsReplenishRuleCond cond);

    String replenishInfoGenerateByCond(WhWmsReplenishInfoCond cond) throws WarehouseException;
}
