package com.thebeastshop.pegasus.service.warehouse.service;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsReplenishInfoCond;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsReplenishInfo;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsBatchReplenishInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsReplenishInfoVO;
import page.Pagination;

import java.util.List;
import java.util.Map;

/**
 * @author xw
 * @create 2018-08-14 16:24
 */
public interface WhWmsReplenishInfoService {

    Pagination<WhWmsReplenishInfoVO> pageWhWmsReplenishInfoVOByCond(WhWmsReplenishInfoCond cond);

    List<WhWmsReplenishInfoVO> listWhWmsReplenishInfoVOByCond(WhWmsReplenishInfoCond cond);

    List<WhWmsReplenishInfo> listWhWmsReplenishInfoByCond(WhWmsReplenishInfoCond cond);

    WhWmsReplenishInfo findWhWmsReplenishInfoById(Long id);

    WhWmsReplenishInfoVO findWhWmsReplenishInfoVOById(Long id);

    WhWmsReplenishInfoVO saveOrUpdateWhWmsReplenishInfoVO(WhWmsReplenishInfoVO replenishInfoVO);

    boolean batchSaveWhWmsReplenishInfo(List<WhWmsReplenishInfo> replenishInfos);

    String batchSaveWhWmsReplenishInfoVO(WhWmsBatchReplenishInfoVO replenishInfo) throws WarehouseException;

    String createReplenishMoveStock(WhWmsReplenishInfoCond cond) throws Exception;

    boolean saveWhWmsReplenishInfoVO(WhWmsReplenishInfoVO replenishInfoVO);

    boolean updateWhWmsReplenishInfoVO(WhWmsReplenishInfoVO replenishInfoVO);

    boolean updateWhWmsReplenishInfoByCond(WhWmsReplenishInfo replenishInfo, WhWmsReplenishInfoCond cond);

    boolean updateWhWmsReplenishInfoStatesByRefCode(String refCode, Integer refType, Integer newReplenishStates);

    Map<String, Boolean> usedSupplierAndEffectiveGoods(List<String> skuCodes);

    public String buildAndCreateMoveStock(WhWmsReplenishInfo replenishInfo, Map<String, Boolean> skuBooleanMap, WhWmsReplenishInfoCond cond) throws WarehouseException;

}