package com.thebeastshop.pegasus.service.warehouse.service;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsPrdcMaterialDetailCond;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsPrdcMaterialDetail;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsPrdcMaterialDetailVO;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

public interface WhWmsPrdcMaterialDetailService {
    /**
     * 新增生产加工主耗材详情信息
     * @param record
     * @return
     */
    @Transactional
    public boolean create(WhWmsPrdcMaterialDetail record);

    @Transactional
    public boolean batchCreate(List<WhWmsPrdcMaterialDetail> records);

    /**
     * 更新主耗材详情信息
     * @param record
     * @return
     */
    @Transactional
    Boolean updateById(WhWmsPrdcMaterialDetail record);

    Boolean updateByCond(WhWmsPrdcMaterialDetail record,WhWmsPrdcMaterialDetailCond cond);

    /**
     * 根据主键查找
     * @param id
     * @return
     */
    WhWmsPrdcMaterialDetail findWhWmsPrdcMaterialDetailById(Long id);

    /**
     * 根据条件查询加工主耗材信息列表
     * @param cond
     * @return
     */
    public List<WhWmsPrdcMaterialDetail> listWhWmsPrdcMaterialDetailByCond(WhWmsPrdcMaterialDetailCond cond);

    public List<WhWmsPrdcMaterialDetailVO> listWhWmsPrdcMaterialDetailVOByCond(WhWmsPrdcMaterialDetailCond cond);

}
