package com.thebeastshop.pegasus.service.warehouse.service;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsPrdcJobTaskCond;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsPrdcJobTask;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuBarcode;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsPrdcJobTaskVO;
import page.Pagination;

import java.util.List;
import java.util.Map;

import org.springframework.transaction.annotation.Transactional;

/**
 * Created by devin.li on 16/4/14.
 */
public interface WhWmsPrdcJobTaskService {

    /**
     * 条件获取生产任务列
     * @param cond
     * @return
     */
    public List<WhWmsPrdcJobTaskVO> getPrdcJobTaskByCond(WhWmsPrdcJobTaskCond cond);

    /**
     * 根据主键获取生产加工子任务
     * @param id
     * @return
     */
    public WhWmsPrdcJobTaskVO getPrdcJobTaskById(Long id);

    /**
     * 根据子任务code获取子任务
     * @param taskCode
     * @return
     */
    public WhWmsPrdcJobTaskVO getPrdcJobTaskByTaskCode(String taskCode);

    /**
     * 根据jobCode获取所有子任务列
     * @param jobCode
     * @return
     */
    public List<WhWmsPrdcJobTaskVO> getPrdcJobTaskByJobCode(String jobCode);


    /**
     * 生成加工子任务,并占用相应库存
     * @param vo
     * @return
     */
    public Boolean createJobTaskAndOccupyStock(WhWmsPrdcJobTaskVO vo);


    /**
     * 更新生产任务
     * @param vo
     * @return
     */
    public Boolean updateJobTask(WhWmsPrdcJobTaskVO vo);

    /**
     * 获取生产任务列 分页
     * @param cond
     * @return
     */
    public Pagination<WhWmsPrdcJobTaskVO> getPrdcTaskByCondPage(WhWmsPrdcJobTaskCond cond);

    /**
     * 获取单张生产订单最大可启动子任务数
     * @param vo
     * @return
     */
    public int getPrdcJobMaxTask(WhWmsPrdcJobTaskVO vo);

    public WhWmsSkuBarcode findMinExpiryDateByMaterialOccupy(WhWmsPrdcJobTaskVO vo);

    public List<Map<String,Object>> getWmsPrdcJobTaskFinishedInfo(List<String> prdcJobCodes);
    
    public List<Map<String,Object>> getWmsPrdcJobTaskProcessingInfo(List<String> prdcJobCodes);

    /**
     * 完成子任务，并更新相应库存
     * @param jobTaskVO
     * @return
     */
    @Transactional
    public Boolean finishTaskAndUpdateStock(WhWmsPrdcJobTaskVO jobTaskVO,Long userId)throws Exception;

	public List<Map<String, Object>> getWmsPrdcJobTaskFinishedRealAmount(List<String> prdcJobCodes);
}
