package com.thebeastshop.pegasus.service.warehouse.service;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsOccupyCond;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsOccupyVO;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * Created by Administrator on 2016/3/23.
 */
public interface WhWmsOccupyService {

    /**
     * 更新WMS占用记录
     *
     * @param vo
     * @return
     */
    @Transactional
    Boolean update(WhWmsOccupyVO vo);

    /**
     * 根据主键查找
     *
     * @param id
     * @return
     */
    WhWmsOccupyVO findById(Long id);


    /**
     * WMS的SKU库存占用
     *
     * @param vo SKU库存占用vo
     */
    @Transactional
    public Long wmsOccupy(WhWmsOccupyVO vo);


    /**
     * WMS批量SKU库存占用
     *
     * @param voList WMS的SKU库存占用vo列表
     */
    @Transactional
    public List<Long> wmsBatchOccupy(List<WhWmsOccupyVO> voList);


    /**
     * 释放WMS的SKU库存占用
     *
     * @param vo
     */
    @Transactional
    public boolean releaseWmsOccupy(WhWmsOccupyVO vo);

    @Transactional
    public boolean releaseWmsOccupyById(WhWmsOccupyVO vo);

    /**
     * 释放波次占用
     * @param connectId
     * @return
     */
    @Transactional
    public boolean releaseWmsOccupyByConnectId(Long connectId);

    boolean releaseWmsOccupyByConnectId(List<Long> connectIds);

    /**
     * 释放移库占用
     * @param vo
     * @return
     */
    @Transactional
    public boolean releaseWmsOccupyByMove(WhWmsOccupyVO vo);

    boolean releaseWmsOccupyByCond(WhWmsOccupyVO cond);

    /**
     * 多条件获取WMS占用记录
     *
     * @param cond
     * @return
     */
    public List<WhWmsOccupyVO> getWmsOccupyByCond(WhWmsOccupyVO cond);
}


