package com.thebeastshop.pegasus.service.warehouse.service;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsMoveStockCond;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsMoveStock;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveSkuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsShelvesSkuInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsTaskAssignVO;
import page.Pagination;

import java.util.List;

/**
 * Created by devin.li on 2016/3/27.
 */
public interface WhWmsMoveStockService {
    /**
     * 条件查询移库单
     * @param cond
     * @return
     */
    public Pagination<WhWmsMoveStockVO> getMoveStockByCond(WhWmsMoveStockCond cond);

    List<WhWmsMoveStockVO> getMoveStockByCodes(List<String> moveCodes,boolean cascade);

    public List<WhWmsMoveSkuVO> findMoveStockSkuRf(String moveCode);
    /**
     * 根据ID获取移库单
     * @param id
     * @return
     */
    public WhWmsMoveStock getMoveStockById(Long id);

    /**
     * 根据移库单code获取移库单信息
     * @param code
     * @return
     */
    public WhWmsMoveStockVO getMoveStockByCode(String code);

    /**
     * 新建移库单
     * @param moveStockVO
     * @return
     */
    public Boolean newMoveStock(WhWmsMoveStockVO moveStockVO);
    public boolean buildMoveStock(WhWmsMoveStockVO moveStockVO);
    public String createMoveStock(WhWmsMoveStockVO moveStockVO);

    String quickMoveStock(WhWmsMoveStockVO moveStockVO);
    String executeMoveStock(WhWmsMoveStockVO moveStockVO);
    void moveStockCheck(WhWmsMoveStockVO moveStockVO);
    void rebuildMoveStock(final WhWmsMoveStockVO moveStockVO);

    /**
     * 新建移库单并完成
     * @param moveStockVO
     * @return
     */
    public Boolean createMoveStockThenFinish(WhWmsMoveStockVO moveStockVO);

    /**
     * 移库后释放占用并扣减库存
     * @param moveCode
     * @return
     */
    public Boolean doMoveStockAndReleaseOccupyAndFinish(String moveCode,Long operatorId);

    /**
     * 取消移库单
     * @param list
     */
    public void cancelMoveStock(List<WhWmsMoveStockVO> list,Long operatorId);
    /**
     * 移库单单个记录完成
     * @param moveCode
     * @param operatorId
     * @param moveSkuId
     * @return
     */
    public Boolean moveStockFinishByMoveSku(String moveCode,Long operatorId,Long moveSkuId);

    /**
     * 移库单单个记录完成
     * @param moveCode
     * @param operatorId
     * @param moveSkuId
     * @param taskAssignVO
     * @return
     */
    public Boolean moveStockFinishByMoveSku(String moveCode, Long operatorId, Long moveSkuId, WhWmsTaskAssignVO taskAssignVO);

    public Boolean moveStockFinishByMoveSku(WhWmsMoveSkuVO whWmsMoveSkuVO, WhWmsTaskAssignVO taskAssignVO);

    List<WhWmsMoveStock> findWmsMoveStockByPrdCode(String prdCode);

    Integer cancelWmsMoveStockByIdList(List<Long> idList);


}
