package com.thebeastshop.pegasus.service.warehouse.service;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsMoveSkuCond;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsMoveSku;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveSkuVO;
import page.Pagination;

import java.util.List;

/**
 * Created by devin.li on 2016/3/27.
 */
public interface WhWmsMoveSkuService {

    /**
     * 根据移库任务行code获取移库行任务信息
     * @param code
     * @return
     */
    public List<WhWmsMoveSkuVO> getMoveSkuByMoveCode(String code);

    /**
     * 新建移库任务行
     * @param moveSkuVO
     * @return
     */
    public Boolean newMoveSkuVO(WhWmsMoveSkuVO moveSkuVO);

    boolean batchCreateMoveSku(List<WhWmsMoveSkuVO> moveSkuVOList);

    /**
     * 条件查询移库任务行 分页
     * @param cond
     * @return
     */
    public Pagination<WhWmsMoveSkuVO> getMoveSkuByMoveByCondPage(WhWmsMoveSkuCond cond);

    /**
     * 根据id获取任务行
     * @param id
     * @return
     */
    public WhWmsMoveSkuVO getMoveSkuById(Long id);

    List<WhWmsMoveSkuVO> getMoveSkuByMoveByCond(WhWmsMoveSkuCond cond);
}
