package com.thebeastshop.pegasus.service.warehouse.service;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsInventoryPlanCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsInventoryPlanShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsInventoryPlanShelvesDetailCond;
import com.thebeastshop.pegasus.service.warehouse.vo.WhCountVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsInventoryPlanShelvesDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsInventoryPlanShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsInventoryPlanVO;
import page.Pagination;

import java.util.List;

/**
 * Created by Administrator on 2018/5/31.
 */
public interface WhWmsInventoryService {

    List<WhWmsInventoryPlanShelvesVO> findCanInventoryPlanShelvesByCond(WhWmsInventoryPlanShelvesDetailCond cond);

    WhWmsInventoryPlanVO findInventoryPlan(Long id,boolean cascade);

    List<WhWmsInventoryPlanVO> findInventoryPlan(WhWmsInventoryPlanCond cond);

    Pagination<WhWmsInventoryPlanVO> findInventoryPlanPage(WhWmsInventoryPlanCond cond);

    boolean saveInventoryPlan(WhWmsInventoryPlanVO plan);

    boolean updateInventoryPlanStatus(WhWmsInventoryPlanVO plan);

    boolean cancelInventoryPlan(Long id);

    WhWmsInventoryPlanShelvesVO findInventoryPlanShelves(Long planShelvesId,boolean cascade);

    List<WhWmsInventoryPlanShelvesVO> findInventoryPlanShelvesByCond(WhWmsInventoryPlanShelvesCond cond);

    Pagination<WhWmsInventoryPlanShelvesVO> findInventoryPlanShelvesByCondPage(WhWmsInventoryPlanShelvesCond cond);

    boolean updateInventoryPlanShelves(WhWmsInventoryPlanShelvesVO planShelves);

    boolean complateInventoryPlanShelves(WhWmsInventoryPlanShelvesVO planShelves);

    boolean inventoryQuick(List<WhWmsInventoryPlanVO> planList);

    List<WhCountVO> countInventoryPlan(Long operatorId, String physicalWarehouseCode);
}
