package com.thebeastshop.pegasus.service.warehouse.service;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsHouseShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsHouseShelves;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsHouseShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsShelvesSkuInfoVO;
import page.Pagination;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Created by devin.li on 2016/3/20.
 */
public interface WhWmsHouseShelvesService {

    /**
     * 条件获取库位信息
     * @param cond
     * @return
     */
    public List<WhWmsHouseShelvesVO> getHouseShelvesByCond(WhWmsHouseShelvesCond cond);

    /**
     * 根据库位code获取库位信息
     * @param code
     * @return
     */
    public WhWmsHouseShelvesVO getHouseShelvesByCode(String code);

    List<WhWmsHouseShelves> getHouseShelvesByCode(List<String> codes);

    Map<String,WhWmsHouseShelves> getHouseShelvesMapByCode(List<String> codes);

    /**
     * 根据库位id查询库位信息
     * @param id
     * @return
     */
    public WhWmsHouseShelvesVO getHouseShelvesById(Integer id);
    /**
     * 新增库位
     * @param houseShelves
     * @return
     */
    public Boolean newHouseShelves(WhWmsHouseShelves houseShelves);

    /**
     *更新库位信息
     * @param houseShelves
     * @return
     */
    public Boolean updateHouseShelves(WhWmsHouseShelves houseShelves);

    /**
     * 条件获取库位信息 分页用
     * @param cond
     * @return
     */
    public Pagination<WhWmsHouseShelvesVO> getHouseShelvesByCondPage(WhWmsHouseShelvesCond cond);

    /**
     * 条件获取库位信息 无分页
     * @param cond
     * @return
     */
    public List<WhWmsHouseShelves> getHouseShelvesByCondNoPage(WhWmsHouseShelvesCond cond);

    /**
     * 模糊获取库位号
     * @param name
     * @return
     */
    public List<WhWmsHouseShelves> getHouseShelvesLikeCode(String name);

    /**
     * 拼接库位号
     * @param physicalWarehouseCode
     * @param houseType
     * @param shelves
     * @return
     */

//    public String  excuteShelvesCode(String physicalWarehouseCode,String houseType,String shelves);



}
