package com.thebeastshop.pegasus.service.warehouse.service;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsGradeOfQualityBarcodeCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsGradeOfQualityCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsGradeOfQualitySkuCond;
import com.thebeastshop.pegasus.service.warehouse.model.*;
import com.thebeastshop.pegasus.service.warehouse.vo.WhGradeSalesOrderVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsGradeOfQualitySkuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsGradeOfQualityVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import org.apache.commons.collections.CollectionUtils;
import page.Pagination;

import java.util.List;

public interface WhWmsGradeOfQualityService {

    /**
     * 查询品级调整申请列表
     * @param cond
     * @return
     */
    Pagination<WhWmsGradeOfQualityVO> listWhWmsGradeOfQualityVOByCond(WhWmsGradeOfQualityCond cond);

    WhWmsGradeOfQuality findWhWmsGradeOfQualityById(Long id) throws Exception;

    WhWmsGradeOfQualityVO findWhWmsGradeOfQualityVOById(Long id,boolean fetchGradeSku,boolean fetchGradeBarcode);

    WhWmsGradeOfQualityVO findWhWmsGradeOfQualityVOByCond(WhWmsGradeOfQualityCond cond);

    List<WhWmsGradeOfQuality> findWhWmsGradeOfQualityByCond(WhWmsGradeOfQualityCond cond);

    public List<WhWmsGradeOfQualitySku> listWhWmsGradeOfQualitySkuByCond(WhWmsGradeOfQualitySkuCond skuCond);

    public List<WhWmsGradeOfQualityBarcode> listWhWmsGradeOfQualityBarcodeByCond(WhWmsGradeOfQualityBarcodeCond barcodeCond);

    public List<WhWmsGradeOfQualityBarcode> listWhWmsGradeOfQualityBarcodeByWmsGradeSkuId(Long wmsGradeSkuId);

    public List<WhWmsGradeOfQualityBarcode> listWhWmsGradeOfQualityBarcodesByWmsGradeId(Long wmsGradeId);

    public List<WhWmsGradeOfQualitySkuVO> listWhWmsGradeOfQualitySkuVOsByCond(WhWmsGradeOfQualitySkuCond skuCond);

    public List<WhWmsGradeOfQualitySkuVO> listWhWmsGradeOfQualitySkuVOsByWmsGradeId(Long wmsGradeId,boolean fetchGradeBarcode);

    public boolean create(WhWmsGradeOfQualityVO vo) throws Exception;

    public boolean manualApprovalFlag(WhWmsGradeOfQualityVO vo);

    public boolean approveWhWmsGradeOfQuality(WhWmsGradeOfQualityVO vo) throws Exception;

    public List<WhGradeSalesOrderVO> listSalesOrderByWmsOccupyRefCodes(WhWmsGradeOfQualityCond cond) throws Exception;

    public void createWhGrade(WhWmsGradeOfQualityVO vo) throws Exception;

    public boolean update(WhWmsGradeOfQualityVO vo) throws Exception;

    public boolean createOrUpdate(WhWmsGradeOfQualityVO vo) throws Exception;

    public boolean cancelWhWmsGradeOfQuality(WhWmsGradeOfQuality record) throws Exception;

    public boolean cancelWhWmsGradeOfQualitySku(WhWmsGradeOfQualitySku record) throws Exception;

    public boolean cancelWhWmsGradeOfQualitySkuByCond(WhWmsGradeOfQualitySkuCond cond) throws Exception;

    public boolean wmsReleaseOccupy(WhWmsGradeOfQualityVO vo,Long wmsGradeSkuId);

    public boolean rejectWmsGradeOfQuality(WhWmsGradeOfQualityVO vo,Long wmsGradeSkuId);

    public boolean passWmsGradeOfQuality(WhWmsGradeOfQualityVO vo, Long wmsGradeSkuId);

    public void wmsOccupy(WhWmsGradeOfQualityVO vo);

    public boolean updateSkuStockByCond(WhWmsGradeOfQualityVO whWmsGradeVO,String skuCode,Long wmsGradeSkuId);

    public boolean updateWhWmsGradeOfQualitySku(WhWmsGradeOfQualityVO vo);

    public boolean updateWhWmsGradeOfQualityBarcode(WhWmsGradeOfQualityVO vo);

    public boolean batchCreateWhWmsGradeOfQualitySku(List<WhWmsGradeOfQualitySku> gradeOfQualitySkus);

    public boolean batchCreateWhWmsGradeOfQualityBarcode(List<WhWmsGradeOfQualityBarcode> gradeOfQualityBarcodes);

    public boolean batchDeleteWhWmsGradeOfQualitySkuByCond(WhWmsGradeOfQualitySkuCond cond);

    public boolean batchDeleteWhWmsGradeOfQualityBarcodeByCond(WhWmsGradeOfQualityBarcodeCond cond);

    public WhWarehouse findGradeWarehouseByCond(String phyCode,Integer relateType,Integer skuStatus) throws Exception;

    public boolean modifyStatus(WhWmsGradeOfQualityVO vo);
}
