package com.thebeastshop.pegasus.service.warehouse.service;

import com.github.pagehelper.PageInfo;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuSimpleVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsConsumableSkuCond;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConsumableSku;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConsumableSkuVO;

import java.util.List;

/**
 * 耗材领用Service
 * @author Gary
 * @date 2017-11-17 14:45
 */
public interface WhWmsConsumableService {

  /**
   * 查询可领用的SKU
   * @param cond
   * @return
   */
  PageInfo<WhWmsConsumableSkuVO> findWmsConsumableSkuByCond(WhWmsConsumableSkuCond cond);

  /**
   * 批量创建耗材领用SKU
   * @param consumableSkuVOList
   * @return
   */
  List<Integer> batchCreate(List<WhWmsConsumableSkuVO> consumableSkuVOList);

  /**
   * 批量删除可领用SKU
   * @param skuCodes
   */
  void batchDeleteConsumableSku(List<String> skuCodes);

  /**
   * 查询可用的 耗材SKU
   * @param skuCodeOrName
   * @return
   */
  List<PcsSkuSimpleVO> findConsumableSkuByCodeOrName(String skuCodeOrName);


  List<WhWmsConsumableSku> buildListVO2PO(List<WhWmsConsumableSkuVO> whWmsConsumableSkuVOList);


  List<String> findBySkuCodes(List<String> skuCodes);
}
