/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.warehouse.service;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsConnectPickSkuCond;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectPickSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectTurnoverBox;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuStock;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

/**
 * @author Eric.Lou
 * @version $Id: WhWmsConnectPickSkuService.java, v 0.1 2016-03-25 下午5:48
 */
public interface WhWmsConnectPickSkuService {

    /**
     * 创建
     * @param vo
     * @return
     */
    @Transactional
    WhWmsConnectPickSkuVO create(WhWmsConnectPickSkuVO vo);

    @Transactional
    boolean batchCreate(List<WhWmsConnectPickSkuVO> voList);

    boolean cancelConnectPickSku(List<Long> connectIds);

    /**
     * 更新
     * @param vo
     * @return
     */
    @Transactional
    Boolean update(WhWmsConnectPickSkuVO vo);
    @Transactional
    void updateWhWmsConnectPickSkuByKey(WhWmsConnectPickSku vo);
    /**
     * 提交拣货任务
     * @param
     * @param
     * @param
     * @return
     */
    @Transactional
    Boolean submitConnectPickSku(WhWmsConnectPickSkuSubmitDataVO whWmsConnectPickSkuSubmitDataVO);
    boolean preSubmitConnectPickSku(WhWmsConnectInfoVO connectVO,List<WhWmsConnectPickSkuVO> pickSkuVOList,Long operatorId,WhCommand cmd,List<WhWmsCommandConnectVO> commandConnects) throws Exception;
    /**
     * 提交拣货任务
     * @param
     * @param pickSkuVOList
     * @param operatorId
     * @return
     */
    WhWmsConnectPickSkuSubmitDataVO checkSubmitConnectPickSku(WhWmsConnectInfoVO connectVO,List<WhWmsConnectPickSkuVO> pickSkuVOList,Long operatorId,WhCommand cmd,List<WhWmsCommandConnectVO> commandConnects) throws Exception;
    boolean submitConnectPickSkuAlt(WhWmsConnectPickSkuSubmitDataVO vo,Long operatorId) throws Exception;
    WhWmsConnectPickSkuSubmitDataVO checkSubmitConnectPickSkuPcsRtn(WhWmsConnectInfoVO connectVO,List<WhWmsCommandConnectVO> commandConnectList,List<WhWmsConnectPickSkuVO> pickSkuVOList,Long operatorId) throws Exception;
    boolean submitConnectPickSkuPcsRtn(WhWmsConnectPickSkuSubmitDataVO vo,Long operatorId) throws Exception;
    WhWmsConnectPickSkuSubmitDataVO checkSubmitConnectPickSkuAlt(WhWmsConnectInfoVO connectVO,List<WhWmsConnectPickSkuVO> pickSkuVOList,Long operatorId) throws Exception;

    WhWmsConnectPickSkuSubmitDataVO checkSubmitConnectPickSkuRecWaste(WhWmsConnectInfoVO connectVO,List<WhWmsCommandConnectVO> commandConnectList,List<WhWmsConnectPickSkuVO> pickSkuVOList,Long operatorId) throws Exception;
    boolean submitConnectPickSkuRecWaste(WhWmsConnectPickSkuSubmitDataVO vo,Long operatorId) throws Exception;
    /**
     * 绑定拣货周转箱
     * @param connectId
     * @param turnoverBoxNo
     * @param createUserId
     * @return
     */
    @Transactional
    Boolean bindConnectBox(Long connectId,String turnoverBoxNo,Long createUserId);

    List<WhWmsConnectTurnoverBox> findConnectBoxByConnectId(Long connectId);

    /**
     * 删除拣货周转箱
     * @param connectId
     * @return
     */
    @Transactional
    Boolean deleteConnectBox(Long connectId);

    /**
     * 删除拣货周转箱
     * @param connectId
     * @param turnoverBoxNo
     * @return
     */
    @Transactional
    Boolean delConnectBox(Long connectId,String turnoverBoxNo);

    /**
     * 根据条件查找拣货箱
     * @param cond
     * @return
     */
    List<WhWmsConnectTurnoverBox> findBoxByCond(WhWmsConnectTurnoverBox cond);

    /**
     * 根据主键查找
     * @param id
     * @return
     */
    WhWmsConnectPickSkuVO findById(Long id);

    /**
     * 根据条件查找
     * @param cond
     * @return
     */
    List<WhWmsConnectPickSkuVO> findByCond(WhWmsConnectPickSkuCond cond);
    int findPickCommandCount(Long connectId);
    /**
     * 根据connectId查找
     * @param connectId
     * @return
     */
    List<WhWmsConnectPickSkuVO> findByConnectId(Long connectId);
    List<WhWmsConnectPickSkuVO> findConnectPickSkuByCond(WhWmsConnectPickSkuCond cond);

    boolean isConnectPickSkuFinish(List<WhWmsConnectPickSkuVO> connectPickSkuVOs);

    List<WhCountVO> countConnectPickSku(Long operatorId,String physicalWarehouseCode);
    void autoProcessShelvesStatus();
    /**
     * 根据connectId查找
     * @param connectIds
     * @return
     */
    List<WhWmsConnectPickSkuVO> findByConnectIds(List<Long> connectIds);
    List<WhWmsConnectPickSkuVO> findListConnectPickSku(List<Long> connectIds);
    /**
     * 耗材领用 出入库，扣减wms库存
     * @param packageCode
     * @param quantityMap
     * @param whWmsSkuStocks
     * @param operatorId
     * @return
     * @throws Exception
     */
    boolean consumableReceiveOutInPut(String dispatchBillCode, Map<String,Integer> quantityMap, List<WhWmsSkuStock> whWmsSkuStocks,
                              Long operatorId) throws Exception;

}
