/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.warehouse.service;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsConnectParaCond;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectParaVO;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author Eric.Lou
 * @version $Id: WhWmsConnectParaService.java, v 0.1 2016-03-16 下午4:50
 */
public interface WhWmsConnectParaService {

    /**
     * 创建
     * @param vo
     * @return
     */
    @Transactional
    WhWmsConnectParaVO create(WhWmsConnectParaVO vo);

    /**
     * 更新
     * @param vo
     * @return
     */
    @Transactional
    Boolean update(WhWmsConnectParaVO vo);

    /**
     * 根据主键查找
     * @param id
     * @return
     */
    WhWmsConnectParaVO findById(Long id);

    /**
     * 根据主键查找
     * @param id
     * @return
     */
    Integer findValueById(Long id);

    /**
     * 根据条件查找
     * @param cond
     * @return
     */
    List<WhWmsConnectParaVO> findByCond(WhWmsConnectParaCond cond);

    /**
     * 根据名称查找
     * @param name
     * @return
     */
    WhWmsConnectParaVO findByName(String name);

    /**
     * 根据名称查找
     * @param name
     * @return
     */
    Integer findValueByName(String name);



}
