package com.thebeastshop.pegasus.service.warehouse.service;

import com.thebeastshop.pegasus.service.warehouse.cond.*;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsBoxNumber;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectInfo;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

import java.util.List;
import java.util.Map;

/**
 * @author Eric.Lou
 * @version $Id: WhWmsConnectInfoService.java, v 0.1 2016-03-16 下午4:48
 */
public interface WhWmsConnectInfoService {

    /**
     * 创建波次
     * @param vo 波次vo
     * @param count 波次最大command数
     * @return
     */
    @Transactional
    List<WhWmsConnectInfoVO> createWhWmsConnectInfo(WhWmsConnectInfoVO vo,int count)throws Exception;
    
    /**
     * 创建波次-调拨
     * @param vo 波次vo
     * @param count 波次最大command数
     * @return
     */
    @Transactional
    List<WhWmsConnectInfoVO> createWhWmsConnectInfoAlt(WhWmsConnectInfoVO vo,int count)throws Exception;


    List<WhWmsConnectInfoVO> createWhWmsConnectInfoRecWaste(WhWmsConnectInfoVO vo,int count) throws Exception;

    boolean startConnect(WhWmsConnectInfoVO connectInfo) throws Exception;

    List<WhWmsConnectCountVO> connectCount(String physicalWarehouseCode);

    boolean connectDistribute(WhWmsConnectDistributVO connectDistribut);

    boolean connectDistribute(Long connectId);
    
    /**
     * 创建波次-采退
     * @param vo 波次vo
     * @param count 波次最大command数
     * @return
     */
    @Transactional
    List<WhWmsConnectInfoVO> createWhWmsConnectInfoPcsRtn(WhWmsConnectInfoVO vo,int count)throws Exception;

    /**
     * 创建波次
     * @param vo
     * @return
     */
    @Transactional
    WhWmsConnectInfoVO create(WhWmsConnectInfoVO vo)throws Exception;

    /**
     * 更新波次
     * @param vo
     * @return
     */
    @Transactional
    Boolean update(WhWmsConnectInfoVO vo);

    /**
     * 更新波次状态
     * @return
     */
    @Transactional
    Boolean connectStatusTransform(Long connectId,Integer beforeStatus,Integer afterStatus);


    /**
     * 根据主键删除
     * @param id
     * @return
     */
    @Transactional
    boolean deleteById(Long id);

    boolean cancelConnect(List<Long> idList);

    /**
     * 根据主键查找
     * @param id
     * @return
     */
    WhWmsConnectInfoVO findById(Long id);

    /**
     * 查找拣货已完成但
     * 波次未进行后续流程的波次
     * */
    List<WhWmsConnectInfoVO> findNeedHandleConnect();

    /**
     * 根据条件查找
     * @param cond
     * @return
     */
    Pagination<WhWmsConnectInfoVO> findByCond(WhWmsConnectInfoCond cond);

    List<WhWmsConnectInfo> findConnectInfoByCond(WhWmsConnectInfoCond cond);

    /**
     * 根据条件查找待出库的仓库指令
     * @param cond
     * @return
     */
    List<WhWmsWaitOutStockVO> findWaitOutStockCommandByCond(WhWmsWaitOutStockCond cond);

    List<WhWmsWaitOutStockVO> findWaitOutStockCommandSaleOutByCond(WhWmsWaitOutStockCond cond);
    
    /**
     * 根据条件查找待出库的仓库指令
     * @param cond
     * @return
     */
    List<WhWmsWaitOutStockVO> findWaitOutStockCommandAltByCond(WhWmsWaitOutStockCondAlt cond);
    
    /**
     * 根据条件查找待出库的仓库指令
     * @param cond
     * @return
     */
    List<WhWmsWaitOutStockVO> findWaitOutStockCommandPcsRtnByCond(WhWmsWaitOutStockCondPcsRtn cond);


    Pagination<WhWmsWaitOutStockVO> findWaitOutStockCommandRecWasteByCond(WhWmsWaitOutStockCondRecWaste cond);
    
    /**
     * 打包验货-调拨
     * */
    boolean submitConnectAltCheck(WhWmsConnectAllotPackageVO packageVO) throws Exception; 
    
    /**
     * 根据条件查找待出库的仓库指令
     * 单品单件 top5 sku
     * @param cond
     * @return
     */
    public List<WhSkuInfoVO> findWaitOutStockCommandSkuByCond(WhWmsWaitOutStockCond cond);

    /**
     * 根据条件查找箱号
     * @param cond
     * @return
     */
    List<WhWmsBoxNumber> findWmsBoxNumberByCond(WhWmsBoxNumberCond cond);
    List<WhWmsBoxNumberVO> findSingleBoxNumberByCond(WhWmsBoxNumberCond cond);

    Map<Integer, WhWmsConnectCountInfoVO> countUnfinishedConnect(String physicalWarehouseCode);

    boolean updateBoxNumber(WhWmsBoxNumberVO vo);

    WhWmsBoxNumberVO createBoxNumber(WhWmsBoxNumberVO vo);

    boolean createBoxNumber(WhWmsBoxNumber boxNumber);

}
