package com.thebeastshop.pegasus.service.warehouse.service;

import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectDistribution;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandCheckVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectDistributeInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectDistributionVO;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

/**
 * @author Eric.Lou
 * @version $Id: WhWmsConnectDistributionService.java, v 0.1 2016-04-11 下午2:50
 */
public interface WhWmsConnectDistributionService {

    /**
     * 批量创建
     * @param vos
     * @return
     */
    @Transactional
    List<WhWmsConnectDistributionVO> create(List<WhWmsConnectDistributionVO> vos);


    /**
     * 批量创建
     * @param vos
     * @return
     */
    @Transactional
    List<WhWmsConnectDistributionVO> create(List<WhWmsConnectDistributionVO> vos,Long operatorId);

    boolean connectDistribute(WhWmsConnectDistributeInfoVO connectDistributeInfo);

    /**
     * 更新
     * @param vo
     * @return
     */
    @Transactional
    Boolean update(WhWmsConnectDistributionVO vo);

    /**
     * 删除分拨数据
     * @param connectId
     * @param commandCode
     * @return
     */
    @Transactional
    boolean deleteConnectDistribution(Long connectId,String commandCode);

    @Transactional
    boolean batchDeleteConnectDistribution(Long connectId,List<String> commandCodes);

    /**
     * 根据主键查找
     * @param id
     * @return
     */
    WhWmsConnectDistributionVO findById(Long id);

    /**
     * 根据条件查找
     * @param cond
     * @return
     */
    List<WhWmsConnectDistributionVO> findByCond(WhWmsConnectDistributionVO cond);
    Map<String, List<String>> findPackageDistributionBoxNo(List<Long> commandIdList, List<String> commandCodeList);
    /**
     * 检查出库验货数据是否正确
     * @param connectId
     * @param commandCode
     * @param paras
     * @return
     */
    boolean checkConnectDistribution(Long connectId,String commandCode,List<WhWmsCommandCheckVO> paras);

    /**
     * 检查取消出库验货数据是否正确
     * @param connectId
     * @param commandCode
     * @param paras
     * @return
     */
    List<WhWmsConnectDistribution> cancelCheckConnectDistribution(Long connectId, String commandCode, List<WhWmsCommandCheckVO> paras);

    /**
     * 检查是否可以绑定分拨箱
     * @param code
     * @return
     */
    boolean checkBoxNo(String code);


}
