package com.thebeastshop.pegasus.service.warehouse.service;


import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsCommandConnectCond;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsCommandConnect;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandConnectVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuPickStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuStockVO;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author Eric.Lou
 * @version $Id: WhWmsCommandConnectService.java, v 0.1 2016-03-16 下午4:51
 */
public interface WhWmsCommandConnectService {

    /**
     * 批量创建
     * @param vo
     * @return
     */
    @Transactional
    List<WhWmsCommandConnectVO> create(WhWmsConnectInfoVO vo);

    boolean create(List<WhWmsCommandConnectVO> voList);
    
    /**
     * 批量创建-调拨
     * @param vo
     * @return
     */
    @Transactional
    List<WhWmsCommandConnectVO> createConnectInfoAlt(WhWmsConnectInfoVO vo);
    
    /**
     * 批量创建-采退
     * @param vo
     * @return
     */
    @Transactional
    List<WhWmsCommandConnectVO> createConnectInfoPcsRtn(WhWmsConnectInfoVO vo);

    @Transactional
    List<WhWmsCommandConnectVO> createConnectInfoRecWaste(WhWmsConnectInfoVO vo);


    void sortSkuStock(List<WhWmsSkuStockVO> stocks);

    /*
    * 拣货逻辑
    * */
    List<WhWmsSkuPickStockVO> generalPickSkuStockStragety(List<WhWmsSkuPickStockVO> pickStockList , Integer skuStatus, String physicalWarehouseCode);

    /**
     * 更新
     * @param vo
     * @return
     */
    @Transactional
    Boolean update(WhWmsCommandConnectVO vo);

    @Transactional
    Boolean batchUpdate(WhWmsCommandConnect record, WhWmsCommandConnectCond cond);

    Boolean batchCancel(List<String> commandCodes,Long connectId);

    Boolean batchCancelByConnectId(List<Long> connectIds);

    /**
     * 根据主键查找
     * @param id
     * @return
     */
    WhWmsCommandConnectVO findById(Long id);

    /**
     * 根据仓库指令查 非取消的 波次仓库指令
     * @param whCommandCode
     * @return
     */
    WhWmsCommandConnectVO findNotCanceledByWhCommandCode(String whCommandCode);

    /**
     * 根据仓库指令查 波次仓库指令
     * @param whCommandCode
     * @return
     */
    WhWmsCommandConnectVO findByWhCommandCode(String whCommandCode,boolean isCanceled);

    /**
     * 根据波次id查 非取消的 波次仓库指令
     * @param connectId
     * @return
     */
    List<WhWmsCommandConnectVO> findNotCanceledByConnectId(Long connectId);

    /**
     * 根据波次id查 波次仓库指令 总数
     * @param connectId
     * @return
     */
    Integer findCountByConnectId(Long connectId);

    List<WhCountVO> countConnectCommandByConnectId(List<Long> connectId);

    /**
     * 根据条件查找
     * @param cond
     * @return
     */
    List<WhWmsCommandConnectVO> findByCond(WhWmsCommandConnectCond cond);

}
