package com.thebeastshop.pegasus.service.warehouse.service;

import com.thebeastshop.pegasus.integration.express.PackageInfo;
import com.thebeastshop.pegasus.integration.express.zt.ZTOrder;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsCheckGiftCard;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

/**
 * @author Eric.Lou
 * @version $Id: WhWmsCommandCheckService.java, v 0.1 2016-04-14 下午3:31
 */
public interface WhWmsCommandCheckService {
    WhWmsConnectPickSkuSubmitDataVO preCheckCommandCheck(List<WhWmsCommandCheckVO> vos,Long operatorId);
    WhWmsConnectPickSkuSubmitDataVO preBatchCheckCommandCheck(List<WhWmsCommandCheckVO> vos,Long operatorId,List<WhCommand> whCommands);
    /**
     * 创建
     * @param vos
     * @param
     * @param operatorId
     * @param
     * @return
     */
    @Transactional
    List<WhWmsCommandCheckVO> create(List<WhWmsCommandCheckVO> vos, WhWmsConnectPickSkuSubmitDataVO whWmsConnectPickSkuSubmitDataVO, Long operatorId);


    boolean submitConnectCheck(WhWmsConnectCheckVO connectCheck);

    boolean createCustomization(WhWmsCommandCheckInfo checkInfo);

    /**
     * 批量创建出库单出库验货数据
     * @param connectId
     * @param batchList
     * @param fedList
     * @param sfList
     * @return
     */
    @Transactional
    Boolean create(Long connectId, List<WhWmsCommandCheckBatch> batchList, List<PackageInfo> fedList, List<PackageInfo> sfList);

    /**
     * 标记缺货中,取消出库
     * @param commandCode
     * @param operatorId
     * @param vos
     * @return
     */
    @Transactional
    Boolean cancel(String commandCode,Long operatorId,List<WhWmsCommandCheckVO> vos);

    @Transactional
    Boolean cancel(String commandCode,Long operatorId);

    /**
     * 出库指令取消,取消出库
     * @param commandCode
     * @param operatorId
     * @return
     */
    @Transactional
    Boolean reject(String commandCode,Long operatorId);
    /**
     * 更新
     * @param vo
     * @return
     */
    @Transactional
    Boolean update(WhWmsCommandCheckVO vo);

    /**
     * 根据主键删除
     * @param id
     * @return
     */
    @Transactional
    boolean deleteById(Long id);

    /**
     * 根据主键查找
     * @param id
     * @return
     */
    WhWmsCommandCheckVO findById(Long id);

    /**
     * 根据条件查找
     * @param cond
     * @return
     */
    List<WhWmsCommandCheckVO> findByCond(WhWmsCommandCheckVO cond);

    boolean checkGiftCardCanBindByCardNo(String cardNo);

    boolean unBoundCheckGiftCard(String packageCode);

}
