/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.warehouse.service;

import com.github.pagehelper.PageInfo;
import com.thebeastshop.pegasus.service.warehouse.cond.WhTakeStockCond;
import com.thebeastshop.pegasus.service.warehouse.model.WhTakeStock;
import com.thebeastshop.pegasus.service.warehouse.vo.WhPhysicalWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhTakeStockRcdVO;

import java.util.List;

/**
 * @author Royan
 * @version $Id: WhTakeStockService.java, v 0.1 2015-07-09 下午2:53
 */
public interface WhTakeStockService {

    /**
     * 创建
     *
     * @param whTakeStock
     * @return ID
     */
    public Long createTakeStock(WhTakeStock whTakeStock)throws Exception;

    /**
     * 批量创建盘点记录
     * @param whTakeStockList
     * @return
     * @throws Exception
     */
    List<Long> batchCreateTakeStock(List<WhTakeStock> whTakeStockList)throws Exception;

    WhPhysicalWarehouseVO findPhysicalByWarehouseCode(String warehouseCode);

    public void recordScmStock(WhTakeStock whTakeStock)throws Exception;

    /**
     * 根据仓库编码查找
     *
     * @param warehouseCode 仓库编码
     * @param fetchRcd 是否抓取记录
     * @return 列表
     */
    public List<WhTakeStockRcdVO> findTakeStockByWarehouseCode(String warehouseCode, boolean fetchRcd);

    /**
     * 根据条件查找
     *
     * @param cond 条件
     * @return 列表
     */
    PageInfo<WhTakeStockRcdVO> findTakeStockByCond(WhTakeStockCond cond);

    Long findMaxBatchNumber();
}
