package com.thebeastshop.pegasus.service.warehouse.service;

import com.thebeastshop.pegasus.service.warehouse.model.WhJitPackageSkuReference;
import com.thebeastshop.pegasus.service.warehouse.vo.AssociatedInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhJitPackageSkuReferenceVO;

import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2017/7/13.
 */
public interface WhJitPackageSkuReferenceService {

    boolean createWhJitPackageSkuReference(WhJitPackageSkuReferenceVO vo);
    
    boolean updateByPrimaryKeySelective(WhJitPackageSkuReference record);

    boolean createWhJitPackageSkuReference(List<WhJitPackageSkuReferenceVO> voList);

    List<WhJitPackageSkuReferenceVO> findByReferenceCode(String referenceCode);
    
    List<WhJitPackageSkuReferenceVO> findBySkuCode(String skuCode);
    
    List<WhJitPackageSkuReferenceVO> findByPackageCode(String skuCode);
    
    int findUndistributedNumberByreferenceCode(String referenceCode);
    
    List<WhJitPackageSkuReferenceVO> findNeedAllotPackageByReferenceCode(String referenceCode,Integer type);
    
    List<WhJitPackageSkuReferenceVO> findOpJitPackageReferenceListByTypeAndReferenceCode(String referenceCode,Integer type);

    List<WhJitPackageSkuReferenceVO> findOpJitPackageReferenceByTypeAndReferenceCode(List<String> referenceCode,Integer type);

    WhJitPackageSkuReferenceVO findLastUsableJitPackageReferenceByTypeAndReferenceCode(String referenceCode,Integer type);

    List<WhJitPackageSkuReferenceVO> findJitPackageRefByPackageCode(String packageCode,Integer type);
    
    List<WhJitPackageSkuReferenceVO> findNeedAllotByReferenceCode(String packageCode,String skuCode);
    
    List<WhJitPackageSkuReferenceVO> findNeedAllotByPackageCodeAndSkuCode(String packageCode,String skuCode,Integer referenceType);
    
    int countAssigndNumber(String packageCode,String skuCode);
    
    WhJitPackageSkuReferenceVO findPopWarehouseByReferenceCode(String referenceCode);
    
    WhJitPackageSkuReferenceVO findPjWarehouseByReferenceCode(String referenceCode);

    List<WhJitPackageSkuReferenceVO> findByReferenceCode(List<String> referenceCodeList);
    
    List<WhJitPackageSkuReferenceVO> findBySkuCode(List<String> skuCodeList);
    
    List<WhJitPackageSkuReferenceVO> findByPackageCode(List<String> packageCodeList);

    List<WhJitPackageSkuReferenceVO> findByPackageCode(List<String> packageCode,Integer referenceType);

    Map<String,List<WhJitPackageSkuReferenceVO>> findByReferenceCodeGroup(List<String> referenceCodeList);

    List<WhJitPackageSkuReferenceVO> findJitPackageSkuNotSendMailAfterJobCancel();

    List<WhJitPackageSkuReferenceVO> findJitPackageSkuNotSendMailAfterJobFinishException();

    List<WhJitPackageSkuReferenceVO> findJitPackageSkuNotCreatePrdcJobAfterAltFinished();

    Map<String,List<WhJitPackageSkuReferenceVO>> findJitPackageSkuNotCreatePrdcJobAfterAltFinishedGroup();

    List<WhJitPackageSkuReferenceVO> findJitPackageSkuNotSendMailAfterAltFinished(WhJitPackageSkuReferenceVO vo);

    Map<String,List<WhJitPackageSkuReferenceVO>> findJitPackageSkuNotSendMailAfterAltFinishedGroup(WhJitPackageSkuReferenceVO vo);

    List<WhJitPackageSkuReferenceVO> findJitPackageSkuNotAltAfterPrdcJobFinished();

    Map<String,List<WhJitPackageSkuReferenceVO>> findJitPackageSkuNotAltAfterPrdcJobFinishedGroup();

    Map<String,List<WhJitPackageSkuReferenceVO>> findJitPackageSkuOrderCancelGroup();

    List<WhJitPackageSkuReferenceVO> findJitPackageSkuNotSendMailAfterOrderCancel();

    Map<String,List<WhJitPackageSkuReferenceVO>> findJitPackageSkuNotProcessAfterOrderPaidGroup();

    List<WhJitPackageSkuReferenceVO> findJitPackageSkuByPackageCode(List<String> packageCodes);
    
    List<WhJitPackageSkuReferenceVO> findReferenceCodeByPackageCode(List<String> packageCodes);
    
    List<AssociatedInfoVO> findAssociatedInfoByreferenceCode(String referenceCode);
    
    List<AssociatedInfoVO> findJobAssociatedInfoByreferenceCode(String referenceCode);
    
    List<WhJitPackageSkuReferenceVO> findNonCustomByPackageCode(Long orderId);

    boolean deleteByReferenceCode(String referenceCode);

    boolean finishByReferenceCode(String referenceCode);
}
