package com.thebeastshop.pegasus.service.warehouse.service;

import com.thebeastshop.pegasus.service.warehouse.cond.WhInventoryCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhInventoryDetailCond;
import com.thebeastshop.pegasus.service.warehouse.model.WhInventoryDetail;
import com.thebeastshop.pegasus.service.warehouse.model.WhInventoryReasionDic;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import page.Pagination;

import java.util.List;

/**
 * Created by Administrator on 2018/8/2.
 */
public interface WhInventoryService {

    boolean createWhInventory(WhInventoryCreateVO inventoryInfo);

    WhInventoryVO findWhInventory(Long id);

    WhInventoryVO findWhInventory(Long id,boolean cascade);

    List<WhInventoryVO> findWhInventoryByCond(WhInventoryCond cond);

    Pagination<WhInventoryVO> findWhInventoryByCondPage(WhInventoryCond cond);

    boolean initWhInventory(Long invenotryId);

    boolean cancelWhInventory(Long inventoryId);

    boolean whInventoryExistDiff(Long inventoryId);

    //提交待经理审批
    boolean submitInventoryForManagerAudit(Long inventoryId);

    WhInventoryDetailVO findWhInventoryDetail(Long detailId);

    List<WhInventoryDetailVO> findWhInventoryDetailByCond(WhInventoryDetailCond detailCond);

    Pagination<WhInventoryDetailVO> findWhInventoryDetailByCondPage(WhInventoryDetailCond detailCond);

    List<WhInventoryReasionDicVO> findAllWhInventoryReasionDic();

    boolean submitWhInventoryDetail(WhInventoryDetailVO inventoryDetail);

    boolean reInitInventoryDetail(Long inventoryDetailId);

    boolean addWhInventoryDetail(WhInventoryDetailVO inventoryDetail);

    boolean inventoryDetailManagerAudit(WhInventoryDetailAuditVO auditInfo);

    boolean inventoryDetailManagerBatchAudit(WhInventoryDetailAuditVO auditInfo);

    boolean inventoryFinishForManager(WhInventoryAuditVO auditInfo);

    boolean inventoryDetailFinanceAudit(WhInventoryDetailAuditVO auditInfo);

    boolean inventoryDetailFinanceBatchAudit(WhInventoryDetailAuditVO auditInfo);

    boolean inventoryFinishForFinance(WhInventoryAuditVO auditInfo);

    //rf相关
    WhInventoryCountInfoVO countProcessingWhInventory(String physicalWarehouseCode);

    boolean processingWhInventoryDetailInSingle(WhInventoryDetailVO inventoryDetail);

    boolean processingWhInventoryDetailInContinue(WhInventoryDetailVO inventoryDetail);

    //门店盘点邮箱配置
    List<WhInventoryEmailVO> findAllWhInventoryEmail();

    List<WhInventoryEmailVO> findWhInventoryEmail(String physicalWarehouseCode);

    boolean saveWhInventoryEmail(List<WhInventoryEmailVO> emailList);

}
