/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.warehouse.service;

import com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO;
import com.thebeastshop.pegasus.service.warehouse.cond.WhInvRcdCond;
import com.thebeastshop.pegasus.service.warehouse.model.WhInvOccupy;
import com.thebeastshop.pegasus.service.warehouse.model.WhInvRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhInvRcdExtend;
import com.thebeastshop.pegasus.service.warehouse.model.WhWarehouse;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import com.thebeastshop.stock.dto.SStockReleaseDTO;
import com.thebeastshop.stock.vo.SStockRecordVO;

import java.util.List;
import java.util.Map;

/**
 * @author Royan
 * @version $Id: WhInvService.java, v 0.1 2015-07-08 下午10:11
 */
public interface WhInvService {

    /**
     * 记录SKU库存记录
     *
     * @param whInvRcd SKU库存记录
     * @return 库存记录ID
     */
    Boolean record(WhInvRcd whInvRcd);

    Boolean batchRecord(List<WhInvRcd> whInvRcdList);

    /**
     * 记录SKU库存占用
     *
     * @param whInvOccupy SKU库存占用
     * @return 库存占用ID
     */
    public Long occupy(WhInvOccupy whInvOccupy);


    boolean batchRecords(List<WhInvRcd> whInvRcdList);

    /**
     * 记录SKU库存占用
     *
     * @param whInvOccupyList SKU库存占用列表
     * @return 库存占用ID
     */
    public List<Long> occupy(List<WhInvOccupy> whInvOccupyList);

    public List<Long> occupyAndNoNeedCheckStock(List<WhInvOccupy> whInvOccupyList,boolean noNeedCheckStock);

    public List<Long> occupy(List<WhInvOccupy> whInvOccupyList,List<WhJitPackageSkuReferenceVO> whJitPackageSkuReferenceVOList);

    List<Long> occupy(final List<WhInvOccupy> whInvOccupyList,List<WhJitPackageSkuReferenceVO> whJitPackageSkuReferenceVOList,String allotCode);

    /**
     * 权益服务库存占用
     * @param params
     * @return
     */
    Map<String, List<Long>> interestOccupy(Map<String, List<WhInvOccupy>> params);

    /**
     * 抢购活动库存占用
     * @param params
     * @return
     */
    Map<String, List<Long>> campaignOccupy(Map<String, List<WhInvOccupy>> params);

    /**
     * 释放SKU库存后占用
     *
     * @param whInvOccupyList
     * @param whReleaseOccupationVOList
     * @return 库存占用ID
     */
    public List<Long> occupyAfterRelease(List<WhInvOccupy> whInvOccupyList,
                                         List<WhReleaseOccupationVO> whReleaseOccupationVOList);

    List<Long> occupyAfterRelease(List<WhInvOccupy> whInvOccupyList,
                                  List<WhReleaseOccupationVO> whReleaseOccupationVOList,
                                  String referenceCode,
                                  List<WhJitPackageSkuReferenceVO> whJitPackageSkuReferenceVOList);

    public void releaseJitPackageOccupy(String packageCode);
    /**
     * SKU库存占用释放
     *
     * @param id SKU库存占用Id
     */
    public void releaseOccupationById(Long id);

    /**
     * 根据占用类型和相关单据号释放SKU库存占用
     *
     * @param whReleaseOccupationVO          释放占用
     */
    public void releaseOccupation(WhReleaseOccupationVO whReleaseOccupationVO);

    /**
     * 根据占用类型和相关单据号释放SKU库存占用
     *
     * @param whReleaseOccupationVOList          释放占用
     */
    public void releaseOccupation(List<WhReleaseOccupationVO> whReleaseOccupationVOList);

    /**
     * 根据占用类型和相关单据号释放SKU库存占用
     *
     * @param whReleaseOccupationVOList          释放占用
     */
    public void releaseOccupation(List<WhReleaseOccupationVO> whReleaseOccupationVOList,List<WhJitPackageSkuReferenceVO> whJitPackageSkuReferenceVOList);


    /**
     * 根据相关单据号查询SKU库存占用
     * */
    public List<WhInvOccupy> getWhInvOccupy(List<String> referenceCodes);

    /**
     * 根据SKU编码查找库存数量
     *
     * @param skuCode SKU编码
     * @return Map<仓库编码,库存数量>
     */
    public List<WhWarehouseInvQttVO> findInvQttBySkuCode(String skuCode);

    /**
     * 根据SKU编码查找待入库数量
     *
     * @param skuCode SKU编码
     * @return Map<仓库编码,库存数量>
     */
    public List<WhWarehouseInvQttVO> findWillInQttBySkuCode(String skuCode);
    
    /**
     * 根据SKU编码查找待入库数量
     *
     * @param skuCode SKU编码
     * @return Map<仓库编码,库存数量>
     */
    public List<WhWarehouseInvQttVO> findNewWillInQttBySkuCode(String skuCode);

    /**
     * 根据SKU编码和仓库编码查找库存数量
     *
     * @param skuCode       SKU编码
     * @param warehouseCode 仓库编码
     * @return 库存数量
     */
    public int findInvQttBySkuCodeAndWarehouseCode(String skuCode, String warehouseCode);
    
    /**
     * 根据SKU编码查找所有仓库的可用库存数量
     * @param skuCode       SKU编码
     * @return 可用库存数量
     */
    public int findQttBySkuCode(String skuCode);

    /**
     * 根据SKU编码列表和仓库编码查找库存数量
     *
     * @param skuCodes       SKU编码列表
     * @param warehouseCode 仓库编码
     * @return Map<SKU编码,库存数量>
     */
    public List<WhSkuInvQttVO> findInvQttBySkuCodesAndWarehouseCode(List<String> skuCodes,
                                                                    String warehouseCode);

    /**
     * 根据仓库编码查找SKU库存数量
     *
     * @param warehouseCode 仓库编码
     * @return Map<SKU编码,库存数量>
     */
    public List<WhSkuInvQttVO> findSkuInvQttByWarehouseCode(String warehouseCode);

    /**
     * 根据物理仓库编码查找SKU库存数量
     *
     * @param physicalWarehouseCode 物理仓库编码
     * @return Map<SKU编码,库存数量>
     */
    public List<WhSkuInvQttVO> findSkuInvQttByPhysicalWarehouseCode(String physicalWarehouseCode);

    /**
     * 根据仓库编码列表查找SKU库存数量
     *
     * @param warehouseCodeList 仓库编码列表
     * @return Map<SKU编码,库存数量>
     */
    public List<WhSkuInvQttVO> findSkuInvQttByWarehouseCodes(List<String> warehouseCodeList);

    /**
     * 根据仓库编码查找占用数量
     *
     * @param warehouseCode 仓库编码
     * @return Map<SKU编码,库存数量>
     */
    public List<WhSkuInvQttVO> findOccupyQttByWarehouseCode(String warehouseCode);

    /**
     * 根据仓库编码查找待入库数量
     *
     * @param warehouseCode 仓库编码
     * @return Map<SKU编码,库存数量>
     */
    public List<WhSkuInvQttVO> findWillInQttByWarehouseCode(String warehouseCode);

    /**
     * 根据SKU编码查找占用数量
     *
     * @param skuCode SKU编码
     * @return Map<仓库编码,库存数量>
     */
    public List<WhWarehouseInvQttVO> findOccupyQttBySkuCode(String skuCode);

    /**
     * 根据SKU编码和仓库编码查找占用数量
     *
     * @param skuCode       SKU编码
     * @param warehouseCode 仓库编码
     * @return 库存数量
     */
    public int findOccupyQttBySkuCodeAndWarehouseCode(String skuCode, String warehouseCode);

    /**
     * 根据SKU编码列表和仓库编码查找占用数量
     *
     * @param skuCodes       SKU编码列表
     * @param warehouseCode 仓库编码
     * @return Map<SKU编码,库存数量>
     */
    public List<WhSkuInvQttVO> findOccupyQttBySkuCodesAndWarehouseCode(List<String> skuCodes,
                                                                       String warehouseCode);

    /**
     * 根据SKU编码查找可用库存数量
     *
     * @param skuCode SKU编码
     * @return Map<仓库编码,库存数量>
     */
    public Map<String, WhInvVO> findCanUseQttBySkuCode(String skuCode);

    public List<WhWarehouseSkuInvVO> findWarehousesSkuInvByCond(List<String> warehouseCodeList,String skuCode);

    Map<String, Map<String, WhInvVO>> findSkuStocks(List<String> skuCodes, List<String> warhouseCodes);

    public Map<String, WhWarehouse> getWarehouseMap(List<String> warehouseCodeList);
    /**
     * 根据仓库编码查找可用库存数量
     *
     * @param warehouseCode 仓库编码
     * @return Map<SKU编码,库存数量>
     */
    public Map<String, WhInvVO> findCanUseQttByWarehouseCode(String warehouseCode);

    /**
     * 根据SKU编码和仓库编码查找可用库存数量
     *
     * @param skuCode       SKU编码
     * @param warehouseCode 仓库编码
     * @return 库存数量
     */
    public WhInvVO findCanUseQttBySkuCodeAndWarehouseCode(String skuCode, String warehouseCode);

    /**
     * 根据SKU编码列表和仓库编码查找可用库存数量
     *
     * @param skuCodes       SKU编码列表
     * @param warehouseCode 仓库编码
     * @return Map<SKU编码,库存数量>
     */
    public Map<String, WhInvVO> findCanUseQttBySkuCodesAndWarehouseCode(List<String> skuCodes,
                                                                        String warehouseCode);

    /**
     * 计算可用库存报表
     */
    public List<WhInvVO> calCanUseQtt();


    /**
     * 条件获取出入库记录
     * @param cond
     * @return
     */
    public List<WhInvRcdVO> getInvRcdByCond(WhInvRcdCond cond);
    List<WhInvRcdExtend> findWhInvRcdExtendListByIdList(List<Long> idList);
    /**
     * 条件获取占用记录
     * @param cond
     * @return
     */
    public List<WhInvOccupy> getInvOccupyByCond(WhInvRcdCond cond);
    /**
     * 条件获取待入库总数
     * @param cond
     * @return
     */
    public WhInvOccupy getCountInvRcdWillInByCond(WhInvRcdCond cond);
    /**
     * 条件获取待入库详情记录
     * @param cond
     * @return
     */
    public List<WhInvOccupy> getInvRcdWillInByCond(WhInvRcdCond cond);
    /**
     * 查询各渠道库存
     * @param skuCodes
     * @return
     */
    public List<WhInvQttVO> findInvQttBySkuCode_IPOS(String channelCode, String skuCodes);

    /**
     * 根据相关单据号查找占用
     * @param referenceCode
     */
    public WhInvOccupy findOccupyQttByReferenceCode(String referenceCode);

    /**
     * 根据相关单据号查找占用 like
     * @param referenceCode
     */
    List<WhInvOccupy> findOccupyQttByReferenceCodeLike(String referenceCode);

    /**
     * 更新占用类型
     * @param record
     * @return
     */
    int updateOccupyType(WhInvOccupy record);


    /**
     * 释放指定数量的权益库存占用
     * @param interestId
     * @param skuCode
     * @param quantity
     * @return
     */
    Boolean releaseInterestOccupy(String interestId, String skuCode, Integer quantity);

    /**
     * 释放指定数量的活动库存占用
     * @param campaignCode
     * @param skuCode
     * @param quantity
     * @return
     */
    Boolean releaseCampaignOccupy(String campaignCode, String skuCode, Integer quantity);

    /**
     * 通过活动编码和sku编码获取库存
     * @param warehouseCode   仓库编码
     * @param campaignCode 活动编码
     * @param skuCode sku编码
     * @return
     */
    Integer findOccupyByCampaignCodeAndSkuCode(String warehouseCode, String campaignCode, String skuCode);

    /**
     * 删除抢购占用库存
     * @param releaseList
     */
    void deleteCampaignOccupation(List<WhReleaseOccupationVO> releaseList);
    /**
     *
     * @param whInvOccupyList
     * @return 释放库存
     */
    int releaseOccupy(List<WhInvOccupy> whInvOccupyList);

    /**
     *
     * @param whInvOccupyList
     * @return 更换code
     */
    int updateReferenceCode(String oldReferenceCode,String newReferenceCode);

    /**
     * vo 转换为库存释放DTO
     * @param whReleaseOccupationVOList
     * @return
     */
    List<SStockReleaseDTO> convertWhRelease2DTO(List<WhReleaseOccupationVO> whReleaseOccupationVOList);

    List<SStockRecordVO> convertWhInv2DTO(List<WhInvRcd> whInvRcdList);

    /**
     * 调拨在途
     * @param warehouseCode
     * @return
     */
    List<WhSkuInvQttVO> findAllotWillInQttByWarehouseCode(final String warehouseCode);
}
