/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.warehouse.service;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.thebeastshop.pegasus.service.warehouse.cond.WhAllotCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWarehouseCond;
import com.thebeastshop.pegasus.service.warehouse.model.*;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAllotDiffSendMessageVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhDistrictPhysicalWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhPhysicalWarehouseRelateWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhPhysicalWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseVO;
import org.apache.ibatis.annotations.Param;

/**
 * @author Royan
 * @version $Id: WhInfoService.java, v 0.1 2015-07-06 下午4:48
 */
public interface WhInfoService {

    /**
     * 创建物理仓
     *
     * @param whPhysicalWarehouse 物理仓
     * @return 物理仓编码
     */
    public String createPhysicalWarehouse(WhPhysicalWarehouse whPhysicalWarehouse);

    /**
     * 更新物理仓
     *
     * @param whPhysicalWarehouse 物理仓
     * @return 是否成功
     */
    public boolean updatePhysicalWarehouse(WhPhysicalWarehouse whPhysicalWarehouse);
    void saveOrUpdateApplicationPara(String bu,boolean autoAudit);
    WhApplicatPara findWhApplicationParaByBu(String bu);
    List<WhApplicatPara> findAllWhApplicationPara();
    List<WhApplicatParaSku> findWhApplicationParaSkuBySkuCode(String skuCode);
    /**
     * 根据编码更新物理仓
     *
     * @param code 编码
     * @param whPhysicalWarehouse 物理仓
     * @return 是否成功
     */
    public boolean updatePhysicalWarehouseByCode(String code,
                                                 WhPhysicalWarehouse whPhysicalWarehouse);
    public WhWmsExpressInfo findExpressInfoById(Long id);

    public List<WhWmsExpressInfo> findAllExpressInfo();
    /**
     * 删除物理仓
     *
     * @param whPhysicalWarehouse 物理仓
     * @return 是否成功
     */
    public boolean deletePhysicalWarehouse(WhPhysicalWarehouse whPhysicalWarehouse);

    /**
     * 根据编码查找物理仓
     *
     * @param code 物理仓编码
     * @return 物理仓
     */
    public WhPhysicalWarehouse findPhysicalWarehouseByCode(String code);
    public WhPhysicalWarehouseVO findPhysicalWarehouseVOAndWarehouseGroupByPhyCode(String code);
    public WhPhysicalWarehouse findPhysicalWarehouseById(Long id);

    List<WhPhysicalWarehouseVO> findPhysicalWarehouseByGroupId(List<Long> warehouseGroupIds);

    Map<Long,List<WhPhysicalWarehouseVO>> findPhysicalWarehouseMapByGroupId(List<Long> warehouseGroupIds);

    List<WhPhysicalWarehouse> findPhysicalWarehouseByNameCode(String nameOrCode);
    List<WhPhysicalWarehouse> findNewPhysicalWarehouseByNameOrCode(String nameOrCode);
    public List<WhPhysicalWarehouse> listPhysicalWarehouseByIds(List<Long> ids);

    List<WhPhysicalWarehouse> findPhysicalWarehouseByDistrict(List<Long> districtIds);
    /**
     * 查找所有物理仓（含禁用）
     *
     * @return 物理仓列表
     */
    public List<WhPhysicalWarehouse> findAllPhysicalWarehouse();

    Map<String,WhPhysicalWarehouseVO> findAllPhysicalWarehouseMap();

    public List<WhPhysicalWarehouse> findPhysicalWarehouseByCond(WhPhysicalWarehouseVO whPhysicalWarehouseVO);

    public List<WhPhysicalWarehouseVO> listOffLinePhysicalWarehouse(WhPhysicalWarehouseVO whPhysicalWarehouseVO);

    /**
     * 查询 城市物理仓优化级
     * @param whDistrictPhysicalWarehouseVO
     * @return
     */
    public List<WhDistrictPhysicalWarehouseVO> findDistrictPyWarehouseByExample(WhDistrictPhysicalWarehouseVO whDistrictPhysicalWarehouseVO);
    public List<WhDistrictPhysicalWarehouseVO> findDistrictPyWarehouseByCodeAndDistrictId(List<String> codes,Long districtId);
    public List<WhDistrictPhysicalWarehouseVO> listDistrictPyWarehouseByCond(WhDistrictPhysicalWarehouseVO whDistrictPhysicalWarehouseVO);
    public int batchInsertDistrictPyWarehouse(List<WhDistrictPhysicalWarehouseVO> whDistrictPhysicalWarehouseVOs);
    public int deleteDistrictPyWarehouseByExample(WhDistrictPhysicalWarehouseVO whDistrictPhysicalWarehouseVO);
    void insertApplicationParaSku(WhApplicatParaSku whApplicatParaSku);
    void deleteApplicationParaSku(String skuCode);
    List<WhApplicatParaSku> findAllWhApplicationParaSku();
    /**
     * 查找所有可用物理仓
     *
     * @return 物理仓列表
     */
    public List<WhPhysicalWarehouse> findPhysicalWarehouse();

    /**
     * 根据逻辑仓查找物理仓
     *
     * @param warehouseCode 逻辑仓编码
     * @return 物理仓列表
     */
    @Deprecated
    public WhPhysicalWarehouse findPhysicalWarehouseByWarehouse(String warehouseCode);

    public List<WhPhysicalWarehouse> findPhysicalWarehouseByWarehouseCodes(Set<String> warehouseCodeSet);

    public List<WhPhysicalWarehouse> findPhysicalWarehouseByWarehouseCodesNew(Set<String> warehouseCodeSet);

    /**
     * 创建逻辑仓
     *
     * @param whPhysicalWarehouse 物理仓
     * @param whWarehouse         逻辑仓
     * @return 逻辑仓编码
     */
    public String createWarehouse(WhPhysicalWarehouse whPhysicalWarehouse, WhWarehouse whWarehouse);

    /**
     * 更新逻辑仓
     *
     * @param whWarehouse 逻辑仓
     * @return 是否成功
     */
    public boolean updateWarehouse(WhWarehouse whWarehouse);

    /**
     * 根据编码更新逻辑仓
     *
     * @param code 逻辑仓编码
     * @param whWarehouse 逻辑仓
     * @return 是否成功
     */
    public boolean updateWarehouseByCode(String code, WhWarehouse whWarehouse);

    /**
     * 删除逻辑仓
     *
     * @param whWarehouse 逻辑仓
     * @return 是否成功
     */
    public boolean deleteWarehouse(WhWarehouse whWarehouse);

    /**
     * 根据编码查找逻辑仓
     *
     * @param code 逻辑仓编码
     * @return 逻辑仓
     */
    public WhWarehouse findWarehouseByCode(String code);

    public WhWarehouseVO findWarehouseAndGroupByWarehouseCode(String code);

    public List<WhWarehouseVO> findWarehouseAndGroupByWarehouseCodes(List<String> warehouseCode);

    /**
     * 根据编码列表查找逻辑仓
     *
     * @param codes 逻辑仓编码列表
     * @return 逻辑仓列表
     */
    public List<WhWarehouse> findWarehouseByCodes(List<String> codes);

    Map<String,WhWarehouseVO> findWarehouseMapByCodes(List<String> codes);

    List<WhWarehouseVO> findWarehouseByGroupId(List<Long> warehouseGroupIds);

    Map<Long,List<WhWarehouseVO>> findWarehouseMapByGroupId(List<Long> warehouseGroupIds);

    List<WhWarehouse> findGroupWarehouseSorted(String phyWhCode,Integer skuStatus);

    Map<Integer,List<WhWarehouse>> findGroupWarehouseSortedMap(String phyWhCode,Integer skuStatus);
    /**
     * 根据条件查找逻辑仓
     *
     * @param cond 条件
     * @return 逻辑仓列表
     */
    public List<WhWarehouse> findWarehouseByCond(WhWarehouseCond cond);

    /**
     * 根据名字/编码查找逻辑仓
     *
     * @param nameOrCode 名字/编码
     * @param noPage 默认分页
     * @return 逻辑仓列表
     */
    public List<WhWarehouse> findWarehouseByNameCode(String nameOrCode);

    public List<WhWarehouse> findGroupWarehouseByNameCode(String nameOrCode,String physicalWarehouseCode,Boolean noPage);

    /**
     * 根据名字/编码和类型查找逻辑仓
     *
     * @param nameOrCode 名字/编码
     * @param warehouseType 类型
     * @return 逻辑仓列表
     */
    public List<WhWarehouse> findWarehouseByNameCodeAndType(String nameOrCode, Integer warehouseType);
    @Deprecated
    public List<WhWarehouse> findWarehouseByNameAndWaitForDispatchingFilter(String nameOrCode, Integer filterRuleType);

    /**
     * 根据仓库编码查找同物理仓下唯一的良品待分配仓
     * @param warehouseCode
     * @return
     */
    @Deprecated
    public WhWarehouse findUniqWaitForDispatchingWarehouse(String warehouseCode);

    /**
     * 根据仓库编码查找同物理仓下唯一的残次仓
     * @param warehouseCode
     * @return
     */
    @Deprecated
    public WhWarehouse findUniqDamagedWarehouse(String warehouseCode);

    /**
     * 根据仓库编码查找同物理仓下唯一的报废仓
     * @param warehouseCode
     * @return
     */
    @Deprecated
    public WhWarehouse findUniqWastedWarehouse(String warehouseCode);

    /**
     * 根据仓库编码查找同物理仓下唯一的生产加工仓
     * @param warehouseCode
     * @return
     */
    @Deprecated
    public WhWarehouse findUniqProducingWarehouse(String warehouseCode);

    /**
     * 判断两个是否在同一物理仓
     * 
     * @param warehouseCode1 逻辑仓1
     * @param warehouseCode2 逻辑仓2
     * @return
     */
    public boolean isInSamePhysicalWarehouse(String warehouseCode1, String warehouseCode2);

    /**
     * 判断两个是否库间移动（瞬间完成）
     *
     * @param warehouseCode1 逻辑仓1
     * @param warehouseCode2 逻辑仓2
     * @return
     */
    @Deprecated
    public boolean isWarehouseMove(String warehouseCode1, String warehouseCode2);

    boolean isWarehouseInSameWarehouseGroup(final String warehouseCode1, final String warehouseCode2);
    /**
     * 根据序号查找物理仓
     *
     * @param no 物理仓编码
     * @return 物理仓
     */
    public WhPhysicalWarehouse findPhysicalWarehouseByNo(String no);

    List<WhPhysicalWarehouseVO> findNotRelatePhysicalWarehouses();

    List<WhWarehouseVO> findNotRelateWarehouses();

    boolean physicalWarehouseRelateWarehouseGroup(List<String> physicalWarehouseCodes,Long warehouseGroupId);

    boolean physicalWarehouseRelieveWarehouseGroup(Long warehouseGroupId);

    boolean warehouseRelateWarehouseGroup(List<String> warehouseCodes,Long warehouseGroupId);

    boolean warehouseRelieveWarehouseGroup(Long warehouseGroupId);

    /**
     * 更新仓库配送通知
     * */
    boolean updateWhPhysicalWarehouseDeliveryNotice(Long whPhysicalWarehouseId,Integer needDeliveryNotice);

    /**
     * 通过物理仓（可有可无）  和  逻辑仓类型(可有可无)   查询逻辑仓结果
     * @param pyhialCode 物理仓 code
     * @param type   逻辑仓类型  1良品待分配仓2残次品仓3废品仓4礼品仓5样品仓6生产加工仓9渠道销售仓
     *
     * @auhtor lijing
     * @return
     */
    public List<WhWarehouse> findWarehouseByPhysicalCodeAndStatus(String pyhialCode,Integer type);

    public List<WhWarehouse> findAllWarehousesByPhyCodeAndStatus(String pyhialCode,Integer type,Integer relateType);

    public List<WhWarehouse> listWarehousesByPhyCodeAndStatusFromGroup(String pyhialCode,Integer type);

    /**
     * 查询良品仓CODE列表
     * @return
     */
    List<String> findGoodWarehouseCode();

    WhWarehouse findDefaultInOrOutWarehouseByPhyWhCode(String physicalWarehouseCode,Integer inOrOut,Integer skuStatus);

    WhWarehouse findDefaultInNondefectiveWarehouseByPhyWhCode(String physicalWarehouseCode);

    WhWarehouse findDefaultInDefectiveWarehouseByPhyWhCode(String physicalWarehouseCode);

    WhWarehouse findDefaultInWarehouseByPhyWhCodeAndCommodityStatus(String physicalWarehouseCode,Integer commodityStatus);

    WhWarehouse findDefaultOutWarehouseByPhyWhCodeAndCommodityStatus(String physicalWarehouseCode,Integer commodityStatus);

    WhWarehouse findDefaultOutNondefectiveWarehouseByPhyWhCode(String physicalWarehouseCode);

    // #################### 查询物理仓默认出入库逻辑仓 ####################
    /**
     * 根据物理仓 查询默认的出库良品逻辑仓
     * @param physicalWarehouseCode 物理仓code
     * @return
     */
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultOutNondefectiveWarehouseByPyCode(String physicalWarehouseCode);

    /**
     * 根据物理仓 查询默认的出库残次逻辑仓
     * @param physicalWarehouseCode 物理仓code
     * @return
     */
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultOutDefectiveWarehouseByPyCode(String physicalWarehouseCode);

    /**
     * 根据物理仓 查询默认的出库样品逻辑仓
     * @param physicalWarehouseCode 物理仓code
     * @return
     */
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultOutSampleWarehouseByPyCode(final String physicalWarehouseCode);

    /**
     * 根据物理仓 查询默认的出库废品逻辑仓
     * @param physicalWarehouseCode 物理仓code
     * @return
     */
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultOutWasteWarehouseByPyCode(final String physicalWarehouseCode);

    /**
     * 根据物理仓 查询默认的入库良品逻辑仓
     * @param physicalWarehouseCode 物理仓code
     * @return
     */
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultInNondefectiveWarehouseByPyCode(String physicalWarehouseCode);

    /**
     * 根据物理仓 查询默认的入库残次逻辑仓
     * @param physicalWarehouseCode 物理仓code
     * @return
     */
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultInDefectiveWarehouseByPyCode(String physicalWarehouseCode);

    /**
     * 根据物理仓 查询默认的入库样品逻辑仓
     * @param physicalWarehouseCode 物理仓code
     * @return
     */
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultInSampleWarehouseByPyCode(final String physicalWarehouseCode);

    /**
     * 根据物理仓 查询默认的入库废品逻辑仓
     * @param physicalWarehouseCode 物理仓code
     * @return
     */
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultInWasteWarehouseByPyCode(final String physicalWarehouseCode);

    /**
     * 根据物理仓 查询默认的入库废品逻辑仓
     * @param physicalWarehouseCode 物理仓code
     * @return
     */
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultInDisplayWarehouseByPyCode(final String physicalWarehouseCode);

    /**
     * 查询物理仓逻辑仓关联关系
     * @param cond
     * @return
     */
    public List<WhPhysicalWarehouseRelateWarehouseVO> findPhysicalWarehouseRelateWarehouseByCond(WhPhysicalWarehouseRelateWarehouseVO cond);

    List<WhPhysicalWarehouseVO> findPhysicalWarehouseByWarehouseCode(String warehouseCode);

    List<WhPhysicalWarehouseVO> findRelatePhysicalWarehouseByWarehouseCode(String warehouseCode,Integer inOrOut,Integer skuStatus);
    WhPhysicalWarehouse findPhysicalWarehouseByWarehouseGroupCond(String warehouseCode,Integer relateInOrOut);

    List<WhPhysicalWarehouse> findPhysicalWarehouseByType(List<Integer> warehouseTypeList);

    /**
     * 查询逻辑仓对应的物理仓
     * @param warehouseCodeList
     * @return Map <逻辑仓code, 物流仓PO>
     */
    Map<String, WhPhysicalWarehouse> findPhyWhMapByWarehouseCodes(List<String> warehouseCodeList);

    List<WhWarehouseVO> findWarehouseByGroupId(Long warehouseGroupId);

}