package com.thebeastshop.pegasus.service.warehouse.service;

import com.thebeastshop.pegasus.service.warehouse.cond.*;
import com.thebeastshop.pegasus.service.warehouse.model.*;
import com.thebeastshop.pegasus.service.warehouse.vo.WhGradeAffectInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhGradeOfQualityVO;
import page.Pagination;

import java.util.List;
import java.util.Map;

public interface WhGradeOfQualityService {

    /**
     * 查询品级调整审批列表
     * @param cond
     * @return
     */
    Pagination<WhGradeOfQualityVO> pageWhGradeOfQualityVOByCond(WhGradeOfQualityCond cond);

    public List<WhGradeAffectInfo> listWhGradeAffectInfoByWhGradeId(Long whGradeId);

    public List<WhGradeOfQualityDetail> listWhGradeOfQualityDetailByCond(WhGradeOfQualityDetailCond cond);

    public List<WhGradeAffectInfo> listWhGradeAffectInfoByCond(WhGradeAffectInfoCond cond);

    public List<WhGradeAffectInfoVO> listWhGradeAffectInfoVOByCond(WhGradeAffectInfoCond cond);

    public boolean updateWhGradeAffectInfo(WhGradeAffectInfo affectInfo);

    public boolean updateWhGradeAffectInfoOptFlag(List<Long> ids,Integer newOptFlag,Integer oldOptFlag);

    public boolean updateWhGradeAffectInfoSendMailFlag(List<Long> ids,Integer newSendMailFlag,Integer oldSendMailFlag);

    public boolean updateWhGradeAffectInfoByExampleSelective(WhGradeAffectInfo affectInfo,WhGradeAffectInfoCond affectCond);

    WhGradeOfQualityVO findWhGradeOfQualityVOById(Long id, WhGradeOfQualityCond cond);

    WhGradeOfQualityVO findWhGradeOfQualityVOByCond(WhGradeOfQualityCond cond);

    List<WhGradeOfQualityVO> listWhGradeOfQualityVOByCond(WhGradeOfQualityCond cond);

    public List<WhGradeOfQualityVO> listWhGradeOfQualityVOsByCond(WhGradeOfQualityCond cond);

    List<WhGradeOfQuality> listWhGradeOfQualityByCond(WhGradeOfQualityCond cond);

    public boolean create(WhGradeOfQualityVO vo) throws Exception;

    public boolean update(WhGradeOfQualityVO vo) throws Exception;

    public boolean modifyAndFetch(WhGradeOfQualityVO vo);

    public boolean createOrUpdate(WhGradeOfQualityVO vo) throws Exception;

    public boolean auditWhGradeOfQuality(WhGradeOfQualityVO vo) throws Exception;

    public List<Long> batchAuditWhGradeOfQuality(List<WhGradeOfQualityVO> gradeOfQualityVOs,Long approveUserId) throws Exception;

    public boolean batchCreateWhGradeAndFetch(List<WhGradeOfQualityVO> vos) throws Exception;

    public boolean updateWhGradeOfQualityDetail(WhGradeOfQualityDetail whGradeDetail);

    public boolean batchCreateWhGradeOfQuality(List<WhGradeOfQuality> gradeOfQualitys);

    public boolean batchCreateWhGradeOfQualityDetail(List<WhGradeOfQualityDetail> gradeOfQualityDetails);

    public boolean batchDeleteWhGradeOfQualityDetailByCond(WhGradeOfQualityDetailCond cond);

    public void gradeAdjustApplySendMail(final List<WhGradeOfQualityVO> whGradeVOs);

    // 缺货
    public void stockOutByGradeAdjustSendMail(final WhGradeOfQualityVO whGradeVO,final List<WhGradeAffectInfoVO> affectInfoVOs);

    public void sendMailStockOutByGradeAdjust(final WhGradeOfQualityVO whGradeVO, final List<WhGradeAffectInfoVO> affectInfoVOs,Map<String,WhGradeAffectInfoVO> waitSendEmailMap);

    public void sendStockOutEmailForGradeAdjust(List<String> toAddressList,String emailContent,List<Long> affectIds);

    // 其它订单异常
    public void orderExceptionByGradeAdjustSendMail(final WhGradeOfQualityVO whGradeVO,final List<WhGradeAffectInfoVO> affectInfoVOs);

    public void sendMailOrderExceptionByGradeAdjust(final WhGradeOfQualityVO whGradeVO,final List<WhGradeAffectInfoVO> affectInfoVOs,Map<String,WhGradeAffectInfoVO> waitSendEmailMap);

    public void sendOrderExceptionEmailForGradeAdjust(List<String> toAddressList,String emailContent,List<Long> affectIds);

    // 库存变动
    public void stockChangeByGradeAdjustSendMail(final WhGradeOfQualityVO whGradeVO,final List<WhGradeAffectInfoVO> affectInfoVOs);

    public void sendMailStockChangeByGradeAdjust(final WhGradeOfQualityVO whGradeVO,final List<WhGradeAffectInfoVO> affectInfoVOs,
                                                 Map<String,WhGradeAffectInfoVO> waitSendEmailMap);

    public void sendStockChangeEmailForGradeAdjust(List<String> toAddressList,String emailContent,List<Long> affectIds);

}
