/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.warehouse.service;

import com.thebeastshop.pegasus.service.warehouse.cond.WhDamagedRcdCond;
import com.thebeastshop.pegasus.service.warehouse.model.WhDamagedRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhWastedRcd;

import java.util.List;
import java.util.Map;

/**
 * @author Royan
 * @version $Id: WhDamageWasteService.java, v 0.1 2015-07-09 下午3:40
 */
public interface WhDamageWasteService {

    /**
     * 记录耗损
     *
     * @param whDamagedRcd 耗损
     * @return 记录ID
     */
    public Long recordDamage(WhDamagedRcd whDamagedRcd)throws Exception;

    /**
     * 记录报废
     *
     * @param whWastedRcd 报废
     * @return 记录ID
     */
    public Long recordWaste(WhWastedRcd whWastedRcd)throws Exception;

    /**
     * 根据SKU编码查找耗损记录
     *
     * @param skuCode SKU编码
     * @return Map<来源仓库编码,耗损记录列表>
     */
    public Map<String, List<WhDamagedRcd>> findDamagedRcdBySkuCode(String skuCode);

    /**
     * 根据SKU编码和来源仓库编码查找耗损记录
     *
     * @param skuCode             SKU编码
     * @param sourceWarehouseCode 来源仓库编码
     * @return 耗损记录列表
     */
    public List<WhDamagedRcd> findDamagedRcdBySkuCodeAndWarehouseCode(String skuCode,
                                                                      String sourceWarehouseCode);

    /**
     * 根据条件查找残次记录
     *
     * @param cond 条件
     * @return 残次记录列表
     */
    public List<WhDamagedRcd> findDamagedRcdByCond(WhDamagedRcdCond cond);

    /**
     * 根据SKU编码查找报废记录
     *
     * @param skuCode SKU编码
     * @return Map<来源仓库编码,报废记录列表>
     */
    public Map<String, List<WhWastedRcd>> findWastedRcdBySkuCode(String skuCode);

    /**
     * 根据SKU编码和来源仓库编码查找报废记录
     *
     * @param skuCode             SKU编码
     * @param sourceWarehouseCode 来源仓库编码
     * @return 报废记录列表
     */
    public List<WhWastedRcd> findWastedRcdBySkuCodeAndWarehouseCode(String skuCode,
                                                                    String sourceWarehouseCode);

    /**
     * 处理残次
     *
     * @param warehouseCode 残次仓编码
     * @param skuCode   sku编码
     * @param quantity  处理数量
     * @param type  类型（waste,fix）
     * @return
     */
    public boolean dealDamaged(String warehouseCode, String skuCode, Integer quantity, String type) throws Exception;
}