/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.warehouse.service;

import com.thebeastshop.pegasus.integration.express.PackageInfo;
import com.thebeastshop.pegasus.integration.express.zt.ZTOrderSubmitResponse;
import com.thebeastshop.pegasus.service.warehouse.cond.*;
import com.thebeastshop.pegasus.service.warehouse.model.*;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import com.thebeastshop.pegasus.util.vo.JdStockSyncResult;
import com.thebeastshop.stock.dto.SStockReleaseDTO;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author Royan
 * @version $Id: WhCommandService.java, v 0.1 2015-07-08 上午11:54
 */
public interface WhCommandService {

    /**
     * 创建指令
     *
     * @param whCommand 指令
     * @return 指令编码
     */
    public String createCommand(WhCommand whCommand) throws Exception;

    boolean recordCommand(List<WhCommand> cmdList);


    /**
     * 创建指令
     * 不生成指令占用
     * @param whCommand 指令
     * @return 指令编码
     */
    String createCommandWithoutOccupy(WhCommand whCommand);

    /**
     * 制单指令创建
     * @param whCommand
     * @param whReleaseOccupationVOList
     * @return
     * @throws Exception
     */
    String createCommand(WhCommand whCommand, List<WhReleaseOccupationVO> whReleaseOccupationVOList) throws Exception;

    /**
     * 创建指令（已经有预占用的单据需先释放库存）
     * @param whCommand
     * @param occupyDTOList
     * @return
     * @throws Exception
     *
     * */

    String createCommandAfterReleasePreOccupy(WhCommand whCommand, List<SStockReleaseDTO> releaseList) throws Exception;

    /**
     * 创建指令，并自动完成
     *
     * @param whCommand 指令
     * @return 指令编码
     */
    public String createCommandThenFinish(WhCommand whCommand) throws Exception;
    /**
     * 创建指令，并自动完成
     *
     * @param whCommands 指令
     * @return 指令编码
     */
    public List<String> createCommandsThenFinish(List<WhCommand> whCommands)throws Exception;

    /**
     * 释放SKU库存后创建指令
     *
     * @param whCommand 指令
     * @param whReleaseOccupationVOList          释放占用
     * @return 指令编码
     */
    public String createCommandAfterRelease(WhCommand whCommand,
                                            List<WhReleaseOccupationVO> whReleaseOccupationVOList)throws Exception;

    /**
     * 占用SKU库存后创建指令
     *
     * @param whCommand 指令
     * @param whInvOccupyList SKU库存占用列表
     * @return 指令编码
     */
    public String createCommandAfterOccupy(WhCommand whCommand, List<WhInvOccupy> whInvOccupyList)throws Exception;

    /**
     * 释放SKU库存后创建指令，并自动完成
     *
     * @param whCommand 指令
     * @return 指令编码
     */
    public String createCommandAfterReleaseThenFinish(WhCommand whCommand,
                                                      List<WhReleaseOccupationVO> whReleaseOccupationVOList)throws Exception;

    String createCommandThenFinishWithoutOccupy(WhCommand whCommand,List<WhReleaseOccupationVO> releaseList);

    String createCommandThenFinishForSales(WhCommand whCommand
            ,List<WhReleaseOccupationVO> releaseList,List<WhInvRcd> invRcdList,String uniqueCode);

    boolean finishOutCommandForSales(WhCommand whCommand,List<WhReleaseOccupationVO> releaseList,List<WhInvRcd> invRcdList);

    /**
     * 释放SKU库存后创建指令，并自动完成
     *
     * @param whCommands                 指令
     * @param whReleaseOccupationVOList
     * @return 指令编码
     */
    public List<String> createCommandsAfterReleaseThenFinish(List<WhCommand> whCommands,
                                                       List<WhReleaseOccupationVO> whReleaseOccupationVOList)throws Exception;
    
    /**
     * 释放SKU库存后创建指令，并自动完成
     *
     * @param whCommands                 指令
     * @param whReleaseOccupationVOList
     * @return 指令编码
     */
    public List<String> createCommandsAfterReleaseThenFinishForPrdc(List<WhCommand> whCommands,
                                                       List<WhReleaseOccupationVO> whReleaseOccupationVOList)throws Exception;
    
    /**
     * 释放SKU库存后创建指令，并自动完成,并创建占用
     *
     * @param whCommands                 指令
     * @param whReleaseOccupationVOList
     * @return 指令编码
     */
    public List<String> createCommandsAfterReleaseThenFinishThenOccupy(List<WhCommand> whCommands,
                                                       List<WhReleaseOccupationVO> whReleaseOccupationVOList,
                                                       List<WhInvOccupy> whInvOccupyList)throws Exception;

    /**
     * 占用SKU库存后创建指令，并自动完成
     *
     * @param whCommand 指令
     * @param whInvOccupyList SKU库存占用列表
     * @return 指令编码
     */
    public String createCommandAfterOccupyThenFinish(WhCommand whCommand,
                                                      List<WhInvOccupy> whInvOccupyList)throws Exception;

    /**
     * 根据CODE列表查找指令列表
     *
     * @param codeList 指令编码列表
     * @param fetch 是否抓取行
     * @return 指令列表
     */
    public List<WhCommand> findCommandByCodes(List<String> codeList, boolean fetch);
    public List<WhCommandSku> findCommandSkuByCommandCodes(List<String> commandCodeList);
    public List<WhCommandSku> findCommandSkuByCommandSkuCodes(List<String> commandSkuCodeList);
    /**
     * 根据仓库和指令编码查找处理中的指令
     *
     * @param warehouseCodeList
     * @param codeList
     * @return
     */
    List<WhCommand> findInProcessCommandByWarehouseAndAndCodes(List<String> warehouseCodeList,
                                                               List<String> codeList);

    /**
     * 根据CODE查找指令
     *
     * @param code 指令编码
     * @param fetch 是否抓取行
     * @return 指令
     */
    public WhCommand findCommandByCode(String code, boolean fetch);
    public WhCommand findNewCommandByCode(String code, boolean fetch);
    public WhCommand findCommandById(Integer id, boolean fetch);

    /**
     * 根据出入库类型和相关单据号查找指令
     *
     * @param type          出入库类型
     * @param referenceCode 相关单据号
     * @param fetch 是否抓取行
     * @return 是否成功
     */
    public WhCommand findCommandByTypeAndReferenceCode(Integer type, String referenceCode,
                                                       boolean fetch);

    /**
     * 根据条件查找指令
     *
     * @param cond 条件
     * @return
     */
    public List<WhCommand> findCommandByCond(WhCommandCond cond);
    public List<WhCommand> findNewCommandByCond(WhCommandCond cond);
    public List<WhCommand> findUnDeliveryGoodsAndNoSendMailByCond(WhCommandCond cond);

    /**
     * 根据逻辑仓创建时间范围查找处理中的指令
     *
     * @param warehouseCodeList
     * @param startTime
     * @param endTime
     * @return 指令列表
     */
    public List<WhCommand> findInProcessCommandByWarehouseAndTimeRange(List<String> warehouseCodeList,
                                                                       Date startTime, Date endTime);

    /**
     * 根据CODE查找指令行
     *
     * @param code 指令行编码
     * @return 指令行
     */
    public WhCommandSku findCommandSkuByCode(String code);

    /**
     * 根据CODE查找指令行
     *
     * @param commandCode 指令编码
     * @return 指令行列表
     */
    public List<WhCommandSku> findCommandSkuByCommandCode(String commandCode);

    /**
     * 根据CODE查找指令行
     *
     * @param commandId 指令Id
     * @return 指令行列表
     */
    public List<WhCommandSku> findCommandSkuByCommandId(Long commandId);

    /**
     * 根据ID取消指令
     *
     * @param id 指令Id
     * @return 是否成功
     */
    public boolean cancelCommandById(Long id);

    /**
     * 根据编码取消指令
     *
     * @param code 指令编码
     * @return 是否成功
     */
    public boolean cancelCommandByCode(String code);

    public boolean cancelCommandByCodeWithoutOccupy(String code);

    /**
     * 根据出入库类型和相关单据号取消指令
     *
     * @param type          出入库类型
     * @param referenceCode 相关单据号
     * @return 是否成功
     */
    public boolean cancelCommandByTypeAndReferenceCode(Integer type, String referenceCode);

    /**
     * 先释放占用,再根据出入库类型和相关单据号取消指令
     *
     * @param type          出入库类型
     * @param referenceCode 相关单据号
     * @param whReleaseOccupationVOList 释放占用列表
     * @return 是否成功
     */
    public boolean cancelCommandByTypeAndReferenceCodeAfterRelease(Integer type, String referenceCode, List<WhReleaseOccupationVO> whReleaseOccupationVOList);

    /**
     * 根据出入库类型和相关单据号重置指令相关单据号
     *
     * @param type          出入库类型
     * @param referenceCode 相关单据号
     */
    public void resetCommandReferenceCodeByTypeAndReferenceCode(Integer type, String referenceCode);

    /**
     * 占用前根据出入库类型和相关单据号重置指令相关单据号
     *
     * @param type
     * @param referenceCode
     */
    public void resetCommandReferenceCodeByTypeAndReferenceCodeBeforeOccupy(Integer type,
                                                                            String referenceCode,
                                                                            List<WhInvOccupy> whInvOccupyList);

    /**
     * 根据出入库类型和相关单据号取消指令,再占用
     *
     * @param type          出入库类型
     * @param referenceCode 相关单据号
     * @param whInvOccupyList 占用列表
     * @return 是否成功
     */
    public boolean cancelCommandByTypeAndReferenceCodeBeforeOccupy(Integer type,
                                                                   String referenceCode,
                                                                   List<WhInvOccupy> whInvOccupyList);

    /**
     * 根据出入库类型和相关单据号取消指令,指令不占用
     *
     * @param type          出入库类型
     * @param referenceCode 相关单据号

     * @return 是否成功
     */
    boolean cancelCommandByTypeAndReferenceCodeWithoutOccupy(Integer type,String referenceCode);

    /**
     * 根据ID完成指令
     *
     * @param id 指令Id
     * @return 是否成功
     */
    boolean finishCommandById(Long id)throws Exception;

    boolean updatePhyWhSkuStockOut(String physicalWarehouseCode,String skuCode,Integer skuStatus,Integer outAmount);

    /**
     * 根据编码完成指令
     *
     * @param code 指令编码
     * @return 是否成功
     */
    boolean finishCommandByCode(String code)throws Exception;

    boolean finishCommandWithoutOccupy(String code);

    int getSkuStatusByWarehouseType(Integer warehouseType);

    /**
     * 根据逻辑仓和增量时间条件查找处理中的指令
     *
     * @param warehouseCodeList 逻辑仓列表
     * @param incrementTime 增量时间
     * @return 指令列表
     */
    List<WhCommand> findInProcessCommandByIncrement(List<String> warehouseCodeList,
                                                    Date incrementTime);

    /**
     * 根据出入库类型和相关单据号完成指令
     *
     * @param type          出入库类型
     * @param referenceCode 相关单据号
     * @return 是否成功
     */
    boolean finishCommandByTypeAndReferenceCode(Integer type, String referenceCode)throws Exception;

    /**
     * 完成指令
     *
     * @param rcd 指令
     * @return 是否成功
     */
    boolean finishCommand(WhCommand rcd)throws Exception;

    boolean finishCommandWithoutOccupy(WhCommand rcd);

    boolean finishCommandWithoutOccupy(WhCommand rcd,List<WhReleaseOccupationVO> releaseList);


    boolean processAllotPackageInBound(WhAllotPackageInBoundVO altPackageInBound);
    boolean processCommandOutFinish(
            WhCommand command
            ,List<WhInvRcd> invRcdList
            ,List<WhReleaseOccupationVO> releaseList);

    /*
    2016-03-22 wms
     */

    /**
     * 指令状态变更到缺货中
     * @param whCommandCode
     * @return
     */
    boolean commandStatusToShortages(String whCommandCode);

    boolean commandStatusToShortages(List<String> whCommandCodes);

    /**
     * 指令从处理中到待拣货
     * @param whCommandCode
     * @return
     */
    public boolean commandInProcessingToPicking(String whCommandCode);

    /**
     * 指令从待拣货到待分拨
     * @param whCommandCode
     * @return
     */
    public boolean commandInPickingToDistribution(String whCommandCode);
    
    /**
     * 指令从待拣货到待交接 - 调拨
     * @param whCommandCode
     * @return
     */
    public boolean commandInPickingToHandover(String whCommandCode);

    /**
     * 指令从待分拨到待包装
     * @param whCommandCode
     * @return
     */
    public boolean commandInDistributionToPacking(String whCommandCode);

    boolean batchUpdateCommandStatus(List<String> whCommandCodes,Integer newStatus,Integer oldStatus);
    boolean batchUpdateCommandStatusAndFailure(List<String> whCommandCodes,Integer newStatus);
    public List<WhCommand> findCommandByConnectIdAndBarCode(String barCode, Long connectId);
    /**
     * 指令从待包装到待交接
     * @param whCommandCode
     * @return
     */
    public boolean commandInPackingToHandover(String whCommandCode);
    public boolean batchCommandInPackingToHandover(List<String> whCommandCodes);

    /**
     * 指令从执行中到待交接
     * @param whCommandCode
     * @return
     */
    @Transactional
    boolean commandInProcessingToHandover(String whCommandCode);

    /**
     * 指令从缺货中到处理中
     * @param whCommandCode
     * @return
     */
    public boolean commandShortagesToInProcessing(String whCommandCode);

    /**
     * 指令从处理中到缺货中
     * @param whCommandCode
     * @return
     */
    public boolean commandInProcessingToShortages(String whCommandCode);

    /**
     * 指令从待包装到缺货中
     * @param whCommandCode
     * @return
     */
    public boolean commandInPackingToShortages(String whCommandCode);

    /**
     * 根据条件查找待出库的仓库指令
     * @param cond
     * @return
     */
    public List<WhWmsWaitOutStockVO> findWaitOutStockCommandByCond(WhWmsWaitOutStockCond cond);

    public List<WhWmsWaitOutStockVO> findWaitOutStockCommandSaleOutByCond(WhWmsWaitOutStockCond cond);

    /**
     * 根据条件查找待出库的仓库指令-调拨
     * @param cond
     * @return
     */
    public List<WhWmsWaitOutStockVO> findWaitOutStockCommandAltByCond(WhWmsWaitOutStockCondAlt cond);
    
    /**
     * 根据条件查找待出库的仓库指令-调拨
     * @param cond
     * @return
     */
    public List<WhWmsWaitOutStockVO> findWaitOutStockCommandPcsRtnByCond(WhWmsWaitOutStockCondPcsRtn cond);
    
    /**
     * 根据条件查找待出库的仓库指令
     * 单品单件 top5 sku
     * @param cond
     * @return
     */
    public List<WhSkuInfoVO> findWaitOutStockCommandSkuByCond(WhWmsWaitOutStockCond cond);


    Pagination<WhWmsWaitOutStockVO> findWaitOutStockCommandRecWasteByCond(WhWmsWaitOutStockCondRecWaste cond);


    /**
     * 条件查询不同种类入库单
     * @param vo
     */
    public List<WhReceiveShelvesVO> findReceiveShelvesByCon(WhReceiveShelvesVO vo);

    public List<WhReceiveShelvesVO> findWaitClosePopCommandByCond(WhReceiveShelvesVO vo);

    public Integer findCountReceiveShelvesByCon(WhReceiveShelvesVO vo);

    // returnExceptionSku
    public WhSalesReturnExceptionSkuVO findSalesReturnExceptionSkuByCond(WhSalesReturnExceptionSkuCond cond);

    public List<WhSalesReturnExceptionSkuVO> listSalesReturnExceptionSkuByCond(WhSalesReturnExceptionSkuCond cond);

    public List<WhSalesReturnExceptionSku> selectSalesReturnExceptionSkuByCond(WhSalesReturnExceptionSkuCond cond);

    // returnException
    public WhSalesReturnExceptionVO findSalesReturnExceptionByCond(WhSalesReturnExceptionCond cond);

    public List<WhSalesReturnExceptionVO> listSalesReturnExceptionByCond(WhSalesReturnExceptionCond cond);

    public WhSalesReturnException selectSalesReturnExceptionById(Long id);

    public List<WhSalesReturnException> selectSalesReturnExceptionByCond(WhSalesReturnExceptionCond cond);

    public boolean updateSalesReturnException(WhSalesReturnExceptionVO vo) throws Exception;

    public boolean updateSalesReturnExceptionById(WhSalesReturnExceptionVO vo) throws Exception;

    public boolean updateSalesReturnExceptionSkuById(WhSalesReturnExceptionSku vo) throws Exception;

    public boolean insertSalesReturnException(WhSalesReturnExceptionVO vo) throws Exception;


    public Integer findCountSalesReturnExceptionByCond(WhSalesReturnExceptionCond cond);


    /**
     * 根据入库类型和t_wh_command_id查询入库单
     * @param whInType,whCommandId
     */
    public List<WhReceiveShelvesVO> findReceiveShelvesDetail(Integer whInType,Integer whCommandId);

    /**
     * 质检
     */
    public boolean qualityControl(WhReceiveShelvesVO vo);

    public Set<Long> getGlobalConfigByKey(String configKey);

    public String createBarCodeWhenNotExists(String skuCode,String barcode,int batchNo,Date firstInTime);
    
    /**
     * 生产加工质检
     * @return 目标库位
     */
    public String qualityControl(WhReceiveShelvesVO vo,String targetHouseType);

    /**
     *根据id更新指令状态
     */
    public boolean updateCommandStatusById(Integer id,Integer status);

    
    /**
	 * 查找出库订单信息
	 * */
	public List<WhWmsCommandInfoVO> findCommandInfoByCond(
			WhWmsCommandInfoCond cond);
	
	public Pagination<WhWmsCommandInfoVO> findPaginationCommandInfoByCond(
			WhWmsCommandInfoCond cond);
	
	/**
	 * 查找出库订单信息
	 * */
	public List<WhWmsCommandInfoVO> findNewCommandInfoByCond(
			WhWmsCommandInfoCond cond);
	
	/**
	 * 统计出库订单信息
	 * */
	public Map<String,Object> countCommandInfoByCond(WhWmsCommandInfoCond cond);
	
	/**
	 * 查询附加信息
	 * */
	public List<Map<String, Object>> findAdditionalInfosByCond(WhWmsCommandInfoCond cond);
	
	/**
	 * 查询波次信息
	 * */
	public WhWmsConnectInfoVO findWhWmsConnectInfoVOByCommandCode(String commandCode);
    
    /**
     * 更改快递单号
     * @param commandCode
     * @param expressCode
     * @return
     */
    boolean commandAssociateExpress(String commandCode,String expressCode);

    /**
     * 更改快递单号
     * @param commandCode
     * @param expressCode
     * @param operationSource
     * @return
     */
    boolean commandAssociateExpress(String commandCode,String expressCode,String operationSource);

    /**
     * 更改快递单号
     * @return
     */
    boolean commandAssociateExpress(WhCommandAssoExpressVO vo);

    /**
     * 根据快递单号查找command
     * @param expressCode
     * @return
     */
    WhCommand findCommandByExpressCode(String expressCode);

    /**
     * 关闭COMMAND
     * @param inoutType
     * @param referenceCode
     * @return
     */
    public boolean colseCommandByReferenceCode(int inoutType,String referenceCode);

    /**
     * 查找command sku行
     * @param skuCode
     * @param
     * @return
    */
    WhCommandSku findCommandSku(String skuCode, Long commandId);

    /**
     * 启动波次失败
     * @param cmdCode
     */
    void failureStartConnect(String cmdCode);

    void failureStartConnect(List<String> cmdCodes);

    void packageAssoExpressFED(PackageInfo pi);
    void packageAssoExpressFEDAndCommand(PackageInfo pi);
    void packageAssoExpressSF(PackageInfo pi);
    void packageAssoExpressSFAndPackage(PackageInfo pi);
    void packageAssoExpressZTAndPackage(ZTOrderSubmitResponse ztOrderSubmitResponse);

    void packageAssoExpressExFreshAndCommand(PackageInfo pi);

    void packageAssoExpressTmsAndCommand(PackageInfo pi);
    /**
     * 根据相关单据号查找command
     * @param referenceCode
     * @return
     */
    WhCommand findCommandByReferenceCode(String referenceCode);
    void updateCommand(WhCommand whCommand);
    void batchUpdateCommand(WhCommand whCommand,WhCommandExample example);

    //跨事务操作
    WhCommand updateCommandV2(WhCommand whCommand);
    /**
     * 记录command缺货SKU
     * @param commandCode
     * @param skuCode
     * @param shortAmount
     */
    void recordCommandShortSku(String commandCode,String skuCode,int shortAmount);

    boolean recordCommandShortSku(List<WhWmsCommandShortRecord> shortRecordList);

    List<WhWmsCommandShortRecord> findWhWmsCommandShortRecordByCommandCode(String commandCode);

    public void commandWithPackageExpress();
    
    public boolean cancelCommand(WhCommand whCommand);

    public boolean cancelCommandWithoutOccupy(WhCommand whCommand);

    public boolean cancelCommandforShortage(WhCommand whCommand);

    public boolean cancelCommandforShortage(String commandCode);

    boolean cancelCommandforShortage(List<String> whCommandCodes,Integer oldStatus);

    boolean cancelCommandForSalesOrder(List<WhCommand> whCommands, List<SStockReleaseDTO> releaseList);

    public void releaseWhCommandOccupy(WhCommand rcd);
    
    String synCommodityStocks(Long numIid, String outerId, long quantity, String channelCode, int syncType, String referenceCode,Long operatorId) throws Exception;
    TmallStockLog synCommodityStocksAllot(Long numIid, String outerId, long quantity, String channelCode, int syncType, String referenceCode) throws Exception;


    Map<String,JdStockSyncResult> syncJdSkuStock(String warehouseCode
            , Map<String,Integer> skuQuantityMap
            , Integer syncType
            , List<String> referenceCodes
            , Long operatorId);

    Map<String,JdStockSyncResult> syncJdSkuStock(String warehouseCode
            , Map<String,Integer> skuQuantityMap
            , Integer syncType
            , List<String> referenceCodes
            , Long operatorId
            , boolean failThenThrowException);

    public void insertWhCommandOutFinish(WhCommandOutFinish whCommandOutFinish);
    
    public List<WhCommandOutFinish> findWhCommandOutFinishNoFinish();
    
    public String getBarCode(WhQualityControlVO qc);

    public String getPrePrintBarCode(WhQualityControlVO qc);

    public String getBarCode(String skuCode,Date prodDate);

    public String getBarCode(String skuCode,Date prodDate,Date expirationDate);
    
    public Long getSupplierIdByPurchaseReturnCode(String purchaseReturnCode);
    
    public String getOriPhyCodeByPurchaseReturnCode(String purchaseReturnCode);
    
    public void cancelPurchaseRtnByWhCommand(WhCommand command);
    
    public WmsPurchaseReturn getPurchaseReturnByCode(String code,boolean fetch);
    
    public void finishPurchaseRtnByWhCommand(WhCommand command);
    
    /**
     * 统计指令数
     * */
    public List<WhCommandCountVO> getCommandOutCountByCond(WhCommandCond cond);

    /**
     * 查询【一条】CHN2053发货完成的把包裹信息
     * */
    public List<WhPackageInfoVO> findCHN2053PackageInfo();
    public List<WhWmsSubmitHandRecord> autoProcessSubmitHandData();
    public void processSubmitData(List<WhWmsSubmitHandRecord> list);
    public Boolean checkTmallSku(Long numIid, String outerId, long quantity, String sessionKey)throws Exception;

    String findSalesOrderAddressByCond(String cond);

    Integer findSalesOrderTypeByCond(String cond);

    /**
     * 取消调拨命令
     *
     * @param type          出入库类型
     * @param referenceCode 相关单据号
     * @return 是否成功
     */
    public boolean cancelAllotRcdCommandByTypeAndReferenceCode(Integer type, String referenceCode);

    public Integer autoCloseCommandInEndMonth();

    public void updateCommandSku(WhCommandSku whCommandSku);

    List<WhCommandSku> findDiffCommandSkuByCommandReferenceCodes(List<String> allotCodeList);

    boolean updatePhyWhSkuStockOut(String physicalWarehouseCode
            ,String skuCode,Integer skuStatus,Integer quantity
            ,Integer inOutType,String referenceCode,Long operatorId,String memo);
    /**
     * 批量查询commd 里的referenceCode
     * @param commdCodeList
     * @return
     */
    Map<String, String> findReferenceCodesByCommdCodes(List<String> commdCodeList);

    /**
     * 批量更新预计发货日期
     * @param referenceCodes
     * @param planDeliveryDate
     * @return
     */
    int updatePlanedDyDateByReCodes(List<WhCommand> whCommandList);


    String createAllotRcdAndFinishCommand(final WhAllotRcd whAllotRcd,final Integer type,
                                          final boolean fetch) throws Exception;
}