package com.thebeastshop.pegasus.service.warehouse.service;

import com.thebeastshop.pegasus.integration.express.PackageInfo;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.vo.WhCommandAssoExpressVO;

import org.springframework.transaction.annotation.Transactional;

import java.util.List;


public interface WhCommandAssociateExpressService {
	
	/**
     * 出库单关联快递单(单个)
     *
     * @param commandCode
     * @param expressCode
     * @return
     */
	@Transactional
    Boolean commandAssociateExpress(String commandCode, String expressCode);

    @Transactional
    Boolean batchCommandAssociateExpress(List<WhCommand> whCommands);

    /**
     * 出库单关联快递单(单个)
     *
     * @param commandCode
     * @param expressCode
     * @param operationSource
     * @return
     */
    @Transactional
    Boolean commandAssociateExpress(String commandCode, String expressCode,String operationSource);

	/**
     * 出库单关联快递单(单个)
     *
     * @return
     */
	@Transactional
    Boolean commandAssociateExpress(WhCommandAssoExpressVO vo);

	/**
	 * 出库单关联快递单(单个),顺丰
	 *
	 * @param commandCode
	 * @param pi
	 * @return
	 */
	@Transactional
	Boolean commandAssociateExpressSF(String commandCode, PackageInfo pi);

	/**
	 * 出库单关联快递单(单个),联邦
	 *
	 * @param commandCode
	 * @param pi
	 * @return
	 */
	@Transactional
	Boolean commandAssociateExpressFED(String commandCode, PackageInfo pi);

}
