package com.thebeastshop.pegasus.service.warehouse.service;

import com.github.pagehelper.PageInfo;
import com.thebeastshop.pegasus.service.warehouse.cond.WhAutoAllotCond;
import com.thebeastshop.pegasus.service.warehouse.model.WhAutoAllotCallbackExcludeCategory;
import com.thebeastshop.pegasus.service.warehouse.model.WhAutoAllotExcludeCategory;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAutoAllotRecordDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAutoAllotRecordVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAutoAllotRuleVO;

import java.util.List;
import java.util.Set;

public interface WhAutoAllotService {

  /**
   * 保存自動分货规则
   * @return
   */
  int saveAutoAllotRule(WhAutoAllotRuleVO whAutoAllotRule) throws Exception;

  /**
   * 获取历史规则
   * @return
   */
  List<WhAutoAllotRuleVO> findHisRules(String bu, short allotChannel);

  List<WhAutoAllotExcludeCategory> findExcludeCategorysByRuleId(Integer ruleId);

  /**
   * 获取回调排除分类
   * @param ruleId
   * @return
   */
  List<WhAutoAllotCallbackExcludeCategory> findCallbackExcludeCategorysByRuleId(Integer ruleId);

  /**
   * 执行分货任务
   */
  void executeAutoAllot(Long operatorId, String bu, boolean isAuto) throws Exception;

  void cronExecuteAutoAllot(Long operatorId) throws Exception;


  /**
   * 执行线上分货
   * @param operatorId
   * @param isAuto
   * @throws Exception
   */
  void executeAutoAllotOnline(Long operatorId, boolean isAuto) throws Exception;

  WhAutoAllotRuleVO findCurrentRule(String bu, boolean cascade);

  WhAutoAllotRuleVO findCurrentRuleOnline(boolean cascade);

  PageInfo<WhAutoAllotRecordVO> findAutoAllotRecords(WhAutoAllotCond whAutoAllotCond);

  /**
   * 查看分货结果
   * @param recordId
   * @return
   */
  List<WhAutoAllotRecordDetailVO> findDetailByRecordId(Integer recordId);

  Set<String> confirmExecuteAutoAllot(Integer recordId) throws Exception;

  Set<String> cancleExecuteAutoAllot(Integer recordId) throws Exception;

  /**
   * 检查是否需要自动分货
   * @param skuCode
   * @param warehouseCode
   * @return
   */
  List<String> checkWhetherNeedAutoAllot(final List<String> skuCode, final String warehouseCode);

  /**
   * LB 商品限量销售 自动分货
   */
  void autoAllotForLbLimitSale();
}
