package com.thebeastshop.pegasus.service.warehouse.service;

import com.github.pagehelper.PageInfo;
import com.thebeastshop.pegasus.service.warehouse.cond.WhAllotStoreApplicationCond;
import com.thebeastshop.pegasus.service.warehouse.model.WhAllotStoreApplication;
import com.thebeastshop.pegasus.service.warehouse.model.WhAllotStoreApplicationSku;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAllotStoreApplicationApproveVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAllotStoreApplicationSkuRefusedDateVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAllotStoreApplicationSkuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAllotStoreApplicationVO;

import java.util.List;
import java.util.Map;

/**
 * 门店调拨申请
 */
public interface WhAllotStoreApplicationService {

  /**
   * 申请调拨
   * @param storeApplication
   * @return
   * @throws Exception
   */
  int applicationAllot(WhAllotStoreApplicationVO storeApplication) throws Exception;

  PageInfo<WhAllotStoreApplicationSkuVO> listApplicationRecord(WhAllotStoreApplicationCond cond);

  PageInfo<WhAllotStoreApplicationSkuVO> listApprovalListByCond(WhAllotStoreApplicationCond cond);
  WhAllotStoreApplication findApplicationByKey(Integer id);
  /**
   * 按渠道分组统计
   * @param cond
   * @return
   */
  PageInfo<WhAllotStoreApplicationSkuVO> listChannelGroupApplicationBySkuCode(WhAllotStoreApplicationCond cond);

  int cancelApplication(Integer applicationLineId,Long cancelPerson)throws Exception;

  List<WhAllotStoreApplicationSkuVO> approve(WhAllotStoreApplicationApproveVO approveVO,Map<String,WhAllotStoreApplicationSkuRefusedDateVO> skuPurchaseOrderMap)throws Exception;

  int batchUpdateSelective(List<WhAllotStoreApplicationSkuVO> recordList);

  int batchApprove(List<WhAllotStoreApplicationSkuVO> recordList);

  Map<String, List<WhAllotStoreApplicationSkuVO>> mapNotNotifyApplication();

  /**
   * 给各个渠道通知审批结果
   */
  void nofityApplovalResult();

  /**
   * 是否可以申请调拨
   * @param skuCodes
   * @param channelCode
   */
  String canApplyAllot(List<String> skuCodes, String channelCode);


  /**
   * 由于门店申请货品后可能存在未及时使用的情况，为了最大化利用现有库存，如果门店未使用则定期回调库存
   逻辑仓：WH000254910254、WH000255910255、WH000562910562、WH000563910563
   每天下午4点，以上仓位所有可用库存调拨回WH020600010096
   */
  void createAllotsCron() throws Exception;

}
