/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.warehouse.service;

import com.thebeastshop.pegasus.service.warehouse.cond.WhAllotCond;
import com.thebeastshop.pegasus.service.warehouse.model.*;
import com.thebeastshop.pegasus.service.warehouse.vo.*;

import java.util.List;
import java.util.Map;

/**
 * @author Royan
 * @version $Id: WhAllotService.java, v 0.1 2015-07-08 上午11:14
 */
public interface WhAllotService {

    /**
     * 创建调拨单
     *
     * @param whAllotRcd 调拨单
     * @return 调拨单号
     */
    public String createAllotRcd(WhAllotRcd whAllotRcd) throws Exception ;
    public String createAllotRcdNoSynTmall(WhAllotRcd whAllotRcd) throws Exception ;
    public boolean isWarehouseInnerMove(WhAllotRcd whAllotRcd);
    public boolean isWarehouseGroupChannelMove(WhAllotRcd whAllotRcd);

    boolean isAllotDirectComplete(WhAllotRcd whAllotRcd);

    boolean isAllotSecondConfirm(WhAllotRcd whAllotRcd);
    /**
     * 来单制作自动调拨
     *
     * @param whAllotRcd 调拨单
     * @return 调拨单号
     */
    public String createAutoTransferAllot(WhAllotRcd whAllotRcd) throws Exception ;
    public String createPreAllotRcd(WhPreAllotRcd whPreAllotRcd) throws Exception ;

    /**
     * 创建调拨单
     *
     * @param whAllotRcds 调拨单
     * @return 调拨单号
     */
    public List<String> createAllotRcds(List<WhAllotRcd> whAllotRcds) throws Exception;

    boolean recordAllotRcd(List<WhAllotRcd> whAllotRcds);

    /**
     * 自动分货创建调拨单
     * @param whAllotRcds
     * @return
     * @throws Exception
     */
    List<WhAllotRcd> autoAllotCreateRcds(List<WhAllotRcd> whAllotRcds) throws Exception;

    /**
     * 自动分货预占用
     * @param whAllotRcds
     * @return
     * @throws Exception
     */
    void autoAllotPreOccupy(List<WhAllotRcd> whAllotRcds) throws Exception;

    /**
     * 调拨同步京东后台库存
     * @param allotRcd
     * @return
     */
    String trySyncJdStock(WhAllotRcd allotRcd);

    String trySyncJdStockNew(WhAllotRcd allotRcd, boolean inStorage);

    public boolean createAllotRcdAndPrdcJobOccupy(List<WhAllotRcd> whAllotRcds,List<WhInvOccupy> whInvOccupyList, List<WhJitPackageSkuReferenceVO> whJitPackageSkuReferenceVOList) throws Exception;


    /**
     * 取消调拨单
     *
     * @param code     调拨单CODE
     * @return 是否成功
     */
    public boolean cancelAllotRcdByCode(String code)throws Exception;


    public boolean cancelAllotRcdByCodeForCustomization(String code)throws Exception;

    /**
     * 取消调拨单
     *
     * @param code     调拨单CODE
     * @return 是否成功
     */
    public boolean cancelAllotRcdByCodeFromWms(String code)throws Exception;

    /**
     * 根据CODE查找调拨单
     *
     * @param code     调拨单CODE
     * @param fetchSku 是否抓取调拨单SKU
     * @return 调拨单
     */
    public WhAllotRcd findAllotRcdByCode(String code, boolean fetchSku);
    public WhAllotRcd findAllotRcdByCode(String code, boolean fetchSku,boolean fetchRefPackageSku);
    public List<WhAllotDiffDetailVO> findAllotDiffDetailByExample(WhAllotDiffDetailVO allotDiffDetailVO);
    public List<WhAllotDiffDetailVO> listAllotDiffDetailByCode(WhAllotDiffDetailVO allotDiffDetailVO);
    public WhAllotRcd findAllotRcdById(Long id);
    // 统计取消的商品数量 在调拨入库完成后
    public Integer countRefPackCancelQuantityAfterAllotFinished(WhAllotCond allotCond);

    /**
     * 根据类型和相关单据查找调拨
     * @param type
     * @param referenceCode
     * @param fetchSku
     * @return
     */
    public WhAllotRcd findAllotRcdByTypeAndReferenceCode(Integer type, String referenceCode,
                                                         boolean fetchSku);

    /**
     * 根据条件查找调拨
     * @param cond 条件
     * @return
     */
    public List<WhAllotRcd> findAllotRcdByCond(WhAllotCond cond);
    public List<WhAllotRcd> selectAllotRcdByCond(WhAllotCond cond);
    public List<WhPreAllotRcdVO> findPreAllotRcdByCond(WhAllotCond cond);
    public List<WhPreAllotRcdVO> findPreAllotRcdByCond(WhAllotCond cond,boolean fetchSku,boolean fetchCountQuantity);
    public List<WhPreAllotRcdSku> findPreAllotRcdSkuByPreId(Long preId);
    public List<WhPreAllotRcdSku> findPreAllotRcdSkuCountQuantityByPreId(Long preId);
    public List<WhPreAllotRcdDownloadVO> findPreAllotRcdListByCond(WhAllotCond cond);
    public String autoCreateAllotRcd(WhPreAllotRcdVO vo);
    /**
     * 根据条件查找调拨
     * @param cond 条件
     * @return
     */
    public List<WhAllotRcd> getAllotRcdByCond(WhAllotCond cond);
    public void updateWhPreAllotRcdByCond(WhPreAllotRcd whPreAllotRcd);
    /**
     * 根据调拨单ID查找调拨单SKU
     *
     * @param allotId 调拨单ID
     * @return 调拨单SKU列表
     */
    public List<WhAllotRcdSku> findAllotRcdSkuByAllotId(Long allotId);

    /**
     * 根据调拨单CODE查找调拨单SKU
     *
     * @param allotCode 源调拨单CODE
     * @return 调拨单SKU列表
     */
    public List<WhAllotRcdSku> findAllotRcdSkuByAllotCode(String allotCode);

    /**
     * 根据仓库CODE查找待确认调拨单
     *
     * @param warehouseCode 仓库CODE
     * @return 调拨单
     */
    public List<WhAllotRcd> findAllotRcdWaitForConfirmation(String warehouseCode);

    /**
     * 根据仓库CODE查找待出库调拨单
     *
     * @param warehouseCode 仓库CODE
     * @return 调拨单
     */
    public List<WhAllotRcd> findAllotRcdWaitForOutbound(String warehouseCode);

    /**
     * 根据仓库CODE查找待入库调拨单
     *
     * @param warehouseCode 仓库CODE
     * @return 调拨单
     */
    public List<WhAllotRcd> findAllotRcdWaitForInbound(String warehouseCode);

    /**
     * 根据ID更新调拨单状态
     *
     * @param id        源调拨单ID
     * @param newStatus 新状态
     * @return 是否成功
     */
    public boolean updateAllotRcdStatusById(Long id, Integer newStatus)throws Exception;

    /**
     * 根据CODE更新调拨单状态
     *
     * @param code      源调拨单CODE
     * @param newStatus 新状态
     * @return 是否成功
     */
    public boolean updateAllotRcdStatusByCode(String code, Integer newStatus)throws Exception;
    
    /**
     * 根据CODE更新调拨单状态
     *
     * @param code      源调拨单CODE
     * @param newStatus 新状态
     * @return 是否成功
     */
    public boolean updateAllotRcdStatusByCodeNew(String code, Integer newStatus,String rejectedReason)throws Exception;



    public List<String> createAllotRcdByList(List<WhAllotRcdVO> whAllotRcdVOList) throws Exception;
    /**
     * 更新调拨单
     *
     * @return 是否成功
     */
    public boolean updateAllotRcd(WhAllotRcd rcd);

    /**
     * 更新调拨记录行
     *
     * @return 是否成功
     */
    public boolean updateAllotRcdSku(WhAllotRcdSku rcdSku);

    //门店调拨箱收货
    boolean allotPackageInbound(WhAllotPackageInBoundVO altPackageInBound);



    /**
     * 根据移库单反向移库
     * @param code
     * @return
     */
    public boolean revertAllotRcd(String code) throws Exception;

    /**
     * 批量创建预调拨单
     * @param whPreAllotRcdList
     * @return
     */
    List<String> batchCreatePreAllotRcd(List<WhPreAllotRcd> whPreAllotRcdList) throws Exception;

    /**
     * 获取差异邮件信息
     * @param cond
     * @return
     */
    List<WhAllotDiffSendMessageVO> getWhAllotDiffMessage(WhAllotCond cond);

    Map<String,Boolean> isAllotCanCancel(List<String> codes);

    /**
     * 确认自动分货调拨单
     * @param allotRcdCode
     */
    void confirmExecuteAutoAllot(String allotRcdCode) throws Exception;
}